package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class ExternalMetricSourceFluentImpl<A extends io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSourceFluent<A> {

    private java.lang.String metricName;
    private io.fabric8.kubernetes.api.model.LabelSelectorBuilder metricSelector;
    private io.fabric8.kubernetes.api.model.Quantity targetAverageValue;
    private io.fabric8.kubernetes.api.model.Quantity targetValue;

    public ExternalMetricSourceFluentImpl() {
    }

    public ExternalMetricSourceFluentImpl(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSource instance) {
        this.withMetricName(instance.getMetricName()); 
        this.withMetricSelector(instance.getMetricSelector()); 
        this.withTargetAverageValue(instance.getTargetAverageValue()); 
        this.withTargetValue(instance.getTargetValue()); 
    }

    public java.lang.String getMetricName() {
        return this.metricName;
    }

    public A withMetricName(java.lang.String metricName) {
        this.metricName=metricName; return (A) this;
    }

    public java.lang.Boolean hasMetricName() {
        return this.metricName != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withMetricName instead.
     */
        public A withNewMetricName(java.lang.String arg0) {
        return (A)withMetricName(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetricSelector instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.LabelSelector getMetricSelector() {
        return this.metricSelector!=null?this.metricSelector.build():null;
    }

    public io.fabric8.kubernetes.api.model.LabelSelector buildMetricSelector() {
        return this.metricSelector!=null?this.metricSelector.build():null;
    }

    public A withMetricSelector(io.fabric8.kubernetes.api.model.LabelSelector metricSelector) {
        _visitables.get("metricSelector").remove(this.metricSelector);
        if (metricSelector!=null){ this.metricSelector= new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(metricSelector); _visitables.get("metricSelector").add(this.metricSelector);} return (A) this;
    }

    public java.lang.Boolean hasMetricSelector() {
        return this.metricSelector != null;
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSourceFluent.MetricSelectorNested<A> withNewMetricSelector() {
        return new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSourceFluentImpl.MetricSelectorNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSourceFluent.MetricSelectorNested<A> withNewMetricSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
        return new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSourceFluentImpl.MetricSelectorNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSourceFluent.MetricSelectorNested<A> editMetricSelector() {
        return withNewMetricSelectorLike(getMetricSelector());
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSourceFluent.MetricSelectorNested<A> editOrNewMetricSelector() {
        return withNewMetricSelectorLike(getMetricSelector() != null ? getMetricSelector(): new io.fabric8.kubernetes.api.model.LabelSelectorBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSourceFluent.MetricSelectorNested<A> editOrNewMetricSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
        return withNewMetricSelectorLike(getMetricSelector() != null ? getMetricSelector(): item);
    }

    public io.fabric8.kubernetes.api.model.Quantity getTargetAverageValue() {
        return this.targetAverageValue;
    }

    public A withTargetAverageValue(io.fabric8.kubernetes.api.model.Quantity targetAverageValue) {
        this.targetAverageValue=targetAverageValue; return (A) this;
    }

    public java.lang.Boolean hasTargetAverageValue() {
        return this.targetAverageValue != null;
    }

    public A withNewTargetAverageValue(java.lang.String amount,java.lang.String format) {
        return (A)withTargetAverageValue(new Quantity(amount, format));
    }

    public A withNewTargetAverageValue(java.lang.String amount) {
        return (A)withTargetAverageValue(new Quantity(amount));
    }

    public io.fabric8.kubernetes.api.model.Quantity getTargetValue() {
        return this.targetValue;
    }

    public A withTargetValue(io.fabric8.kubernetes.api.model.Quantity targetValue) {
        this.targetValue=targetValue; return (A) this;
    }

    public java.lang.Boolean hasTargetValue() {
        return this.targetValue != null;
    }

    public A withNewTargetValue(java.lang.String amount,java.lang.String format) {
        return (A)withTargetValue(new Quantity(amount, format));
    }

    public A withNewTargetValue(java.lang.String amount) {
        return (A)withTargetValue(new Quantity(amount));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ExternalMetricSourceFluentImpl that = (ExternalMetricSourceFluentImpl) o;
        if (metricName != null ? !metricName.equals(that.metricName) :that.metricName != null) return false;
        if (metricSelector != null ? !metricSelector.equals(that.metricSelector) :that.metricSelector != null) return false;
        if (targetAverageValue != null ? !targetAverageValue.equals(that.targetAverageValue) :that.targetAverageValue != null) return false;
        if (targetValue != null ? !targetValue.equals(that.targetValue) :that.targetValue != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(metricName,  metricSelector,  targetAverageValue,  targetValue,  super.hashCode());
    }

    public class MetricSelectorNestedImpl<N> extends io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSourceFluent.MetricSelectorNested<N>> implements io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSourceFluent.MetricSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.LabelSelectorBuilder builder;

            MetricSelectorNestedImpl(io.fabric8.kubernetes.api.model.LabelSelector item) {
                this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this, item);
                        
            }

            MetricSelectorNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) ExternalMetricSourceFluentImpl.this.withMetricSelector(builder.build());
            }

            public N endMetricSelector() {
                return and();
            }
    }


}
