package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class PodsMetricSourceFluentImpl<A extends io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricSourceFluent<A> {

    private java.lang.String metricName;
    private io.fabric8.kubernetes.api.model.LabelSelectorBuilder selector;
    private io.fabric8.kubernetes.api.model.Quantity targetAverageValue;

    public PodsMetricSourceFluentImpl() {
    }

    public PodsMetricSourceFluentImpl(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricSource instance) {
        this.withMetricName(instance.getMetricName()); 
        this.withSelector(instance.getSelector()); 
        this.withTargetAverageValue(instance.getTargetAverageValue()); 
    }

    public java.lang.String getMetricName() {
        return this.metricName;
    }

    public A withMetricName(java.lang.String metricName) {
        this.metricName=metricName; return (A) this;
    }

    public java.lang.Boolean hasMetricName() {
        return this.metricName != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withMetricName instead.
     */
        public A withNewMetricName(java.lang.String arg0) {
        return (A)withMetricName(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSelector instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.LabelSelector getSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public io.fabric8.kubernetes.api.model.LabelSelector buildSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(io.fabric8.kubernetes.api.model.LabelSelector selector) {
        _visitables.get("selector").remove(this.selector);
        if (selector!=null){ this.selector= new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public java.lang.Boolean hasSelector() {
        return this.selector != null;
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricSourceFluent.SelectorNested<A> withNewSelector() {
        return new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricSourceFluentImpl.SelectorNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricSourceFluent.SelectorNested<A> withNewSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
        return new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricSourceFluentImpl.SelectorNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricSourceFluent.SelectorNested<A> editSelector() {
        return withNewSelectorLike(getSelector());
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricSourceFluent.SelectorNested<A> editOrNewSelector() {
        return withNewSelectorLike(getSelector() != null ? getSelector(): new io.fabric8.kubernetes.api.model.LabelSelectorBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricSourceFluent.SelectorNested<A> editOrNewSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
        return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    public io.fabric8.kubernetes.api.model.Quantity getTargetAverageValue() {
        return this.targetAverageValue;
    }

    public A withTargetAverageValue(io.fabric8.kubernetes.api.model.Quantity targetAverageValue) {
        this.targetAverageValue=targetAverageValue; return (A) this;
    }

    public java.lang.Boolean hasTargetAverageValue() {
        return this.targetAverageValue != null;
    }

    public A withNewTargetAverageValue(java.lang.String amount,java.lang.String format) {
        return (A)withTargetAverageValue(new Quantity(amount, format));
    }

    public A withNewTargetAverageValue(java.lang.String amount) {
        return (A)withTargetAverageValue(new Quantity(amount));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PodsMetricSourceFluentImpl that = (PodsMetricSourceFluentImpl) o;
        if (metricName != null ? !metricName.equals(that.metricName) :that.metricName != null) return false;
        if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
        if (targetAverageValue != null ? !targetAverageValue.equals(that.targetAverageValue) :that.targetAverageValue != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(metricName,  selector,  targetAverageValue,  super.hashCode());
    }

    public class SelectorNestedImpl<N> extends io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricSourceFluent.SelectorNested<N>> implements io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricSourceFluent.SelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.LabelSelectorBuilder builder;

            SelectorNestedImpl(io.fabric8.kubernetes.api.model.LabelSelector item) {
                this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this, item);
                        
            }

            SelectorNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) PodsMetricSourceFluentImpl.this.withSelector(builder.build());
            }

            public N endSelector() {
                return and();
            }
    }


}
