package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class MetricValueStatusBuilder extends io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricValueStatusFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricValueStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricValueStatus,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricValueStatusBuilder> {

    io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricValueStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public MetricValueStatusBuilder() {
        this(true);
    }

    public MetricValueStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new MetricValueStatus(), validationEnabled);
    }

    public MetricValueStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricValueStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public MetricValueStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricValueStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new MetricValueStatus(), validationEnabled);
    }

    public MetricValueStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricValueStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricValueStatus instance) {
        this(fluent, instance, true);
    }

    public MetricValueStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricValueStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricValueStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAverageUtilization(instance.getAverageUtilization()); 
        fluent.withAverageValue(instance.getAverageValue()); 
        fluent.withValue(instance.getValue()); 
        this.validationEnabled = validationEnabled; 
    }

    public MetricValueStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricValueStatus instance) {
        this(instance,true);
    }

    public MetricValueStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricValueStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withAverageUtilization(instance.getAverageUtilization()); 
        this.withAverageValue(instance.getAverageValue()); 
        this.withValue(instance.getValue()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricValueStatus build() {
        MetricValueStatus buildable = new MetricValueStatus(fluent.getAverageUtilization(),fluent.getAverageValue(),fluent.getValue());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        MetricValueStatusBuilder that = (MetricValueStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
