package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ObjectMetricSourceBuilder extends io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricSourceFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricSource,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricSourceBuilder> {

    io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricSourceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ObjectMetricSourceBuilder() {
        this(true);
    }

    public ObjectMetricSourceBuilder(java.lang.Boolean validationEnabled) {
        this(new ObjectMetricSource(), validationEnabled);
    }

    public ObjectMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public ObjectMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ObjectMetricSource(), validationEnabled);
    }

    public ObjectMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricSource instance) {
        this(fluent, instance, true);
    }

    public ObjectMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDescribedObject(instance.getDescribedObject()); 
        fluent.withMetric(instance.getMetric()); 
        fluent.withTarget(instance.getTarget()); 
        this.validationEnabled = validationEnabled; 
    }

    public ObjectMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricSource instance) {
        this(instance,true);
    }

    public ObjectMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withDescribedObject(instance.getDescribedObject()); 
        this.withMetric(instance.getMetric()); 
        this.withTarget(instance.getTarget()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricSource build() {
        ObjectMetricSource buildable = new ObjectMetricSource(fluent.getDescribedObject(),fluent.getMetric(),fluent.getTarget());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ObjectMetricSourceBuilder that = (ObjectMetricSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
