/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ContainerResourceMetricSource;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ContainerResourceMetricSourceFluent;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ContainerResourceMetricSourceFluentImpl;
import java.util.Objects;

public class ContainerResourceMetricSourceBuilder
extends ContainerResourceMetricSourceFluentImpl<ContainerResourceMetricSourceBuilder>
implements VisitableBuilder<ContainerResourceMetricSource, ContainerResourceMetricSourceBuilder> {
    ContainerResourceMetricSourceFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerResourceMetricSourceBuilder() {
        this(false);
    }

    public ContainerResourceMetricSourceBuilder(Boolean validationEnabled) {
        this(new ContainerResourceMetricSource(), validationEnabled);
    }

    public ContainerResourceMetricSourceBuilder(ContainerResourceMetricSourceFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ContainerResourceMetricSourceBuilder(ContainerResourceMetricSourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ContainerResourceMetricSource(), validationEnabled);
    }

    public ContainerResourceMetricSourceBuilder(ContainerResourceMetricSourceFluent<?> fluent, ContainerResourceMetricSource instance) {
        this(fluent, instance, false);
    }

    public ContainerResourceMetricSourceBuilder(ContainerResourceMetricSourceFluent<?> fluent, ContainerResourceMetricSource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withContainer(instance.getContainer());
        fluent.withName(instance.getName());
        fluent.withTargetAverageUtilization(instance.getTargetAverageUtilization());
        fluent.withTargetAverageValue(instance.getTargetAverageValue());
        this.validationEnabled = validationEnabled;
    }

    public ContainerResourceMetricSourceBuilder(ContainerResourceMetricSource instance) {
        this(instance, (Boolean)false);
    }

    public ContainerResourceMetricSourceBuilder(ContainerResourceMetricSource instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withContainer(instance.getContainer());
        this.withName(instance.getName());
        this.withTargetAverageUtilization(instance.getTargetAverageUtilization());
        this.withTargetAverageValue(instance.getTargetAverageValue());
        this.validationEnabled = validationEnabled;
    }

    public ContainerResourceMetricSource build() {
        ContainerResourceMetricSource buildable = new ContainerResourceMetricSource(this.fluent.getContainer(), this.fluent.getName(), this.fluent.getTargetAverageUtilization(), this.fluent.getTargetAverageValue());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerResourceMetricSourceBuilder that = (ContainerResourceMetricSourceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

