package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ContainerResourceMetricStatusBuilder extends ContainerResourceMetricStatusFluent<ContainerResourceMetricStatusBuilder> implements VisitableBuilder<ContainerResourceMetricStatus,ContainerResourceMetricStatusBuilder>{
  public ContainerResourceMetricStatusBuilder() {
    this(new ContainerResourceMetricStatus());
  }
  
  public ContainerResourceMetricStatusBuilder(ContainerResourceMetricStatusFluent<?> fluent) {
    this(fluent, new ContainerResourceMetricStatus());
  }
  
  public ContainerResourceMetricStatusBuilder(ContainerResourceMetricStatusFluent<?> fluent,ContainerResourceMetricStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ContainerResourceMetricStatusBuilder(ContainerResourceMetricStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ContainerResourceMetricStatusFluent<?> fluent;
  
  public ContainerResourceMetricStatus build() {
    ContainerResourceMetricStatus buildable = new ContainerResourceMetricStatus(fluent.getContainer(),fluent.getCurrentAverageUtilization(),fluent.getCurrentAverageValue(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}