package io.fabric8.kubernetes.api.model.autoscaling.v2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class HorizontalPodAutoscalerConditionBuilder extends HorizontalPodAutoscalerConditionFluent<HorizontalPodAutoscalerConditionBuilder> implements VisitableBuilder<HorizontalPodAutoscalerCondition,HorizontalPodAutoscalerConditionBuilder>{
  public HorizontalPodAutoscalerConditionBuilder() {
    this(new HorizontalPodAutoscalerCondition());
  }
  
  public HorizontalPodAutoscalerConditionBuilder(HorizontalPodAutoscalerConditionFluent<?> fluent) {
    this(fluent, new HorizontalPodAutoscalerCondition());
  }
  
  public HorizontalPodAutoscalerConditionBuilder(HorizontalPodAutoscalerConditionFluent<?> fluent,HorizontalPodAutoscalerCondition instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public HorizontalPodAutoscalerConditionBuilder(HorizontalPodAutoscalerCondition instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  HorizontalPodAutoscalerConditionFluent<?> fluent;
  
  public HorizontalPodAutoscalerCondition build() {
    HorizontalPodAutoscalerCondition buildable = new HorizontalPodAutoscalerCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}