package io.fabric8.kubernetes.api.model.autoscaling.v2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MetricStatusBuilder extends MetricStatusFluentImpl<MetricStatusBuilder> implements VisitableBuilder<MetricStatus,MetricStatusBuilder>{
  public MetricStatusBuilder() {
    this(false);
  }
  public MetricStatusBuilder(Boolean validationEnabled) {
    this(new MetricStatus(), validationEnabled);
  }
  public MetricStatusBuilder(MetricStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public MetricStatusBuilder(MetricStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MetricStatus(), validationEnabled);
  }
  public MetricStatusBuilder(MetricStatusFluent<?> fluent,MetricStatus instance) {
    this(fluent, instance, false);
  }
  public MetricStatusBuilder(MetricStatusFluent<?> fluent,MetricStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withContainerResource(instance.getContainerResource()); 
    fluent.withExternal(instance.getExternal()); 
    fluent.withObject(instance.getObject()); 
    fluent.withPods(instance.getPods()); 
    fluent.withResource(instance.getResource()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public MetricStatusBuilder(MetricStatus instance) {
    this(instance,false);
  }
  public MetricStatusBuilder(MetricStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withContainerResource(instance.getContainerResource()); 
    this.withExternal(instance.getExternal()); 
    this.withObject(instance.getObject()); 
    this.withPods(instance.getPods()); 
    this.withResource(instance.getResource()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  MetricStatusFluent<?> fluent;
  Boolean validationEnabled;
  public MetricStatus build() {
    MetricStatus buildable = new MetricStatus(fluent.getContainerResource(),fluent.getExternal(),fluent.getObject(),fluent.getPods(),fluent.getResource(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}