package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HorizontalPodAutoscalerListBuilder extends HorizontalPodAutoscalerListFluentImpl<HorizontalPodAutoscalerListBuilder> implements VisitableBuilder<HorizontalPodAutoscalerList,HorizontalPodAutoscalerListBuilder>{
  public HorizontalPodAutoscalerListBuilder() {
    this(false);
  }
  public HorizontalPodAutoscalerListBuilder(Boolean validationEnabled) {
    this(new HorizontalPodAutoscalerList(), validationEnabled);
  }
  public HorizontalPodAutoscalerListBuilder(HorizontalPodAutoscalerListFluent<?> fluent) {
    this(fluent, false);
  }
  public HorizontalPodAutoscalerListBuilder(HorizontalPodAutoscalerListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HorizontalPodAutoscalerList(), validationEnabled);
  }
  public HorizontalPodAutoscalerListBuilder(HorizontalPodAutoscalerListFluent<?> fluent,HorizontalPodAutoscalerList instance) {
    this(fluent, instance, false);
  }
  public HorizontalPodAutoscalerListBuilder(HorizontalPodAutoscalerListFluent<?> fluent,HorizontalPodAutoscalerList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HorizontalPodAutoscalerListBuilder(HorizontalPodAutoscalerList instance) {
    this(instance,false);
  }
  public HorizontalPodAutoscalerListBuilder(HorizontalPodAutoscalerList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  HorizontalPodAutoscalerListFluent<?> fluent;
  Boolean validationEnabled;
  public HorizontalPodAutoscalerList build() {
    HorizontalPodAutoscalerList buildable = new HorizontalPodAutoscalerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}