package io.fabric8.kubernetes.api.model.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ScaleBuilder extends ScaleFluentImpl<ScaleBuilder> implements VisitableBuilder<Scale,ScaleBuilder>{
  public ScaleBuilder() {
    this(false);
  }
  public ScaleBuilder(Boolean validationEnabled) {
    this(new Scale(), validationEnabled);
  }
  public ScaleBuilder(ScaleFluent<?> fluent) {
    this(fluent, false);
  }
  public ScaleBuilder(ScaleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Scale(), validationEnabled);
  }
  public ScaleBuilder(ScaleFluent<?> fluent,Scale instance) {
    this(fluent, instance, false);
  }
  public ScaleBuilder(ScaleFluent<?> fluent,Scale instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ScaleBuilder(Scale instance) {
    this(instance,false);
  }
  public ScaleBuilder(Scale instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ScaleFluent<?> fluent;
  Boolean validationEnabled;
  public Scale build() {
    Scale buildable = new Scale(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}