package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ContainerResourceMetricStatusFluentImpl<A extends ContainerResourceMetricStatusFluent<A>> extends BaseFluent<A> implements ContainerResourceMetricStatusFluent<A>{
  public ContainerResourceMetricStatusFluentImpl() {
  }
  public ContainerResourceMetricStatusFluentImpl(ContainerResourceMetricStatus instance) {
    if (instance != null) {
      this.withContainer(instance.getContainer());
      this.withCurrentAverageUtilization(instance.getCurrentAverageUtilization());
      this.withCurrentAverageValue(instance.getCurrentAverageValue());
      this.withName(instance.getName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String container;
  private Integer currentAverageUtilization;
  private Quantity currentAverageValue;
  private String name;
  private Map<String,Object> additionalProperties;
  public String getContainer() {
    return this.container;
  }
  public A withContainer(String container) {
    this.container=container; return (A) this;
  }
  public Boolean hasContainer() {
    return this.container != null;
  }
  public Integer getCurrentAverageUtilization() {
    return this.currentAverageUtilization;
  }
  public A withCurrentAverageUtilization(Integer currentAverageUtilization) {
    this.currentAverageUtilization=currentAverageUtilization; return (A) this;
  }
  public Boolean hasCurrentAverageUtilization() {
    return this.currentAverageUtilization != null;
  }
  public Quantity getCurrentAverageValue() {
    return this.currentAverageValue;
  }
  public A withCurrentAverageValue(Quantity currentAverageValue) {
    this.currentAverageValue=currentAverageValue; return (A) this;
  }
  public Boolean hasCurrentAverageValue() {
    return this.currentAverageValue != null;
  }
  public A withNewCurrentAverageValue(String amount,String format) {
    return (A)withCurrentAverageValue(new Quantity(amount, format));
  }
  public A withNewCurrentAverageValue(String amount) {
    return (A)withCurrentAverageValue(new Quantity(amount));
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ContainerResourceMetricStatusFluentImpl that = (ContainerResourceMetricStatusFluentImpl) o;
    if (!java.util.Objects.equals(container, that.container)) return false;

    if (!java.util.Objects.equals(currentAverageUtilization, that.currentAverageUtilization)) return false;

    if (!java.util.Objects.equals(currentAverageValue, that.currentAverageValue)) return false;

    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(container,  currentAverageUtilization,  currentAverageValue,  name,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (container != null) { sb.append("container:"); sb.append(container + ","); }
    if (currentAverageUtilization != null) { sb.append("currentAverageUtilization:"); sb.append(currentAverageUtilization + ","); }
    if (currentAverageValue != null) { sb.append("currentAverageValue:"); sb.append(currentAverageValue + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}