package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExternalMetricStatusBuilder extends ExternalMetricStatusFluentImpl<ExternalMetricStatusBuilder> implements VisitableBuilder<ExternalMetricStatus,ExternalMetricStatusBuilder>{
  public ExternalMetricStatusBuilder() {
    this(false);
  }
  public ExternalMetricStatusBuilder(Boolean validationEnabled) {
    this(new ExternalMetricStatus(), validationEnabled);
  }
  public ExternalMetricStatusBuilder(ExternalMetricStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ExternalMetricStatusBuilder(ExternalMetricStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ExternalMetricStatus(), validationEnabled);
  }
  public ExternalMetricStatusBuilder(ExternalMetricStatusFluent<?> fluent,ExternalMetricStatus instance) {
    this(fluent, instance, false);
  }
  public ExternalMetricStatusBuilder(ExternalMetricStatusFluent<?> fluent,ExternalMetricStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCurrent(instance.getCurrent());
      fluent.withMetric(instance.getMetric());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ExternalMetricStatusBuilder(ExternalMetricStatus instance) {
    this(instance,false);
  }
  public ExternalMetricStatusBuilder(ExternalMetricStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCurrent(instance.getCurrent());
      this.withMetric(instance.getMetric());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ExternalMetricStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ExternalMetricStatus build() {
    ExternalMetricStatus buildable = new ExternalMetricStatus(fluent.getCurrent(),fluent.getMetric());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}