package io.fabric8.kubernetes.api.model.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ScaleSpecBuilder extends ScaleSpecFluent<ScaleSpecBuilder> implements VisitableBuilder<ScaleSpec,ScaleSpecBuilder>{
  public ScaleSpecBuilder() {
    this(false);
  }
  public ScaleSpecBuilder(Boolean validationEnabled) {
    this(new ScaleSpec(), validationEnabled);
  }
  public ScaleSpecBuilder(ScaleSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ScaleSpecBuilder(ScaleSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ScaleSpec(), validationEnabled);
  }
  public ScaleSpecBuilder(ScaleSpecFluent<?> fluent,ScaleSpec instance) {
    this(fluent, instance, false);
  }
  public ScaleSpecBuilder(ScaleSpecFluent<?> fluent,ScaleSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ScaleSpec());

    if (instance != null) {
      fluent.withReplicas(instance.getReplicas());
      fluent.withReplicas(instance.getReplicas());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ScaleSpecBuilder(ScaleSpec instance) {
    this(instance,false);
  }
  public ScaleSpecBuilder(ScaleSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ScaleSpec());

    if (instance != null) {
      this.withReplicas(instance.getReplicas());
      this.withReplicas(instance.getReplicas());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ScaleSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ScaleSpec build() {
    ScaleSpec buildable = new ScaleSpec(fluent.getReplicas());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}