package io.fabric8.kubernetes.api.model.autoscaling.v2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExternalMetricSourceBuilder extends ExternalMetricSourceFluent<ExternalMetricSourceBuilder> implements VisitableBuilder<ExternalMetricSource,ExternalMetricSourceBuilder>{
  public ExternalMetricSourceBuilder() {
    this(false);
  }
  public ExternalMetricSourceBuilder(Boolean validationEnabled) {
    this(new ExternalMetricSource(), validationEnabled);
  }
  public ExternalMetricSourceBuilder(ExternalMetricSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ExternalMetricSourceBuilder(ExternalMetricSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ExternalMetricSource(), validationEnabled);
  }
  public ExternalMetricSourceBuilder(ExternalMetricSourceFluent<?> fluent,ExternalMetricSource instance) {
    this(fluent, instance, false);
  }
  public ExternalMetricSourceBuilder(ExternalMetricSourceFluent<?> fluent,ExternalMetricSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ExternalMetricSource());

    if (instance != null) {
      fluent.withMetric(instance.getMetric());
      fluent.withTarget(instance.getTarget());
      fluent.withMetric(instance.getMetric());
      fluent.withTarget(instance.getTarget());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ExternalMetricSourceBuilder(ExternalMetricSource instance) {
    this(instance,false);
  }
  public ExternalMetricSourceBuilder(ExternalMetricSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ExternalMetricSource());

    if (instance != null) {
      this.withMetric(instance.getMetric());
      this.withTarget(instance.getTarget());
      this.withMetric(instance.getMetric());
      this.withTarget(instance.getTarget());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ExternalMetricSourceFluent<?> fluent;
  Boolean validationEnabled;
  public ExternalMetricSource build() {
    ExternalMetricSource buildable = new ExternalMetricSource(fluent.buildMetric(),fluent.buildTarget());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}