package io.fabric8.kubernetes.api.model.autoscaling.v2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HorizontalPodAutoscalerBehaviorBuilder extends HorizontalPodAutoscalerBehaviorFluent<HorizontalPodAutoscalerBehaviorBuilder> implements VisitableBuilder<HorizontalPodAutoscalerBehavior,HorizontalPodAutoscalerBehaviorBuilder>{
  public HorizontalPodAutoscalerBehaviorBuilder() {
    this(false);
  }
  public HorizontalPodAutoscalerBehaviorBuilder(Boolean validationEnabled) {
    this(new HorizontalPodAutoscalerBehavior(), validationEnabled);
  }
  public HorizontalPodAutoscalerBehaviorBuilder(HorizontalPodAutoscalerBehaviorFluent<?> fluent) {
    this(fluent, false);
  }
  public HorizontalPodAutoscalerBehaviorBuilder(HorizontalPodAutoscalerBehaviorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HorizontalPodAutoscalerBehavior(), validationEnabled);
  }
  public HorizontalPodAutoscalerBehaviorBuilder(HorizontalPodAutoscalerBehaviorFluent<?> fluent,HorizontalPodAutoscalerBehavior instance) {
    this(fluent, instance, false);
  }
  public HorizontalPodAutoscalerBehaviorBuilder(HorizontalPodAutoscalerBehaviorFluent<?> fluent,HorizontalPodAutoscalerBehavior instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new HorizontalPodAutoscalerBehavior());

    if (instance != null) {
      fluent.withScaleDown(instance.getScaleDown());
      fluent.withScaleUp(instance.getScaleUp());
      fluent.withScaleDown(instance.getScaleDown());
      fluent.withScaleUp(instance.getScaleUp());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HorizontalPodAutoscalerBehaviorBuilder(HorizontalPodAutoscalerBehavior instance) {
    this(instance,false);
  }
  public HorizontalPodAutoscalerBehaviorBuilder(HorizontalPodAutoscalerBehavior instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new HorizontalPodAutoscalerBehavior());

    if (instance != null) {
      this.withScaleDown(instance.getScaleDown());
      this.withScaleUp(instance.getScaleUp());
      this.withScaleDown(instance.getScaleDown());
      this.withScaleUp(instance.getScaleUp());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  HorizontalPodAutoscalerBehaviorFluent<?> fluent;
  Boolean validationEnabled;
  public HorizontalPodAutoscalerBehavior build() {
    HorizontalPodAutoscalerBehavior buildable = new HorizontalPodAutoscalerBehavior(fluent.buildScaleDown(),fluent.buildScaleUp());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}