package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CrossVersionObjectReferenceBuilder extends CrossVersionObjectReferenceFluent<CrossVersionObjectReferenceBuilder> implements VisitableBuilder<CrossVersionObjectReference,CrossVersionObjectReferenceBuilder>{
  public CrossVersionObjectReferenceBuilder() {
    this(false);
  }
  public CrossVersionObjectReferenceBuilder(Boolean validationEnabled) {
    this(new CrossVersionObjectReference(), validationEnabled);
  }
  public CrossVersionObjectReferenceBuilder(CrossVersionObjectReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public CrossVersionObjectReferenceBuilder(CrossVersionObjectReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CrossVersionObjectReference(), validationEnabled);
  }
  public CrossVersionObjectReferenceBuilder(CrossVersionObjectReferenceFluent<?> fluent,CrossVersionObjectReference instance) {
    this(fluent, instance, false);
  }
  public CrossVersionObjectReferenceBuilder(CrossVersionObjectReferenceFluent<?> fluent,CrossVersionObjectReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CrossVersionObjectReference());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CrossVersionObjectReferenceBuilder(CrossVersionObjectReference instance) {
    this(instance,false);
  }
  public CrossVersionObjectReferenceBuilder(CrossVersionObjectReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CrossVersionObjectReference());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CrossVersionObjectReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public CrossVersionObjectReference build() {
    CrossVersionObjectReference buildable = new CrossVersionObjectReference(fluent.getApiVersion(),fluent.getKind(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}