package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JobStatusBuilder extends JobStatusFluentImpl<JobStatusBuilder> implements VisitableBuilder<JobStatus,JobStatusBuilder>{
  public JobStatusBuilder() {
    this(false);
  }
  public JobStatusBuilder(Boolean validationEnabled) {
    this(new JobStatus(), validationEnabled);
  }
  public JobStatusBuilder(JobStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public JobStatusBuilder(JobStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new JobStatus(), validationEnabled);
  }
  public JobStatusBuilder(JobStatusFluent<?> fluent,JobStatus instance) {
    this(fluent, instance, false);
  }
  public JobStatusBuilder(JobStatusFluent<?> fluent,JobStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withActive(instance.getActive()); 
    fluent.withCompletedIndexes(instance.getCompletedIndexes()); 
    fluent.withCompletionTime(instance.getCompletionTime()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withFailed(instance.getFailed()); 
    fluent.withReady(instance.getReady()); 
    fluent.withStartTime(instance.getStartTime()); 
    fluent.withSucceeded(instance.getSucceeded()); 
    fluent.withUncountedTerminatedPods(instance.getUncountedTerminatedPods()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public JobStatusBuilder(JobStatus instance) {
    this(instance,false);
  }
  public JobStatusBuilder(JobStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withActive(instance.getActive()); 
    this.withCompletedIndexes(instance.getCompletedIndexes()); 
    this.withCompletionTime(instance.getCompletionTime()); 
    this.withConditions(instance.getConditions()); 
    this.withFailed(instance.getFailed()); 
    this.withReady(instance.getReady()); 
    this.withStartTime(instance.getStartTime()); 
    this.withSucceeded(instance.getSucceeded()); 
    this.withUncountedTerminatedPods(instance.getUncountedTerminatedPods()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  JobStatusFluent<?> fluent;
  Boolean validationEnabled;
  public JobStatus build() {
    JobStatus buildable = new JobStatus(fluent.getActive(),fluent.getCompletedIndexes(),fluent.getCompletionTime(),fluent.getConditions(),fluent.getFailed(),fluent.getReady(),fluent.getStartTime(),fluent.getSucceeded(),fluent.getUncountedTerminatedPods());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}