package io.fabric8.kubernetes.api.model.batch.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PodFailurePolicyOnExitCodesRequirementFluentImpl<A extends PodFailurePolicyOnExitCodesRequirementFluent<A>> extends BaseFluent<A> implements PodFailurePolicyOnExitCodesRequirementFluent<A>{
  public PodFailurePolicyOnExitCodesRequirementFluentImpl() {
  }
  public PodFailurePolicyOnExitCodesRequirementFluentImpl(PodFailurePolicyOnExitCodesRequirement instance) {
    this.withContainerName(instance.getContainerName()); 
    this.withOperator(instance.getOperator()); 
    this.withValues(instance.getValues()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String containerName;
  private String operator;
  private List<Integer> values = new ArrayList<Integer>();
  private Map<String,Object> additionalProperties;
  public String getContainerName() {
    return this.containerName;
  }
  public A withContainerName(String containerName) {
    this.containerName=containerName; return (A) this;
  }
  public Boolean hasContainerName() {
    return this.containerName != null;
  }
  public String getOperator() {
    return this.operator;
  }
  public A withOperator(String operator) {
    this.operator=operator; return (A) this;
  }
  public Boolean hasOperator() {
    return this.operator != null;
  }
  public A addToValues(Integer index,Integer item) {
    if (this.values == null) {this.values = new ArrayList<Integer>();}
    this.values.add(index, item);
    return (A)this;
  }
  public A setToValues(Integer index,Integer item) {
    if (this.values == null) {this.values = new ArrayList<Integer>();}
    this.values.set(index, item); return (A)this;
  }
  public A addToValues(java.lang.Integer... items) {
    if (this.values == null) {this.values = new ArrayList<Integer>();}
    for (Integer item : items) {this.values.add(item);} return (A)this;
  }
  public A addAllToValues(Collection<Integer> items) {
    if (this.values == null) {this.values = new ArrayList<Integer>();}
    for (Integer item : items) {this.values.add(item);} return (A)this;
  }
  public A removeFromValues(java.lang.Integer... items) {
    for (Integer item : items) {if (this.values!= null){ this.values.remove(item);}} return (A)this;
  }
  public A removeAllFromValues(Collection<Integer> items) {
    for (Integer item : items) {if (this.values!= null){ this.values.remove(item);}} return (A)this;
  }
  public List<Integer> getValues() {
    return this.values;
  }
  public Integer getValue(Integer index) {
    return this.values.get(index);
  }
  public Integer getFirstValue() {
    return this.values.get(0);
  }
  public Integer getLastValue() {
    return this.values.get(values.size() - 1);
  }
  public Integer getMatchingValue(Predicate<Integer> predicate) {
    for (Integer item: values) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingValue(Predicate<Integer> predicate) {
    for (Integer item: values) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withValues(List<Integer> values) {
    if (values != null) {this.values = new ArrayList(); for (Integer item : values){this.addToValues(item);}} else { this.values = null;} return (A) this;
  }
  public A withValues(java.lang.Integer... values) {
    if (this.values != null) {this.values.clear();}
    if (values != null) {for (Integer item :values){ this.addToValues(item);}} return (A) this;
  }
  public Boolean hasValues() {
    return values != null && !values.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PodFailurePolicyOnExitCodesRequirementFluentImpl that = (PodFailurePolicyOnExitCodesRequirementFluentImpl) o;
    if (containerName != null ? !containerName.equals(that.containerName) :that.containerName != null) return false;
    if (operator != null ? !operator.equals(that.operator) :that.operator != null) return false;
    if (values != null ? !values.equals(that.values) :that.values != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(containerName,  operator,  values,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (containerName != null) { sb.append("containerName:"); sb.append(containerName + ","); }
    if (operator != null) { sb.append("operator:"); sb.append(operator + ","); }
    if (values != null && !values.isEmpty()) { sb.append("values:"); sb.append(values + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}