package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodFailurePolicyOnPodConditionsPatternBuilder extends PodFailurePolicyOnPodConditionsPatternFluentImpl<PodFailurePolicyOnPodConditionsPatternBuilder> implements VisitableBuilder<PodFailurePolicyOnPodConditionsPattern,PodFailurePolicyOnPodConditionsPatternBuilder>{
  public PodFailurePolicyOnPodConditionsPatternBuilder() {
    this(false);
  }
  public PodFailurePolicyOnPodConditionsPatternBuilder(Boolean validationEnabled) {
    this(new PodFailurePolicyOnPodConditionsPattern(), validationEnabled);
  }
  public PodFailurePolicyOnPodConditionsPatternBuilder(PodFailurePolicyOnPodConditionsPatternFluent<?> fluent) {
    this(fluent, false);
  }
  public PodFailurePolicyOnPodConditionsPatternBuilder(PodFailurePolicyOnPodConditionsPatternFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodFailurePolicyOnPodConditionsPattern(), validationEnabled);
  }
  public PodFailurePolicyOnPodConditionsPatternBuilder(PodFailurePolicyOnPodConditionsPatternFluent<?> fluent,PodFailurePolicyOnPodConditionsPattern instance) {
    this(fluent, instance, false);
  }
  public PodFailurePolicyOnPodConditionsPatternBuilder(PodFailurePolicyOnPodConditionsPatternFluent<?> fluent,PodFailurePolicyOnPodConditionsPattern instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodFailurePolicyOnPodConditionsPatternBuilder(PodFailurePolicyOnPodConditionsPattern instance) {
    this(instance,false);
  }
  public PodFailurePolicyOnPodConditionsPatternBuilder(PodFailurePolicyOnPodConditionsPattern instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodFailurePolicyOnPodConditionsPatternFluent<?> fluent;
  Boolean validationEnabled;
  public PodFailurePolicyOnPodConditionsPattern build() {
    PodFailurePolicyOnPodConditionsPattern buildable = new PodFailurePolicyOnPodConditionsPattern(fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}