package io.fabric8.kubernetes.api.model.batch.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CronJobStatusFluentImpl<A extends CronJobStatusFluent<A>> extends BaseFluent<A> implements CronJobStatusFluent<A>{
  public CronJobStatusFluentImpl() {
  }
  public CronJobStatusFluentImpl(CronJobStatus instance) {
    if (instance != null) {
      this.withActive(instance.getActive());
      this.withLastScheduleTime(instance.getLastScheduleTime());
      this.withLastSuccessfulTime(instance.getLastSuccessfulTime());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<ObjectReferenceBuilder> active = new ArrayList<ObjectReferenceBuilder>();
  private String lastScheduleTime;
  private String lastSuccessfulTime;
  private Map<String,Object> additionalProperties;
  public A addToActive(int index,ObjectReference item) {
    if (this.active == null) {this.active = new ArrayList<ObjectReferenceBuilder>();}
    ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
    if (index < 0 || index >= active.size()) { _visitables.get("active").add(builder); active.add(builder); } else { _visitables.get("active").add(index, builder); active.add(index, builder);}
    return (A)this;
  }
  public A setToActive(int index,ObjectReference item) {
    if (this.active == null) {this.active = new ArrayList<ObjectReferenceBuilder>();}
    ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
    if (index < 0 || index >= active.size()) { _visitables.get("active").add(builder); active.add(builder); } else { _visitables.get("active").set(index, builder); active.set(index, builder);}
    return (A)this;
  }
  public A addToActive(io.fabric8.kubernetes.api.model.ObjectReference... items) {
    if (this.active == null) {this.active = new ArrayList<ObjectReferenceBuilder>();}
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("active").add(builder);this.active.add(builder);} return (A)this;
  }
  public A addAllToActive(Collection<ObjectReference> items) {
    if (this.active == null) {this.active = new ArrayList<ObjectReferenceBuilder>();}
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("active").add(builder);this.active.add(builder);} return (A)this;
  }
  public A removeFromActive(io.fabric8.kubernetes.api.model.ObjectReference... items) {
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("active").remove(builder);if (this.active != null) {this.active.remove(builder);}} return (A)this;
  }
  public A removeAllFromActive(Collection<ObjectReference> items) {
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("active").remove(builder);if (this.active != null) {this.active.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromActive(Predicate<ObjectReferenceBuilder> predicate) {
    if (active == null) return (A) this;
    final Iterator<ObjectReferenceBuilder> each = active.iterator();
    final List visitables = _visitables.get("active");
    while (each.hasNext()) {
      ObjectReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildActive instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ObjectReference> getActive() {
    return active != null ? build(active) : null;
  }
  public List<ObjectReference> buildActive() {
    return active != null ? build(active) : null;
  }
  public ObjectReference buildActive(int index) {
    return this.active.get(index).build();
  }
  public ObjectReference buildFirstActive() {
    return this.active.get(0).build();
  }
  public ObjectReference buildLastActive() {
    return this.active.get(active.size() - 1).build();
  }
  public ObjectReference buildMatchingActive(Predicate<ObjectReferenceBuilder> predicate) {
    for (ObjectReferenceBuilder item: active) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingActive(Predicate<ObjectReferenceBuilder> predicate) {
    for (ObjectReferenceBuilder item: active) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withActive(List<ObjectReference> active) {
    if (this.active != null) { _visitables.get("active").clear();}
    if (active != null) {this.active = new ArrayList(); for (ObjectReference item : active){this.addToActive(item);}} else { this.active = null;} return (A) this;
  }
  public A withActive(io.fabric8.kubernetes.api.model.ObjectReference... active) {
    if (this.active != null) {this.active.clear(); _visitables.remove("active"); }
    if (active != null) {for (ObjectReference item :active){ this.addToActive(item);}} return (A) this;
  }
  public Boolean hasActive() {
    return active != null && !active.isEmpty();
  }
  public CronJobStatusFluentImpl.ActiveNested<A> addNewActive() {
    return new CronJobStatusFluentImpl.ActiveNestedImpl();
  }
  public CronJobStatusFluentImpl.ActiveNested<A> addNewActiveLike(ObjectReference item) {
    return new CronJobStatusFluentImpl.ActiveNestedImpl(-1, item);
  }
  public CronJobStatusFluentImpl.ActiveNested<A> setNewActiveLike(int index,ObjectReference item) {
    return new CronJobStatusFluentImpl.ActiveNestedImpl(index, item);
  }
  public CronJobStatusFluentImpl.ActiveNested<A> editActive(int index) {
    if (active.size() <= index) throw new RuntimeException("Can't edit active. Index exceeds size.");
    return setNewActiveLike(index, buildActive(index));
  }
  public CronJobStatusFluentImpl.ActiveNested<A> editFirstActive() {
    if (active.size() == 0) throw new RuntimeException("Can't edit first active. The list is empty.");
    return setNewActiveLike(0, buildActive(0));
  }
  public CronJobStatusFluentImpl.ActiveNested<A> editLastActive() {
    int index = active.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last active. The list is empty.");
    return setNewActiveLike(index, buildActive(index));
  }
  public CronJobStatusFluentImpl.ActiveNested<A> editMatchingActive(Predicate<ObjectReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<active.size();i++) { 
    if (predicate.test(active.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching active. No match found.");
    return setNewActiveLike(index, buildActive(index));
  }
  public String getLastScheduleTime() {
    return this.lastScheduleTime;
  }
  public A withLastScheduleTime(String lastScheduleTime) {
    this.lastScheduleTime=lastScheduleTime; return (A) this;
  }
  public Boolean hasLastScheduleTime() {
    return this.lastScheduleTime != null;
  }
  public String getLastSuccessfulTime() {
    return this.lastSuccessfulTime;
  }
  public A withLastSuccessfulTime(String lastSuccessfulTime) {
    this.lastSuccessfulTime=lastSuccessfulTime; return (A) this;
  }
  public Boolean hasLastSuccessfulTime() {
    return this.lastSuccessfulTime != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CronJobStatusFluentImpl that = (CronJobStatusFluentImpl) o;
    if (!java.util.Objects.equals(active, that.active)) return false;

    if (!java.util.Objects.equals(lastScheduleTime, that.lastScheduleTime)) return false;

    if (!java.util.Objects.equals(lastSuccessfulTime, that.lastSuccessfulTime)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(active,  lastScheduleTime,  lastSuccessfulTime,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (active != null) { sb.append("active:"); sb.append(active + ","); }
    if (lastScheduleTime != null) { sb.append("lastScheduleTime:"); sb.append(lastScheduleTime + ","); }
    if (lastSuccessfulTime != null) { sb.append("lastSuccessfulTime:"); sb.append(lastSuccessfulTime + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ActiveNestedImpl<N> extends ObjectReferenceFluentImpl<CronJobStatusFluentImpl.ActiveNested<N>> implements CronJobStatusFluentImpl.ActiveNested<N>,Nested<N>{
    ActiveNestedImpl(int index,ObjectReference item) {
      this.index = index;
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ActiveNestedImpl() {
      this.index = -1;
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    int index;
    public N and() {
      return (N) CronJobStatusFluentImpl.this.setToActive(index,builder.build());
    }
    public N endActive() {
      return and();
    }
    
  }
  
}