package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CronJobStatusBuilder extends CronJobStatusFluent<CronJobStatusBuilder> implements VisitableBuilder<CronJobStatus,CronJobStatusBuilder>{
  public CronJobStatusBuilder() {
    this(false);
  }
  public CronJobStatusBuilder(Boolean validationEnabled) {
    this(new CronJobStatus(), validationEnabled);
  }
  public CronJobStatusBuilder(CronJobStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public CronJobStatusBuilder(CronJobStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CronJobStatus(), validationEnabled);
  }
  public CronJobStatusBuilder(CronJobStatusFluent<?> fluent,CronJobStatus instance) {
    this(fluent, instance, false);
  }
  public CronJobStatusBuilder(CronJobStatusFluent<?> fluent,CronJobStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CronJobStatus());

    if (instance != null) {
      fluent.withActive(instance.getActive());
      fluent.withLastScheduleTime(instance.getLastScheduleTime());
      fluent.withLastSuccessfulTime(instance.getLastSuccessfulTime());
      fluent.withActive(instance.getActive());
      fluent.withLastScheduleTime(instance.getLastScheduleTime());
      fluent.withLastSuccessfulTime(instance.getLastSuccessfulTime());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CronJobStatusBuilder(CronJobStatus instance) {
    this(instance,false);
  }
  public CronJobStatusBuilder(CronJobStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CronJobStatus());

    if (instance != null) {
      this.withActive(instance.getActive());
      this.withLastScheduleTime(instance.getLastScheduleTime());
      this.withLastSuccessfulTime(instance.getLastSuccessfulTime());
      this.withActive(instance.getActive());
      this.withLastScheduleTime(instance.getLastScheduleTime());
      this.withLastSuccessfulTime(instance.getLastSuccessfulTime());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CronJobStatusFluent<?> fluent;
  Boolean validationEnabled;
  public CronJobStatus build() {
    CronJobStatus buildable = new CronJobStatus(fluent.buildActive(),fluent.getLastScheduleTime(),fluent.getLastSuccessfulTime());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}