package io.fabric8.kubernetes.api.model.certificates.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class CertificateSigningRequestStatusBuilder extends io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestStatusFluentImpl<io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestStatus,io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestStatusBuilder>{
  public CertificateSigningRequestStatusBuilder() {
    this(false);
  }
  public CertificateSigningRequestStatusBuilder(java.lang.Boolean validationEnabled) {
    this(new CertificateSigningRequestStatus(), validationEnabled);
  }
  public CertificateSigningRequestStatusBuilder(io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public CertificateSigningRequestStatusBuilder(io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new CertificateSigningRequestStatus(), validationEnabled);
  }
  public CertificateSigningRequestStatusBuilder(io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestStatus instance) {
    this(fluent, instance, false);
  }
  public CertificateSigningRequestStatusBuilder(io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCertificate(instance.getCertificate()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CertificateSigningRequestStatusBuilder(io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestStatus instance) {
    this(instance,false);
  }
  public CertificateSigningRequestStatusBuilder(io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCertificate(instance.getCertificate()); 
    this.withConditions(instance.getConditions()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestStatus build() {
    CertificateSigningRequestStatus buildable = new CertificateSigningRequestStatus(fluent.getCertificate(),fluent.getConditions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CertificateSigningRequestStatusBuilder that = (CertificateSigningRequestStatusBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}