/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.certificates.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestSpec;
import io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestSpecFluent;
import io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestSpecFluentImpl;
import java.util.Objects;

public class CertificateSigningRequestSpecBuilder
extends CertificateSigningRequestSpecFluentImpl<CertificateSigningRequestSpecBuilder>
implements VisitableBuilder<CertificateSigningRequestSpec, CertificateSigningRequestSpecBuilder> {
    CertificateSigningRequestSpecFluent<?> fluent;
    Boolean validationEnabled;

    public CertificateSigningRequestSpecBuilder() {
        this(false);
    }

    public CertificateSigningRequestSpecBuilder(Boolean validationEnabled) {
        this(new CertificateSigningRequestSpec(), validationEnabled);
    }

    public CertificateSigningRequestSpecBuilder(CertificateSigningRequestSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public CertificateSigningRequestSpecBuilder(CertificateSigningRequestSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CertificateSigningRequestSpec(), validationEnabled);
    }

    public CertificateSigningRequestSpecBuilder(CertificateSigningRequestSpecFluent<?> fluent, CertificateSigningRequestSpec instance) {
        this(fluent, instance, false);
    }

    public CertificateSigningRequestSpecBuilder(CertificateSigningRequestSpecFluent<?> fluent, CertificateSigningRequestSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withExpirationSeconds(instance.getExpirationSeconds());
        fluent.withExtra(instance.getExtra());
        fluent.withGroups(instance.getGroups());
        fluent.withRequest(instance.getRequest());
        fluent.withSignerName(instance.getSignerName());
        fluent.withUid(instance.getUid());
        fluent.withUsages(instance.getUsages());
        fluent.withUsername(instance.getUsername());
        this.validationEnabled = validationEnabled;
    }

    public CertificateSigningRequestSpecBuilder(CertificateSigningRequestSpec instance) {
        this(instance, (Boolean)false);
    }

    public CertificateSigningRequestSpecBuilder(CertificateSigningRequestSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withExpirationSeconds(instance.getExpirationSeconds());
        this.withExtra(instance.getExtra());
        this.withGroups(instance.getGroups());
        this.withRequest(instance.getRequest());
        this.withSignerName(instance.getSignerName());
        this.withUid(instance.getUid());
        this.withUsages(instance.getUsages());
        this.withUsername(instance.getUsername());
        this.validationEnabled = validationEnabled;
    }

    public CertificateSigningRequestSpec build() {
        CertificateSigningRequestSpec buildable = new CertificateSigningRequestSpec(this.fluent.getExpirationSeconds(), this.fluent.getExtra(), this.fluent.getGroups(), this.fluent.getRequest(), this.fluent.getSignerName(), this.fluent.getUid(), this.fluent.getUsages(), this.fluent.getUsername());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CertificateSigningRequestSpecBuilder that = (CertificateSigningRequestSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

