package io.fabric8.kubernetes.api.model.certificates.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterTrustBundleListBuilder extends ClusterTrustBundleListFluent<ClusterTrustBundleListBuilder> implements VisitableBuilder<ClusterTrustBundleList,ClusterTrustBundleListBuilder>{
  public ClusterTrustBundleListBuilder() {
    this(false);
  }
  public ClusterTrustBundleListBuilder(Boolean validationEnabled) {
    this(new ClusterTrustBundleList(), validationEnabled);
  }
  public ClusterTrustBundleListBuilder(ClusterTrustBundleListFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterTrustBundleListBuilder(ClusterTrustBundleListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterTrustBundleList(), validationEnabled);
  }
  public ClusterTrustBundleListBuilder(ClusterTrustBundleListFluent<?> fluent,ClusterTrustBundleList instance) {
    this(fluent, instance, false);
  }
  public ClusterTrustBundleListBuilder(ClusterTrustBundleListFluent<?> fluent,ClusterTrustBundleList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterTrustBundleList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterTrustBundleListBuilder(ClusterTrustBundleList instance) {
    this(instance,false);
  }
  public ClusterTrustBundleListBuilder(ClusterTrustBundleList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterTrustBundleList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterTrustBundleListFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterTrustBundleList build() {
    ClusterTrustBundleList buildable = new ClusterTrustBundleList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}