package io.fabric8.kubernetes.api.model.certificates.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterTrustBundleBuilder extends ClusterTrustBundleFluent<ClusterTrustBundleBuilder> implements VisitableBuilder<ClusterTrustBundle,ClusterTrustBundleBuilder>{
  public ClusterTrustBundleBuilder() {
    this(new ClusterTrustBundle());
  }
  
  public ClusterTrustBundleBuilder(ClusterTrustBundleFluent<?> fluent) {
    this(fluent, new ClusterTrustBundle());
  }
  
  public ClusterTrustBundleBuilder(ClusterTrustBundleFluent<?> fluent,ClusterTrustBundle instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterTrustBundleBuilder(ClusterTrustBundle instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterTrustBundleFluent<?> fluent;
  
  public ClusterTrustBundle build() {
    ClusterTrustBundle buildable = new ClusterTrustBundle(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}