package io.fabric8.kubernetes.api.model.coordination.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class LeaseListBuilder extends LeaseListFluentImpl<LeaseListBuilder> implements VisitableBuilder<LeaseList,LeaseListBuilder> {

    LeaseListFluent<?> fluent;
    Boolean validationEnabled;

    public LeaseListBuilder() {
        this(true);
    }

    public LeaseListBuilder(Boolean validationEnabled) {
        this(new LeaseList(), validationEnabled);
    }

    public LeaseListBuilder(LeaseListFluent<?> fluent) {
        this(fluent, true);
    }

    public LeaseListBuilder(LeaseListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new LeaseList(), validationEnabled);
    }

    public LeaseListBuilder(LeaseListFluent<?> fluent,LeaseList instance) {
        this(fluent, instance, true);
    }

    public LeaseListBuilder(LeaseListFluent<?> fluent,LeaseList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public LeaseListBuilder(LeaseList instance) {
        this(instance,true);
    }

    public LeaseListBuilder(LeaseList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public LeaseList build() {
        LeaseList buildable = new LeaseList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        LeaseListBuilder that = (LeaseListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
