package io.fabric8.kubernetes.api.model.coordination.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LeaseListBuilder extends LeaseListFluentImpl<LeaseListBuilder> implements VisitableBuilder<LeaseList,io.fabric8.kubernetes.api.model.coordination.v1.LeaseListBuilder>{
  public LeaseListBuilder() {
    this(false);
  }
  public LeaseListBuilder(Boolean validationEnabled) {
    this(new LeaseList(), validationEnabled);
  }
  public LeaseListBuilder(io.fabric8.kubernetes.api.model.coordination.v1.LeaseListFluent<?> fluent) {
    this(fluent, false);
  }
  public LeaseListBuilder(io.fabric8.kubernetes.api.model.coordination.v1.LeaseListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new LeaseList(), validationEnabled);
  }
  public LeaseListBuilder(io.fabric8.kubernetes.api.model.coordination.v1.LeaseListFluent<?> fluent,io.fabric8.kubernetes.api.model.coordination.v1.LeaseList instance) {
    this(fluent, instance, false);
  }
  public LeaseListBuilder(io.fabric8.kubernetes.api.model.coordination.v1.LeaseListFluent<?> fluent,io.fabric8.kubernetes.api.model.coordination.v1.LeaseList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public LeaseListBuilder(io.fabric8.kubernetes.api.model.coordination.v1.LeaseList instance) {
    this(instance,false);
  }
  public LeaseListBuilder(io.fabric8.kubernetes.api.model.coordination.v1.LeaseList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.coordination.v1.LeaseListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.coordination.v1.LeaseList build() {
    LeaseList buildable = new LeaseList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}