package io.fabric8.kubernetes.api.model.coordination.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LeaseBuilder extends LeaseFluentImpl<LeaseBuilder> implements VisitableBuilder<Lease,LeaseBuilder>{
  public LeaseBuilder() {
    this(false);
  }
  public LeaseBuilder(Boolean validationEnabled) {
    this(new Lease(), validationEnabled);
  }
  public LeaseBuilder(LeaseFluent<?> fluent) {
    this(fluent, false);
  }
  public LeaseBuilder(LeaseFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Lease(), validationEnabled);
  }
  public LeaseBuilder(LeaseFluent<?> fluent,Lease instance) {
    this(fluent, instance, false);
  }
  public LeaseBuilder(LeaseFluent<?> fluent,Lease instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public LeaseBuilder(Lease instance) {
    this(instance,false);
  }
  public LeaseBuilder(Lease instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  LeaseFluent<?> fluent;
  Boolean validationEnabled;
  public Lease build() {
    Lease buildable = new Lease(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}