package io.fabric8.kubernetes.api.model.coordination.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LeaseSpecBuilder extends LeaseSpecFluentImpl<LeaseSpecBuilder> implements VisitableBuilder<LeaseSpec,LeaseSpecBuilder>{
  public LeaseSpecBuilder() {
    this(false);
  }
  public LeaseSpecBuilder(Boolean validationEnabled) {
    this(new LeaseSpec(), validationEnabled);
  }
  public LeaseSpecBuilder(LeaseSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public LeaseSpecBuilder(LeaseSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LeaseSpec(), validationEnabled);
  }
  public LeaseSpecBuilder(LeaseSpecFluent<?> fluent,LeaseSpec instance) {
    this(fluent, instance, false);
  }
  public LeaseSpecBuilder(LeaseSpecFluent<?> fluent,LeaseSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAcquireTime(instance.getAcquireTime());
      fluent.withHolderIdentity(instance.getHolderIdentity());
      fluent.withLeaseDurationSeconds(instance.getLeaseDurationSeconds());
      fluent.withLeaseTransitions(instance.getLeaseTransitions());
      fluent.withRenewTime(instance.getRenewTime());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public LeaseSpecBuilder(LeaseSpec instance) {
    this(instance,false);
  }
  public LeaseSpecBuilder(LeaseSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAcquireTime(instance.getAcquireTime());
      this.withHolderIdentity(instance.getHolderIdentity());
      this.withLeaseDurationSeconds(instance.getLeaseDurationSeconds());
      this.withLeaseTransitions(instance.getLeaseTransitions());
      this.withRenewTime(instance.getRenewTime());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  LeaseSpecFluent<?> fluent;
  Boolean validationEnabled;
  public LeaseSpec build() {
    LeaseSpec buildable = new LeaseSpec(fluent.getAcquireTime(),fluent.getHolderIdentity(),fluent.getLeaseDurationSeconds(),fluent.getLeaseTransitions(),fluent.getRenewTime());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}