package io.fabric8.kubernetes.api.model.coordination.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class LeaseSpecBuilder extends LeaseSpecFluent<LeaseSpecBuilder> implements VisitableBuilder<LeaseSpec,LeaseSpecBuilder>{
  public LeaseSpecBuilder() {
    this(new LeaseSpec());
  }
  
  public LeaseSpecBuilder(LeaseSpecFluent<?> fluent) {
    this(fluent, new LeaseSpec());
  }
  
  public LeaseSpecBuilder(LeaseSpecFluent<?> fluent,LeaseSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public LeaseSpecBuilder(LeaseSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  LeaseSpecFluent<?> fluent;
  
  public LeaseSpec build() {
    LeaseSpec buildable = new LeaseSpec(fluent.getAcquireTime(),fluent.getHolderIdentity(),fluent.getLeaseDurationSeconds(),fluent.getLeaseTransitions(),fluent.getPreferredHolder(),fluent.getRenewTime(),fluent.getStrategy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}