package io.fabric8.kubernetes.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class GroupVersionKindFluentImpl<A extends GroupVersionKindFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements GroupVersionKindFluent<A>{

    private String group;
    private String kind;
    private String version;

    public GroupVersionKindFluentImpl(){
    }
    public GroupVersionKindFluentImpl(GroupVersionKind instance){
            this.withGroup(instance.getGroup()); 
            this.withKind(instance.getKind()); 
            this.withVersion(instance.getVersion()); 
    }

    public String getGroup(){
            return this.group;
    }

    public A withGroup(String group){
            this.group=group; return (A) this;
    }

    public Boolean hasGroup(){
            return this.group != null;
    }

    public A withNewGroup(String arg1){
            return (A)withGroup(new String(arg1));
    }

    public A withNewGroup(StringBuilder arg1){
            return (A)withGroup(new String(arg1));
    }

    public A withNewGroup(StringBuffer arg1){
            return (A)withGroup(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    public String getVersion(){
            return this.version;
    }

    public A withVersion(String version){
            this.version=version; return (A) this;
    }

    public Boolean hasVersion(){
            return this.version != null;
    }

    public A withNewVersion(String arg1){
            return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuilder arg1){
            return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuffer arg1){
            return (A)withVersion(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            GroupVersionKindFluentImpl that = (GroupVersionKindFluentImpl) o;
            if (group != null ? !group.equals(that.group) :that.group != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (version != null ? !version.equals(that.version) :that.version != null) return false;
            return true;
    }




}
