package io.fabric8.kubernetes.api.model;

import java.lang.Integer;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class EndpointPortFluentImpl<A extends EndpointPortFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EndpointPortFluent<A>{

    private String appProtocol;
    private String name;
    private Integer port;
    private String protocol;

    public EndpointPortFluentImpl(){
    }
    public EndpointPortFluentImpl(EndpointPort instance){
            this.withAppProtocol(instance.getAppProtocol()); 
            this.withName(instance.getName()); 
            this.withPort(instance.getPort()); 
            this.withProtocol(instance.getProtocol()); 
    }

    public String getAppProtocol(){
            return this.appProtocol;
    }

    public A withAppProtocol(String appProtocol){
            this.appProtocol=appProtocol; return (A) this;
    }

    public Boolean hasAppProtocol(){
            return this.appProtocol != null;
    }

    public A withNewAppProtocol(String arg1){
            return (A)withAppProtocol(new String(arg1));
    }

    public A withNewAppProtocol(StringBuilder arg1){
            return (A)withAppProtocol(new String(arg1));
    }

    public A withNewAppProtocol(StringBuffer arg1){
            return (A)withAppProtocol(new String(arg1));
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public Integer getPort(){
            return this.port;
    }

    public A withPort(Integer port){
            this.port=port; return (A) this;
    }

    public Boolean hasPort(){
            return this.port != null;
    }

    public A withNewPort(String arg1){
            return (A)withPort(new Integer(arg1));
    }

    public A withNewPort(int arg1){
            return (A)withPort(new Integer(arg1));
    }

    public String getProtocol(){
            return this.protocol;
    }

    public A withProtocol(String protocol){
            this.protocol=protocol; return (A) this;
    }

    public Boolean hasProtocol(){
            return this.protocol != null;
    }

    public A withNewProtocol(String arg1){
            return (A)withProtocol(new String(arg1));
    }

    public A withNewProtocol(StringBuilder arg1){
            return (A)withProtocol(new String(arg1));
    }

    public A withNewProtocol(StringBuffer arg1){
            return (A)withProtocol(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            EndpointPortFluentImpl that = (EndpointPortFluentImpl) o;
            if (appProtocol != null ? !appProtocol.equals(that.appProtocol) :that.appProtocol != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (port != null ? !port.equals(that.port) :that.port != null) return false;
            if (protocol != null ? !protocol.equals(that.protocol) :that.protocol != null) return false;
            return true;
    }




}
