package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NamespaceConditionBuilder extends NamespaceConditionFluentImpl<NamespaceConditionBuilder> implements VisitableBuilder<NamespaceCondition,NamespaceConditionBuilder> {

    NamespaceConditionFluent<?> fluent;
    Boolean validationEnabled;

    public NamespaceConditionBuilder() { 
        this(true);
    }


    public NamespaceConditionBuilder(Boolean validationEnabled) { 
        this(new NamespaceCondition(), validationEnabled);
    }


    public NamespaceConditionBuilder(NamespaceConditionFluent<?> fluent) { 
        this(fluent, true);
    }


    public NamespaceConditionBuilder(NamespaceConditionFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new NamespaceCondition(), validationEnabled);
    }


    public NamespaceConditionBuilder(NamespaceConditionFluent<?> fluent,NamespaceCondition instance) { 
        this(fluent, instance, true);
    }


    public NamespaceConditionBuilder(NamespaceConditionFluent<?> fluent,NamespaceCondition instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
        fluent.withMessage(instance.getMessage()); 
        fluent.withReason(instance.getReason()); 
        fluent.withStatus(instance.getStatus()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }


    public NamespaceConditionBuilder(NamespaceCondition instance) { 
        this(instance,true);
    }


    public NamespaceConditionBuilder(NamespaceCondition instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withLastTransitionTime(instance.getLastTransitionTime()); 
        this.withMessage(instance.getMessage()); 
        this.withReason(instance.getReason()); 
        this.withStatus(instance.getStatus()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }


    public NamespaceCondition build() {
        NamespaceCondition buildable = new NamespaceCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        NamespaceConditionBuilder that = (NamespaceConditionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
