package io.fabric8.kubernetes.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class GetOptionsFluentImpl<A extends GetOptionsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements GetOptionsFluent<A> {

    private String apiVersion;
    private String kind;
    private String resourceVersion;

    public GetOptionsFluentImpl() { 
    }


    public GetOptionsFluentImpl(GetOptions instance) { 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withResourceVersion(instance.getResourceVersion()); 
    }


    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public A withResourceVersion(String resourceVersion) {
        this.resourceVersion=resourceVersion; return (A) this;
    }

    public Boolean hasResourceVersion() {
        return this.resourceVersion != null;
    }

    public A withNewResourceVersion(String arg1) {
        return (A)withResourceVersion(new String(arg1));
    }

    public A withNewResourceVersion(StringBuilder arg1) {
        return (A)withResourceVersion(new String(arg1));
    }

    public A withNewResourceVersion(StringBuffer arg1) {
        return (A)withResourceVersion(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GetOptionsFluentImpl that = (GetOptionsFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (resourceVersion != null ? !resourceVersion.equals(that.resourceVersion) :that.resourceVersion != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  kind,  resourceVersion,  super.hashCode());
    }

}
