package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ManagedFieldsEntryBuilder extends ManagedFieldsEntryFluentImpl<ManagedFieldsEntryBuilder> implements VisitableBuilder<ManagedFieldsEntry,ManagedFieldsEntryBuilder> {

    ManagedFieldsEntryFluent<?> fluent;
    Boolean validationEnabled;

    public ManagedFieldsEntryBuilder() { 
        this(true);
    }


    public ManagedFieldsEntryBuilder(Boolean validationEnabled) { 
        this(new ManagedFieldsEntry(), validationEnabled);
    }


    public ManagedFieldsEntryBuilder(ManagedFieldsEntryFluent<?> fluent) { 
        this(fluent, true);
    }


    public ManagedFieldsEntryBuilder(ManagedFieldsEntryFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new ManagedFieldsEntry(), validationEnabled);
    }


    public ManagedFieldsEntryBuilder(ManagedFieldsEntryFluent<?> fluent,ManagedFieldsEntry instance) { 
        this(fluent, instance, true);
    }


    public ManagedFieldsEntryBuilder(ManagedFieldsEntryFluent<?> fluent,ManagedFieldsEntry instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withFieldsType(instance.getFieldsType()); 
        fluent.withFieldsV1(instance.getFieldsV1()); 
        fluent.withManager(instance.getManager()); 
        fluent.withOperation(instance.getOperation()); 
        fluent.withTime(instance.getTime()); 
        this.validationEnabled = validationEnabled; 
    }


    public ManagedFieldsEntryBuilder(ManagedFieldsEntry instance) { 
        this(instance,true);
    }


    public ManagedFieldsEntryBuilder(ManagedFieldsEntry instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withFieldsType(instance.getFieldsType()); 
        this.withFieldsV1(instance.getFieldsV1()); 
        this.withManager(instance.getManager()); 
        this.withOperation(instance.getOperation()); 
        this.withTime(instance.getTime()); 
        this.validationEnabled = validationEnabled; 
    }


    public ManagedFieldsEntry build() {
        ManagedFieldsEntry buildable = new ManagedFieldsEntry(fluent.getApiVersion(),fluent.getFieldsType(),fluent.getFieldsV1(),fluent.getManager(),fluent.getOperation(),fluent.getTime());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ManagedFieldsEntryBuilder that = (ManagedFieldsEntryBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
