package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceBuilder extends ServiceFluentImpl<ServiceBuilder> implements VisitableBuilder<Service,ServiceBuilder> {

    ServiceFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceBuilder() { 
        this(true);
    }


    public ServiceBuilder(Boolean validationEnabled) { 
        this(new Service(), validationEnabled);
    }


    public ServiceBuilder(ServiceFluent<?> fluent) { 
        this(fluent, true);
    }


    public ServiceBuilder(ServiceFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new Service(), validationEnabled);
    }


    public ServiceBuilder(ServiceFluent<?> fluent,Service instance) { 
        this(fluent, instance, true);
    }


    public ServiceBuilder(ServiceFluent<?> fluent,Service instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public ServiceBuilder(Service instance) { 
        this(instance,true);
    }


    public ServiceBuilder(Service instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public Service build() {
        Service buildable = new Service(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServiceBuilder that = (ServiceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
