package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodAntiAffinityBuilder extends PodAntiAffinityFluentImpl<PodAntiAffinityBuilder> implements VisitableBuilder<PodAntiAffinity,PodAntiAffinityBuilder> {

    PodAntiAffinityFluent<?> fluent;
    Boolean validationEnabled;

    public PodAntiAffinityBuilder() { 
        this(true);
    }


    public PodAntiAffinityBuilder(Boolean validationEnabled) { 
        this(new PodAntiAffinity(), validationEnabled);
    }


    public PodAntiAffinityBuilder(PodAntiAffinityFluent<?> fluent) { 
        this(fluent, true);
    }


    public PodAntiAffinityBuilder(PodAntiAffinityFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new PodAntiAffinity(), validationEnabled);
    }


    public PodAntiAffinityBuilder(PodAntiAffinityFluent<?> fluent,PodAntiAffinity instance) { 
        this(fluent, instance, true);
    }


    public PodAntiAffinityBuilder(PodAntiAffinityFluent<?> fluent,PodAntiAffinity instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withPreferredDuringSchedulingIgnoredDuringExecution(instance.getPreferredDuringSchedulingIgnoredDuringExecution()); 
        fluent.withRequiredDuringSchedulingIgnoredDuringExecution(instance.getRequiredDuringSchedulingIgnoredDuringExecution()); 
        this.validationEnabled = validationEnabled; 
    }


    public PodAntiAffinityBuilder(PodAntiAffinity instance) { 
        this(instance,true);
    }


    public PodAntiAffinityBuilder(PodAntiAffinity instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withPreferredDuringSchedulingIgnoredDuringExecution(instance.getPreferredDuringSchedulingIgnoredDuringExecution()); 
        this.withRequiredDuringSchedulingIgnoredDuringExecution(instance.getRequiredDuringSchedulingIgnoredDuringExecution()); 
        this.validationEnabled = validationEnabled; 
    }


    public PodAntiAffinity build() {
        PodAntiAffinity buildable = new PodAntiAffinity(fluent.getPreferredDuringSchedulingIgnoredDuringExecution(),fluent.getRequiredDuringSchedulingIgnoredDuringExecution());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodAntiAffinityBuilder that = (PodAntiAffinityBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
