package io.fabric8.kubernetes.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ServiceAccountTokenProjectionFluentImpl<A extends ServiceAccountTokenProjectionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ServiceAccountTokenProjectionFluent<A> {

    private String audience;
    private Long expirationSeconds;
    private String path;

    public ServiceAccountTokenProjectionFluentImpl() { 
    }


    public ServiceAccountTokenProjectionFluentImpl(ServiceAccountTokenProjection instance) { 
        this.withAudience(instance.getAudience()); 
        this.withExpirationSeconds(instance.getExpirationSeconds()); 
        this.withPath(instance.getPath()); 
    }


    public String getAudience() {
        return this.audience;
    }

    public A withAudience(String audience) {
        this.audience=audience; return (A) this;
    }

    public Boolean hasAudience() {
        return this.audience != null;
    }

    public A withNewAudience(String arg1) {
        return (A)withAudience(new String(arg1));
    }

    public A withNewAudience(StringBuilder arg1) {
        return (A)withAudience(new String(arg1));
    }

    public A withNewAudience(StringBuffer arg1) {
        return (A)withAudience(new String(arg1));
    }

    public Long getExpirationSeconds() {
        return this.expirationSeconds;
    }

    public A withExpirationSeconds(Long expirationSeconds) {
        this.expirationSeconds=expirationSeconds; return (A) this;
    }

    public Boolean hasExpirationSeconds() {
        return this.expirationSeconds != null;
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path=path; return (A) this;
    }

    public Boolean hasPath() {
        return this.path != null;
    }

    public A withNewPath(String arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuilder arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuffer arg1) {
        return (A)withPath(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ServiceAccountTokenProjectionFluentImpl that = (ServiceAccountTokenProjectionFluentImpl) o;
        if (audience != null ? !audience.equals(that.audience) :that.audience != null) return false;
        if (expirationSeconds != null ? !expirationSeconds.equals(that.expirationSeconds) :that.expirationSeconds != null) return false;
        if (path != null ? !path.equals(that.path) :that.path != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(audience,  expirationSeconds,  path,  super.hashCode());
    }

}
