package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface ManagedFieldsEntryFluent<A extends ManagedFieldsEntryFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getFieldsType();
    public A withFieldsType(String fieldsType);
    public Boolean hasFieldsType();
    public A withNewFieldsType(String arg1);
    public A withNewFieldsType(StringBuilder arg1);
    public A withNewFieldsType(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildFieldsV1 instead.
 * @return The buildable object.
 */
@Deprecated public FieldsV1 getFieldsV1();
    public FieldsV1 buildFieldsV1();
    public A withFieldsV1(FieldsV1 fieldsV1);
    public Boolean hasFieldsV1();
    public ManagedFieldsEntryFluent.FieldsV1Nested<A> withNewFieldsV1();
    public ManagedFieldsEntryFluent.FieldsV1Nested<A> withNewFieldsV1Like(FieldsV1 item);
    public ManagedFieldsEntryFluent.FieldsV1Nested<A> editFieldsV1();
    public ManagedFieldsEntryFluent.FieldsV1Nested<A> editOrNewFieldsV1();
    public ManagedFieldsEntryFluent.FieldsV1Nested<A> editOrNewFieldsV1Like(FieldsV1 item);
    public String getManager();
    public A withManager(String manager);
    public Boolean hasManager();
    public A withNewManager(String arg1);
    public A withNewManager(StringBuilder arg1);
    public A withNewManager(StringBuffer arg1);
    public String getOperation();
    public A withOperation(String operation);
    public Boolean hasOperation();
    public A withNewOperation(String arg1);
    public A withNewOperation(StringBuilder arg1);
    public A withNewOperation(StringBuffer arg1);
    public String getTime();
    public A withTime(String time);
    public Boolean hasTime();
    public A withNewTime(String arg1);
    public A withNewTime(StringBuilder arg1);
    public A withNewTime(StringBuffer arg1);
    public interface FieldsV1Nested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,FieldsV1Fluent<ManagedFieldsEntryFluent.FieldsV1Nested<N>> {

        public N and();
        public N endFieldsV1();    }


}
