package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface PatchOptionsFluent<A extends PatchOptionsFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToDryRun(int index,String item);
    public A setToDryRun(int index,String item);
    public A addToDryRun(String... items);
    public A addAllToDryRun(Collection<String> items);
    public A removeFromDryRun(String... items);
    public A removeAllFromDryRun(Collection<String> items);
    public List<String> getDryRun();
    public String getDryRun(int index);
    public String getFirstDryRun();
    public String getLastDryRun();
    public String getMatchingDryRun(Predicate<String> predicate);
    public Boolean hasMatchingDryRun(Predicate<String> predicate);
    public A withDryRun(List<String> dryRun);
    public A withDryRun(String... dryRun);
    public Boolean hasDryRun();
    public A addNewDryRun(String arg1);
    public A addNewDryRun(StringBuilder arg1);
    public A addNewDryRun(StringBuffer arg1);
    public String getFieldManager();
    public A withFieldManager(String fieldManager);
    public Boolean hasFieldManager();
    public A withNewFieldManager(String arg1);
    public A withNewFieldManager(StringBuilder arg1);
    public A withNewFieldManager(StringBuffer arg1);
    public Boolean isForce();
    public A withForce(Boolean force);
    public Boolean hasForce();
    public A withNewForce(String arg1);
    public A withNewForce(boolean arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
}
