package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface PodExecOptionsFluent<A extends PodExecOptionsFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToCommand(int index,String item);
    public A setToCommand(int index,String item);
    public A addToCommand(String... items);
    public A addAllToCommand(Collection<String> items);
    public A removeFromCommand(String... items);
    public A removeAllFromCommand(Collection<String> items);
    public List<String> getCommand();
    public String getCommand(int index);
    public String getFirstCommand();
    public String getLastCommand();
    public String getMatchingCommand(Predicate<String> predicate);
    public Boolean hasMatchingCommand(Predicate<String> predicate);
    public A withCommand(List<String> command);
    public A withCommand(String... command);
    public Boolean hasCommand();
    public A addNewCommand(String arg1);
    public A addNewCommand(StringBuilder arg1);
    public A addNewCommand(StringBuffer arg1);
    public String getContainer();
    public A withContainer(String container);
    public Boolean hasContainer();
    public A withNewContainer(String arg1);
    public A withNewContainer(StringBuilder arg1);
    public A withNewContainer(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public Boolean isStderr();
    public A withStderr(Boolean stderr);
    public Boolean hasStderr();
    public A withNewStderr(String arg1);
    public A withNewStderr(boolean arg1);
    public Boolean isStdin();
    public A withStdin(Boolean stdin);
    public Boolean hasStdin();
    public A withNewStdin(String arg1);
    public A withNewStdin(boolean arg1);
    public Boolean isStdout();
    public A withStdout(Boolean stdout);
    public Boolean hasStdout();
    public A withNewStdout(String arg1);
    public A withNewStdout(boolean arg1);
    public Boolean isTty();
    public A withTty(Boolean tty);
    public Boolean hasTty();
    public A withNewTty(String arg1);
    public A withNewTty(boolean arg1);
}
