
package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.sundr.builder.annotations.Buildable;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "clusterIP",
    "externalIPs",
    "externalName",
    "externalTrafficPolicy",
    "healthCheckNodePort",
    "ipFamily",
    "loadBalancerIP",
    "loadBalancerSourceRanges",
    "ports",
    "publishNotReadyAddresses",
    "selector",
    "sessionAffinity",
    "sessionAffinityConfig",
    "topologyKeys",
    "type"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = true, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder")
public class ServiceSpec implements KubernetesResource
{

    /**
     * 
     */
    @JsonProperty("clusterIP")
    @JsonPropertyDescription("")
    private java.lang.String clusterIP;
    /**
     * 
     */
    @JsonProperty("externalIPs")
    @JsonPropertyDescription("")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<java.lang.String> externalIPs = new ArrayList<java.lang.String>();
    /**
     * 
     */
    @JsonProperty("externalName")
    @JsonPropertyDescription("")
    private java.lang.String externalName;
    /**
     * 
     */
    @JsonProperty("externalTrafficPolicy")
    @JsonPropertyDescription("")
    private java.lang.String externalTrafficPolicy;
    /**
     * 
     */
    @JsonProperty("healthCheckNodePort")
    @JsonPropertyDescription("")
    private Integer healthCheckNodePort;
    /**
     * 
     */
    @JsonProperty("ipFamily")
    @JsonPropertyDescription("")
    private java.lang.String ipFamily;
    /**
     * 
     */
    @JsonProperty("loadBalancerIP")
    @JsonPropertyDescription("")
    private java.lang.String loadBalancerIP;
    /**
     * 
     */
    @JsonProperty("loadBalancerSourceRanges")
    @JsonPropertyDescription("")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<java.lang.String> loadBalancerSourceRanges = new ArrayList<java.lang.String>();
    /**
     * 
     */
    @JsonProperty("ports")
    @JsonPropertyDescription("")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<ServicePort> ports = new ArrayList<ServicePort>();
    /**
     * 
     */
    @JsonProperty("publishNotReadyAddresses")
    @JsonPropertyDescription("")
    private Boolean publishNotReadyAddresses;
    /**
     * 
     */
    @JsonProperty("selector")
    @JsonPropertyDescription("")
    private Map<String, String> selector;
    /**
     * 
     */
    @JsonProperty("sessionAffinity")
    @JsonPropertyDescription("")
    private java.lang.String sessionAffinity;
    /**
     * 
     */
    @JsonProperty("sessionAffinityConfig")
    @JsonPropertyDescription("")
    private SessionAffinityConfig sessionAffinityConfig;
    /**
     * 
     */
    @JsonProperty("topologyKeys")
    @JsonPropertyDescription("")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<java.lang.String> topologyKeys = new ArrayList<java.lang.String>();
    /**
     * 
     */
    @JsonProperty("type")
    @JsonPropertyDescription("")
    private java.lang.String type;
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public ServiceSpec() {
    }

    /**
     * 
     * @param healthCheckNodePort
     * @param externalIPs
     * @param sessionAffinity
     * @param ports
     * @param type
     * @param sessionAffinityConfig
     * @param loadBalancerIP
     * @param externalName
     * @param ipFamily
     * @param loadBalancerSourceRanges
     * @param externalTrafficPolicy
     * @param selector
     * @param publishNotReadyAddresses
     * @param topologyKeys
     * @param clusterIP
     */
    public ServiceSpec(java.lang.String clusterIP, List<java.lang.String> externalIPs, java.lang.String externalName, java.lang.String externalTrafficPolicy, Integer healthCheckNodePort, java.lang.String ipFamily, java.lang.String loadBalancerIP, List<java.lang.String> loadBalancerSourceRanges, List<ServicePort> ports, Boolean publishNotReadyAddresses, Map<String, String> selector, java.lang.String sessionAffinity, SessionAffinityConfig sessionAffinityConfig, List<java.lang.String> topologyKeys, java.lang.String type) {
        super();
        this.clusterIP = clusterIP;
        this.externalIPs = externalIPs;
        this.externalName = externalName;
        this.externalTrafficPolicy = externalTrafficPolicy;
        this.healthCheckNodePort = healthCheckNodePort;
        this.ipFamily = ipFamily;
        this.loadBalancerIP = loadBalancerIP;
        this.loadBalancerSourceRanges = loadBalancerSourceRanges;
        this.ports = ports;
        this.publishNotReadyAddresses = publishNotReadyAddresses;
        this.selector = selector;
        this.sessionAffinity = sessionAffinity;
        this.sessionAffinityConfig = sessionAffinityConfig;
        this.topologyKeys = topologyKeys;
        this.type = type;
    }

    /**
     * 
     */
    @JsonProperty("clusterIP")
    public java.lang.String getClusterIP() {
        return clusterIP;
    }

    /**
     * 
     */
    @JsonProperty("clusterIP")
    public void setClusterIP(java.lang.String clusterIP) {
        this.clusterIP = clusterIP;
    }

    /**
     * 
     */
    @JsonProperty("externalIPs")
    public List<java.lang.String> getExternalIPs() {
        return externalIPs;
    }

    /**
     * 
     */
    @JsonProperty("externalIPs")
    public void setExternalIPs(List<java.lang.String> externalIPs) {
        this.externalIPs = externalIPs;
    }

    /**
     * 
     */
    @JsonProperty("externalName")
    public java.lang.String getExternalName() {
        return externalName;
    }

    /**
     * 
     */
    @JsonProperty("externalName")
    public void setExternalName(java.lang.String externalName) {
        this.externalName = externalName;
    }

    /**
     * 
     */
    @JsonProperty("externalTrafficPolicy")
    public java.lang.String getExternalTrafficPolicy() {
        return externalTrafficPolicy;
    }

    /**
     * 
     */
    @JsonProperty("externalTrafficPolicy")
    public void setExternalTrafficPolicy(java.lang.String externalTrafficPolicy) {
        this.externalTrafficPolicy = externalTrafficPolicy;
    }

    /**
     * 
     */
    @JsonProperty("healthCheckNodePort")
    public Integer getHealthCheckNodePort() {
        return healthCheckNodePort;
    }

    /**
     * 
     */
    @JsonProperty("healthCheckNodePort")
    public void setHealthCheckNodePort(Integer healthCheckNodePort) {
        this.healthCheckNodePort = healthCheckNodePort;
    }

    /**
     * 
     */
    @JsonProperty("ipFamily")
    public java.lang.String getIpFamily() {
        return ipFamily;
    }

    /**
     * 
     */
    @JsonProperty("ipFamily")
    public void setIpFamily(java.lang.String ipFamily) {
        this.ipFamily = ipFamily;
    }

    /**
     * 
     */
    @JsonProperty("loadBalancerIP")
    public java.lang.String getLoadBalancerIP() {
        return loadBalancerIP;
    }

    /**
     * 
     */
    @JsonProperty("loadBalancerIP")
    public void setLoadBalancerIP(java.lang.String loadBalancerIP) {
        this.loadBalancerIP = loadBalancerIP;
    }

    /**
     * 
     */
    @JsonProperty("loadBalancerSourceRanges")
    public List<java.lang.String> getLoadBalancerSourceRanges() {
        return loadBalancerSourceRanges;
    }

    /**
     * 
     */
    @JsonProperty("loadBalancerSourceRanges")
    public void setLoadBalancerSourceRanges(List<java.lang.String> loadBalancerSourceRanges) {
        this.loadBalancerSourceRanges = loadBalancerSourceRanges;
    }

    /**
     * 
     */
    @JsonProperty("ports")
    public List<ServicePort> getPorts() {
        return ports;
    }

    /**
     * 
     */
    @JsonProperty("ports")
    public void setPorts(List<ServicePort> ports) {
        this.ports = ports;
    }

    /**
     * 
     */
    @JsonProperty("publishNotReadyAddresses")
    public Boolean getPublishNotReadyAddresses() {
        return publishNotReadyAddresses;
    }

    /**
     * 
     */
    @JsonProperty("publishNotReadyAddresses")
    public void setPublishNotReadyAddresses(Boolean publishNotReadyAddresses) {
        this.publishNotReadyAddresses = publishNotReadyAddresses;
    }

    /**
     * 
     */
    @JsonProperty("selector")
    public Map<String, String> getSelector() {
        return selector;
    }

    /**
     * 
     */
    @JsonProperty("selector")
    public void setSelector(Map<String, String> selector) {
        this.selector = selector;
    }

    /**
     * 
     */
    @JsonProperty("sessionAffinity")
    public java.lang.String getSessionAffinity() {
        return sessionAffinity;
    }

    /**
     * 
     */
    @JsonProperty("sessionAffinity")
    public void setSessionAffinity(java.lang.String sessionAffinity) {
        this.sessionAffinity = sessionAffinity;
    }

    /**
     * 
     */
    @JsonProperty("sessionAffinityConfig")
    public SessionAffinityConfig getSessionAffinityConfig() {
        return sessionAffinityConfig;
    }

    /**
     * 
     */
    @JsonProperty("sessionAffinityConfig")
    public void setSessionAffinityConfig(SessionAffinityConfig sessionAffinityConfig) {
        this.sessionAffinityConfig = sessionAffinityConfig;
    }

    /**
     * 
     */
    @JsonProperty("topologyKeys")
    public List<java.lang.String> getTopologyKeys() {
        return topologyKeys;
    }

    /**
     * 
     */
    @JsonProperty("topologyKeys")
    public void setTopologyKeys(List<java.lang.String> topologyKeys) {
        this.topologyKeys = topologyKeys;
    }

    /**
     * 
     */
    @JsonProperty("type")
    public java.lang.String getType() {
        return type;
    }

    /**
     * 
     */
    @JsonProperty("type")
    public void setType(java.lang.String type) {
        this.type = type;
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
