package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface StatusFluent<A extends StatusFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public Integer getCode();
    public A withCode(Integer code);
    public Boolean hasCode();
    
/**
 * This method has been deprecated, please use method buildDetails instead.
 * @return The buildable object.
 */
@Deprecated public StatusDetails getDetails();
    public StatusDetails buildDetails();
    public A withDetails(StatusDetails details);
    public Boolean hasDetails();
    public StatusFluent.DetailsNested<A> withNewDetails();
    public StatusFluent.DetailsNested<A> withNewDetailsLike(StatusDetails item);
    public StatusFluent.DetailsNested<A> editDetails();
    public StatusFluent.DetailsNested<A> editOrNewDetails();
    public StatusFluent.DetailsNested<A> editOrNewDetailsLike(StatusDetails item);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public String getMessage();
    public A withMessage(String message);
    public Boolean hasMessage();
    public A withNewMessage(String arg1);
    public A withNewMessage(StringBuilder arg1);
    public A withNewMessage(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ListMeta getMetadata();
    public ListMeta buildMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public StatusFluent.MetadataNested<A> withNewMetadata();
    public StatusFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public StatusFluent.MetadataNested<A> editMetadata();
    public StatusFluent.MetadataNested<A> editOrNewMetadata();
    public StatusFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
    public String getReason();
    public A withReason(String reason);
    public Boolean hasReason();
    public A withNewReason(String arg1);
    public A withNewReason(StringBuilder arg1);
    public A withNewReason(StringBuffer arg1);
    public String getStatus();
    public A withStatus(String status);
    public Boolean hasStatus();
    public A withNewStatus(String arg1);
    public A withNewStatus(StringBuilder arg1);
    public A withNewStatus(StringBuffer arg1);
    public interface DetailsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,StatusDetailsFluent<StatusFluent.DetailsNested<N>> {

            public N and();
            public N endDetails();    }


    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<StatusFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


}
