package io.fabric8.kubernetes.api.model;

import java.lang.String;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.version.Info;
import io.fabric8.kubernetes.api.model.version.InfoBuilder;
import java.lang.StringBuffer;
import java.lang.Long;
import java.lang.Boolean;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.version.InfoFluentImpl;
import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class WatchEventFluentImpl<A extends WatchEventFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements WatchEventFluent<A> {

    private VisitableBuilder<? extends KubernetesResource,?> object;
    private String type;

    public WatchEventFluentImpl() {
    }

    public WatchEventFluentImpl(WatchEvent instance) {
        this.withObject(instance.getObject()); 
        this.withType(instance.getType()); 
    }

    
/**
 * This method has been deprecated, please use method buildObject instead.
 * @return The buildable object.
 */
@Deprecated public KubernetesResource getObject() {
        return this.object!=null?this.object.build():null;
    }

    public KubernetesResource buildObject() {
        return this.object!=null?this.object.build():null;
    }

    public A withObject(KubernetesResource object) {
        if (object instanceof Patch){ this.object= new PatchBuilder((Patch)object); _visitables.get("object").add(this.object);}
        if (object instanceof LimitRange){ this.object= new LimitRangeBuilder((LimitRange)object); _visitables.get("object").add(this.object);}
        if (object instanceof APIGroupList){ this.object= new APIGroupListBuilder((APIGroupList)object); _visitables.get("object").add(this.object);}
        if (object instanceof PodTemplateSpec){ this.object= new PodTemplateSpecBuilder((PodTemplateSpec)object); _visitables.get("object").add(this.object);}
        if (object instanceof CSIPersistentVolumeSource){ this.object= new CSIPersistentVolumeSourceBuilder((CSIPersistentVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof AuthInfo){ this.object= new AuthInfoBuilder((AuthInfo)object); _visitables.get("object").add(this.object);}
        if (object instanceof ResourceRequirements){ this.object= new ResourceRequirementsBuilder((ResourceRequirements)object); _visitables.get("object").add(this.object);}
        if (object instanceof APIService){ this.object= new APIServiceBuilder((APIService)object); _visitables.get("object").add(this.object);}
        if (object instanceof ConfigMapKeySelector){ this.object= new ConfigMapKeySelectorBuilder((ConfigMapKeySelector)object); _visitables.get("object").add(this.object);}
        if (object instanceof HostPathVolumeSource){ this.object= new HostPathVolumeSourceBuilder((HostPathVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof NamedContext){ this.object= new NamedContextBuilder((NamedContext)object); _visitables.get("object").add(this.object);}
        if (object instanceof PersistentVolumeClaimList){ this.object= new PersistentVolumeClaimListBuilder((PersistentVolumeClaimList)object); _visitables.get("object").add(this.object);}
        if (object instanceof Config){ this.object= new ConfigBuilder((Config)object); _visitables.get("object").add(this.object);}
        if (object instanceof Affinity){ this.object= new AffinityBuilder((Affinity)object); _visitables.get("object").add(this.object);}
        if (object instanceof ReplicationControllerStatus){ this.object= new ReplicationControllerStatusBuilder((ReplicationControllerStatus)object); _visitables.get("object").add(this.object);}
        if (object instanceof MicroTime){ this.object= new MicroTimeBuilder((MicroTime)object); _visitables.get("object").add(this.object);}
        if (object instanceof APIServiceStatus){ this.object= new APIServiceStatusBuilder((APIServiceStatus)object); _visitables.get("object").add(this.object);}
        if (object instanceof Lifecycle){ this.object= new LifecycleBuilder((Lifecycle)object); _visitables.get("object").add(this.object);}
        if (object instanceof PortworxVolumeSource){ this.object= new PortworxVolumeSourceBuilder((PortworxVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof EventSource){ this.object= new EventSourceBuilder((EventSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof AzureFileVolumeSource){ this.object= new AzureFileVolumeSourceBuilder((AzureFileVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof ComponentCondition){ this.object= new ComponentConditionBuilder((ComponentCondition)object); _visitables.get("object").add(this.object);}
        if (object instanceof EnvVar){ this.object= new EnvVarBuilder((EnvVar)object); _visitables.get("object").add(this.object);}
        if (object instanceof ReplicationControllerSpec){ this.object= new ReplicationControllerSpecBuilder((ReplicationControllerSpec)object); _visitables.get("object").add(this.object);}
        if (object instanceof LoadBalancerIngress){ this.object= new LoadBalancerIngressBuilder((LoadBalancerIngress)object); _visitables.get("object").add(this.object);}
        if (object instanceof AttachedVolume){ this.object= new AttachedVolumeBuilder((AttachedVolume)object); _visitables.get("object").add(this.object);}
        if (object instanceof LocalObjectReference){ this.object= new LocalObjectReferenceBuilder((LocalObjectReference)object); _visitables.get("object").add(this.object);}
        if (object instanceof NamedAuthInfo){ this.object= new NamedAuthInfoBuilder((NamedAuthInfo)object); _visitables.get("object").add(this.object);}
        if (object instanceof EmptyDirVolumeSource){ this.object= new EmptyDirVolumeSourceBuilder((EmptyDirVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof PodSpec){ this.object= new PodSpecBuilder((PodSpec)object); _visitables.get("object").add(this.object);}
        if (object instanceof AzureDiskVolumeSource){ this.object= new AzureDiskVolumeSourceBuilder((AzureDiskVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof ServerAddressByClientCIDR){ this.object= new ServerAddressByClientCIDRBuilder((ServerAddressByClientCIDR)object); _visitables.get("object").add(this.object);}
        if (object instanceof Preconditions){ this.object= new PreconditionsBuilder((Preconditions)object); _visitables.get("object").add(this.object);}
        if (object instanceof Info){ this.object= new InfoBuilder((Info)object); _visitables.get("object").add(this.object);}
        if (object instanceof CephFSVolumeSource){ this.object= new CephFSVolumeSourceBuilder((CephFSVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof EphemeralContainer){ this.object= new EphemeralContainerBuilder((EphemeralContainer)object); _visitables.get("object").add(this.object);}
        if (object instanceof NodeCondition){ this.object= new NodeConditionBuilder((NodeCondition)object); _visitables.get("object").add(this.object);}
        if (object instanceof EndpointSubset){ this.object= new EndpointSubsetBuilder((EndpointSubset)object); _visitables.get("object").add(this.object);}
        if (object instanceof LocalVolumeSource){ this.object= new LocalVolumeSourceBuilder((LocalVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof ServiceStatus){ this.object= new ServiceStatusBuilder((ServiceStatus)object); _visitables.get("object").add(this.object);}
        if (object instanceof ServiceReference){ this.object= new ServiceReferenceBuilder((ServiceReference)object); _visitables.get("object").add(this.object);}
        if (object instanceof Taint){ this.object= new TaintBuilder((Taint)object); _visitables.get("object").add(this.object);}
        if (object instanceof PatchOptions){ this.object= new PatchOptionsBuilder((PatchOptions)object); _visitables.get("object").add(this.object);}
        if (object instanceof ConfigMapNodeConfigSource){ this.object= new ConfigMapNodeConfigSourceBuilder((ConfigMapNodeConfigSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof HTTPGetAction){ this.object= new HTTPGetActionBuilder((HTTPGetAction)object); _visitables.get("object").add(this.object);}
        if (object instanceof GlusterfsPersistentVolumeSource){ this.object= new GlusterfsPersistentVolumeSourceBuilder((GlusterfsPersistentVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof WindowsSecurityContextOptions){ this.object= new WindowsSecurityContextOptionsBuilder((WindowsSecurityContextOptions)object); _visitables.get("object").add(this.object);}
        if (object instanceof ISCSIPersistentVolumeSource){ this.object= new ISCSIPersistentVolumeSourceBuilder((ISCSIPersistentVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof DownwardAPIVolumeSource){ this.object= new DownwardAPIVolumeSourceBuilder((DownwardAPIVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof EnvFromSource){ this.object= new EnvFromSourceBuilder((EnvFromSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof CreateOptions){ this.object= new CreateOptionsBuilder((CreateOptions)object); _visitables.get("object").add(this.object);}
        if (object instanceof NamespaceSpec){ this.object= new NamespaceSpecBuilder((NamespaceSpec)object); _visitables.get("object").add(this.object);}
        if (object instanceof ListMeta){ this.object= new ListMetaBuilder((ListMeta)object); _visitables.get("object").add(this.object);}
        if (object instanceof TypeMeta){ this.object= new TypeMetaBuilder((TypeMeta)object); _visitables.get("object").add(this.object);}
        if (object instanceof RootPaths){ this.object= new RootPathsBuilder((RootPaths)object); _visitables.get("object").add(this.object);}
        if (object instanceof SecretReference){ this.object= new SecretReferenceBuilder((SecretReference)object); _visitables.get("object").add(this.object);}
        if (object instanceof APIGroup){ this.object= new APIGroupBuilder((APIGroup)object); _visitables.get("object").add(this.object);}
        if (object instanceof FlexVolumeSource){ this.object= new FlexVolumeSourceBuilder((FlexVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof PersistentVolumeClaimTemplate){ this.object= new PersistentVolumeClaimTemplateBuilder((PersistentVolumeClaimTemplate)object); _visitables.get("object").add(this.object);}
        if (object instanceof ISCSIVolumeSource){ this.object= new ISCSIVolumeSourceBuilder((ISCSIVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof SecretKeySelector){ this.object= new SecretKeySelectorBuilder((SecretKeySelector)object); _visitables.get("object").add(this.object);}
        if (object instanceof RBDVolumeSource){ this.object= new RBDVolumeSourceBuilder((RBDVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof ResourceQuotaList){ this.object= new ResourceQuotaListBuilder((ResourceQuotaList)object); _visitables.get("object").add(this.object);}
        if (object instanceof NodeConfigStatus){ this.object= new NodeConfigStatusBuilder((NodeConfigStatus)object); _visitables.get("object").add(this.object);}
        if (object instanceof QuobyteVolumeSource){ this.object= new QuobyteVolumeSourceBuilder((QuobyteVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof ResourceQuotaStatus){ this.object= new ResourceQuotaStatusBuilder((ResourceQuotaStatus)object); _visitables.get("object").add(this.object);}
        if (object instanceof ConfigMapProjection){ this.object= new ConfigMapProjectionBuilder((ConfigMapProjection)object); _visitables.get("object").add(this.object);}
        if (object instanceof ScopedResourceSelectorRequirement){ this.object= new ScopedResourceSelectorRequirementBuilder((ScopedResourceSelectorRequirement)object); _visitables.get("object").add(this.object);}
        if (object instanceof Namespace){ this.object= new NamespaceBuilder((Namespace)object); _visitables.get("object").add(this.object);}
        if (object instanceof ContainerStateTerminated){ this.object= new ContainerStateTerminatedBuilder((ContainerStateTerminated)object); _visitables.get("object").add(this.object);}
        if (object instanceof GroupVersionKind){ this.object= new GroupVersionKindBuilder((GroupVersionKind)object); _visitables.get("object").add(this.object);}
        if (object instanceof LimitRangeSpec){ this.object= new LimitRangeSpecBuilder((LimitRangeSpec)object); _visitables.get("object").add(this.object);}
        if (object instanceof ProjectedVolumeSource){ this.object= new ProjectedVolumeSourceBuilder((ProjectedVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof Handler){ this.object= new HandlerBuilder((Handler)object); _visitables.get("object").add(this.object);}
        if (object instanceof PersistentVolumeClaimStatus){ this.object= new PersistentVolumeClaimStatusBuilder((PersistentVolumeClaimStatus)object); _visitables.get("object").add(this.object);}
        if (object instanceof ContainerState){ this.object= new ContainerStateBuilder((ContainerState)object); _visitables.get("object").add(this.object);}
        if (object instanceof ServiceSpec){ this.object= new ServiceSpecBuilder((ServiceSpec)object); _visitables.get("object").add(this.object);}
        if (object instanceof PhotonPersistentDiskVolumeSource){ this.object= new PhotonPersistentDiskVolumeSourceBuilder((PhotonPersistentDiskVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof ServiceAccountTokenProjection){ this.object= new ServiceAccountTokenProjectionBuilder((ServiceAccountTokenProjection)object); _visitables.get("object").add(this.object);}
        if (object instanceof Container){ this.object= new ContainerBuilder((Container)object); _visitables.get("object").add(this.object);}
        if (object instanceof NodeSpec){ this.object= new NodeSpecBuilder((NodeSpec)object); _visitables.get("object").add(this.object);}
        if (object instanceof TypedLocalObjectReference){ this.object= new TypedLocalObjectReferenceBuilder((TypedLocalObjectReference)object); _visitables.get("object").add(this.object);}
        if (object instanceof FieldsV1){ this.object= new FieldsV1Builder((FieldsV1)object); _visitables.get("object").add(this.object);}
        if (object instanceof SecretList){ this.object= new SecretListBuilder((SecretList)object); _visitables.get("object").add(this.object);}
        if (object instanceof NodeAddress){ this.object= new NodeAddressBuilder((NodeAddress)object); _visitables.get("object").add(this.object);}
        if (object instanceof PodAffinity){ this.object= new PodAffinityBuilder((PodAffinity)object); _visitables.get("object").add(this.object);}
        if (object instanceof Service){ this.object= new ServiceBuilder((Service)object); _visitables.get("object").add(this.object);}
        if (object instanceof ExecEnvVar){ this.object= new ExecEnvVarBuilder((ExecEnvVar)object); _visitables.get("object").add(this.object);}
        if (object instanceof PodCondition){ this.object= new PodConditionBuilder((PodCondition)object); _visitables.get("object").add(this.object);}
        if (object instanceof EventSeries){ this.object= new EventSeriesBuilder((EventSeries)object); _visitables.get("object").add(this.object);}
        if (object instanceof TopologySpreadConstraint){ this.object= new TopologySpreadConstraintBuilder((TopologySpreadConstraint)object); _visitables.get("object").add(this.object);}
        if (object instanceof ContainerImage){ this.object= new ContainerImageBuilder((ContainerImage)object); _visitables.get("object").add(this.object);}
        if (object instanceof ExecAction){ this.object= new ExecActionBuilder((ExecAction)object); _visitables.get("object").add(this.object);}
        if (object instanceof ReplicationController){ this.object= new ReplicationControllerBuilder((ReplicationController)object); _visitables.get("object").add(this.object);}
        if (object instanceof NodeStatus){ this.object= new NodeStatusBuilder((NodeStatus)object); _visitables.get("object").add(this.object);}
        if (object instanceof ConfigMapList){ this.object= new ConfigMapListBuilder((ConfigMapList)object); _visitables.get("object").add(this.object);}
        if (object instanceof NodeSelector){ this.object= new NodeSelectorBuilder((NodeSelector)object); _visitables.get("object").add(this.object);}
        if (object instanceof Toleration){ this.object= new TolerationBuilder((Toleration)object); _visitables.get("object").add(this.object);}
        if (object instanceof CephFSPersistentVolumeSource){ this.object= new CephFSPersistentVolumeSourceBuilder((CephFSPersistentVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof PersistentVolumeClaimCondition){ this.object= new PersistentVolumeClaimConditionBuilder((PersistentVolumeClaimCondition)object); _visitables.get("object").add(this.object);}
        if (object instanceof PreferredSchedulingTerm){ this.object= new PreferredSchedulingTermBuilder((PreferredSchedulingTerm)object); _visitables.get("object").add(this.object);}
        if (object instanceof PersistentVolumeList){ this.object= new PersistentVolumeListBuilder((PersistentVolumeList)object); _visitables.get("object").add(this.object);}
        if (object instanceof GCEPersistentDiskVolumeSource){ this.object= new GCEPersistentDiskVolumeSourceBuilder((GCEPersistentDiskVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof PodDNSConfigOption){ this.object= new PodDNSConfigOptionBuilder((PodDNSConfigOption)object); _visitables.get("object").add(this.object);}
        if (object instanceof APIServiceCondition){ this.object= new APIServiceConditionBuilder((APIServiceCondition)object); _visitables.get("object").add(this.object);}
        if (object instanceof EventList){ this.object= new EventListBuilder((EventList)object); _visitables.get("object").add(this.object);}
        if (object instanceof PodReadinessGate){ this.object= new PodReadinessGateBuilder((PodReadinessGate)object); _visitables.get("object").add(this.object);}
        if (object instanceof ContainerStateWaiting){ this.object= new ContainerStateWaitingBuilder((ContainerStateWaiting)object); _visitables.get("object").add(this.object);}
        if (object instanceof VolumeMount){ this.object= new VolumeMountBuilder((VolumeMount)object); _visitables.get("object").add(this.object);}
        if (object instanceof NamespaceCondition){ this.object= new NamespaceConditionBuilder((NamespaceCondition)object); _visitables.get("object").add(this.object);}
        if (object instanceof LabelSelector){ this.object= new LabelSelectorBuilder((LabelSelector)object); _visitables.get("object").add(this.object);}
        if (object instanceof StatusCause){ this.object= new StatusCauseBuilder((StatusCause)object); _visitables.get("object").add(this.object);}
        if (object instanceof NamedCluster){ this.object= new NamedClusterBuilder((NamedCluster)object); _visitables.get("object").add(this.object);}
        if (object instanceof StatusDetails){ this.object= new StatusDetailsBuilder((StatusDetails)object); _visitables.get("object").add(this.object);}
        if (object instanceof DownwardAPIVolumeFile){ this.object= new DownwardAPIVolumeFileBuilder((DownwardAPIVolumeFile)object); _visitables.get("object").add(this.object);}
        if (object instanceof SeccompProfile){ this.object= new SeccompProfileBuilder((SeccompProfile)object); _visitables.get("object").add(this.object);}
        if (object instanceof Sysctl){ this.object= new SysctlBuilder((Sysctl)object); _visitables.get("object").add(this.object);}
        if (object instanceof Status){ this.object= new StatusBuilder((Status)object); _visitables.get("object").add(this.object);}
        if (object instanceof DeleteOptions){ this.object= new DeleteOptionsBuilder((DeleteOptions)object); _visitables.get("object").add(this.object);}
        if (object instanceof ContainerStatus){ this.object= new ContainerStatusBuilder((ContainerStatus)object); _visitables.get("object").add(this.object);}
        if (object instanceof PodTemplate){ this.object= new PodTemplateBuilder((PodTemplate)object); _visitables.get("object").add(this.object);}
        if (object instanceof ConfigMapEnvSource){ this.object= new ConfigMapEnvSourceBuilder((ConfigMapEnvSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof NodeSelectorRequirement){ this.object= new NodeSelectorRequirementBuilder((NodeSelectorRequirement)object); _visitables.get("object").add(this.object);}
        if (object instanceof TCPSocketAction){ this.object= new TCPSocketActionBuilder((TCPSocketAction)object); _visitables.get("object").add(this.object);}
        if (object instanceof Event){ this.object= new EventBuilder((Event)object); _visitables.get("object").add(this.object);}
        if (object instanceof Preferences){ this.object= new PreferencesBuilder((Preferences)object); _visitables.get("object").add(this.object);}
        if (object instanceof ObjectFieldSelector){ this.object= new ObjectFieldSelectorBuilder((ObjectFieldSelector)object); _visitables.get("object").add(this.object);}
        if (object instanceof PodTemplateList){ this.object= new PodTemplateListBuilder((PodTemplateList)object); _visitables.get("object").add(this.object);}
        if (object instanceof PersistentVolume){ this.object= new PersistentVolumeBuilder((PersistentVolume)object); _visitables.get("object").add(this.object);}
        if (object instanceof CinderVolumeSource){ this.object= new CinderVolumeSourceBuilder((CinderVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof EndpointAddress){ this.object= new EndpointAddressBuilder((EndpointAddress)object); _visitables.get("object").add(this.object);}
        if (object instanceof NodeConfigSource){ this.object= new NodeConfigSourceBuilder((NodeConfigSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof VsphereVirtualDiskVolumeSource){ this.object= new VsphereVirtualDiskVolumeSourceBuilder((VsphereVirtualDiskVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof ObjectMeta){ this.object= new ObjectMetaBuilder((ObjectMeta)object); _visitables.get("object").add(this.object);}
        if (object instanceof PersistentVolumeClaim){ this.object= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)object); _visitables.get("object").add(this.object);}
        if (object instanceof LabelSelectorRequirement){ this.object= new LabelSelectorRequirementBuilder((LabelSelectorRequirement)object); _visitables.get("object").add(this.object);}
        if (object instanceof GitRepoVolumeSource){ this.object= new GitRepoVolumeSourceBuilder((GitRepoVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof EndpointsList){ this.object= new EndpointsListBuilder((EndpointsList)object); _visitables.get("object").add(this.object);}
        if (object instanceof GroupVersionResource){ this.object= new GroupVersionResourceBuilder((GroupVersionResource)object); _visitables.get("object").add(this.object);}
        if (object instanceof CinderPersistentVolumeSource){ this.object= new CinderPersistentVolumeSourceBuilder((CinderPersistentVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof TopologySelectorTerm){ this.object= new TopologySelectorTermBuilder((TopologySelectorTerm)object); _visitables.get("object").add(this.object);}
        if (object instanceof OwnerReference){ this.object= new OwnerReferenceBuilder((OwnerReference)object); _visitables.get("object").add(this.object);}
        if (object instanceof StorageOSPersistentVolumeSource){ this.object= new StorageOSPersistentVolumeSourceBuilder((StorageOSPersistentVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof EphemeralVolumeSource){ this.object= new EphemeralVolumeSourceBuilder((EphemeralVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof ReplicationControllerCondition){ this.object= new ReplicationControllerConditionBuilder((ReplicationControllerCondition)object); _visitables.get("object").add(this.object);}
        if (object instanceof PodAntiAffinity){ this.object= new PodAntiAffinityBuilder((PodAntiAffinity)object); _visitables.get("object").add(this.object);}
        if (object instanceof SecurityContext){ this.object= new SecurityContextBuilder((SecurityContext)object); _visitables.get("object").add(this.object);}
        if (object instanceof ReplicationControllerList){ this.object= new ReplicationControllerListBuilder((ReplicationControllerList)object); _visitables.get("object").add(this.object);}
        if (object instanceof ConfigMapVolumeSource){ this.object= new ConfigMapVolumeSourceBuilder((ConfigMapVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof ContainerStateRunning){ this.object= new ContainerStateRunningBuilder((ContainerStateRunning)object); _visitables.get("object").add(this.object);}
        if (object instanceof FlockerVolumeSource){ this.object= new FlockerVolumeSourceBuilder((FlockerVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof ComponentStatusList){ this.object= new ComponentStatusListBuilder((ComponentStatusList)object); _visitables.get("object").add(this.object);}
        if (object instanceof ScaleIOVolumeSource){ this.object= new ScaleIOVolumeSourceBuilder((ScaleIOVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof LimitRangeList){ this.object= new LimitRangeListBuilder((LimitRangeList)object); _visitables.get("object").add(this.object);}
        if (object instanceof PodExecOptions){ this.object= new PodExecOptionsBuilder((PodExecOptions)object); _visitables.get("object").add(this.object);}
        if (object instanceof Probe){ this.object= new ProbeBuilder((Probe)object); _visitables.get("object").add(this.object);}
        if (object instanceof UpdateOptions){ this.object= new UpdateOptionsBuilder((UpdateOptions)object); _visitables.get("object").add(this.object);}
        if (object instanceof Endpoints){ this.object= new EndpointsBuilder((Endpoints)object); _visitables.get("object").add(this.object);}
        if (object instanceof NamedExtension){ this.object= new NamedExtensionBuilder((NamedExtension)object); _visitables.get("object").add(this.object);}
        if (object instanceof AzureFilePersistentVolumeSource){ this.object= new AzureFilePersistentVolumeSourceBuilder((AzureFilePersistentVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof APIServiceList){ this.object= new APIServiceListBuilder((APIServiceList)object); _visitables.get("object").add(this.object);}
        if (object instanceof SecretVolumeSource){ this.object= new SecretVolumeSourceBuilder((SecretVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof Pod){ this.object= new PodBuilder((Pod)object); _visitables.get("object").add(this.object);}
        if (object instanceof ClientIPConfig){ this.object= new ClientIPConfigBuilder((ClientIPConfig)object); _visitables.get("object").add(this.object);}
        if (object instanceof Context){ this.object= new ContextBuilder((Context)object); _visitables.get("object").add(this.object);}
        if (object instanceof NodeAffinity){ this.object= new NodeAffinityBuilder((NodeAffinity)object); _visitables.get("object").add(this.object);}
        if (object instanceof ConfigMap){ this.object= new ConfigMapBuilder((ConfigMap)object); _visitables.get("object").add(this.object);}
        if (object instanceof ContainerPort){ this.object= new ContainerPortBuilder((ContainerPort)object); _visitables.get("object").add(this.object);}
        if (object instanceof Condition){ this.object= new ConditionBuilder((Condition)object); _visitables.get("object").add(this.object);}
        if (object instanceof PodList){ this.object= new PodListBuilder((PodList)object); _visitables.get("object").add(this.object);}
        if (object instanceof FCVolumeSource){ this.object= new FCVolumeSourceBuilder((FCVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof ResourceFieldSelector){ this.object= new ResourceFieldSelectorBuilder((ResourceFieldSelector)object); _visitables.get("object").add(this.object);}
        if (object instanceof PersistentVolumeClaimSpec){ this.object= new PersistentVolumeClaimSpecBuilder((PersistentVolumeClaimSpec)object); _visitables.get("object").add(this.object);}
        if (object instanceof LoadBalancerStatus){ this.object= new LoadBalancerStatusBuilder((LoadBalancerStatus)object); _visitables.get("object").add(this.object);}
        if (object instanceof ScopeSelector){ this.object= new ScopeSelectorBuilder((ScopeSelector)object); _visitables.get("object").add(this.object);}
        if (object instanceof PodSecurityContext){ this.object= new PodSecurityContextBuilder((PodSecurityContext)object); _visitables.get("object").add(this.object);}
        if (object instanceof DownwardAPIProjection){ this.object= new DownwardAPIProjectionBuilder((DownwardAPIProjection)object); _visitables.get("object").add(this.object);}
        if (object instanceof PodAffinityTerm){ this.object= new PodAffinityTermBuilder((PodAffinityTerm)object); _visitables.get("object").add(this.object);}
        if (object instanceof APIServiceSpec){ this.object= new APIServiceSpecBuilder((APIServiceSpec)object); _visitables.get("object").add(this.object);}
        if (object instanceof ServicePort){ this.object= new ServicePortBuilder((ServicePort)object); _visitables.get("object").add(this.object);}
        if (object instanceof GroupVersionForDiscovery){ this.object= new GroupVersionForDiscoveryBuilder((GroupVersionForDiscovery)object); _visitables.get("object").add(this.object);}
        if (object instanceof PersistentVolumeClaimVolumeSource){ this.object= new PersistentVolumeClaimVolumeSourceBuilder((PersistentVolumeClaimVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof SessionAffinityConfig){ this.object= new SessionAffinityConfigBuilder((SessionAffinityConfig)object); _visitables.get("object").add(this.object);}
        if (object instanceof ServiceAccountList){ this.object= new ServiceAccountListBuilder((ServiceAccountList)object); _visitables.get("object").add(this.object);}
        if (object instanceof ComponentStatus){ this.object= new ComponentStatusBuilder((ComponentStatus)object); _visitables.get("object").add(this.object);}
        if (object instanceof DaemonEndpoint){ this.object= new DaemonEndpointBuilder((DaemonEndpoint)object); _visitables.get("object").add(this.object);}
        if (object instanceof KeyToPath){ this.object= new KeyToPathBuilder((KeyToPath)object); _visitables.get("object").add(this.object);}
        if (object instanceof FlexPersistentVolumeSource){ this.object= new FlexPersistentVolumeSourceBuilder((FlexPersistentVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof NamespaceList){ this.object= new NamespaceListBuilder((NamespaceList)object); _visitables.get("object").add(this.object);}
        if (object instanceof PodDNSConfig){ this.object= new PodDNSConfigBuilder((PodDNSConfig)object); _visitables.get("object").add(this.object);}
        if (object instanceof NodeList){ this.object= new NodeListBuilder((NodeList)object); _visitables.get("object").add(this.object);}
        if (object instanceof Binding){ this.object= new BindingBuilder((Binding)object); _visitables.get("object").add(this.object);}
        if (object instanceof EnvVarSource){ this.object= new EnvVarSourceBuilder((EnvVarSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof VolumeProjection){ this.object= new VolumeProjectionBuilder((VolumeProjection)object); _visitables.get("object").add(this.object);}
        if (object instanceof ResourceQuota){ this.object= new ResourceQuotaBuilder((ResourceQuota)object); _visitables.get("object").add(this.object);}
        if (object instanceof Secret){ this.object= new SecretBuilder((Secret)object); _visitables.get("object").add(this.object);}
        if (object instanceof ServiceList){ this.object= new ServiceListBuilder((ServiceList)object); _visitables.get("object").add(this.object);}
        if (object instanceof VolumeNodeAffinity){ this.object= new VolumeNodeAffinityBuilder((VolumeNodeAffinity)object); _visitables.get("object").add(this.object);}
        if (object instanceof ResourceQuotaSpec){ this.object= new ResourceQuotaSpecBuilder((ResourceQuotaSpec)object); _visitables.get("object").add(this.object);}
        if (object instanceof NodeSelectorTerm){ this.object= new NodeSelectorTermBuilder((NodeSelectorTerm)object); _visitables.get("object").add(this.object);}
        if (object instanceof ScaleIOPersistentVolumeSource){ this.object= new ScaleIOPersistentVolumeSourceBuilder((ScaleIOPersistentVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof ListOptions){ this.object= new ListOptionsBuilder((ListOptions)object); _visitables.get("object").add(this.object);}
        if (object instanceof WeightedPodAffinityTerm){ this.object= new WeightedPodAffinityTermBuilder((WeightedPodAffinityTerm)object); _visitables.get("object").add(this.object);}
        if (object instanceof BaseKubernetesList){ this.object= new BaseKubernetesListBuilder((BaseKubernetesList)object); _visitables.get("object").add(this.object);}
        if (object instanceof NodeSystemInfo){ this.object= new NodeSystemInfoBuilder((NodeSystemInfo)object); _visitables.get("object").add(this.object);}
        if (object instanceof TopologySelectorLabelRequirement){ this.object= new TopologySelectorLabelRequirementBuilder((TopologySelectorLabelRequirement)object); _visitables.get("object").add(this.object);}
        if (object instanceof RBDPersistentVolumeSource){ this.object= new RBDPersistentVolumeSourceBuilder((RBDPersistentVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof AuthProviderConfig){ this.object= new AuthProviderConfigBuilder((AuthProviderConfig)object); _visitables.get("object").add(this.object);}
        if (object instanceof SELinuxOptions){ this.object= new SELinuxOptionsBuilder((SELinuxOptions)object); _visitables.get("object").add(this.object);}
        if (object instanceof HostAlias){ this.object= new HostAliasBuilder((HostAlias)object); _visitables.get("object").add(this.object);}
        if (object instanceof NodeDaemonEndpoints){ this.object= new NodeDaemonEndpointsBuilder((NodeDaemonEndpoints)object); _visitables.get("object").add(this.object);}
        if (object instanceof CSIVolumeSource){ this.object= new CSIVolumeSourceBuilder((CSIVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof VolumeDevice){ this.object= new VolumeDeviceBuilder((VolumeDevice)object); _visitables.get("object").add(this.object);}
        if (object instanceof PersistentVolumeSpec){ this.object= new PersistentVolumeSpecBuilder((PersistentVolumeSpec)object); _visitables.get("object").add(this.object);}
        if (object instanceof Node){ this.object= new NodeBuilder((Node)object); _visitables.get("object").add(this.object);}
        if (object instanceof Volume){ this.object= new VolumeBuilder((Volume)object); _visitables.get("object").add(this.object);}
        if (object instanceof NFSVolumeSource){ this.object= new NFSVolumeSourceBuilder((NFSVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof Cluster){ this.object= new ClusterBuilder((Cluster)object); _visitables.get("object").add(this.object);}
        if (object instanceof StorageOSVolumeSource){ this.object= new StorageOSVolumeSourceBuilder((StorageOSVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof PodStatus){ this.object= new PodStatusBuilder((PodStatus)object); _visitables.get("object").add(this.object);}
        if (object instanceof ExecConfig){ this.object= new ExecConfigBuilder((ExecConfig)object); _visitables.get("object").add(this.object);}
        if (object instanceof KubernetesList){ this.object= new KubernetesListBuilder((KubernetesList)object); _visitables.get("object").add(this.object);}
        if (object instanceof PersistentVolumeStatus){ this.object= new PersistentVolumeStatusBuilder((PersistentVolumeStatus)object); _visitables.get("object").add(this.object);}
        if (object instanceof EndpointPort){ this.object= new EndpointPortBuilder((EndpointPort)object); _visitables.get("object").add(this.object);}
        if (object instanceof HTTPHeader){ this.object= new HTTPHeaderBuilder((HTTPHeader)object); _visitables.get("object").add(this.object);}
        if (object instanceof Capabilities){ this.object= new CapabilitiesBuilder((Capabilities)object); _visitables.get("object").add(this.object);}
        if (object instanceof WatchEvent){ this.object= new WatchEventBuilder((WatchEvent)object); _visitables.get("object").add(this.object);}
        if (object instanceof ObjectReference){ this.object= new ObjectReferenceBuilder((ObjectReference)object); _visitables.get("object").add(this.object);}
        if (object instanceof LimitRangeItem){ this.object= new LimitRangeItemBuilder((LimitRangeItem)object); _visitables.get("object").add(this.object);}
        if (object instanceof SecretProjection){ this.object= new SecretProjectionBuilder((SecretProjection)object); _visitables.get("object").add(this.object);}
        if (object instanceof GetOptions){ this.object= new GetOptionsBuilder((GetOptions)object); _visitables.get("object").add(this.object);}
        if (object instanceof GlusterfsVolumeSource){ this.object= new GlusterfsVolumeSourceBuilder((GlusterfsVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof NamespaceStatus){ this.object= new NamespaceStatusBuilder((NamespaceStatus)object); _visitables.get("object").add(this.object);}
        if (object instanceof ManagedFieldsEntry){ this.object= new ManagedFieldsEntryBuilder((ManagedFieldsEntry)object); _visitables.get("object").add(this.object);}
        if (object instanceof SecretEnvSource){ this.object= new SecretEnvSourceBuilder((SecretEnvSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof AWSElasticBlockStoreVolumeSource){ this.object= new AWSElasticBlockStoreVolumeSourceBuilder((AWSElasticBlockStoreVolumeSource)object); _visitables.get("object").add(this.object);}
        if (object instanceof ServiceAccount){ this.object= new ServiceAccountBuilder((ServiceAccount)object); _visitables.get("object").add(this.object);}
        if (object instanceof PodIP){ this.object= new PodIPBuilder((PodIP)object); _visitables.get("object").add(this.object);}
        return (A) this;
    }

    public Boolean hasObject() {
        return this.object != null;
    }

    public A withPatchObject(Patch patchObject) {
        _visitables.get("object").remove(this.object);
        if (patchObject!=null){ this.object= new PatchBuilder(patchObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PatchObjectNested<A> withNewPatchObject() {
        return new PatchObjectNestedImpl();
    }

    public WatchEventFluent.PatchObjectNested<A> withNewPatchObjectLike(Patch item) {
        return new PatchObjectNestedImpl(item);
    }

    public A withLimitRangeObject(LimitRange limitRangeObject) {
        _visitables.get("object").remove(this.object);
        if (limitRangeObject!=null){ this.object= new LimitRangeBuilder(limitRangeObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.LimitRangeObjectNested<A> withNewLimitRangeObject() {
        return new LimitRangeObjectNestedImpl();
    }

    public WatchEventFluent.LimitRangeObjectNested<A> withNewLimitRangeObjectLike(LimitRange item) {
        return new LimitRangeObjectNestedImpl(item);
    }

    public A withAPIGroupListObject(APIGroupList aPIGroupListObject) {
        _visitables.get("object").remove(this.object);
        if (aPIGroupListObject!=null){ this.object= new APIGroupListBuilder(aPIGroupListObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.APIGroupListObjectNested<A> withNewAPIGroupListObject() {
        return new APIGroupListObjectNestedImpl();
    }

    public WatchEventFluent.APIGroupListObjectNested<A> withNewAPIGroupListObjectLike(APIGroupList item) {
        return new APIGroupListObjectNestedImpl(item);
    }

    public A withPodTemplateSpecObject(PodTemplateSpec podTemplateSpecObject) {
        _visitables.get("object").remove(this.object);
        if (podTemplateSpecObject!=null){ this.object= new PodTemplateSpecBuilder(podTemplateSpecObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PodTemplateSpecObjectNested<A> withNewPodTemplateSpecObject() {
        return new PodTemplateSpecObjectNestedImpl();
    }

    public WatchEventFluent.PodTemplateSpecObjectNested<A> withNewPodTemplateSpecObjectLike(PodTemplateSpec item) {
        return new PodTemplateSpecObjectNestedImpl(item);
    }

    public A withCSIPersistentVolumeSourceObject(CSIPersistentVolumeSource cSIPersistentVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (cSIPersistentVolumeSourceObject!=null){ this.object= new CSIPersistentVolumeSourceBuilder(cSIPersistentVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.CSIPersistentVolumeSourceObjectNested<A> withNewCSIPersistentVolumeSourceObject() {
        return new CSIPersistentVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.CSIPersistentVolumeSourceObjectNested<A> withNewCSIPersistentVolumeSourceObjectLike(CSIPersistentVolumeSource item) {
        return new CSIPersistentVolumeSourceObjectNestedImpl(item);
    }

    public A withAuthInfoObject(AuthInfo authInfoObject) {
        _visitables.get("object").remove(this.object);
        if (authInfoObject!=null){ this.object= new AuthInfoBuilder(authInfoObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.AuthInfoObjectNested<A> withNewAuthInfoObject() {
        return new AuthInfoObjectNestedImpl();
    }

    public WatchEventFluent.AuthInfoObjectNested<A> withNewAuthInfoObjectLike(AuthInfo item) {
        return new AuthInfoObjectNestedImpl(item);
    }

    public A withResourceRequirementsObject(ResourceRequirements resourceRequirementsObject) {
        _visitables.get("object").remove(this.object);
        if (resourceRequirementsObject!=null){ this.object= new ResourceRequirementsBuilder(resourceRequirementsObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ResourceRequirementsObjectNested<A> withNewResourceRequirementsObject() {
        return new ResourceRequirementsObjectNestedImpl();
    }

    public WatchEventFluent.ResourceRequirementsObjectNested<A> withNewResourceRequirementsObjectLike(ResourceRequirements item) {
        return new ResourceRequirementsObjectNestedImpl(item);
    }

    public A withAPIServiceObject(APIService aPIServiceObject) {
        _visitables.get("object").remove(this.object);
        if (aPIServiceObject!=null){ this.object= new APIServiceBuilder(aPIServiceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.APIServiceObjectNested<A> withNewAPIServiceObject() {
        return new APIServiceObjectNestedImpl();
    }

    public WatchEventFluent.APIServiceObjectNested<A> withNewAPIServiceObjectLike(APIService item) {
        return new APIServiceObjectNestedImpl(item);
    }

    public A withConfigMapKeySelectorObject(ConfigMapKeySelector configMapKeySelectorObject) {
        _visitables.get("object").remove(this.object);
        if (configMapKeySelectorObject!=null){ this.object= new ConfigMapKeySelectorBuilder(configMapKeySelectorObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ConfigMapKeySelectorObjectNested<A> withNewConfigMapKeySelectorObject() {
        return new ConfigMapKeySelectorObjectNestedImpl();
    }

    public WatchEventFluent.ConfigMapKeySelectorObjectNested<A> withNewConfigMapKeySelectorObjectLike(ConfigMapKeySelector item) {
        return new ConfigMapKeySelectorObjectNestedImpl(item);
    }

    public A withNewConfigMapKeySelectorObject(String key,String name,Boolean optional) {
        return (A)withConfigMapKeySelectorObject(new ConfigMapKeySelector(key, name, optional));
    }

    public A withHostPathVolumeSourceObject(HostPathVolumeSource hostPathVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (hostPathVolumeSourceObject!=null){ this.object= new HostPathVolumeSourceBuilder(hostPathVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.HostPathVolumeSourceObjectNested<A> withNewHostPathVolumeSourceObject() {
        return new HostPathVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.HostPathVolumeSourceObjectNested<A> withNewHostPathVolumeSourceObjectLike(HostPathVolumeSource item) {
        return new HostPathVolumeSourceObjectNestedImpl(item);
    }

    public A withNewHostPathVolumeSourceObject(String path,String type) {
        return (A)withHostPathVolumeSourceObject(new HostPathVolumeSource(path, type));
    }

    public A withNamedContextObject(NamedContext namedContextObject) {
        _visitables.get("object").remove(this.object);
        if (namedContextObject!=null){ this.object= new NamedContextBuilder(namedContextObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.NamedContextObjectNested<A> withNewNamedContextObject() {
        return new NamedContextObjectNestedImpl();
    }

    public WatchEventFluent.NamedContextObjectNested<A> withNewNamedContextObjectLike(NamedContext item) {
        return new NamedContextObjectNestedImpl(item);
    }

    public A withPersistentVolumeClaimListObject(PersistentVolumeClaimList persistentVolumeClaimListObject) {
        _visitables.get("object").remove(this.object);
        if (persistentVolumeClaimListObject!=null){ this.object= new PersistentVolumeClaimListBuilder(persistentVolumeClaimListObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PersistentVolumeClaimListObjectNested<A> withNewPersistentVolumeClaimListObject() {
        return new PersistentVolumeClaimListObjectNestedImpl();
    }

    public WatchEventFluent.PersistentVolumeClaimListObjectNested<A> withNewPersistentVolumeClaimListObjectLike(PersistentVolumeClaimList item) {
        return new PersistentVolumeClaimListObjectNestedImpl(item);
    }

    public A withConfigObject(Config configObject) {
        _visitables.get("object").remove(this.object);
        if (configObject!=null){ this.object= new ConfigBuilder(configObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ConfigObjectNested<A> withNewConfigObject() {
        return new ConfigObjectNestedImpl();
    }

    public WatchEventFluent.ConfigObjectNested<A> withNewConfigObjectLike(Config item) {
        return new ConfigObjectNestedImpl(item);
    }

    public A withAffinityObject(Affinity affinityObject) {
        _visitables.get("object").remove(this.object);
        if (affinityObject!=null){ this.object= new AffinityBuilder(affinityObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.AffinityObjectNested<A> withNewAffinityObject() {
        return new AffinityObjectNestedImpl();
    }

    public WatchEventFluent.AffinityObjectNested<A> withNewAffinityObjectLike(Affinity item) {
        return new AffinityObjectNestedImpl(item);
    }

    public A withReplicationControllerStatusObject(ReplicationControllerStatus replicationControllerStatusObject) {
        _visitables.get("object").remove(this.object);
        if (replicationControllerStatusObject!=null){ this.object= new ReplicationControllerStatusBuilder(replicationControllerStatusObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ReplicationControllerStatusObjectNested<A> withNewReplicationControllerStatusObject() {
        return new ReplicationControllerStatusObjectNestedImpl();
    }

    public WatchEventFluent.ReplicationControllerStatusObjectNested<A> withNewReplicationControllerStatusObjectLike(ReplicationControllerStatus item) {
        return new ReplicationControllerStatusObjectNestedImpl(item);
    }

    public A withMicroTimeObject(MicroTime microTimeObject) {
        _visitables.get("object").remove(this.object);
        if (microTimeObject!=null){ this.object= new MicroTimeBuilder(microTimeObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.MicroTimeObjectNested<A> withNewMicroTimeObject() {
        return new MicroTimeObjectNestedImpl();
    }

    public WatchEventFluent.MicroTimeObjectNested<A> withNewMicroTimeObjectLike(MicroTime item) {
        return new MicroTimeObjectNestedImpl(item);
    }

    public A withNewMicroTimeObject(String time) {
        return (A)withMicroTimeObject(new MicroTime(time));
    }

    public A withAPIServiceStatusObject(APIServiceStatus aPIServiceStatusObject) {
        _visitables.get("object").remove(this.object);
        if (aPIServiceStatusObject!=null){ this.object= new APIServiceStatusBuilder(aPIServiceStatusObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.APIServiceStatusObjectNested<A> withNewAPIServiceStatusObject() {
        return new APIServiceStatusObjectNestedImpl();
    }

    public WatchEventFluent.APIServiceStatusObjectNested<A> withNewAPIServiceStatusObjectLike(APIServiceStatus item) {
        return new APIServiceStatusObjectNestedImpl(item);
    }

    public A withLifecycleObject(Lifecycle lifecycleObject) {
        _visitables.get("object").remove(this.object);
        if (lifecycleObject!=null){ this.object= new LifecycleBuilder(lifecycleObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.LifecycleObjectNested<A> withNewLifecycleObject() {
        return new LifecycleObjectNestedImpl();
    }

    public WatchEventFluent.LifecycleObjectNested<A> withNewLifecycleObjectLike(Lifecycle item) {
        return new LifecycleObjectNestedImpl(item);
    }

    public A withPortworxVolumeSourceObject(PortworxVolumeSource portworxVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (portworxVolumeSourceObject!=null){ this.object= new PortworxVolumeSourceBuilder(portworxVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PortworxVolumeSourceObjectNested<A> withNewPortworxVolumeSourceObject() {
        return new PortworxVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.PortworxVolumeSourceObjectNested<A> withNewPortworxVolumeSourceObjectLike(PortworxVolumeSource item) {
        return new PortworxVolumeSourceObjectNestedImpl(item);
    }

    public A withNewPortworxVolumeSourceObject(String fsType,Boolean readOnly,String volumeID) {
        return (A)withPortworxVolumeSourceObject(new PortworxVolumeSource(fsType, readOnly, volumeID));
    }

    public A withEventSourceObject(EventSource eventSourceObject) {
        _visitables.get("object").remove(this.object);
        if (eventSourceObject!=null){ this.object= new EventSourceBuilder(eventSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.EventSourceObjectNested<A> withNewEventSourceObject() {
        return new EventSourceObjectNestedImpl();
    }

    public WatchEventFluent.EventSourceObjectNested<A> withNewEventSourceObjectLike(EventSource item) {
        return new EventSourceObjectNestedImpl(item);
    }

    public A withNewEventSourceObject(String component,String host) {
        return (A)withEventSourceObject(new EventSource(component, host));
    }

    public A withAzureFileVolumeSourceObject(AzureFileVolumeSource azureFileVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (azureFileVolumeSourceObject!=null){ this.object= new AzureFileVolumeSourceBuilder(azureFileVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.AzureFileVolumeSourceObjectNested<A> withNewAzureFileVolumeSourceObject() {
        return new AzureFileVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.AzureFileVolumeSourceObjectNested<A> withNewAzureFileVolumeSourceObjectLike(AzureFileVolumeSource item) {
        return new AzureFileVolumeSourceObjectNestedImpl(item);
    }

    public A withNewAzureFileVolumeSourceObject(Boolean readOnly,String secretName,String shareName) {
        return (A)withAzureFileVolumeSourceObject(new AzureFileVolumeSource(readOnly, secretName, shareName));
    }

    public A withComponentConditionObject(ComponentCondition componentConditionObject) {
        _visitables.get("object").remove(this.object);
        if (componentConditionObject!=null){ this.object= new ComponentConditionBuilder(componentConditionObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ComponentConditionObjectNested<A> withNewComponentConditionObject() {
        return new ComponentConditionObjectNestedImpl();
    }

    public WatchEventFluent.ComponentConditionObjectNested<A> withNewComponentConditionObjectLike(ComponentCondition item) {
        return new ComponentConditionObjectNestedImpl(item);
    }

    public A withNewComponentConditionObject(String error,String message,String status,String type) {
        return (A)withComponentConditionObject(new ComponentCondition(error, message, status, type));
    }

    public A withEnvVarObject(EnvVar envVarObject) {
        _visitables.get("object").remove(this.object);
        if (envVarObject!=null){ this.object= new EnvVarBuilder(envVarObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.EnvVarObjectNested<A> withNewEnvVarObject() {
        return new EnvVarObjectNestedImpl();
    }

    public WatchEventFluent.EnvVarObjectNested<A> withNewEnvVarObjectLike(EnvVar item) {
        return new EnvVarObjectNestedImpl(item);
    }

    public A withReplicationControllerSpecObject(ReplicationControllerSpec replicationControllerSpecObject) {
        _visitables.get("object").remove(this.object);
        if (replicationControllerSpecObject!=null){ this.object= new ReplicationControllerSpecBuilder(replicationControllerSpecObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ReplicationControllerSpecObjectNested<A> withNewReplicationControllerSpecObject() {
        return new ReplicationControllerSpecObjectNestedImpl();
    }

    public WatchEventFluent.ReplicationControllerSpecObjectNested<A> withNewReplicationControllerSpecObjectLike(ReplicationControllerSpec item) {
        return new ReplicationControllerSpecObjectNestedImpl(item);
    }

    public A withLoadBalancerIngressObject(LoadBalancerIngress loadBalancerIngressObject) {
        _visitables.get("object").remove(this.object);
        if (loadBalancerIngressObject!=null){ this.object= new LoadBalancerIngressBuilder(loadBalancerIngressObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.LoadBalancerIngressObjectNested<A> withNewLoadBalancerIngressObject() {
        return new LoadBalancerIngressObjectNestedImpl();
    }

    public WatchEventFluent.LoadBalancerIngressObjectNested<A> withNewLoadBalancerIngressObjectLike(LoadBalancerIngress item) {
        return new LoadBalancerIngressObjectNestedImpl(item);
    }

    public A withNewLoadBalancerIngressObject(String hostname,String ip) {
        return (A)withLoadBalancerIngressObject(new LoadBalancerIngress(hostname, ip));
    }

    public A withAttachedVolumeObject(AttachedVolume attachedVolumeObject) {
        _visitables.get("object").remove(this.object);
        if (attachedVolumeObject!=null){ this.object= new AttachedVolumeBuilder(attachedVolumeObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.AttachedVolumeObjectNested<A> withNewAttachedVolumeObject() {
        return new AttachedVolumeObjectNestedImpl();
    }

    public WatchEventFluent.AttachedVolumeObjectNested<A> withNewAttachedVolumeObjectLike(AttachedVolume item) {
        return new AttachedVolumeObjectNestedImpl(item);
    }

    public A withNewAttachedVolumeObject(String devicePath,String name) {
        return (A)withAttachedVolumeObject(new AttachedVolume(devicePath, name));
    }

    public A withLocalObjectReference(LocalObjectReference localObjectReference) {
        _visitables.get("object").remove(this.object);
        if (localObjectReference!=null){ this.object= new LocalObjectReferenceBuilder(localObjectReference); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.LocalObjectReferenceNested<A> withNewLocalObjectReference() {
        return new LocalObjectReferenceNestedImpl();
    }

    public WatchEventFluent.LocalObjectReferenceNested<A> withNewLocalObjectReferenceLike(LocalObjectReference item) {
        return new LocalObjectReferenceNestedImpl(item);
    }

    public A withNewLocalObjectReference(String name) {
        return (A)withLocalObjectReference(new LocalObjectReference(name));
    }

    public A withNamedAuthInfoObject(NamedAuthInfo namedAuthInfoObject) {
        _visitables.get("object").remove(this.object);
        if (namedAuthInfoObject!=null){ this.object= new NamedAuthInfoBuilder(namedAuthInfoObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.NamedAuthInfoObjectNested<A> withNewNamedAuthInfoObject() {
        return new NamedAuthInfoObjectNestedImpl();
    }

    public WatchEventFluent.NamedAuthInfoObjectNested<A> withNewNamedAuthInfoObjectLike(NamedAuthInfo item) {
        return new NamedAuthInfoObjectNestedImpl(item);
    }

    public A withEmptyDirVolumeSourceObject(EmptyDirVolumeSource emptyDirVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (emptyDirVolumeSourceObject!=null){ this.object= new EmptyDirVolumeSourceBuilder(emptyDirVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.EmptyDirVolumeSourceObjectNested<A> withNewEmptyDirVolumeSourceObject() {
        return new EmptyDirVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.EmptyDirVolumeSourceObjectNested<A> withNewEmptyDirVolumeSourceObjectLike(EmptyDirVolumeSource item) {
        return new EmptyDirVolumeSourceObjectNestedImpl(item);
    }

    public A withPodSpecObject(PodSpec podSpecObject) {
        _visitables.get("object").remove(this.object);
        if (podSpecObject!=null){ this.object= new PodSpecBuilder(podSpecObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PodSpecObjectNested<A> withNewPodSpecObject() {
        return new PodSpecObjectNestedImpl();
    }

    public WatchEventFluent.PodSpecObjectNested<A> withNewPodSpecObjectLike(PodSpec item) {
        return new PodSpecObjectNestedImpl(item);
    }

    public A withAzureDiskVolumeSourceObject(AzureDiskVolumeSource azureDiskVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (azureDiskVolumeSourceObject!=null){ this.object= new AzureDiskVolumeSourceBuilder(azureDiskVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.AzureDiskVolumeSourceObjectNested<A> withNewAzureDiskVolumeSourceObject() {
        return new AzureDiskVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.AzureDiskVolumeSourceObjectNested<A> withNewAzureDiskVolumeSourceObjectLike(AzureDiskVolumeSource item) {
        return new AzureDiskVolumeSourceObjectNestedImpl(item);
    }

    public A withServerAddressByClientCIDRObject(ServerAddressByClientCIDR serverAddressByClientCIDRObject) {
        _visitables.get("object").remove(this.object);
        if (serverAddressByClientCIDRObject!=null){ this.object= new ServerAddressByClientCIDRBuilder(serverAddressByClientCIDRObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ServerAddressByClientCIDRObjectNested<A> withNewServerAddressByClientCIDRObject() {
        return new ServerAddressByClientCIDRObjectNestedImpl();
    }

    public WatchEventFluent.ServerAddressByClientCIDRObjectNested<A> withNewServerAddressByClientCIDRObjectLike(ServerAddressByClientCIDR item) {
        return new ServerAddressByClientCIDRObjectNestedImpl(item);
    }

    public A withNewServerAddressByClientCIDRObject(String clientCIDR,String serverAddress) {
        return (A)withServerAddressByClientCIDRObject(new ServerAddressByClientCIDR(clientCIDR, serverAddress));
    }

    public A withPreconditionsObject(Preconditions preconditionsObject) {
        _visitables.get("object").remove(this.object);
        if (preconditionsObject!=null){ this.object= new PreconditionsBuilder(preconditionsObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PreconditionsObjectNested<A> withNewPreconditionsObject() {
        return new PreconditionsObjectNestedImpl();
    }

    public WatchEventFluent.PreconditionsObjectNested<A> withNewPreconditionsObjectLike(Preconditions item) {
        return new PreconditionsObjectNestedImpl(item);
    }

    public A withNewPreconditionsObject(String resourceVersion,String uid) {
        return (A)withPreconditionsObject(new Preconditions(resourceVersion, uid));
    }

    public A withInfoObject(Info infoObject) {
        _visitables.get("object").remove(this.object);
        if (infoObject!=null){ this.object= new InfoBuilder(infoObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.InfoObjectNested<A> withNewInfoObject() {
        return new InfoObjectNestedImpl();
    }

    public WatchEventFluent.InfoObjectNested<A> withNewInfoObjectLike(Info item) {
        return new InfoObjectNestedImpl(item);
    }

    public A withCephFSVolumeSourceObject(CephFSVolumeSource cephFSVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (cephFSVolumeSourceObject!=null){ this.object= new CephFSVolumeSourceBuilder(cephFSVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.CephFSVolumeSourceObjectNested<A> withNewCephFSVolumeSourceObject() {
        return new CephFSVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.CephFSVolumeSourceObjectNested<A> withNewCephFSVolumeSourceObjectLike(CephFSVolumeSource item) {
        return new CephFSVolumeSourceObjectNestedImpl(item);
    }

    public A withEphemeralContainerObject(EphemeralContainer ephemeralContainerObject) {
        _visitables.get("object").remove(this.object);
        if (ephemeralContainerObject!=null){ this.object= new EphemeralContainerBuilder(ephemeralContainerObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.EphemeralContainerObjectNested<A> withNewEphemeralContainerObject() {
        return new EphemeralContainerObjectNestedImpl();
    }

    public WatchEventFluent.EphemeralContainerObjectNested<A> withNewEphemeralContainerObjectLike(EphemeralContainer item) {
        return new EphemeralContainerObjectNestedImpl(item);
    }

    public A withNodeConditionObject(NodeCondition nodeConditionObject) {
        _visitables.get("object").remove(this.object);
        if (nodeConditionObject!=null){ this.object= new NodeConditionBuilder(nodeConditionObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.NodeConditionObjectNested<A> withNewNodeConditionObject() {
        return new NodeConditionObjectNestedImpl();
    }

    public WatchEventFluent.NodeConditionObjectNested<A> withNewNodeConditionObjectLike(NodeCondition item) {
        return new NodeConditionObjectNestedImpl(item);
    }

    public A withEndpointSubsetObject(EndpointSubset endpointSubsetObject) {
        _visitables.get("object").remove(this.object);
        if (endpointSubsetObject!=null){ this.object= new EndpointSubsetBuilder(endpointSubsetObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.EndpointSubsetObjectNested<A> withNewEndpointSubsetObject() {
        return new EndpointSubsetObjectNestedImpl();
    }

    public WatchEventFluent.EndpointSubsetObjectNested<A> withNewEndpointSubsetObjectLike(EndpointSubset item) {
        return new EndpointSubsetObjectNestedImpl(item);
    }

    public A withLocalVolumeSourceObject(LocalVolumeSource localVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (localVolumeSourceObject!=null){ this.object= new LocalVolumeSourceBuilder(localVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.LocalVolumeSourceObjectNested<A> withNewLocalVolumeSourceObject() {
        return new LocalVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.LocalVolumeSourceObjectNested<A> withNewLocalVolumeSourceObjectLike(LocalVolumeSource item) {
        return new LocalVolumeSourceObjectNestedImpl(item);
    }

    public A withNewLocalVolumeSourceObject(String fsType,String path) {
        return (A)withLocalVolumeSourceObject(new LocalVolumeSource(fsType, path));
    }

    public A withServiceStatusObject(ServiceStatus serviceStatusObject) {
        _visitables.get("object").remove(this.object);
        if (serviceStatusObject!=null){ this.object= new ServiceStatusBuilder(serviceStatusObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ServiceStatusObjectNested<A> withNewServiceStatusObject() {
        return new ServiceStatusObjectNestedImpl();
    }

    public WatchEventFluent.ServiceStatusObjectNested<A> withNewServiceStatusObjectLike(ServiceStatus item) {
        return new ServiceStatusObjectNestedImpl(item);
    }

    public A withServiceReferenceObject(ServiceReference serviceReferenceObject) {
        _visitables.get("object").remove(this.object);
        if (serviceReferenceObject!=null){ this.object= new ServiceReferenceBuilder(serviceReferenceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ServiceReferenceObjectNested<A> withNewServiceReferenceObject() {
        return new ServiceReferenceObjectNestedImpl();
    }

    public WatchEventFluent.ServiceReferenceObjectNested<A> withNewServiceReferenceObjectLike(ServiceReference item) {
        return new ServiceReferenceObjectNestedImpl(item);
    }

    public A withNewServiceReferenceObject(String name,String namespace,Integer port) {
        return (A)withServiceReferenceObject(new ServiceReference(name, namespace, port));
    }

    public A withTaintObject(Taint taintObject) {
        _visitables.get("object").remove(this.object);
        if (taintObject!=null){ this.object= new TaintBuilder(taintObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.TaintObjectNested<A> withNewTaintObject() {
        return new TaintObjectNestedImpl();
    }

    public WatchEventFluent.TaintObjectNested<A> withNewTaintObjectLike(Taint item) {
        return new TaintObjectNestedImpl(item);
    }

    public A withNewTaintObject(String effect,String key,String timeAdded,String value) {
        return (A)withTaintObject(new Taint(effect, key, timeAdded, value));
    }

    public A withPatchOptionsObject(PatchOptions patchOptionsObject) {
        _visitables.get("object").remove(this.object);
        if (patchOptionsObject!=null){ this.object= new PatchOptionsBuilder(patchOptionsObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PatchOptionsObjectNested<A> withNewPatchOptionsObject() {
        return new PatchOptionsObjectNestedImpl();
    }

    public WatchEventFluent.PatchOptionsObjectNested<A> withNewPatchOptionsObjectLike(PatchOptions item) {
        return new PatchOptionsObjectNestedImpl(item);
    }

    public A withConfigMapNodeConfigSourceObject(ConfigMapNodeConfigSource configMapNodeConfigSourceObject) {
        _visitables.get("object").remove(this.object);
        if (configMapNodeConfigSourceObject!=null){ this.object= new ConfigMapNodeConfigSourceBuilder(configMapNodeConfigSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ConfigMapNodeConfigSourceObjectNested<A> withNewConfigMapNodeConfigSourceObject() {
        return new ConfigMapNodeConfigSourceObjectNestedImpl();
    }

    public WatchEventFluent.ConfigMapNodeConfigSourceObjectNested<A> withNewConfigMapNodeConfigSourceObjectLike(ConfigMapNodeConfigSource item) {
        return new ConfigMapNodeConfigSourceObjectNestedImpl(item);
    }

    public A withNewConfigMapNodeConfigSourceObject(String kubeletConfigKey,String name,String namespace,String resourceVersion,String uid) {
        return (A)withConfigMapNodeConfigSourceObject(new ConfigMapNodeConfigSource(kubeletConfigKey, name, namespace, resourceVersion, uid));
    }

    public A withHTTPGetActionObject(HTTPGetAction hTTPGetActionObject) {
        _visitables.get("object").remove(this.object);
        if (hTTPGetActionObject!=null){ this.object= new HTTPGetActionBuilder(hTTPGetActionObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.HTTPGetActionObjectNested<A> withNewHTTPGetActionObject() {
        return new HTTPGetActionObjectNestedImpl();
    }

    public WatchEventFluent.HTTPGetActionObjectNested<A> withNewHTTPGetActionObjectLike(HTTPGetAction item) {
        return new HTTPGetActionObjectNestedImpl(item);
    }

    public A withGlusterfsPersistentVolumeSourceObject(GlusterfsPersistentVolumeSource glusterfsPersistentVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (glusterfsPersistentVolumeSourceObject!=null){ this.object= new GlusterfsPersistentVolumeSourceBuilder(glusterfsPersistentVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.GlusterfsPersistentVolumeSourceObjectNested<A> withNewGlusterfsPersistentVolumeSourceObject() {
        return new GlusterfsPersistentVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.GlusterfsPersistentVolumeSourceObjectNested<A> withNewGlusterfsPersistentVolumeSourceObjectLike(GlusterfsPersistentVolumeSource item) {
        return new GlusterfsPersistentVolumeSourceObjectNestedImpl(item);
    }

    public A withNewGlusterfsPersistentVolumeSourceObject(String endpoints,String endpointsNamespace,String path,Boolean readOnly) {
        return (A)withGlusterfsPersistentVolumeSourceObject(new GlusterfsPersistentVolumeSource(endpoints, endpointsNamespace, path, readOnly));
    }

    public A withWindowsSecurityContextOptionsObject(WindowsSecurityContextOptions windowsSecurityContextOptionsObject) {
        _visitables.get("object").remove(this.object);
        if (windowsSecurityContextOptionsObject!=null){ this.object= new WindowsSecurityContextOptionsBuilder(windowsSecurityContextOptionsObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.WindowsSecurityContextOptionsObjectNested<A> withNewWindowsSecurityContextOptionsObject() {
        return new WindowsSecurityContextOptionsObjectNestedImpl();
    }

    public WatchEventFluent.WindowsSecurityContextOptionsObjectNested<A> withNewWindowsSecurityContextOptionsObjectLike(WindowsSecurityContextOptions item) {
        return new WindowsSecurityContextOptionsObjectNestedImpl(item);
    }

    public A withNewWindowsSecurityContextOptionsObject(String gmsaCredentialSpec,String gmsaCredentialSpecName,String runAsUserName) {
        return (A)withWindowsSecurityContextOptionsObject(new WindowsSecurityContextOptions(gmsaCredentialSpec, gmsaCredentialSpecName, runAsUserName));
    }

    public A withISCSIPersistentVolumeSourceObject(ISCSIPersistentVolumeSource iSCSIPersistentVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (iSCSIPersistentVolumeSourceObject!=null){ this.object= new ISCSIPersistentVolumeSourceBuilder(iSCSIPersistentVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ISCSIPersistentVolumeSourceObjectNested<A> withNewISCSIPersistentVolumeSourceObject() {
        return new ISCSIPersistentVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.ISCSIPersistentVolumeSourceObjectNested<A> withNewISCSIPersistentVolumeSourceObjectLike(ISCSIPersistentVolumeSource item) {
        return new ISCSIPersistentVolumeSourceObjectNestedImpl(item);
    }

    public A withDownwardAPIVolumeSourceObject(DownwardAPIVolumeSource downwardAPIVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (downwardAPIVolumeSourceObject!=null){ this.object= new DownwardAPIVolumeSourceBuilder(downwardAPIVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.DownwardAPIVolumeSourceObjectNested<A> withNewDownwardAPIVolumeSourceObject() {
        return new DownwardAPIVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.DownwardAPIVolumeSourceObjectNested<A> withNewDownwardAPIVolumeSourceObjectLike(DownwardAPIVolumeSource item) {
        return new DownwardAPIVolumeSourceObjectNestedImpl(item);
    }

    public A withEnvFromSourceObject(EnvFromSource envFromSourceObject) {
        _visitables.get("object").remove(this.object);
        if (envFromSourceObject!=null){ this.object= new EnvFromSourceBuilder(envFromSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.EnvFromSourceObjectNested<A> withNewEnvFromSourceObject() {
        return new EnvFromSourceObjectNestedImpl();
    }

    public WatchEventFluent.EnvFromSourceObjectNested<A> withNewEnvFromSourceObjectLike(EnvFromSource item) {
        return new EnvFromSourceObjectNestedImpl(item);
    }

    public A withCreateOptionsObject(CreateOptions createOptionsObject) {
        _visitables.get("object").remove(this.object);
        if (createOptionsObject!=null){ this.object= new CreateOptionsBuilder(createOptionsObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.CreateOptionsObjectNested<A> withNewCreateOptionsObject() {
        return new CreateOptionsObjectNestedImpl();
    }

    public WatchEventFluent.CreateOptionsObjectNested<A> withNewCreateOptionsObjectLike(CreateOptions item) {
        return new CreateOptionsObjectNestedImpl(item);
    }

    public A withNamespaceSpecObject(NamespaceSpec namespaceSpecObject) {
        _visitables.get("object").remove(this.object);
        if (namespaceSpecObject!=null){ this.object= new NamespaceSpecBuilder(namespaceSpecObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.NamespaceSpecObjectNested<A> withNewNamespaceSpecObject() {
        return new NamespaceSpecObjectNestedImpl();
    }

    public WatchEventFluent.NamespaceSpecObjectNested<A> withNewNamespaceSpecObjectLike(NamespaceSpec item) {
        return new NamespaceSpecObjectNestedImpl(item);
    }

    public A withListMetaObject(ListMeta listMetaObject) {
        _visitables.get("object").remove(this.object);
        if (listMetaObject!=null){ this.object= new ListMetaBuilder(listMetaObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ListMetaObjectNested<A> withNewListMetaObject() {
        return new ListMetaObjectNestedImpl();
    }

    public WatchEventFluent.ListMetaObjectNested<A> withNewListMetaObjectLike(ListMeta item) {
        return new ListMetaObjectNestedImpl(item);
    }

    public A withNewListMetaObject(String _continue,Long remainingItemCount,String resourceVersion,String selfLink) {
        return (A)withListMetaObject(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public A withTypeMetaObject(TypeMeta typeMetaObject) {
        _visitables.get("object").remove(this.object);
        if (typeMetaObject!=null){ this.object= new TypeMetaBuilder(typeMetaObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.TypeMetaObjectNested<A> withNewTypeMetaObject() {
        return new TypeMetaObjectNestedImpl();
    }

    public WatchEventFluent.TypeMetaObjectNested<A> withNewTypeMetaObjectLike(TypeMeta item) {
        return new TypeMetaObjectNestedImpl(item);
    }

    public A withNewTypeMetaObject(String apiVersion,String kind) {
        return (A)withTypeMetaObject(new TypeMeta(apiVersion, kind));
    }

    public A withRootPathsObject(RootPaths rootPathsObject) {
        _visitables.get("object").remove(this.object);
        if (rootPathsObject!=null){ this.object= new RootPathsBuilder(rootPathsObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.RootPathsObjectNested<A> withNewRootPathsObject() {
        return new RootPathsObjectNestedImpl();
    }

    public WatchEventFluent.RootPathsObjectNested<A> withNewRootPathsObjectLike(RootPaths item) {
        return new RootPathsObjectNestedImpl(item);
    }

    public A withSecretReferenceObject(SecretReference secretReferenceObject) {
        _visitables.get("object").remove(this.object);
        if (secretReferenceObject!=null){ this.object= new SecretReferenceBuilder(secretReferenceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.SecretReferenceObjectNested<A> withNewSecretReferenceObject() {
        return new SecretReferenceObjectNestedImpl();
    }

    public WatchEventFluent.SecretReferenceObjectNested<A> withNewSecretReferenceObjectLike(SecretReference item) {
        return new SecretReferenceObjectNestedImpl(item);
    }

    public A withNewSecretReferenceObject(String name,String namespace) {
        return (A)withSecretReferenceObject(new SecretReference(name, namespace));
    }

    public A withAPIGroupObject(APIGroup aPIGroupObject) {
        _visitables.get("object").remove(this.object);
        if (aPIGroupObject!=null){ this.object= new APIGroupBuilder(aPIGroupObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.APIGroupObjectNested<A> withNewAPIGroupObject() {
        return new APIGroupObjectNestedImpl();
    }

    public WatchEventFluent.APIGroupObjectNested<A> withNewAPIGroupObjectLike(APIGroup item) {
        return new APIGroupObjectNestedImpl(item);
    }

    public A withFlexVolumeSourceObject(FlexVolumeSource flexVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (flexVolumeSourceObject!=null){ this.object= new FlexVolumeSourceBuilder(flexVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.FlexVolumeSourceObjectNested<A> withNewFlexVolumeSourceObject() {
        return new FlexVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.FlexVolumeSourceObjectNested<A> withNewFlexVolumeSourceObjectLike(FlexVolumeSource item) {
        return new FlexVolumeSourceObjectNestedImpl(item);
    }

    public A withPersistentVolumeClaimTemplateObject(PersistentVolumeClaimTemplate persistentVolumeClaimTemplateObject) {
        _visitables.get("object").remove(this.object);
        if (persistentVolumeClaimTemplateObject!=null){ this.object= new PersistentVolumeClaimTemplateBuilder(persistentVolumeClaimTemplateObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PersistentVolumeClaimTemplateObjectNested<A> withNewPersistentVolumeClaimTemplateObject() {
        return new PersistentVolumeClaimTemplateObjectNestedImpl();
    }

    public WatchEventFluent.PersistentVolumeClaimTemplateObjectNested<A> withNewPersistentVolumeClaimTemplateObjectLike(PersistentVolumeClaimTemplate item) {
        return new PersistentVolumeClaimTemplateObjectNestedImpl(item);
    }

    public A withISCSIVolumeSourceObject(ISCSIVolumeSource iSCSIVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (iSCSIVolumeSourceObject!=null){ this.object= new ISCSIVolumeSourceBuilder(iSCSIVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ISCSIVolumeSourceObjectNested<A> withNewISCSIVolumeSourceObject() {
        return new ISCSIVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.ISCSIVolumeSourceObjectNested<A> withNewISCSIVolumeSourceObjectLike(ISCSIVolumeSource item) {
        return new ISCSIVolumeSourceObjectNestedImpl(item);
    }

    public A withSecretKeySelectorObject(SecretKeySelector secretKeySelectorObject) {
        _visitables.get("object").remove(this.object);
        if (secretKeySelectorObject!=null){ this.object= new SecretKeySelectorBuilder(secretKeySelectorObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.SecretKeySelectorObjectNested<A> withNewSecretKeySelectorObject() {
        return new SecretKeySelectorObjectNestedImpl();
    }

    public WatchEventFluent.SecretKeySelectorObjectNested<A> withNewSecretKeySelectorObjectLike(SecretKeySelector item) {
        return new SecretKeySelectorObjectNestedImpl(item);
    }

    public A withNewSecretKeySelectorObject(String key,String name,Boolean optional) {
        return (A)withSecretKeySelectorObject(new SecretKeySelector(key, name, optional));
    }

    public A withRBDVolumeSourceObject(RBDVolumeSource rBDVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (rBDVolumeSourceObject!=null){ this.object= new RBDVolumeSourceBuilder(rBDVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.RBDVolumeSourceObjectNested<A> withNewRBDVolumeSourceObject() {
        return new RBDVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.RBDVolumeSourceObjectNested<A> withNewRBDVolumeSourceObjectLike(RBDVolumeSource item) {
        return new RBDVolumeSourceObjectNestedImpl(item);
    }

    public A withResourceQuotaListObject(ResourceQuotaList resourceQuotaListObject) {
        _visitables.get("object").remove(this.object);
        if (resourceQuotaListObject!=null){ this.object= new ResourceQuotaListBuilder(resourceQuotaListObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ResourceQuotaListObjectNested<A> withNewResourceQuotaListObject() {
        return new ResourceQuotaListObjectNestedImpl();
    }

    public WatchEventFluent.ResourceQuotaListObjectNested<A> withNewResourceQuotaListObjectLike(ResourceQuotaList item) {
        return new ResourceQuotaListObjectNestedImpl(item);
    }

    public A withNodeConfigStatusObject(NodeConfigStatus nodeConfigStatusObject) {
        _visitables.get("object").remove(this.object);
        if (nodeConfigStatusObject!=null){ this.object= new NodeConfigStatusBuilder(nodeConfigStatusObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.NodeConfigStatusObjectNested<A> withNewNodeConfigStatusObject() {
        return new NodeConfigStatusObjectNestedImpl();
    }

    public WatchEventFluent.NodeConfigStatusObjectNested<A> withNewNodeConfigStatusObjectLike(NodeConfigStatus item) {
        return new NodeConfigStatusObjectNestedImpl(item);
    }

    public A withQuobyteVolumeSourceObject(QuobyteVolumeSource quobyteVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (quobyteVolumeSourceObject!=null){ this.object= new QuobyteVolumeSourceBuilder(quobyteVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.QuobyteVolumeSourceObjectNested<A> withNewQuobyteVolumeSourceObject() {
        return new QuobyteVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.QuobyteVolumeSourceObjectNested<A> withNewQuobyteVolumeSourceObjectLike(QuobyteVolumeSource item) {
        return new QuobyteVolumeSourceObjectNestedImpl(item);
    }

    public A withResourceQuotaStatusObject(ResourceQuotaStatus resourceQuotaStatusObject) {
        _visitables.get("object").remove(this.object);
        if (resourceQuotaStatusObject!=null){ this.object= new ResourceQuotaStatusBuilder(resourceQuotaStatusObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ResourceQuotaStatusObjectNested<A> withNewResourceQuotaStatusObject() {
        return new ResourceQuotaStatusObjectNestedImpl();
    }

    public WatchEventFluent.ResourceQuotaStatusObjectNested<A> withNewResourceQuotaStatusObjectLike(ResourceQuotaStatus item) {
        return new ResourceQuotaStatusObjectNestedImpl(item);
    }

    public A withConfigMapProjectionObject(ConfigMapProjection configMapProjectionObject) {
        _visitables.get("object").remove(this.object);
        if (configMapProjectionObject!=null){ this.object= new ConfigMapProjectionBuilder(configMapProjectionObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ConfigMapProjectionObjectNested<A> withNewConfigMapProjectionObject() {
        return new ConfigMapProjectionObjectNestedImpl();
    }

    public WatchEventFluent.ConfigMapProjectionObjectNested<A> withNewConfigMapProjectionObjectLike(ConfigMapProjection item) {
        return new ConfigMapProjectionObjectNestedImpl(item);
    }

    public A withScopedResourceSelectorRequirementObject(ScopedResourceSelectorRequirement scopedResourceSelectorRequirementObject) {
        _visitables.get("object").remove(this.object);
        if (scopedResourceSelectorRequirementObject!=null){ this.object= new ScopedResourceSelectorRequirementBuilder(scopedResourceSelectorRequirementObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ScopedResourceSelectorRequirementObjectNested<A> withNewScopedResourceSelectorRequirementObject() {
        return new ScopedResourceSelectorRequirementObjectNestedImpl();
    }

    public WatchEventFluent.ScopedResourceSelectorRequirementObjectNested<A> withNewScopedResourceSelectorRequirementObjectLike(ScopedResourceSelectorRequirement item) {
        return new ScopedResourceSelectorRequirementObjectNestedImpl(item);
    }

    public A withNamespaceObject(Namespace namespaceObject) {
        _visitables.get("object").remove(this.object);
        if (namespaceObject!=null){ this.object= new NamespaceBuilder(namespaceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.NamespaceObjectNested<A> withNewNamespaceObject() {
        return new NamespaceObjectNestedImpl();
    }

    public WatchEventFluent.NamespaceObjectNested<A> withNewNamespaceObjectLike(Namespace item) {
        return new NamespaceObjectNestedImpl(item);
    }

    public A withContainerStateTerminatedObject(ContainerStateTerminated containerStateTerminatedObject) {
        _visitables.get("object").remove(this.object);
        if (containerStateTerminatedObject!=null){ this.object= new ContainerStateTerminatedBuilder(containerStateTerminatedObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ContainerStateTerminatedObjectNested<A> withNewContainerStateTerminatedObject() {
        return new ContainerStateTerminatedObjectNestedImpl();
    }

    public WatchEventFluent.ContainerStateTerminatedObjectNested<A> withNewContainerStateTerminatedObjectLike(ContainerStateTerminated item) {
        return new ContainerStateTerminatedObjectNestedImpl(item);
    }

    public A withGroupVersionKindObject(GroupVersionKind groupVersionKindObject) {
        _visitables.get("object").remove(this.object);
        if (groupVersionKindObject!=null){ this.object= new GroupVersionKindBuilder(groupVersionKindObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.GroupVersionKindObjectNested<A> withNewGroupVersionKindObject() {
        return new GroupVersionKindObjectNestedImpl();
    }

    public WatchEventFluent.GroupVersionKindObjectNested<A> withNewGroupVersionKindObjectLike(GroupVersionKind item) {
        return new GroupVersionKindObjectNestedImpl(item);
    }

    public A withNewGroupVersionKindObject(String group,String kind,String version) {
        return (A)withGroupVersionKindObject(new GroupVersionKind(group, kind, version));
    }

    public A withLimitRangeSpecObject(LimitRangeSpec limitRangeSpecObject) {
        _visitables.get("object").remove(this.object);
        if (limitRangeSpecObject!=null){ this.object= new LimitRangeSpecBuilder(limitRangeSpecObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.LimitRangeSpecObjectNested<A> withNewLimitRangeSpecObject() {
        return new LimitRangeSpecObjectNestedImpl();
    }

    public WatchEventFluent.LimitRangeSpecObjectNested<A> withNewLimitRangeSpecObjectLike(LimitRangeSpec item) {
        return new LimitRangeSpecObjectNestedImpl(item);
    }

    public A withProjectedVolumeSourceObject(ProjectedVolumeSource projectedVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (projectedVolumeSourceObject!=null){ this.object= new ProjectedVolumeSourceBuilder(projectedVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ProjectedVolumeSourceObjectNested<A> withNewProjectedVolumeSourceObject() {
        return new ProjectedVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.ProjectedVolumeSourceObjectNested<A> withNewProjectedVolumeSourceObjectLike(ProjectedVolumeSource item) {
        return new ProjectedVolumeSourceObjectNestedImpl(item);
    }

    public A withHandlerObject(Handler handlerObject) {
        _visitables.get("object").remove(this.object);
        if (handlerObject!=null){ this.object= new HandlerBuilder(handlerObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.HandlerObjectNested<A> withNewHandlerObject() {
        return new HandlerObjectNestedImpl();
    }

    public WatchEventFluent.HandlerObjectNested<A> withNewHandlerObjectLike(Handler item) {
        return new HandlerObjectNestedImpl(item);
    }

    public A withPersistentVolumeClaimStatusObject(PersistentVolumeClaimStatus persistentVolumeClaimStatusObject) {
        _visitables.get("object").remove(this.object);
        if (persistentVolumeClaimStatusObject!=null){ this.object= new PersistentVolumeClaimStatusBuilder(persistentVolumeClaimStatusObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PersistentVolumeClaimStatusObjectNested<A> withNewPersistentVolumeClaimStatusObject() {
        return new PersistentVolumeClaimStatusObjectNestedImpl();
    }

    public WatchEventFluent.PersistentVolumeClaimStatusObjectNested<A> withNewPersistentVolumeClaimStatusObjectLike(PersistentVolumeClaimStatus item) {
        return new PersistentVolumeClaimStatusObjectNestedImpl(item);
    }

    public A withContainerStateObject(ContainerState containerStateObject) {
        _visitables.get("object").remove(this.object);
        if (containerStateObject!=null){ this.object= new ContainerStateBuilder(containerStateObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ContainerStateObjectNested<A> withNewContainerStateObject() {
        return new ContainerStateObjectNestedImpl();
    }

    public WatchEventFluent.ContainerStateObjectNested<A> withNewContainerStateObjectLike(ContainerState item) {
        return new ContainerStateObjectNestedImpl(item);
    }

    public A withServiceSpecObject(ServiceSpec serviceSpecObject) {
        _visitables.get("object").remove(this.object);
        if (serviceSpecObject!=null){ this.object= new ServiceSpecBuilder(serviceSpecObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ServiceSpecObjectNested<A> withNewServiceSpecObject() {
        return new ServiceSpecObjectNestedImpl();
    }

    public WatchEventFluent.ServiceSpecObjectNested<A> withNewServiceSpecObjectLike(ServiceSpec item) {
        return new ServiceSpecObjectNestedImpl(item);
    }

    public A withPhotonPersistentDiskVolumeSourceObject(PhotonPersistentDiskVolumeSource photonPersistentDiskVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (photonPersistentDiskVolumeSourceObject!=null){ this.object= new PhotonPersistentDiskVolumeSourceBuilder(photonPersistentDiskVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PhotonPersistentDiskVolumeSourceObjectNested<A> withNewPhotonPersistentDiskVolumeSourceObject() {
        return new PhotonPersistentDiskVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.PhotonPersistentDiskVolumeSourceObjectNested<A> withNewPhotonPersistentDiskVolumeSourceObjectLike(PhotonPersistentDiskVolumeSource item) {
        return new PhotonPersistentDiskVolumeSourceObjectNestedImpl(item);
    }

    public A withNewPhotonPersistentDiskVolumeSourceObject(String fsType,String pdID) {
        return (A)withPhotonPersistentDiskVolumeSourceObject(new PhotonPersistentDiskVolumeSource(fsType, pdID));
    }

    public A withServiceAccountTokenProjectionObject(ServiceAccountTokenProjection serviceAccountTokenProjectionObject) {
        _visitables.get("object").remove(this.object);
        if (serviceAccountTokenProjectionObject!=null){ this.object= new ServiceAccountTokenProjectionBuilder(serviceAccountTokenProjectionObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ServiceAccountTokenProjectionObjectNested<A> withNewServiceAccountTokenProjectionObject() {
        return new ServiceAccountTokenProjectionObjectNestedImpl();
    }

    public WatchEventFluent.ServiceAccountTokenProjectionObjectNested<A> withNewServiceAccountTokenProjectionObjectLike(ServiceAccountTokenProjection item) {
        return new ServiceAccountTokenProjectionObjectNestedImpl(item);
    }

    public A withNewServiceAccountTokenProjectionObject(String audience,Long expirationSeconds,String path) {
        return (A)withServiceAccountTokenProjectionObject(new ServiceAccountTokenProjection(audience, expirationSeconds, path));
    }

    public A withContainerObject(Container containerObject) {
        _visitables.get("object").remove(this.object);
        if (containerObject!=null){ this.object= new ContainerBuilder(containerObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ContainerObjectNested<A> withNewContainerObject() {
        return new ContainerObjectNestedImpl();
    }

    public WatchEventFluent.ContainerObjectNested<A> withNewContainerObjectLike(Container item) {
        return new ContainerObjectNestedImpl(item);
    }

    public A withNodeSpecObject(NodeSpec nodeSpecObject) {
        _visitables.get("object").remove(this.object);
        if (nodeSpecObject!=null){ this.object= new NodeSpecBuilder(nodeSpecObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.NodeSpecObjectNested<A> withNewNodeSpecObject() {
        return new NodeSpecObjectNestedImpl();
    }

    public WatchEventFluent.NodeSpecObjectNested<A> withNewNodeSpecObjectLike(NodeSpec item) {
        return new NodeSpecObjectNestedImpl(item);
    }

    public A withTypedLocalObjectReference(TypedLocalObjectReference typedLocalObjectReference) {
        _visitables.get("object").remove(this.object);
        if (typedLocalObjectReference!=null){ this.object= new TypedLocalObjectReferenceBuilder(typedLocalObjectReference); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.TypedLocalObjectReferenceNested<A> withNewTypedLocalObjectReference() {
        return new TypedLocalObjectReferenceNestedImpl();
    }

    public WatchEventFluent.TypedLocalObjectReferenceNested<A> withNewTypedLocalObjectReferenceLike(TypedLocalObjectReference item) {
        return new TypedLocalObjectReferenceNestedImpl(item);
    }

    public A withNewTypedLocalObjectReference(String apiGroup,String kind,String name) {
        return (A)withTypedLocalObjectReference(new TypedLocalObjectReference(apiGroup, kind, name));
    }

    public A withFieldsV1Object(FieldsV1 fieldsV1Object) {
        _visitables.get("object").remove(this.object);
        if (fieldsV1Object!=null){ this.object= new FieldsV1Builder(fieldsV1Object); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.FieldsV1ObjectNested<A> withNewFieldsV1Object() {
        return new FieldsV1ObjectNestedImpl();
    }

    public WatchEventFluent.FieldsV1ObjectNested<A> withNewFieldsV1ObjectLike(FieldsV1 item) {
        return new FieldsV1ObjectNestedImpl(item);
    }

    public A withSecretListObject(SecretList secretListObject) {
        _visitables.get("object").remove(this.object);
        if (secretListObject!=null){ this.object= new SecretListBuilder(secretListObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.SecretListObjectNested<A> withNewSecretListObject() {
        return new SecretListObjectNestedImpl();
    }

    public WatchEventFluent.SecretListObjectNested<A> withNewSecretListObjectLike(SecretList item) {
        return new SecretListObjectNestedImpl(item);
    }

    public A withNodeAddressObject(NodeAddress nodeAddressObject) {
        _visitables.get("object").remove(this.object);
        if (nodeAddressObject!=null){ this.object= new NodeAddressBuilder(nodeAddressObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.NodeAddressObjectNested<A> withNewNodeAddressObject() {
        return new NodeAddressObjectNestedImpl();
    }

    public WatchEventFluent.NodeAddressObjectNested<A> withNewNodeAddressObjectLike(NodeAddress item) {
        return new NodeAddressObjectNestedImpl(item);
    }

    public A withNewNodeAddressObject(String address,String type) {
        return (A)withNodeAddressObject(new NodeAddress(address, type));
    }

    public A withPodAffinityObject(PodAffinity podAffinityObject) {
        _visitables.get("object").remove(this.object);
        if (podAffinityObject!=null){ this.object= new PodAffinityBuilder(podAffinityObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PodAffinityObjectNested<A> withNewPodAffinityObject() {
        return new PodAffinityObjectNestedImpl();
    }

    public WatchEventFluent.PodAffinityObjectNested<A> withNewPodAffinityObjectLike(PodAffinity item) {
        return new PodAffinityObjectNestedImpl(item);
    }

    public A withServiceObject(Service serviceObject) {
        _visitables.get("object").remove(this.object);
        if (serviceObject!=null){ this.object= new ServiceBuilder(serviceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ServiceObjectNested<A> withNewServiceObject() {
        return new ServiceObjectNestedImpl();
    }

    public WatchEventFluent.ServiceObjectNested<A> withNewServiceObjectLike(Service item) {
        return new ServiceObjectNestedImpl(item);
    }

    public A withExecEnvVarObject(ExecEnvVar execEnvVarObject) {
        _visitables.get("object").remove(this.object);
        if (execEnvVarObject!=null){ this.object= new ExecEnvVarBuilder(execEnvVarObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ExecEnvVarObjectNested<A> withNewExecEnvVarObject() {
        return new ExecEnvVarObjectNestedImpl();
    }

    public WatchEventFluent.ExecEnvVarObjectNested<A> withNewExecEnvVarObjectLike(ExecEnvVar item) {
        return new ExecEnvVarObjectNestedImpl(item);
    }

    public A withNewExecEnvVarObject(String name,String value) {
        return (A)withExecEnvVarObject(new ExecEnvVar(name, value));
    }

    public A withPodConditionObject(PodCondition podConditionObject) {
        _visitables.get("object").remove(this.object);
        if (podConditionObject!=null){ this.object= new PodConditionBuilder(podConditionObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PodConditionObjectNested<A> withNewPodConditionObject() {
        return new PodConditionObjectNestedImpl();
    }

    public WatchEventFluent.PodConditionObjectNested<A> withNewPodConditionObjectLike(PodCondition item) {
        return new PodConditionObjectNestedImpl(item);
    }

    public A withEventSeriesObject(EventSeries eventSeriesObject) {
        _visitables.get("object").remove(this.object);
        if (eventSeriesObject!=null){ this.object= new EventSeriesBuilder(eventSeriesObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.EventSeriesObjectNested<A> withNewEventSeriesObject() {
        return new EventSeriesObjectNestedImpl();
    }

    public WatchEventFluent.EventSeriesObjectNested<A> withNewEventSeriesObjectLike(EventSeries item) {
        return new EventSeriesObjectNestedImpl(item);
    }

    public A withTopologySpreadConstraintObject(TopologySpreadConstraint topologySpreadConstraintObject) {
        _visitables.get("object").remove(this.object);
        if (topologySpreadConstraintObject!=null){ this.object= new TopologySpreadConstraintBuilder(topologySpreadConstraintObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.TopologySpreadConstraintObjectNested<A> withNewTopologySpreadConstraintObject() {
        return new TopologySpreadConstraintObjectNestedImpl();
    }

    public WatchEventFluent.TopologySpreadConstraintObjectNested<A> withNewTopologySpreadConstraintObjectLike(TopologySpreadConstraint item) {
        return new TopologySpreadConstraintObjectNestedImpl(item);
    }

    public A withContainerImageObject(ContainerImage containerImageObject) {
        _visitables.get("object").remove(this.object);
        if (containerImageObject!=null){ this.object= new ContainerImageBuilder(containerImageObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ContainerImageObjectNested<A> withNewContainerImageObject() {
        return new ContainerImageObjectNestedImpl();
    }

    public WatchEventFluent.ContainerImageObjectNested<A> withNewContainerImageObjectLike(ContainerImage item) {
        return new ContainerImageObjectNestedImpl(item);
    }

    public A withExecActionObject(ExecAction execActionObject) {
        _visitables.get("object").remove(this.object);
        if (execActionObject!=null){ this.object= new ExecActionBuilder(execActionObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ExecActionObjectNested<A> withNewExecActionObject() {
        return new ExecActionObjectNestedImpl();
    }

    public WatchEventFluent.ExecActionObjectNested<A> withNewExecActionObjectLike(ExecAction item) {
        return new ExecActionObjectNestedImpl(item);
    }

    public A withReplicationControllerObject(ReplicationController replicationControllerObject) {
        _visitables.get("object").remove(this.object);
        if (replicationControllerObject!=null){ this.object= new ReplicationControllerBuilder(replicationControllerObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ReplicationControllerObjectNested<A> withNewReplicationControllerObject() {
        return new ReplicationControllerObjectNestedImpl();
    }

    public WatchEventFluent.ReplicationControllerObjectNested<A> withNewReplicationControllerObjectLike(ReplicationController item) {
        return new ReplicationControllerObjectNestedImpl(item);
    }

    public A withNodeStatusObject(NodeStatus nodeStatusObject) {
        _visitables.get("object").remove(this.object);
        if (nodeStatusObject!=null){ this.object= new NodeStatusBuilder(nodeStatusObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.NodeStatusObjectNested<A> withNewNodeStatusObject() {
        return new NodeStatusObjectNestedImpl();
    }

    public WatchEventFluent.NodeStatusObjectNested<A> withNewNodeStatusObjectLike(NodeStatus item) {
        return new NodeStatusObjectNestedImpl(item);
    }

    public A withConfigMapListObject(ConfigMapList configMapListObject) {
        _visitables.get("object").remove(this.object);
        if (configMapListObject!=null){ this.object= new ConfigMapListBuilder(configMapListObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ConfigMapListObjectNested<A> withNewConfigMapListObject() {
        return new ConfigMapListObjectNestedImpl();
    }

    public WatchEventFluent.ConfigMapListObjectNested<A> withNewConfigMapListObjectLike(ConfigMapList item) {
        return new ConfigMapListObjectNestedImpl(item);
    }

    public A withNodeSelectorObject(NodeSelector nodeSelectorObject) {
        _visitables.get("object").remove(this.object);
        if (nodeSelectorObject!=null){ this.object= new NodeSelectorBuilder(nodeSelectorObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.NodeSelectorObjectNested<A> withNewNodeSelectorObject() {
        return new NodeSelectorObjectNestedImpl();
    }

    public WatchEventFluent.NodeSelectorObjectNested<A> withNewNodeSelectorObjectLike(NodeSelector item) {
        return new NodeSelectorObjectNestedImpl(item);
    }

    public A withTolerationObject(Toleration tolerationObject) {
        _visitables.get("object").remove(this.object);
        if (tolerationObject!=null){ this.object= new TolerationBuilder(tolerationObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.TolerationObjectNested<A> withNewTolerationObject() {
        return new TolerationObjectNestedImpl();
    }

    public WatchEventFluent.TolerationObjectNested<A> withNewTolerationObjectLike(Toleration item) {
        return new TolerationObjectNestedImpl(item);
    }

    public A withNewTolerationObject(String effect,String key,String operator,Long tolerationSeconds,String value) {
        return (A)withTolerationObject(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    public A withCephFSPersistentVolumeSourceObject(CephFSPersistentVolumeSource cephFSPersistentVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (cephFSPersistentVolumeSourceObject!=null){ this.object= new CephFSPersistentVolumeSourceBuilder(cephFSPersistentVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.CephFSPersistentVolumeSourceObjectNested<A> withNewCephFSPersistentVolumeSourceObject() {
        return new CephFSPersistentVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.CephFSPersistentVolumeSourceObjectNested<A> withNewCephFSPersistentVolumeSourceObjectLike(CephFSPersistentVolumeSource item) {
        return new CephFSPersistentVolumeSourceObjectNestedImpl(item);
    }

    public A withPersistentVolumeClaimConditionObject(PersistentVolumeClaimCondition persistentVolumeClaimConditionObject) {
        _visitables.get("object").remove(this.object);
        if (persistentVolumeClaimConditionObject!=null){ this.object= new PersistentVolumeClaimConditionBuilder(persistentVolumeClaimConditionObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PersistentVolumeClaimConditionObjectNested<A> withNewPersistentVolumeClaimConditionObject() {
        return new PersistentVolumeClaimConditionObjectNestedImpl();
    }

    public WatchEventFluent.PersistentVolumeClaimConditionObjectNested<A> withNewPersistentVolumeClaimConditionObjectLike(PersistentVolumeClaimCondition item) {
        return new PersistentVolumeClaimConditionObjectNestedImpl(item);
    }

    public A withPreferredSchedulingTermObject(PreferredSchedulingTerm preferredSchedulingTermObject) {
        _visitables.get("object").remove(this.object);
        if (preferredSchedulingTermObject!=null){ this.object= new PreferredSchedulingTermBuilder(preferredSchedulingTermObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PreferredSchedulingTermObjectNested<A> withNewPreferredSchedulingTermObject() {
        return new PreferredSchedulingTermObjectNestedImpl();
    }

    public WatchEventFluent.PreferredSchedulingTermObjectNested<A> withNewPreferredSchedulingTermObjectLike(PreferredSchedulingTerm item) {
        return new PreferredSchedulingTermObjectNestedImpl(item);
    }

    public A withPersistentVolumeListObject(PersistentVolumeList persistentVolumeListObject) {
        _visitables.get("object").remove(this.object);
        if (persistentVolumeListObject!=null){ this.object= new PersistentVolumeListBuilder(persistentVolumeListObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PersistentVolumeListObjectNested<A> withNewPersistentVolumeListObject() {
        return new PersistentVolumeListObjectNestedImpl();
    }

    public WatchEventFluent.PersistentVolumeListObjectNested<A> withNewPersistentVolumeListObjectLike(PersistentVolumeList item) {
        return new PersistentVolumeListObjectNestedImpl(item);
    }

    public A withGCEPersistentDiskVolumeSourceObject(GCEPersistentDiskVolumeSource gCEPersistentDiskVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (gCEPersistentDiskVolumeSourceObject!=null){ this.object= new GCEPersistentDiskVolumeSourceBuilder(gCEPersistentDiskVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.GCEPersistentDiskVolumeSourceObjectNested<A> withNewGCEPersistentDiskVolumeSourceObject() {
        return new GCEPersistentDiskVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.GCEPersistentDiskVolumeSourceObjectNested<A> withNewGCEPersistentDiskVolumeSourceObjectLike(GCEPersistentDiskVolumeSource item) {
        return new GCEPersistentDiskVolumeSourceObjectNestedImpl(item);
    }

    public A withNewGCEPersistentDiskVolumeSourceObject(String fsType,Integer partition,String pdName,Boolean readOnly) {
        return (A)withGCEPersistentDiskVolumeSourceObject(new GCEPersistentDiskVolumeSource(fsType, partition, pdName, readOnly));
    }

    public A withPodDNSConfigOptionObject(PodDNSConfigOption podDNSConfigOptionObject) {
        _visitables.get("object").remove(this.object);
        if (podDNSConfigOptionObject!=null){ this.object= new PodDNSConfigOptionBuilder(podDNSConfigOptionObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PodDNSConfigOptionObjectNested<A> withNewPodDNSConfigOptionObject() {
        return new PodDNSConfigOptionObjectNestedImpl();
    }

    public WatchEventFluent.PodDNSConfigOptionObjectNested<A> withNewPodDNSConfigOptionObjectLike(PodDNSConfigOption item) {
        return new PodDNSConfigOptionObjectNestedImpl(item);
    }

    public A withNewPodDNSConfigOptionObject(String name,String value) {
        return (A)withPodDNSConfigOptionObject(new PodDNSConfigOption(name, value));
    }

    public A withAPIServiceConditionObject(APIServiceCondition aPIServiceConditionObject) {
        _visitables.get("object").remove(this.object);
        if (aPIServiceConditionObject!=null){ this.object= new APIServiceConditionBuilder(aPIServiceConditionObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.APIServiceConditionObjectNested<A> withNewAPIServiceConditionObject() {
        return new APIServiceConditionObjectNestedImpl();
    }

    public WatchEventFluent.APIServiceConditionObjectNested<A> withNewAPIServiceConditionObjectLike(APIServiceCondition item) {
        return new APIServiceConditionObjectNestedImpl(item);
    }

    public A withNewAPIServiceConditionObject(String lastTransitionTime,String message,String reason,String status,String type) {
        return (A)withAPIServiceConditionObject(new APIServiceCondition(lastTransitionTime, message, reason, status, type));
    }

    public A withEventListObject(EventList eventListObject) {
        _visitables.get("object").remove(this.object);
        if (eventListObject!=null){ this.object= new EventListBuilder(eventListObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.EventListObjectNested<A> withNewEventListObject() {
        return new EventListObjectNestedImpl();
    }

    public WatchEventFluent.EventListObjectNested<A> withNewEventListObjectLike(EventList item) {
        return new EventListObjectNestedImpl(item);
    }

    public A withPodReadinessGateObject(PodReadinessGate podReadinessGateObject) {
        _visitables.get("object").remove(this.object);
        if (podReadinessGateObject!=null){ this.object= new PodReadinessGateBuilder(podReadinessGateObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PodReadinessGateObjectNested<A> withNewPodReadinessGateObject() {
        return new PodReadinessGateObjectNestedImpl();
    }

    public WatchEventFluent.PodReadinessGateObjectNested<A> withNewPodReadinessGateObjectLike(PodReadinessGate item) {
        return new PodReadinessGateObjectNestedImpl(item);
    }

    public A withNewPodReadinessGateObject(String conditionType) {
        return (A)withPodReadinessGateObject(new PodReadinessGate(conditionType));
    }

    public A withContainerStateWaitingObject(ContainerStateWaiting containerStateWaitingObject) {
        _visitables.get("object").remove(this.object);
        if (containerStateWaitingObject!=null){ this.object= new ContainerStateWaitingBuilder(containerStateWaitingObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ContainerStateWaitingObjectNested<A> withNewContainerStateWaitingObject() {
        return new ContainerStateWaitingObjectNestedImpl();
    }

    public WatchEventFluent.ContainerStateWaitingObjectNested<A> withNewContainerStateWaitingObjectLike(ContainerStateWaiting item) {
        return new ContainerStateWaitingObjectNestedImpl(item);
    }

    public A withNewContainerStateWaitingObject(String message,String reason) {
        return (A)withContainerStateWaitingObject(new ContainerStateWaiting(message, reason));
    }

    public A withVolumeMountObject(VolumeMount volumeMountObject) {
        _visitables.get("object").remove(this.object);
        if (volumeMountObject!=null){ this.object= new VolumeMountBuilder(volumeMountObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.VolumeMountObjectNested<A> withNewVolumeMountObject() {
        return new VolumeMountObjectNestedImpl();
    }

    public WatchEventFluent.VolumeMountObjectNested<A> withNewVolumeMountObjectLike(VolumeMount item) {
        return new VolumeMountObjectNestedImpl(item);
    }

    public A withNamespaceConditionObject(NamespaceCondition namespaceConditionObject) {
        _visitables.get("object").remove(this.object);
        if (namespaceConditionObject!=null){ this.object= new NamespaceConditionBuilder(namespaceConditionObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.NamespaceConditionObjectNested<A> withNewNamespaceConditionObject() {
        return new NamespaceConditionObjectNestedImpl();
    }

    public WatchEventFluent.NamespaceConditionObjectNested<A> withNewNamespaceConditionObjectLike(NamespaceCondition item) {
        return new NamespaceConditionObjectNestedImpl(item);
    }

    public A withNewNamespaceConditionObject(String lastTransitionTime,String message,String reason,String status,String type) {
        return (A)withNamespaceConditionObject(new NamespaceCondition(lastTransitionTime, message, reason, status, type));
    }

    public A withLabelSelectorObject(LabelSelector labelSelectorObject) {
        _visitables.get("object").remove(this.object);
        if (labelSelectorObject!=null){ this.object= new LabelSelectorBuilder(labelSelectorObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.LabelSelectorObjectNested<A> withNewLabelSelectorObject() {
        return new LabelSelectorObjectNestedImpl();
    }

    public WatchEventFluent.LabelSelectorObjectNested<A> withNewLabelSelectorObjectLike(LabelSelector item) {
        return new LabelSelectorObjectNestedImpl(item);
    }

    public A withStatusCauseObject(StatusCause statusCauseObject) {
        _visitables.get("object").remove(this.object);
        if (statusCauseObject!=null){ this.object= new StatusCauseBuilder(statusCauseObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.StatusCauseObjectNested<A> withNewStatusCauseObject() {
        return new StatusCauseObjectNestedImpl();
    }

    public WatchEventFluent.StatusCauseObjectNested<A> withNewStatusCauseObjectLike(StatusCause item) {
        return new StatusCauseObjectNestedImpl(item);
    }

    public A withNewStatusCauseObject(String field,String message,String reason) {
        return (A)withStatusCauseObject(new StatusCause(field, message, reason));
    }

    public A withNamedClusterObject(NamedCluster namedClusterObject) {
        _visitables.get("object").remove(this.object);
        if (namedClusterObject!=null){ this.object= new NamedClusterBuilder(namedClusterObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.NamedClusterObjectNested<A> withNewNamedClusterObject() {
        return new NamedClusterObjectNestedImpl();
    }

    public WatchEventFluent.NamedClusterObjectNested<A> withNewNamedClusterObjectLike(NamedCluster item) {
        return new NamedClusterObjectNestedImpl(item);
    }

    public A withStatusDetailsObject(StatusDetails statusDetailsObject) {
        _visitables.get("object").remove(this.object);
        if (statusDetailsObject!=null){ this.object= new StatusDetailsBuilder(statusDetailsObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.StatusDetailsObjectNested<A> withNewStatusDetailsObject() {
        return new StatusDetailsObjectNestedImpl();
    }

    public WatchEventFluent.StatusDetailsObjectNested<A> withNewStatusDetailsObjectLike(StatusDetails item) {
        return new StatusDetailsObjectNestedImpl(item);
    }

    public A withDownwardAPIVolumeFileObject(DownwardAPIVolumeFile downwardAPIVolumeFileObject) {
        _visitables.get("object").remove(this.object);
        if (downwardAPIVolumeFileObject!=null){ this.object= new DownwardAPIVolumeFileBuilder(downwardAPIVolumeFileObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.DownwardAPIVolumeFileObjectNested<A> withNewDownwardAPIVolumeFileObject() {
        return new DownwardAPIVolumeFileObjectNestedImpl();
    }

    public WatchEventFluent.DownwardAPIVolumeFileObjectNested<A> withNewDownwardAPIVolumeFileObjectLike(DownwardAPIVolumeFile item) {
        return new DownwardAPIVolumeFileObjectNestedImpl(item);
    }

    public A withSeccompProfileObject(SeccompProfile seccompProfileObject) {
        _visitables.get("object").remove(this.object);
        if (seccompProfileObject!=null){ this.object= new SeccompProfileBuilder(seccompProfileObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.SeccompProfileObjectNested<A> withNewSeccompProfileObject() {
        return new SeccompProfileObjectNestedImpl();
    }

    public WatchEventFluent.SeccompProfileObjectNested<A> withNewSeccompProfileObjectLike(SeccompProfile item) {
        return new SeccompProfileObjectNestedImpl(item);
    }

    public A withNewSeccompProfileObject(String localhostProfile,String type) {
        return (A)withSeccompProfileObject(new SeccompProfile(localhostProfile, type));
    }

    public A withSysctlObject(Sysctl sysctlObject) {
        _visitables.get("object").remove(this.object);
        if (sysctlObject!=null){ this.object= new SysctlBuilder(sysctlObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.SysctlObjectNested<A> withNewSysctlObject() {
        return new SysctlObjectNestedImpl();
    }

    public WatchEventFluent.SysctlObjectNested<A> withNewSysctlObjectLike(Sysctl item) {
        return new SysctlObjectNestedImpl(item);
    }

    public A withNewSysctlObject(String name,String value) {
        return (A)withSysctlObject(new Sysctl(name, value));
    }

    public A withStatusObject(Status statusObject) {
        _visitables.get("object").remove(this.object);
        if (statusObject!=null){ this.object= new StatusBuilder(statusObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.StatusObjectNested<A> withNewStatusObject() {
        return new StatusObjectNestedImpl();
    }

    public WatchEventFluent.StatusObjectNested<A> withNewStatusObjectLike(Status item) {
        return new StatusObjectNestedImpl(item);
    }

    public A withDeleteOptionsObject(DeleteOptions deleteOptionsObject) {
        _visitables.get("object").remove(this.object);
        if (deleteOptionsObject!=null){ this.object= new DeleteOptionsBuilder(deleteOptionsObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.DeleteOptionsObjectNested<A> withNewDeleteOptionsObject() {
        return new DeleteOptionsObjectNestedImpl();
    }

    public WatchEventFluent.DeleteOptionsObjectNested<A> withNewDeleteOptionsObjectLike(DeleteOptions item) {
        return new DeleteOptionsObjectNestedImpl(item);
    }

    public A withContainerStatusObject(ContainerStatus containerStatusObject) {
        _visitables.get("object").remove(this.object);
        if (containerStatusObject!=null){ this.object= new ContainerStatusBuilder(containerStatusObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ContainerStatusObjectNested<A> withNewContainerStatusObject() {
        return new ContainerStatusObjectNestedImpl();
    }

    public WatchEventFluent.ContainerStatusObjectNested<A> withNewContainerStatusObjectLike(ContainerStatus item) {
        return new ContainerStatusObjectNestedImpl(item);
    }

    public A withPodTemplateObject(PodTemplate podTemplateObject) {
        _visitables.get("object").remove(this.object);
        if (podTemplateObject!=null){ this.object= new PodTemplateBuilder(podTemplateObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PodTemplateObjectNested<A> withNewPodTemplateObject() {
        return new PodTemplateObjectNestedImpl();
    }

    public WatchEventFluent.PodTemplateObjectNested<A> withNewPodTemplateObjectLike(PodTemplate item) {
        return new PodTemplateObjectNestedImpl(item);
    }

    public A withConfigMapEnvSourceObject(ConfigMapEnvSource configMapEnvSourceObject) {
        _visitables.get("object").remove(this.object);
        if (configMapEnvSourceObject!=null){ this.object= new ConfigMapEnvSourceBuilder(configMapEnvSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ConfigMapEnvSourceObjectNested<A> withNewConfigMapEnvSourceObject() {
        return new ConfigMapEnvSourceObjectNestedImpl();
    }

    public WatchEventFluent.ConfigMapEnvSourceObjectNested<A> withNewConfigMapEnvSourceObjectLike(ConfigMapEnvSource item) {
        return new ConfigMapEnvSourceObjectNestedImpl(item);
    }

    public A withNewConfigMapEnvSourceObject(String name,Boolean optional) {
        return (A)withConfigMapEnvSourceObject(new ConfigMapEnvSource(name, optional));
    }

    public A withNodeSelectorRequirementObject(NodeSelectorRequirement nodeSelectorRequirementObject) {
        _visitables.get("object").remove(this.object);
        if (nodeSelectorRequirementObject!=null){ this.object= new NodeSelectorRequirementBuilder(nodeSelectorRequirementObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.NodeSelectorRequirementObjectNested<A> withNewNodeSelectorRequirementObject() {
        return new NodeSelectorRequirementObjectNestedImpl();
    }

    public WatchEventFluent.NodeSelectorRequirementObjectNested<A> withNewNodeSelectorRequirementObjectLike(NodeSelectorRequirement item) {
        return new NodeSelectorRequirementObjectNestedImpl(item);
    }

    public A withTCPSocketActionObject(TCPSocketAction tCPSocketActionObject) {
        _visitables.get("object").remove(this.object);
        if (tCPSocketActionObject!=null){ this.object= new TCPSocketActionBuilder(tCPSocketActionObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.TCPSocketActionObjectNested<A> withNewTCPSocketActionObject() {
        return new TCPSocketActionObjectNestedImpl();
    }

    public WatchEventFluent.TCPSocketActionObjectNested<A> withNewTCPSocketActionObjectLike(TCPSocketAction item) {
        return new TCPSocketActionObjectNestedImpl(item);
    }

    public A withEventObject(Event eventObject) {
        _visitables.get("object").remove(this.object);
        if (eventObject!=null){ this.object= new EventBuilder(eventObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.EventObjectNested<A> withNewEventObject() {
        return new EventObjectNestedImpl();
    }

    public WatchEventFluent.EventObjectNested<A> withNewEventObjectLike(Event item) {
        return new EventObjectNestedImpl(item);
    }

    public A withPreferencesObject(Preferences preferencesObject) {
        _visitables.get("object").remove(this.object);
        if (preferencesObject!=null){ this.object= new PreferencesBuilder(preferencesObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PreferencesObjectNested<A> withNewPreferencesObject() {
        return new PreferencesObjectNestedImpl();
    }

    public WatchEventFluent.PreferencesObjectNested<A> withNewPreferencesObjectLike(Preferences item) {
        return new PreferencesObjectNestedImpl(item);
    }

    public A withObjectFieldSelectorObject(ObjectFieldSelector objectFieldSelectorObject) {
        _visitables.get("object").remove(this.object);
        if (objectFieldSelectorObject!=null){ this.object= new ObjectFieldSelectorBuilder(objectFieldSelectorObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ObjectFieldSelectorObjectNested<A> withNewObjectFieldSelectorObject() {
        return new ObjectFieldSelectorObjectNestedImpl();
    }

    public WatchEventFluent.ObjectFieldSelectorObjectNested<A> withNewObjectFieldSelectorObjectLike(ObjectFieldSelector item) {
        return new ObjectFieldSelectorObjectNestedImpl(item);
    }

    public A withNewObjectFieldSelectorObject(String apiVersion,String fieldPath) {
        return (A)withObjectFieldSelectorObject(new ObjectFieldSelector(apiVersion, fieldPath));
    }

    public A withPodTemplateListObject(PodTemplateList podTemplateListObject) {
        _visitables.get("object").remove(this.object);
        if (podTemplateListObject!=null){ this.object= new PodTemplateListBuilder(podTemplateListObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PodTemplateListObjectNested<A> withNewPodTemplateListObject() {
        return new PodTemplateListObjectNestedImpl();
    }

    public WatchEventFluent.PodTemplateListObjectNested<A> withNewPodTemplateListObjectLike(PodTemplateList item) {
        return new PodTemplateListObjectNestedImpl(item);
    }

    public A withPersistentVolumeObject(PersistentVolume persistentVolumeObject) {
        _visitables.get("object").remove(this.object);
        if (persistentVolumeObject!=null){ this.object= new PersistentVolumeBuilder(persistentVolumeObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PersistentVolumeObjectNested<A> withNewPersistentVolumeObject() {
        return new PersistentVolumeObjectNestedImpl();
    }

    public WatchEventFluent.PersistentVolumeObjectNested<A> withNewPersistentVolumeObjectLike(PersistentVolume item) {
        return new PersistentVolumeObjectNestedImpl(item);
    }

    public A withCinderVolumeSourceObject(CinderVolumeSource cinderVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (cinderVolumeSourceObject!=null){ this.object= new CinderVolumeSourceBuilder(cinderVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.CinderVolumeSourceObjectNested<A> withNewCinderVolumeSourceObject() {
        return new CinderVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.CinderVolumeSourceObjectNested<A> withNewCinderVolumeSourceObjectLike(CinderVolumeSource item) {
        return new CinderVolumeSourceObjectNestedImpl(item);
    }

    public A withEndpointAddressObject(EndpointAddress endpointAddressObject) {
        _visitables.get("object").remove(this.object);
        if (endpointAddressObject!=null){ this.object= new EndpointAddressBuilder(endpointAddressObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.EndpointAddressObjectNested<A> withNewEndpointAddressObject() {
        return new EndpointAddressObjectNestedImpl();
    }

    public WatchEventFluent.EndpointAddressObjectNested<A> withNewEndpointAddressObjectLike(EndpointAddress item) {
        return new EndpointAddressObjectNestedImpl(item);
    }

    public A withNodeConfigSourceObject(NodeConfigSource nodeConfigSourceObject) {
        _visitables.get("object").remove(this.object);
        if (nodeConfigSourceObject!=null){ this.object= new NodeConfigSourceBuilder(nodeConfigSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.NodeConfigSourceObjectNested<A> withNewNodeConfigSourceObject() {
        return new NodeConfigSourceObjectNestedImpl();
    }

    public WatchEventFluent.NodeConfigSourceObjectNested<A> withNewNodeConfigSourceObjectLike(NodeConfigSource item) {
        return new NodeConfigSourceObjectNestedImpl(item);
    }

    public A withVsphereVirtualDiskVolumeSourceObject(VsphereVirtualDiskVolumeSource vsphereVirtualDiskVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (vsphereVirtualDiskVolumeSourceObject!=null){ this.object= new VsphereVirtualDiskVolumeSourceBuilder(vsphereVirtualDiskVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.VsphereVirtualDiskVolumeSourceObjectNested<A> withNewVsphereVirtualDiskVolumeSourceObject() {
        return new VsphereVirtualDiskVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.VsphereVirtualDiskVolumeSourceObjectNested<A> withNewVsphereVirtualDiskVolumeSourceObjectLike(VsphereVirtualDiskVolumeSource item) {
        return new VsphereVirtualDiskVolumeSourceObjectNestedImpl(item);
    }

    public A withNewVsphereVirtualDiskVolumeSourceObject(String fsType,String storagePolicyID,String storagePolicyName,String volumePath) {
        return (A)withVsphereVirtualDiskVolumeSourceObject(new VsphereVirtualDiskVolumeSource(fsType, storagePolicyID, storagePolicyName, volumePath));
    }

    public A withObjectMetaObject(ObjectMeta objectMetaObject) {
        _visitables.get("object").remove(this.object);
        if (objectMetaObject!=null){ this.object= new ObjectMetaBuilder(objectMetaObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ObjectMetaObjectNested<A> withNewObjectMetaObject() {
        return new ObjectMetaObjectNestedImpl();
    }

    public WatchEventFluent.ObjectMetaObjectNested<A> withNewObjectMetaObjectLike(ObjectMeta item) {
        return new ObjectMetaObjectNestedImpl(item);
    }

    public A withPersistentVolumeClaimObject(PersistentVolumeClaim persistentVolumeClaimObject) {
        _visitables.get("object").remove(this.object);
        if (persistentVolumeClaimObject!=null){ this.object= new PersistentVolumeClaimBuilder(persistentVolumeClaimObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PersistentVolumeClaimObjectNested<A> withNewPersistentVolumeClaimObject() {
        return new PersistentVolumeClaimObjectNestedImpl();
    }

    public WatchEventFluent.PersistentVolumeClaimObjectNested<A> withNewPersistentVolumeClaimObjectLike(PersistentVolumeClaim item) {
        return new PersistentVolumeClaimObjectNestedImpl(item);
    }

    public A withLabelSelectorRequirementObject(LabelSelectorRequirement labelSelectorRequirementObject) {
        _visitables.get("object").remove(this.object);
        if (labelSelectorRequirementObject!=null){ this.object= new LabelSelectorRequirementBuilder(labelSelectorRequirementObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.LabelSelectorRequirementObjectNested<A> withNewLabelSelectorRequirementObject() {
        return new LabelSelectorRequirementObjectNestedImpl();
    }

    public WatchEventFluent.LabelSelectorRequirementObjectNested<A> withNewLabelSelectorRequirementObjectLike(LabelSelectorRequirement item) {
        return new LabelSelectorRequirementObjectNestedImpl(item);
    }

    public A withGitRepoVolumeSourceObject(GitRepoVolumeSource gitRepoVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (gitRepoVolumeSourceObject!=null){ this.object= new GitRepoVolumeSourceBuilder(gitRepoVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.GitRepoVolumeSourceObjectNested<A> withNewGitRepoVolumeSourceObject() {
        return new GitRepoVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.GitRepoVolumeSourceObjectNested<A> withNewGitRepoVolumeSourceObjectLike(GitRepoVolumeSource item) {
        return new GitRepoVolumeSourceObjectNestedImpl(item);
    }

    public A withNewGitRepoVolumeSourceObject(String directory,String repository,String revision) {
        return (A)withGitRepoVolumeSourceObject(new GitRepoVolumeSource(directory, repository, revision));
    }

    public A withEndpointsListObject(EndpointsList endpointsListObject) {
        _visitables.get("object").remove(this.object);
        if (endpointsListObject!=null){ this.object= new EndpointsListBuilder(endpointsListObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.EndpointsListObjectNested<A> withNewEndpointsListObject() {
        return new EndpointsListObjectNestedImpl();
    }

    public WatchEventFluent.EndpointsListObjectNested<A> withNewEndpointsListObjectLike(EndpointsList item) {
        return new EndpointsListObjectNestedImpl(item);
    }

    public A withGroupVersionResourceObject(GroupVersionResource groupVersionResourceObject) {
        _visitables.get("object").remove(this.object);
        if (groupVersionResourceObject!=null){ this.object= new GroupVersionResourceBuilder(groupVersionResourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.GroupVersionResourceObjectNested<A> withNewGroupVersionResourceObject() {
        return new GroupVersionResourceObjectNestedImpl();
    }

    public WatchEventFluent.GroupVersionResourceObjectNested<A> withNewGroupVersionResourceObjectLike(GroupVersionResource item) {
        return new GroupVersionResourceObjectNestedImpl(item);
    }

    public A withNewGroupVersionResourceObject(String group,String resource,String version) {
        return (A)withGroupVersionResourceObject(new GroupVersionResource(group, resource, version));
    }

    public A withCinderPersistentVolumeSourceObject(CinderPersistentVolumeSource cinderPersistentVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (cinderPersistentVolumeSourceObject!=null){ this.object= new CinderPersistentVolumeSourceBuilder(cinderPersistentVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.CinderPersistentVolumeSourceObjectNested<A> withNewCinderPersistentVolumeSourceObject() {
        return new CinderPersistentVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.CinderPersistentVolumeSourceObjectNested<A> withNewCinderPersistentVolumeSourceObjectLike(CinderPersistentVolumeSource item) {
        return new CinderPersistentVolumeSourceObjectNestedImpl(item);
    }

    public A withTopologySelectorTermObject(TopologySelectorTerm topologySelectorTermObject) {
        _visitables.get("object").remove(this.object);
        if (topologySelectorTermObject!=null){ this.object= new TopologySelectorTermBuilder(topologySelectorTermObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.TopologySelectorTermObjectNested<A> withNewTopologySelectorTermObject() {
        return new TopologySelectorTermObjectNestedImpl();
    }

    public WatchEventFluent.TopologySelectorTermObjectNested<A> withNewTopologySelectorTermObjectLike(TopologySelectorTerm item) {
        return new TopologySelectorTermObjectNestedImpl(item);
    }

    public A withOwnerReferenceObject(OwnerReference ownerReferenceObject) {
        _visitables.get("object").remove(this.object);
        if (ownerReferenceObject!=null){ this.object= new OwnerReferenceBuilder(ownerReferenceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.OwnerReferenceObjectNested<A> withNewOwnerReferenceObject() {
        return new OwnerReferenceObjectNestedImpl();
    }

    public WatchEventFluent.OwnerReferenceObjectNested<A> withNewOwnerReferenceObjectLike(OwnerReference item) {
        return new OwnerReferenceObjectNestedImpl(item);
    }

    public A withStorageOSPersistentVolumeSourceObject(StorageOSPersistentVolumeSource storageOSPersistentVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (storageOSPersistentVolumeSourceObject!=null){ this.object= new StorageOSPersistentVolumeSourceBuilder(storageOSPersistentVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.StorageOSPersistentVolumeSourceObjectNested<A> withNewStorageOSPersistentVolumeSourceObject() {
        return new StorageOSPersistentVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.StorageOSPersistentVolumeSourceObjectNested<A> withNewStorageOSPersistentVolumeSourceObjectLike(StorageOSPersistentVolumeSource item) {
        return new StorageOSPersistentVolumeSourceObjectNestedImpl(item);
    }

    public A withEphemeralVolumeSourceObject(EphemeralVolumeSource ephemeralVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (ephemeralVolumeSourceObject!=null){ this.object= new EphemeralVolumeSourceBuilder(ephemeralVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.EphemeralVolumeSourceObjectNested<A> withNewEphemeralVolumeSourceObject() {
        return new EphemeralVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.EphemeralVolumeSourceObjectNested<A> withNewEphemeralVolumeSourceObjectLike(EphemeralVolumeSource item) {
        return new EphemeralVolumeSourceObjectNestedImpl(item);
    }

    public A withReplicationControllerConditionObject(ReplicationControllerCondition replicationControllerConditionObject) {
        _visitables.get("object").remove(this.object);
        if (replicationControllerConditionObject!=null){ this.object= new ReplicationControllerConditionBuilder(replicationControllerConditionObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ReplicationControllerConditionObjectNested<A> withNewReplicationControllerConditionObject() {
        return new ReplicationControllerConditionObjectNestedImpl();
    }

    public WatchEventFluent.ReplicationControllerConditionObjectNested<A> withNewReplicationControllerConditionObjectLike(ReplicationControllerCondition item) {
        return new ReplicationControllerConditionObjectNestedImpl(item);
    }

    public A withNewReplicationControllerConditionObject(String lastTransitionTime,String message,String reason,String status,String type) {
        return (A)withReplicationControllerConditionObject(new ReplicationControllerCondition(lastTransitionTime, message, reason, status, type));
    }

    public A withPodAntiAffinityObject(PodAntiAffinity podAntiAffinityObject) {
        _visitables.get("object").remove(this.object);
        if (podAntiAffinityObject!=null){ this.object= new PodAntiAffinityBuilder(podAntiAffinityObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PodAntiAffinityObjectNested<A> withNewPodAntiAffinityObject() {
        return new PodAntiAffinityObjectNestedImpl();
    }

    public WatchEventFluent.PodAntiAffinityObjectNested<A> withNewPodAntiAffinityObjectLike(PodAntiAffinity item) {
        return new PodAntiAffinityObjectNestedImpl(item);
    }

    public A withSecurityContextObject(SecurityContext securityContextObject) {
        _visitables.get("object").remove(this.object);
        if (securityContextObject!=null){ this.object= new SecurityContextBuilder(securityContextObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.SecurityContextObjectNested<A> withNewSecurityContextObject() {
        return new SecurityContextObjectNestedImpl();
    }

    public WatchEventFluent.SecurityContextObjectNested<A> withNewSecurityContextObjectLike(SecurityContext item) {
        return new SecurityContextObjectNestedImpl(item);
    }

    public A withReplicationControllerListObject(ReplicationControllerList replicationControllerListObject) {
        _visitables.get("object").remove(this.object);
        if (replicationControllerListObject!=null){ this.object= new ReplicationControllerListBuilder(replicationControllerListObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ReplicationControllerListObjectNested<A> withNewReplicationControllerListObject() {
        return new ReplicationControllerListObjectNestedImpl();
    }

    public WatchEventFluent.ReplicationControllerListObjectNested<A> withNewReplicationControllerListObjectLike(ReplicationControllerList item) {
        return new ReplicationControllerListObjectNestedImpl(item);
    }

    public A withConfigMapVolumeSourceObject(ConfigMapVolumeSource configMapVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (configMapVolumeSourceObject!=null){ this.object= new ConfigMapVolumeSourceBuilder(configMapVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ConfigMapVolumeSourceObjectNested<A> withNewConfigMapVolumeSourceObject() {
        return new ConfigMapVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.ConfigMapVolumeSourceObjectNested<A> withNewConfigMapVolumeSourceObjectLike(ConfigMapVolumeSource item) {
        return new ConfigMapVolumeSourceObjectNestedImpl(item);
    }

    public A withContainerStateRunningObject(ContainerStateRunning containerStateRunningObject) {
        _visitables.get("object").remove(this.object);
        if (containerStateRunningObject!=null){ this.object= new ContainerStateRunningBuilder(containerStateRunningObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ContainerStateRunningObjectNested<A> withNewContainerStateRunningObject() {
        return new ContainerStateRunningObjectNestedImpl();
    }

    public WatchEventFluent.ContainerStateRunningObjectNested<A> withNewContainerStateRunningObjectLike(ContainerStateRunning item) {
        return new ContainerStateRunningObjectNestedImpl(item);
    }

    public A withNewContainerStateRunningObject(String startedAt) {
        return (A)withContainerStateRunningObject(new ContainerStateRunning(startedAt));
    }

    public A withFlockerVolumeSourceObject(FlockerVolumeSource flockerVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (flockerVolumeSourceObject!=null){ this.object= new FlockerVolumeSourceBuilder(flockerVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.FlockerVolumeSourceObjectNested<A> withNewFlockerVolumeSourceObject() {
        return new FlockerVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.FlockerVolumeSourceObjectNested<A> withNewFlockerVolumeSourceObjectLike(FlockerVolumeSource item) {
        return new FlockerVolumeSourceObjectNestedImpl(item);
    }

    public A withNewFlockerVolumeSourceObject(String datasetName,String datasetUUID) {
        return (A)withFlockerVolumeSourceObject(new FlockerVolumeSource(datasetName, datasetUUID));
    }

    public A withComponentStatusListObject(ComponentStatusList componentStatusListObject) {
        _visitables.get("object").remove(this.object);
        if (componentStatusListObject!=null){ this.object= new ComponentStatusListBuilder(componentStatusListObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ComponentStatusListObjectNested<A> withNewComponentStatusListObject() {
        return new ComponentStatusListObjectNestedImpl();
    }

    public WatchEventFluent.ComponentStatusListObjectNested<A> withNewComponentStatusListObjectLike(ComponentStatusList item) {
        return new ComponentStatusListObjectNestedImpl(item);
    }

    public A withScaleIOVolumeSourceObject(ScaleIOVolumeSource scaleIOVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (scaleIOVolumeSourceObject!=null){ this.object= new ScaleIOVolumeSourceBuilder(scaleIOVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ScaleIOVolumeSourceObjectNested<A> withNewScaleIOVolumeSourceObject() {
        return new ScaleIOVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.ScaleIOVolumeSourceObjectNested<A> withNewScaleIOVolumeSourceObjectLike(ScaleIOVolumeSource item) {
        return new ScaleIOVolumeSourceObjectNestedImpl(item);
    }

    public A withLimitRangeListObject(LimitRangeList limitRangeListObject) {
        _visitables.get("object").remove(this.object);
        if (limitRangeListObject!=null){ this.object= new LimitRangeListBuilder(limitRangeListObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.LimitRangeListObjectNested<A> withNewLimitRangeListObject() {
        return new LimitRangeListObjectNestedImpl();
    }

    public WatchEventFluent.LimitRangeListObjectNested<A> withNewLimitRangeListObjectLike(LimitRangeList item) {
        return new LimitRangeListObjectNestedImpl(item);
    }

    public A withPodExecOptionsObject(PodExecOptions podExecOptionsObject) {
        _visitables.get("object").remove(this.object);
        if (podExecOptionsObject!=null){ this.object= new PodExecOptionsBuilder(podExecOptionsObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PodExecOptionsObjectNested<A> withNewPodExecOptionsObject() {
        return new PodExecOptionsObjectNestedImpl();
    }

    public WatchEventFluent.PodExecOptionsObjectNested<A> withNewPodExecOptionsObjectLike(PodExecOptions item) {
        return new PodExecOptionsObjectNestedImpl(item);
    }

    public A withProbeObject(Probe probeObject) {
        _visitables.get("object").remove(this.object);
        if (probeObject!=null){ this.object= new ProbeBuilder(probeObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ProbeObjectNested<A> withNewProbeObject() {
        return new ProbeObjectNestedImpl();
    }

    public WatchEventFluent.ProbeObjectNested<A> withNewProbeObjectLike(Probe item) {
        return new ProbeObjectNestedImpl(item);
    }

    public A withUpdateOptionsObject(UpdateOptions updateOptionsObject) {
        _visitables.get("object").remove(this.object);
        if (updateOptionsObject!=null){ this.object= new UpdateOptionsBuilder(updateOptionsObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.UpdateOptionsObjectNested<A> withNewUpdateOptionsObject() {
        return new UpdateOptionsObjectNestedImpl();
    }

    public WatchEventFluent.UpdateOptionsObjectNested<A> withNewUpdateOptionsObjectLike(UpdateOptions item) {
        return new UpdateOptionsObjectNestedImpl(item);
    }

    public A withEndpointsObject(Endpoints endpointsObject) {
        _visitables.get("object").remove(this.object);
        if (endpointsObject!=null){ this.object= new EndpointsBuilder(endpointsObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.EndpointsObjectNested<A> withNewEndpointsObject() {
        return new EndpointsObjectNestedImpl();
    }

    public WatchEventFluent.EndpointsObjectNested<A> withNewEndpointsObjectLike(Endpoints item) {
        return new EndpointsObjectNestedImpl(item);
    }

    public A withNamedExtensionObject(NamedExtension namedExtensionObject) {
        _visitables.get("object").remove(this.object);
        if (namedExtensionObject!=null){ this.object= new NamedExtensionBuilder(namedExtensionObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.NamedExtensionObjectNested<A> withNewNamedExtensionObject() {
        return new NamedExtensionObjectNestedImpl();
    }

    public WatchEventFluent.NamedExtensionObjectNested<A> withNewNamedExtensionObjectLike(NamedExtension item) {
        return new NamedExtensionObjectNestedImpl(item);
    }

    public A withAzureFilePersistentVolumeSourceObject(AzureFilePersistentVolumeSource azureFilePersistentVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (azureFilePersistentVolumeSourceObject!=null){ this.object= new AzureFilePersistentVolumeSourceBuilder(azureFilePersistentVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.AzureFilePersistentVolumeSourceObjectNested<A> withNewAzureFilePersistentVolumeSourceObject() {
        return new AzureFilePersistentVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.AzureFilePersistentVolumeSourceObjectNested<A> withNewAzureFilePersistentVolumeSourceObjectLike(AzureFilePersistentVolumeSource item) {
        return new AzureFilePersistentVolumeSourceObjectNestedImpl(item);
    }

    public A withNewAzureFilePersistentVolumeSourceObject(Boolean readOnly,String secretName,String secretNamespace,String shareName) {
        return (A)withAzureFilePersistentVolumeSourceObject(new AzureFilePersistentVolumeSource(readOnly, secretName, secretNamespace, shareName));
    }

    public A withAPIServiceListObject(APIServiceList aPIServiceListObject) {
        _visitables.get("object").remove(this.object);
        if (aPIServiceListObject!=null){ this.object= new APIServiceListBuilder(aPIServiceListObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.APIServiceListObjectNested<A> withNewAPIServiceListObject() {
        return new APIServiceListObjectNestedImpl();
    }

    public WatchEventFluent.APIServiceListObjectNested<A> withNewAPIServiceListObjectLike(APIServiceList item) {
        return new APIServiceListObjectNestedImpl(item);
    }

    public A withSecretVolumeSourceObject(SecretVolumeSource secretVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (secretVolumeSourceObject!=null){ this.object= new SecretVolumeSourceBuilder(secretVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.SecretVolumeSourceObjectNested<A> withNewSecretVolumeSourceObject() {
        return new SecretVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.SecretVolumeSourceObjectNested<A> withNewSecretVolumeSourceObjectLike(SecretVolumeSource item) {
        return new SecretVolumeSourceObjectNestedImpl(item);
    }

    public A withPodObject(Pod podObject) {
        _visitables.get("object").remove(this.object);
        if (podObject!=null){ this.object= new PodBuilder(podObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PodObjectNested<A> withNewPodObject() {
        return new PodObjectNestedImpl();
    }

    public WatchEventFluent.PodObjectNested<A> withNewPodObjectLike(Pod item) {
        return new PodObjectNestedImpl(item);
    }

    public A withClientIPConfigObject(ClientIPConfig clientIPConfigObject) {
        _visitables.get("object").remove(this.object);
        if (clientIPConfigObject!=null){ this.object= new ClientIPConfigBuilder(clientIPConfigObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ClientIPConfigObjectNested<A> withNewClientIPConfigObject() {
        return new ClientIPConfigObjectNestedImpl();
    }

    public WatchEventFluent.ClientIPConfigObjectNested<A> withNewClientIPConfigObjectLike(ClientIPConfig item) {
        return new ClientIPConfigObjectNestedImpl(item);
    }

    public A withNewClientIPConfigObject(Integer timeoutSeconds) {
        return (A)withClientIPConfigObject(new ClientIPConfig(timeoutSeconds));
    }

    public A withContextObject(Context contextObject) {
        _visitables.get("object").remove(this.object);
        if (contextObject!=null){ this.object= new ContextBuilder(contextObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ContextObjectNested<A> withNewContextObject() {
        return new ContextObjectNestedImpl();
    }

    public WatchEventFluent.ContextObjectNested<A> withNewContextObjectLike(Context item) {
        return new ContextObjectNestedImpl(item);
    }

    public A withNodeAffinityObject(NodeAffinity nodeAffinityObject) {
        _visitables.get("object").remove(this.object);
        if (nodeAffinityObject!=null){ this.object= new NodeAffinityBuilder(nodeAffinityObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.NodeAffinityObjectNested<A> withNewNodeAffinityObject() {
        return new NodeAffinityObjectNestedImpl();
    }

    public WatchEventFluent.NodeAffinityObjectNested<A> withNewNodeAffinityObjectLike(NodeAffinity item) {
        return new NodeAffinityObjectNestedImpl(item);
    }

    public A withConfigMapObject(ConfigMap configMapObject) {
        _visitables.get("object").remove(this.object);
        if (configMapObject!=null){ this.object= new ConfigMapBuilder(configMapObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ConfigMapObjectNested<A> withNewConfigMapObject() {
        return new ConfigMapObjectNestedImpl();
    }

    public WatchEventFluent.ConfigMapObjectNested<A> withNewConfigMapObjectLike(ConfigMap item) {
        return new ConfigMapObjectNestedImpl(item);
    }

    public A withContainerPortObject(ContainerPort containerPortObject) {
        _visitables.get("object").remove(this.object);
        if (containerPortObject!=null){ this.object= new ContainerPortBuilder(containerPortObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ContainerPortObjectNested<A> withNewContainerPortObject() {
        return new ContainerPortObjectNestedImpl();
    }

    public WatchEventFluent.ContainerPortObjectNested<A> withNewContainerPortObjectLike(ContainerPort item) {
        return new ContainerPortObjectNestedImpl(item);
    }

    public A withNewContainerPortObject(Integer containerPort,String hostIP,Integer hostPort,String name,String protocol) {
        return (A)withContainerPortObject(new ContainerPort(containerPort, hostIP, hostPort, name, protocol));
    }

    public A withConditionObject(Condition conditionObject) {
        _visitables.get("object").remove(this.object);
        if (conditionObject!=null){ this.object= new ConditionBuilder(conditionObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ConditionObjectNested<A> withNewConditionObject() {
        return new ConditionObjectNestedImpl();
    }

    public WatchEventFluent.ConditionObjectNested<A> withNewConditionObjectLike(Condition item) {
        return new ConditionObjectNestedImpl(item);
    }

    public A withPodListObject(PodList podListObject) {
        _visitables.get("object").remove(this.object);
        if (podListObject!=null){ this.object= new PodListBuilder(podListObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PodListObjectNested<A> withNewPodListObject() {
        return new PodListObjectNestedImpl();
    }

    public WatchEventFluent.PodListObjectNested<A> withNewPodListObjectLike(PodList item) {
        return new PodListObjectNestedImpl(item);
    }

    public A withFCVolumeSourceObject(FCVolumeSource fCVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (fCVolumeSourceObject!=null){ this.object= new FCVolumeSourceBuilder(fCVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.FCVolumeSourceObjectNested<A> withNewFCVolumeSourceObject() {
        return new FCVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.FCVolumeSourceObjectNested<A> withNewFCVolumeSourceObjectLike(FCVolumeSource item) {
        return new FCVolumeSourceObjectNestedImpl(item);
    }

    public A withResourceFieldSelectorObject(ResourceFieldSelector resourceFieldSelectorObject) {
        _visitables.get("object").remove(this.object);
        if (resourceFieldSelectorObject!=null){ this.object= new ResourceFieldSelectorBuilder(resourceFieldSelectorObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ResourceFieldSelectorObjectNested<A> withNewResourceFieldSelectorObject() {
        return new ResourceFieldSelectorObjectNestedImpl();
    }

    public WatchEventFluent.ResourceFieldSelectorObjectNested<A> withNewResourceFieldSelectorObjectLike(ResourceFieldSelector item) {
        return new ResourceFieldSelectorObjectNestedImpl(item);
    }

    public A withPersistentVolumeClaimSpecObject(PersistentVolumeClaimSpec persistentVolumeClaimSpecObject) {
        _visitables.get("object").remove(this.object);
        if (persistentVolumeClaimSpecObject!=null){ this.object= new PersistentVolumeClaimSpecBuilder(persistentVolumeClaimSpecObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PersistentVolumeClaimSpecObjectNested<A> withNewPersistentVolumeClaimSpecObject() {
        return new PersistentVolumeClaimSpecObjectNestedImpl();
    }

    public WatchEventFluent.PersistentVolumeClaimSpecObjectNested<A> withNewPersistentVolumeClaimSpecObjectLike(PersistentVolumeClaimSpec item) {
        return new PersistentVolumeClaimSpecObjectNestedImpl(item);
    }

    public A withLoadBalancerStatusObject(LoadBalancerStatus loadBalancerStatusObject) {
        _visitables.get("object").remove(this.object);
        if (loadBalancerStatusObject!=null){ this.object= new LoadBalancerStatusBuilder(loadBalancerStatusObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.LoadBalancerStatusObjectNested<A> withNewLoadBalancerStatusObject() {
        return new LoadBalancerStatusObjectNestedImpl();
    }

    public WatchEventFluent.LoadBalancerStatusObjectNested<A> withNewLoadBalancerStatusObjectLike(LoadBalancerStatus item) {
        return new LoadBalancerStatusObjectNestedImpl(item);
    }

    public A withScopeSelectorObject(ScopeSelector scopeSelectorObject) {
        _visitables.get("object").remove(this.object);
        if (scopeSelectorObject!=null){ this.object= new ScopeSelectorBuilder(scopeSelectorObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ScopeSelectorObjectNested<A> withNewScopeSelectorObject() {
        return new ScopeSelectorObjectNestedImpl();
    }

    public WatchEventFluent.ScopeSelectorObjectNested<A> withNewScopeSelectorObjectLike(ScopeSelector item) {
        return new ScopeSelectorObjectNestedImpl(item);
    }

    public A withPodSecurityContextObject(PodSecurityContext podSecurityContextObject) {
        _visitables.get("object").remove(this.object);
        if (podSecurityContextObject!=null){ this.object= new PodSecurityContextBuilder(podSecurityContextObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PodSecurityContextObjectNested<A> withNewPodSecurityContextObject() {
        return new PodSecurityContextObjectNestedImpl();
    }

    public WatchEventFluent.PodSecurityContextObjectNested<A> withNewPodSecurityContextObjectLike(PodSecurityContext item) {
        return new PodSecurityContextObjectNestedImpl(item);
    }

    public A withDownwardAPIProjectionObject(DownwardAPIProjection downwardAPIProjectionObject) {
        _visitables.get("object").remove(this.object);
        if (downwardAPIProjectionObject!=null){ this.object= new DownwardAPIProjectionBuilder(downwardAPIProjectionObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.DownwardAPIProjectionObjectNested<A> withNewDownwardAPIProjectionObject() {
        return new DownwardAPIProjectionObjectNestedImpl();
    }

    public WatchEventFluent.DownwardAPIProjectionObjectNested<A> withNewDownwardAPIProjectionObjectLike(DownwardAPIProjection item) {
        return new DownwardAPIProjectionObjectNestedImpl(item);
    }

    public A withPodAffinityTermObject(PodAffinityTerm podAffinityTermObject) {
        _visitables.get("object").remove(this.object);
        if (podAffinityTermObject!=null){ this.object= new PodAffinityTermBuilder(podAffinityTermObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PodAffinityTermObjectNested<A> withNewPodAffinityTermObject() {
        return new PodAffinityTermObjectNestedImpl();
    }

    public WatchEventFluent.PodAffinityTermObjectNested<A> withNewPodAffinityTermObjectLike(PodAffinityTerm item) {
        return new PodAffinityTermObjectNestedImpl(item);
    }

    public A withAPIServiceSpecObject(APIServiceSpec aPIServiceSpecObject) {
        _visitables.get("object").remove(this.object);
        if (aPIServiceSpecObject!=null){ this.object= new APIServiceSpecBuilder(aPIServiceSpecObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.APIServiceSpecObjectNested<A> withNewAPIServiceSpecObject() {
        return new APIServiceSpecObjectNestedImpl();
    }

    public WatchEventFluent.APIServiceSpecObjectNested<A> withNewAPIServiceSpecObjectLike(APIServiceSpec item) {
        return new APIServiceSpecObjectNestedImpl(item);
    }

    public A withServicePortObject(ServicePort servicePortObject) {
        _visitables.get("object").remove(this.object);
        if (servicePortObject!=null){ this.object= new ServicePortBuilder(servicePortObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ServicePortObjectNested<A> withNewServicePortObject() {
        return new ServicePortObjectNestedImpl();
    }

    public WatchEventFluent.ServicePortObjectNested<A> withNewServicePortObjectLike(ServicePort item) {
        return new ServicePortObjectNestedImpl(item);
    }

    public A withGroupVersionForDiscoveryObject(GroupVersionForDiscovery groupVersionForDiscoveryObject) {
        _visitables.get("object").remove(this.object);
        if (groupVersionForDiscoveryObject!=null){ this.object= new GroupVersionForDiscoveryBuilder(groupVersionForDiscoveryObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.GroupVersionForDiscoveryObjectNested<A> withNewGroupVersionForDiscoveryObject() {
        return new GroupVersionForDiscoveryObjectNestedImpl();
    }

    public WatchEventFluent.GroupVersionForDiscoveryObjectNested<A> withNewGroupVersionForDiscoveryObjectLike(GroupVersionForDiscovery item) {
        return new GroupVersionForDiscoveryObjectNestedImpl(item);
    }

    public A withNewGroupVersionForDiscoveryObject(String groupVersion,String version) {
        return (A)withGroupVersionForDiscoveryObject(new GroupVersionForDiscovery(groupVersion, version));
    }

    public A withPersistentVolumeClaimSourceObject(PersistentVolumeClaimVolumeSource persistentVolumeClaimSourceObject) {
        _visitables.get("object").remove(this.object);
        if (persistentVolumeClaimSourceObject!=null){ this.object= new PersistentVolumeClaimVolumeSourceBuilder(persistentVolumeClaimSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PersistentVolumeClaimSourceObjectNested<A> withNewPersistentVolumeClaimSourceObject() {
        return new PersistentVolumeClaimSourceObjectNestedImpl();
    }

    public WatchEventFluent.PersistentVolumeClaimSourceObjectNested<A> withNewPersistentVolumeClaimSourceObjectLike(PersistentVolumeClaimVolumeSource item) {
        return new PersistentVolumeClaimSourceObjectNestedImpl(item);
    }

    public A withNewPersistentVolumeClaimSourceObject(String claimName,Boolean readOnly) {
        return (A)withPersistentVolumeClaimSourceObject(new PersistentVolumeClaimVolumeSource(claimName, readOnly));
    }

    public A withSessionAffinityConfigObject(SessionAffinityConfig sessionAffinityConfigObject) {
        _visitables.get("object").remove(this.object);
        if (sessionAffinityConfigObject!=null){ this.object= new SessionAffinityConfigBuilder(sessionAffinityConfigObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.SessionAffinityConfigObjectNested<A> withNewSessionAffinityConfigObject() {
        return new SessionAffinityConfigObjectNestedImpl();
    }

    public WatchEventFluent.SessionAffinityConfigObjectNested<A> withNewSessionAffinityConfigObjectLike(SessionAffinityConfig item) {
        return new SessionAffinityConfigObjectNestedImpl(item);
    }

    public A withServiceAccountListObject(ServiceAccountList serviceAccountListObject) {
        _visitables.get("object").remove(this.object);
        if (serviceAccountListObject!=null){ this.object= new ServiceAccountListBuilder(serviceAccountListObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ServiceAccountListObjectNested<A> withNewServiceAccountListObject() {
        return new ServiceAccountListObjectNestedImpl();
    }

    public WatchEventFluent.ServiceAccountListObjectNested<A> withNewServiceAccountListObjectLike(ServiceAccountList item) {
        return new ServiceAccountListObjectNestedImpl(item);
    }

    public A withComponentStatusObject(ComponentStatus componentStatusObject) {
        _visitables.get("object").remove(this.object);
        if (componentStatusObject!=null){ this.object= new ComponentStatusBuilder(componentStatusObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ComponentStatusObjectNested<A> withNewComponentStatusObject() {
        return new ComponentStatusObjectNestedImpl();
    }

    public WatchEventFluent.ComponentStatusObjectNested<A> withNewComponentStatusObjectLike(ComponentStatus item) {
        return new ComponentStatusObjectNestedImpl(item);
    }

    public A withDaemonEndpointObject(DaemonEndpoint daemonEndpointObject) {
        _visitables.get("object").remove(this.object);
        if (daemonEndpointObject!=null){ this.object= new DaemonEndpointBuilder(daemonEndpointObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.DaemonEndpointObjectNested<A> withNewDaemonEndpointObject() {
        return new DaemonEndpointObjectNestedImpl();
    }

    public WatchEventFluent.DaemonEndpointObjectNested<A> withNewDaemonEndpointObjectLike(DaemonEndpoint item) {
        return new DaemonEndpointObjectNestedImpl(item);
    }

    public A withNewDaemonEndpointObject(Integer port) {
        return (A)withDaemonEndpointObject(new DaemonEndpoint(port));
    }

    public A withKeyToPathObject(KeyToPath keyToPathObject) {
        _visitables.get("object").remove(this.object);
        if (keyToPathObject!=null){ this.object= new KeyToPathBuilder(keyToPathObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.KeyToPathObjectNested<A> withNewKeyToPathObject() {
        return new KeyToPathObjectNestedImpl();
    }

    public WatchEventFluent.KeyToPathObjectNested<A> withNewKeyToPathObjectLike(KeyToPath item) {
        return new KeyToPathObjectNestedImpl(item);
    }

    public A withNewKeyToPathObject(String key,Integer mode,String path) {
        return (A)withKeyToPathObject(new KeyToPath(key, mode, path));
    }

    public A withFlexPersistentVolumeSourceObject(FlexPersistentVolumeSource flexPersistentVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (flexPersistentVolumeSourceObject!=null){ this.object= new FlexPersistentVolumeSourceBuilder(flexPersistentVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.FlexPersistentVolumeSourceObjectNested<A> withNewFlexPersistentVolumeSourceObject() {
        return new FlexPersistentVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.FlexPersistentVolumeSourceObjectNested<A> withNewFlexPersistentVolumeSourceObjectLike(FlexPersistentVolumeSource item) {
        return new FlexPersistentVolumeSourceObjectNestedImpl(item);
    }

    public A withNamespaceListObject(NamespaceList namespaceListObject) {
        _visitables.get("object").remove(this.object);
        if (namespaceListObject!=null){ this.object= new NamespaceListBuilder(namespaceListObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.NamespaceListObjectNested<A> withNewNamespaceListObject() {
        return new NamespaceListObjectNestedImpl();
    }

    public WatchEventFluent.NamespaceListObjectNested<A> withNewNamespaceListObjectLike(NamespaceList item) {
        return new NamespaceListObjectNestedImpl(item);
    }

    public A withPodDNSConfigObject(PodDNSConfig podDNSConfigObject) {
        _visitables.get("object").remove(this.object);
        if (podDNSConfigObject!=null){ this.object= new PodDNSConfigBuilder(podDNSConfigObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PodDNSConfigObjectNested<A> withNewPodDNSConfigObject() {
        return new PodDNSConfigObjectNestedImpl();
    }

    public WatchEventFluent.PodDNSConfigObjectNested<A> withNewPodDNSConfigObjectLike(PodDNSConfig item) {
        return new PodDNSConfigObjectNestedImpl(item);
    }

    public A withNodeListObject(NodeList nodeListObject) {
        _visitables.get("object").remove(this.object);
        if (nodeListObject!=null){ this.object= new NodeListBuilder(nodeListObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.NodeListObjectNested<A> withNewNodeListObject() {
        return new NodeListObjectNestedImpl();
    }

    public WatchEventFluent.NodeListObjectNested<A> withNewNodeListObjectLike(NodeList item) {
        return new NodeListObjectNestedImpl(item);
    }

    public A withBindingObject(Binding bindingObject) {
        _visitables.get("object").remove(this.object);
        if (bindingObject!=null){ this.object= new BindingBuilder(bindingObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.BindingObjectNested<A> withNewBindingObject() {
        return new BindingObjectNestedImpl();
    }

    public WatchEventFluent.BindingObjectNested<A> withNewBindingObjectLike(Binding item) {
        return new BindingObjectNestedImpl(item);
    }

    public A withEnvVarSourceObject(EnvVarSource envVarSourceObject) {
        _visitables.get("object").remove(this.object);
        if (envVarSourceObject!=null){ this.object= new EnvVarSourceBuilder(envVarSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.EnvVarSourceObjectNested<A> withNewEnvVarSourceObject() {
        return new EnvVarSourceObjectNestedImpl();
    }

    public WatchEventFluent.EnvVarSourceObjectNested<A> withNewEnvVarSourceObjectLike(EnvVarSource item) {
        return new EnvVarSourceObjectNestedImpl(item);
    }

    public A withVolumeProjectionObject(VolumeProjection volumeProjectionObject) {
        _visitables.get("object").remove(this.object);
        if (volumeProjectionObject!=null){ this.object= new VolumeProjectionBuilder(volumeProjectionObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.VolumeProjectionObjectNested<A> withNewVolumeProjectionObject() {
        return new VolumeProjectionObjectNestedImpl();
    }

    public WatchEventFluent.VolumeProjectionObjectNested<A> withNewVolumeProjectionObjectLike(VolumeProjection item) {
        return new VolumeProjectionObjectNestedImpl(item);
    }

    public A withResourceQuotaObject(ResourceQuota resourceQuotaObject) {
        _visitables.get("object").remove(this.object);
        if (resourceQuotaObject!=null){ this.object= new ResourceQuotaBuilder(resourceQuotaObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ResourceQuotaObjectNested<A> withNewResourceQuotaObject() {
        return new ResourceQuotaObjectNestedImpl();
    }

    public WatchEventFluent.ResourceQuotaObjectNested<A> withNewResourceQuotaObjectLike(ResourceQuota item) {
        return new ResourceQuotaObjectNestedImpl(item);
    }

    public A withSecretObject(Secret secretObject) {
        _visitables.get("object").remove(this.object);
        if (secretObject!=null){ this.object= new SecretBuilder(secretObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.SecretObjectNested<A> withNewSecretObject() {
        return new SecretObjectNestedImpl();
    }

    public WatchEventFluent.SecretObjectNested<A> withNewSecretObjectLike(Secret item) {
        return new SecretObjectNestedImpl(item);
    }

    public A withServiceListObject(ServiceList serviceListObject) {
        _visitables.get("object").remove(this.object);
        if (serviceListObject!=null){ this.object= new ServiceListBuilder(serviceListObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ServiceListObjectNested<A> withNewServiceListObject() {
        return new ServiceListObjectNestedImpl();
    }

    public WatchEventFluent.ServiceListObjectNested<A> withNewServiceListObjectLike(ServiceList item) {
        return new ServiceListObjectNestedImpl(item);
    }

    public A withVolumeNodeAffinityObject(VolumeNodeAffinity volumeNodeAffinityObject) {
        _visitables.get("object").remove(this.object);
        if (volumeNodeAffinityObject!=null){ this.object= new VolumeNodeAffinityBuilder(volumeNodeAffinityObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.VolumeNodeAffinityObjectNested<A> withNewVolumeNodeAffinityObject() {
        return new VolumeNodeAffinityObjectNestedImpl();
    }

    public WatchEventFluent.VolumeNodeAffinityObjectNested<A> withNewVolumeNodeAffinityObjectLike(VolumeNodeAffinity item) {
        return new VolumeNodeAffinityObjectNestedImpl(item);
    }

    public A withResourceQuotaSpecObject(ResourceQuotaSpec resourceQuotaSpecObject) {
        _visitables.get("object").remove(this.object);
        if (resourceQuotaSpecObject!=null){ this.object= new ResourceQuotaSpecBuilder(resourceQuotaSpecObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ResourceQuotaSpecObjectNested<A> withNewResourceQuotaSpecObject() {
        return new ResourceQuotaSpecObjectNestedImpl();
    }

    public WatchEventFluent.ResourceQuotaSpecObjectNested<A> withNewResourceQuotaSpecObjectLike(ResourceQuotaSpec item) {
        return new ResourceQuotaSpecObjectNestedImpl(item);
    }

    public A withNodeSelectorTermObject(NodeSelectorTerm nodeSelectorTermObject) {
        _visitables.get("object").remove(this.object);
        if (nodeSelectorTermObject!=null){ this.object= new NodeSelectorTermBuilder(nodeSelectorTermObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.NodeSelectorTermObjectNested<A> withNewNodeSelectorTermObject() {
        return new NodeSelectorTermObjectNestedImpl();
    }

    public WatchEventFluent.NodeSelectorTermObjectNested<A> withNewNodeSelectorTermObjectLike(NodeSelectorTerm item) {
        return new NodeSelectorTermObjectNestedImpl(item);
    }

    public A withScaleIOPersistentVolumeSourceObject(ScaleIOPersistentVolumeSource scaleIOPersistentVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (scaleIOPersistentVolumeSourceObject!=null){ this.object= new ScaleIOPersistentVolumeSourceBuilder(scaleIOPersistentVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ScaleIOPersistentVolumeSourceObjectNested<A> withNewScaleIOPersistentVolumeSourceObject() {
        return new ScaleIOPersistentVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.ScaleIOPersistentVolumeSourceObjectNested<A> withNewScaleIOPersistentVolumeSourceObjectLike(ScaleIOPersistentVolumeSource item) {
        return new ScaleIOPersistentVolumeSourceObjectNestedImpl(item);
    }

    public A withListOptionsObject(ListOptions listOptionsObject) {
        _visitables.get("object").remove(this.object);
        if (listOptionsObject!=null){ this.object= new ListOptionsBuilder(listOptionsObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ListOptionsObjectNested<A> withNewListOptionsObject() {
        return new ListOptionsObjectNestedImpl();
    }

    public WatchEventFluent.ListOptionsObjectNested<A> withNewListOptionsObjectLike(ListOptions item) {
        return new ListOptionsObjectNestedImpl(item);
    }

    public A withWeightedPodAffinityTermObject(WeightedPodAffinityTerm weightedPodAffinityTermObject) {
        _visitables.get("object").remove(this.object);
        if (weightedPodAffinityTermObject!=null){ this.object= new WeightedPodAffinityTermBuilder(weightedPodAffinityTermObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.WeightedPodAffinityTermObjectNested<A> withNewWeightedPodAffinityTermObject() {
        return new WeightedPodAffinityTermObjectNestedImpl();
    }

    public WatchEventFluent.WeightedPodAffinityTermObjectNested<A> withNewWeightedPodAffinityTermObjectLike(WeightedPodAffinityTerm item) {
        return new WeightedPodAffinityTermObjectNestedImpl(item);
    }

    public A withBaseKubernetesListObject(BaseKubernetesList baseKubernetesListObject) {
        _visitables.get("object").remove(this.object);
        if (baseKubernetesListObject!=null){ this.object= new BaseKubernetesListBuilder(baseKubernetesListObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.BaseKubernetesListObjectNested<A> withNewBaseKubernetesListObject() {
        return new BaseKubernetesListObjectNestedImpl();
    }

    public WatchEventFluent.BaseKubernetesListObjectNested<A> withNewBaseKubernetesListObjectLike(BaseKubernetesList item) {
        return new BaseKubernetesListObjectNestedImpl(item);
    }

    public A withNodeSystemInfoObject(NodeSystemInfo nodeSystemInfoObject) {
        _visitables.get("object").remove(this.object);
        if (nodeSystemInfoObject!=null){ this.object= new NodeSystemInfoBuilder(nodeSystemInfoObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.NodeSystemInfoObjectNested<A> withNewNodeSystemInfoObject() {
        return new NodeSystemInfoObjectNestedImpl();
    }

    public WatchEventFluent.NodeSystemInfoObjectNested<A> withNewNodeSystemInfoObjectLike(NodeSystemInfo item) {
        return new NodeSystemInfoObjectNestedImpl(item);
    }

    public A withTopologySelectorLabelRequirementObject(TopologySelectorLabelRequirement topologySelectorLabelRequirementObject) {
        _visitables.get("object").remove(this.object);
        if (topologySelectorLabelRequirementObject!=null){ this.object= new TopologySelectorLabelRequirementBuilder(topologySelectorLabelRequirementObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.TopologySelectorLabelRequirementObjectNested<A> withNewTopologySelectorLabelRequirementObject() {
        return new TopologySelectorLabelRequirementObjectNestedImpl();
    }

    public WatchEventFluent.TopologySelectorLabelRequirementObjectNested<A> withNewTopologySelectorLabelRequirementObjectLike(TopologySelectorLabelRequirement item) {
        return new TopologySelectorLabelRequirementObjectNestedImpl(item);
    }

    public A withRBDPersistentVolumeSourceObject(RBDPersistentVolumeSource rBDPersistentVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (rBDPersistentVolumeSourceObject!=null){ this.object= new RBDPersistentVolumeSourceBuilder(rBDPersistentVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.RBDPersistentVolumeSourceObjectNested<A> withNewRBDPersistentVolumeSourceObject() {
        return new RBDPersistentVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.RBDPersistentVolumeSourceObjectNested<A> withNewRBDPersistentVolumeSourceObjectLike(RBDPersistentVolumeSource item) {
        return new RBDPersistentVolumeSourceObjectNestedImpl(item);
    }

    public A withAuthProviderConfigObject(AuthProviderConfig authProviderConfigObject) {
        _visitables.get("object").remove(this.object);
        if (authProviderConfigObject!=null){ this.object= new AuthProviderConfigBuilder(authProviderConfigObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.AuthProviderConfigObjectNested<A> withNewAuthProviderConfigObject() {
        return new AuthProviderConfigObjectNestedImpl();
    }

    public WatchEventFluent.AuthProviderConfigObjectNested<A> withNewAuthProviderConfigObjectLike(AuthProviderConfig item) {
        return new AuthProviderConfigObjectNestedImpl(item);
    }

    public A withSELinuxOptionsObject(SELinuxOptions sELinuxOptionsObject) {
        _visitables.get("object").remove(this.object);
        if (sELinuxOptionsObject!=null){ this.object= new SELinuxOptionsBuilder(sELinuxOptionsObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.SELinuxOptionsObjectNested<A> withNewSELinuxOptionsObject() {
        return new SELinuxOptionsObjectNestedImpl();
    }

    public WatchEventFluent.SELinuxOptionsObjectNested<A> withNewSELinuxOptionsObjectLike(SELinuxOptions item) {
        return new SELinuxOptionsObjectNestedImpl(item);
    }

    public A withNewSELinuxOptionsObject(String level,String role,String type,String user) {
        return (A)withSELinuxOptionsObject(new SELinuxOptions(level, role, type, user));
    }

    public A withHostAliasObject(HostAlias hostAliasObject) {
        _visitables.get("object").remove(this.object);
        if (hostAliasObject!=null){ this.object= new HostAliasBuilder(hostAliasObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.HostAliasObjectNested<A> withNewHostAliasObject() {
        return new HostAliasObjectNestedImpl();
    }

    public WatchEventFluent.HostAliasObjectNested<A> withNewHostAliasObjectLike(HostAlias item) {
        return new HostAliasObjectNestedImpl(item);
    }

    public A withNodeDaemonEndpointsObject(NodeDaemonEndpoints nodeDaemonEndpointsObject) {
        _visitables.get("object").remove(this.object);
        if (nodeDaemonEndpointsObject!=null){ this.object= new NodeDaemonEndpointsBuilder(nodeDaemonEndpointsObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.NodeDaemonEndpointsObjectNested<A> withNewNodeDaemonEndpointsObject() {
        return new NodeDaemonEndpointsObjectNestedImpl();
    }

    public WatchEventFluent.NodeDaemonEndpointsObjectNested<A> withNewNodeDaemonEndpointsObjectLike(NodeDaemonEndpoints item) {
        return new NodeDaemonEndpointsObjectNestedImpl(item);
    }

    public A withCSIVolumeSourceObject(CSIVolumeSource cSIVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (cSIVolumeSourceObject!=null){ this.object= new CSIVolumeSourceBuilder(cSIVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.CSIVolumeSourceObjectNested<A> withNewCSIVolumeSourceObject() {
        return new CSIVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.CSIVolumeSourceObjectNested<A> withNewCSIVolumeSourceObjectLike(CSIVolumeSource item) {
        return new CSIVolumeSourceObjectNestedImpl(item);
    }

    public A withVolumeDeviceObject(VolumeDevice volumeDeviceObject) {
        _visitables.get("object").remove(this.object);
        if (volumeDeviceObject!=null){ this.object= new VolumeDeviceBuilder(volumeDeviceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.VolumeDeviceObjectNested<A> withNewVolumeDeviceObject() {
        return new VolumeDeviceObjectNestedImpl();
    }

    public WatchEventFluent.VolumeDeviceObjectNested<A> withNewVolumeDeviceObjectLike(VolumeDevice item) {
        return new VolumeDeviceObjectNestedImpl(item);
    }

    public A withNewVolumeDeviceObject(String devicePath,String name) {
        return (A)withVolumeDeviceObject(new VolumeDevice(devicePath, name));
    }

    public A withPersistentVolumeSpecObject(PersistentVolumeSpec persistentVolumeSpecObject) {
        _visitables.get("object").remove(this.object);
        if (persistentVolumeSpecObject!=null){ this.object= new PersistentVolumeSpecBuilder(persistentVolumeSpecObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PersistentVolumeSpecObjectNested<A> withNewPersistentVolumeSpecObject() {
        return new PersistentVolumeSpecObjectNestedImpl();
    }

    public WatchEventFluent.PersistentVolumeSpecObjectNested<A> withNewPersistentVolumeSpecObjectLike(PersistentVolumeSpec item) {
        return new PersistentVolumeSpecObjectNestedImpl(item);
    }

    public A withNodeObject(Node nodeObject) {
        _visitables.get("object").remove(this.object);
        if (nodeObject!=null){ this.object= new NodeBuilder(nodeObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.NodeObjectNested<A> withNewNodeObject() {
        return new NodeObjectNestedImpl();
    }

    public WatchEventFluent.NodeObjectNested<A> withNewNodeObjectLike(Node item) {
        return new NodeObjectNestedImpl(item);
    }

    public A withVolumeObject(Volume volumeObject) {
        _visitables.get("object").remove(this.object);
        if (volumeObject!=null){ this.object= new VolumeBuilder(volumeObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.VolumeObjectNested<A> withNewVolumeObject() {
        return new VolumeObjectNestedImpl();
    }

    public WatchEventFluent.VolumeObjectNested<A> withNewVolumeObjectLike(Volume item) {
        return new VolumeObjectNestedImpl(item);
    }

    public A withNFSVolumeSourceObject(NFSVolumeSource nFSVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (nFSVolumeSourceObject!=null){ this.object= new NFSVolumeSourceBuilder(nFSVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.NFSVolumeSourceObjectNested<A> withNewNFSVolumeSourceObject() {
        return new NFSVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.NFSVolumeSourceObjectNested<A> withNewNFSVolumeSourceObjectLike(NFSVolumeSource item) {
        return new NFSVolumeSourceObjectNestedImpl(item);
    }

    public A withNewNFSVolumeSourceObject(String path,Boolean readOnly,String server) {
        return (A)withNFSVolumeSourceObject(new NFSVolumeSource(path, readOnly, server));
    }

    public A withClusterObject(Cluster clusterObject) {
        _visitables.get("object").remove(this.object);
        if (clusterObject!=null){ this.object= new ClusterBuilder(clusterObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ClusterObjectNested<A> withNewClusterObject() {
        return new ClusterObjectNestedImpl();
    }

    public WatchEventFluent.ClusterObjectNested<A> withNewClusterObjectLike(Cluster item) {
        return new ClusterObjectNestedImpl(item);
    }

    public A withStorageOSVolumeSourceObject(StorageOSVolumeSource storageOSVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (storageOSVolumeSourceObject!=null){ this.object= new StorageOSVolumeSourceBuilder(storageOSVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.StorageOSVolumeSourceObjectNested<A> withNewStorageOSVolumeSourceObject() {
        return new StorageOSVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.StorageOSVolumeSourceObjectNested<A> withNewStorageOSVolumeSourceObjectLike(StorageOSVolumeSource item) {
        return new StorageOSVolumeSourceObjectNestedImpl(item);
    }

    public A withPodStatusObject(PodStatus podStatusObject) {
        _visitables.get("object").remove(this.object);
        if (podStatusObject!=null){ this.object= new PodStatusBuilder(podStatusObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PodStatusObjectNested<A> withNewPodStatusObject() {
        return new PodStatusObjectNestedImpl();
    }

    public WatchEventFluent.PodStatusObjectNested<A> withNewPodStatusObjectLike(PodStatus item) {
        return new PodStatusObjectNestedImpl(item);
    }

    public A withExecConfigObject(ExecConfig execConfigObject) {
        _visitables.get("object").remove(this.object);
        if (execConfigObject!=null){ this.object= new ExecConfigBuilder(execConfigObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ExecConfigObjectNested<A> withNewExecConfigObject() {
        return new ExecConfigObjectNestedImpl();
    }

    public WatchEventFluent.ExecConfigObjectNested<A> withNewExecConfigObjectLike(ExecConfig item) {
        return new ExecConfigObjectNestedImpl(item);
    }

    public A withKubernetesListObject(KubernetesList kubernetesListObject) {
        _visitables.get("object").remove(this.object);
        if (kubernetesListObject!=null){ this.object= new KubernetesListBuilder(kubernetesListObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.KubernetesListObjectNested<A> withNewKubernetesListObject() {
        return new KubernetesListObjectNestedImpl();
    }

    public WatchEventFluent.KubernetesListObjectNested<A> withNewKubernetesListObjectLike(KubernetesList item) {
        return new KubernetesListObjectNestedImpl(item);
    }

    public A withPersistentVolumeStatusObject(PersistentVolumeStatus persistentVolumeStatusObject) {
        _visitables.get("object").remove(this.object);
        if (persistentVolumeStatusObject!=null){ this.object= new PersistentVolumeStatusBuilder(persistentVolumeStatusObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PersistentVolumeStatusObjectNested<A> withNewPersistentVolumeStatusObject() {
        return new PersistentVolumeStatusObjectNestedImpl();
    }

    public WatchEventFluent.PersistentVolumeStatusObjectNested<A> withNewPersistentVolumeStatusObjectLike(PersistentVolumeStatus item) {
        return new PersistentVolumeStatusObjectNestedImpl(item);
    }

    public A withNewPersistentVolumeStatusObject(String message,String phase,String reason) {
        return (A)withPersistentVolumeStatusObject(new PersistentVolumeStatus(message, phase, reason));
    }

    public A withEndpointPortObject(EndpointPort endpointPortObject) {
        _visitables.get("object").remove(this.object);
        if (endpointPortObject!=null){ this.object= new EndpointPortBuilder(endpointPortObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.EndpointPortObjectNested<A> withNewEndpointPortObject() {
        return new EndpointPortObjectNestedImpl();
    }

    public WatchEventFluent.EndpointPortObjectNested<A> withNewEndpointPortObjectLike(EndpointPort item) {
        return new EndpointPortObjectNestedImpl(item);
    }

    public A withNewEndpointPortObject(String appProtocol,String name,Integer port,String protocol) {
        return (A)withEndpointPortObject(new EndpointPort(appProtocol, name, port, protocol));
    }

    public A withHTTPHeaderObject(HTTPHeader hTTPHeaderObject) {
        _visitables.get("object").remove(this.object);
        if (hTTPHeaderObject!=null){ this.object= new HTTPHeaderBuilder(hTTPHeaderObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.HTTPHeaderObjectNested<A> withNewHTTPHeaderObject() {
        return new HTTPHeaderObjectNestedImpl();
    }

    public WatchEventFluent.HTTPHeaderObjectNested<A> withNewHTTPHeaderObjectLike(HTTPHeader item) {
        return new HTTPHeaderObjectNestedImpl(item);
    }

    public A withNewHTTPHeaderObject(String name,String value) {
        return (A)withHTTPHeaderObject(new HTTPHeader(name, value));
    }

    public A withCapabilitiesObject(Capabilities capabilitiesObject) {
        _visitables.get("object").remove(this.object);
        if (capabilitiesObject!=null){ this.object= new CapabilitiesBuilder(capabilitiesObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.CapabilitiesObjectNested<A> withNewCapabilitiesObject() {
        return new CapabilitiesObjectNestedImpl();
    }

    public WatchEventFluent.CapabilitiesObjectNested<A> withNewCapabilitiesObjectLike(Capabilities item) {
        return new CapabilitiesObjectNestedImpl(item);
    }

    public A withWatchEventObject(WatchEvent watchEventObject) {
        _visitables.get("object").remove(this.object);
        if (watchEventObject!=null){ this.object= new WatchEventBuilder(watchEventObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.WatchEventObjectNested<A> withNewWatchEventObject() {
        return new WatchEventObjectNestedImpl();
    }

    public WatchEventFluent.WatchEventObjectNested<A> withNewWatchEventObjectLike(WatchEvent item) {
        return new WatchEventObjectNestedImpl(item);
    }

    public A withObjectReferenceObject(ObjectReference objectReferenceObject) {
        _visitables.get("object").remove(this.object);
        if (objectReferenceObject!=null){ this.object= new ObjectReferenceBuilder(objectReferenceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ObjectReferenceObjectNested<A> withNewObjectReferenceObject() {
        return new ObjectReferenceObjectNestedImpl();
    }

    public WatchEventFluent.ObjectReferenceObjectNested<A> withNewObjectReferenceObjectLike(ObjectReference item) {
        return new ObjectReferenceObjectNestedImpl(item);
    }

    public A withLimitRangeItemObject(LimitRangeItem limitRangeItemObject) {
        _visitables.get("object").remove(this.object);
        if (limitRangeItemObject!=null){ this.object= new LimitRangeItemBuilder(limitRangeItemObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.LimitRangeItemObjectNested<A> withNewLimitRangeItemObject() {
        return new LimitRangeItemObjectNestedImpl();
    }

    public WatchEventFluent.LimitRangeItemObjectNested<A> withNewLimitRangeItemObjectLike(LimitRangeItem item) {
        return new LimitRangeItemObjectNestedImpl(item);
    }

    public A withSecretProjectionObject(SecretProjection secretProjectionObject) {
        _visitables.get("object").remove(this.object);
        if (secretProjectionObject!=null){ this.object= new SecretProjectionBuilder(secretProjectionObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.SecretProjectionObjectNested<A> withNewSecretProjectionObject() {
        return new SecretProjectionObjectNestedImpl();
    }

    public WatchEventFluent.SecretProjectionObjectNested<A> withNewSecretProjectionObjectLike(SecretProjection item) {
        return new SecretProjectionObjectNestedImpl(item);
    }

    public A withGetOptionsObject(GetOptions getOptionsObject) {
        _visitables.get("object").remove(this.object);
        if (getOptionsObject!=null){ this.object= new GetOptionsBuilder(getOptionsObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.GetOptionsObjectNested<A> withNewGetOptionsObject() {
        return new GetOptionsObjectNestedImpl();
    }

    public WatchEventFluent.GetOptionsObjectNested<A> withNewGetOptionsObjectLike(GetOptions item) {
        return new GetOptionsObjectNestedImpl(item);
    }

    public A withNewGetOptionsObject(String apiVersion,String kind,String resourceVersion) {
        return (A)withGetOptionsObject(new GetOptions(apiVersion, kind, resourceVersion));
    }

    public A withGlusterfsVolumeSourceObject(GlusterfsVolumeSource glusterfsVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (glusterfsVolumeSourceObject!=null){ this.object= new GlusterfsVolumeSourceBuilder(glusterfsVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.GlusterfsVolumeSourceObjectNested<A> withNewGlusterfsVolumeSourceObject() {
        return new GlusterfsVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.GlusterfsVolumeSourceObjectNested<A> withNewGlusterfsVolumeSourceObjectLike(GlusterfsVolumeSource item) {
        return new GlusterfsVolumeSourceObjectNestedImpl(item);
    }

    public A withNewGlusterfsVolumeSourceObject(String endpoints,String path,Boolean readOnly) {
        return (A)withGlusterfsVolumeSourceObject(new GlusterfsVolumeSource(endpoints, path, readOnly));
    }

    public A withNamespaceStatusObject(NamespaceStatus namespaceStatusObject) {
        _visitables.get("object").remove(this.object);
        if (namespaceStatusObject!=null){ this.object= new NamespaceStatusBuilder(namespaceStatusObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.NamespaceStatusObjectNested<A> withNewNamespaceStatusObject() {
        return new NamespaceStatusObjectNestedImpl();
    }

    public WatchEventFluent.NamespaceStatusObjectNested<A> withNewNamespaceStatusObjectLike(NamespaceStatus item) {
        return new NamespaceStatusObjectNestedImpl(item);
    }

    public A withManagedFieldsEntryObject(ManagedFieldsEntry managedFieldsEntryObject) {
        _visitables.get("object").remove(this.object);
        if (managedFieldsEntryObject!=null){ this.object= new ManagedFieldsEntryBuilder(managedFieldsEntryObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ManagedFieldsEntryObjectNested<A> withNewManagedFieldsEntryObject() {
        return new ManagedFieldsEntryObjectNestedImpl();
    }

    public WatchEventFluent.ManagedFieldsEntryObjectNested<A> withNewManagedFieldsEntryObjectLike(ManagedFieldsEntry item) {
        return new ManagedFieldsEntryObjectNestedImpl(item);
    }

    public A withSecretEnvSourceObject(SecretEnvSource secretEnvSourceObject) {
        _visitables.get("object").remove(this.object);
        if (secretEnvSourceObject!=null){ this.object= new SecretEnvSourceBuilder(secretEnvSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.SecretEnvSourceObjectNested<A> withNewSecretEnvSourceObject() {
        return new SecretEnvSourceObjectNestedImpl();
    }

    public WatchEventFluent.SecretEnvSourceObjectNested<A> withNewSecretEnvSourceObjectLike(SecretEnvSource item) {
        return new SecretEnvSourceObjectNestedImpl(item);
    }

    public A withNewSecretEnvSourceObject(String name,Boolean optional) {
        return (A)withSecretEnvSourceObject(new SecretEnvSource(name, optional));
    }

    public A withAWSElasticBlockStoreVolumeSourceObject(AWSElasticBlockStoreVolumeSource aWSElasticBlockStoreVolumeSourceObject) {
        _visitables.get("object").remove(this.object);
        if (aWSElasticBlockStoreVolumeSourceObject!=null){ this.object= new AWSElasticBlockStoreVolumeSourceBuilder(aWSElasticBlockStoreVolumeSourceObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.AWSElasticBlockStoreVolumeSourceObjectNested<A> withNewAWSElasticBlockStoreVolumeSourceObject() {
        return new AWSElasticBlockStoreVolumeSourceObjectNestedImpl();
    }

    public WatchEventFluent.AWSElasticBlockStoreVolumeSourceObjectNested<A> withNewAWSElasticBlockStoreVolumeSourceObjectLike(AWSElasticBlockStoreVolumeSource item) {
        return new AWSElasticBlockStoreVolumeSourceObjectNestedImpl(item);
    }

    public A withNewAWSElasticBlockStoreVolumeSourceObject(String fsType,Integer partition,Boolean readOnly,String volumeID) {
        return (A)withAWSElasticBlockStoreVolumeSourceObject(new AWSElasticBlockStoreVolumeSource(fsType, partition, readOnly, volumeID));
    }

    public A withServiceAccountObject(ServiceAccount serviceAccountObject) {
        _visitables.get("object").remove(this.object);
        if (serviceAccountObject!=null){ this.object= new ServiceAccountBuilder(serviceAccountObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.ServiceAccountObjectNested<A> withNewServiceAccountObject() {
        return new ServiceAccountObjectNestedImpl();
    }

    public WatchEventFluent.ServiceAccountObjectNested<A> withNewServiceAccountObjectLike(ServiceAccount item) {
        return new ServiceAccountObjectNestedImpl(item);
    }

    public A withPodIPObject(PodIP podIPObject) {
        _visitables.get("object").remove(this.object);
        if (podIPObject!=null){ this.object= new PodIPBuilder(podIPObject); _visitables.get("object").add(this.object);} return (A) this;
    }

    public WatchEventFluent.PodIPObjectNested<A> withNewPodIPObject() {
        return new PodIPObjectNestedImpl();
    }

    public WatchEventFluent.PodIPObjectNested<A> withNewPodIPObjectLike(PodIP item) {
        return new PodIPObjectNestedImpl(item);
    }

    public A withNewPodIPObject(String ip) {
        return (A)withPodIPObject(new PodIP(ip));
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type=type; return (A) this;
    }

    public Boolean hasType() {
        return this.type != null;
    }

    public A withNewType(String arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuilder arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1) {
        return (A)withType(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        WatchEventFluentImpl that = (WatchEventFluentImpl) o;
        if (object != null ? !object.equals(that.object) :that.object != null) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(object,  type,  super.hashCode());
    }

    public class PatchObjectNestedImpl<N> extends PatchFluentImpl<WatchEventFluent.PatchObjectNested<N>> implements WatchEventFluent.PatchObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PatchBuilder builder;

            PatchObjectNestedImpl(Patch item) {
                this.builder = new PatchBuilder(this, item);
                        
            }

            PatchObjectNestedImpl() {
                this.builder = new PatchBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPatchObject() {
                return and();
            }
    }


    public class LimitRangeObjectNestedImpl<N> extends LimitRangeFluentImpl<WatchEventFluent.LimitRangeObjectNested<N>> implements WatchEventFluent.LimitRangeObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LimitRangeBuilder builder;

            LimitRangeObjectNestedImpl(LimitRange item) {
                this.builder = new LimitRangeBuilder(this, item);
                        
            }

            LimitRangeObjectNestedImpl() {
                this.builder = new LimitRangeBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endLimitRangeObject() {
                return and();
            }
    }


    public class APIGroupListObjectNestedImpl<N> extends APIGroupListFluentImpl<WatchEventFluent.APIGroupListObjectNested<N>> implements WatchEventFluent.APIGroupListObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final APIGroupListBuilder builder;

            APIGroupListObjectNestedImpl(APIGroupList item) {
                this.builder = new APIGroupListBuilder(this, item);
                        
            }

            APIGroupListObjectNestedImpl() {
                this.builder = new APIGroupListBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endAPIGroupListObject() {
                return and();
            }
    }


    public class PodTemplateSpecObjectNestedImpl<N> extends PodTemplateSpecFluentImpl<WatchEventFluent.PodTemplateSpecObjectNested<N>> implements WatchEventFluent.PodTemplateSpecObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodTemplateSpecBuilder builder;

            PodTemplateSpecObjectNestedImpl(PodTemplateSpec item) {
                this.builder = new PodTemplateSpecBuilder(this, item);
                        
            }

            PodTemplateSpecObjectNestedImpl() {
                this.builder = new PodTemplateSpecBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPodTemplateSpecObject() {
                return and();
            }
    }


    public class CSIPersistentVolumeSourceObjectNestedImpl<N> extends CSIPersistentVolumeSourceFluentImpl<WatchEventFluent.CSIPersistentVolumeSourceObjectNested<N>> implements WatchEventFluent.CSIPersistentVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CSIPersistentVolumeSourceBuilder builder;

            CSIPersistentVolumeSourceObjectNestedImpl(CSIPersistentVolumeSource item) {
                this.builder = new CSIPersistentVolumeSourceBuilder(this, item);
                        
            }

            CSIPersistentVolumeSourceObjectNestedImpl() {
                this.builder = new CSIPersistentVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endCSIPersistentVolumeSourceObject() {
                return and();
            }
    }


    public class AuthInfoObjectNestedImpl<N> extends AuthInfoFluentImpl<WatchEventFluent.AuthInfoObjectNested<N>> implements WatchEventFluent.AuthInfoObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AuthInfoBuilder builder;

            AuthInfoObjectNestedImpl(AuthInfo item) {
                this.builder = new AuthInfoBuilder(this, item);
                        
            }

            AuthInfoObjectNestedImpl() {
                this.builder = new AuthInfoBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endAuthInfoObject() {
                return and();
            }
    }


    public class ResourceRequirementsObjectNestedImpl<N> extends ResourceRequirementsFluentImpl<WatchEventFluent.ResourceRequirementsObjectNested<N>> implements WatchEventFluent.ResourceRequirementsObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceRequirementsBuilder builder;

            ResourceRequirementsObjectNestedImpl(ResourceRequirements item) {
                this.builder = new ResourceRequirementsBuilder(this, item);
                        
            }

            ResourceRequirementsObjectNestedImpl() {
                this.builder = new ResourceRequirementsBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endResourceRequirementsObject() {
                return and();
            }
    }


    public class APIServiceObjectNestedImpl<N> extends APIServiceFluentImpl<WatchEventFluent.APIServiceObjectNested<N>> implements WatchEventFluent.APIServiceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final APIServiceBuilder builder;

            APIServiceObjectNestedImpl(APIService item) {
                this.builder = new APIServiceBuilder(this, item);
                        
            }

            APIServiceObjectNestedImpl() {
                this.builder = new APIServiceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endAPIServiceObject() {
                return and();
            }
    }


    public class ConfigMapKeySelectorObjectNestedImpl<N> extends ConfigMapKeySelectorFluentImpl<WatchEventFluent.ConfigMapKeySelectorObjectNested<N>> implements WatchEventFluent.ConfigMapKeySelectorObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConfigMapKeySelectorBuilder builder;

            ConfigMapKeySelectorObjectNestedImpl(ConfigMapKeySelector item) {
                this.builder = new ConfigMapKeySelectorBuilder(this, item);
                        
            }

            ConfigMapKeySelectorObjectNestedImpl() {
                this.builder = new ConfigMapKeySelectorBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endConfigMapKeySelectorObject() {
                return and();
            }
    }


    public class HostPathVolumeSourceObjectNestedImpl<N> extends HostPathVolumeSourceFluentImpl<WatchEventFluent.HostPathVolumeSourceObjectNested<N>> implements WatchEventFluent.HostPathVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final HostPathVolumeSourceBuilder builder;

            HostPathVolumeSourceObjectNestedImpl(HostPathVolumeSource item) {
                this.builder = new HostPathVolumeSourceBuilder(this, item);
                        
            }

            HostPathVolumeSourceObjectNestedImpl() {
                this.builder = new HostPathVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endHostPathVolumeSourceObject() {
                return and();
            }
    }


    public class NamedContextObjectNestedImpl<N> extends NamedContextFluentImpl<WatchEventFluent.NamedContextObjectNested<N>> implements WatchEventFluent.NamedContextObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NamedContextBuilder builder;

            NamedContextObjectNestedImpl(NamedContext item) {
                this.builder = new NamedContextBuilder(this, item);
                        
            }

            NamedContextObjectNestedImpl() {
                this.builder = new NamedContextBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endNamedContextObject() {
                return and();
            }
    }


    public class PersistentVolumeClaimListObjectNestedImpl<N> extends PersistentVolumeClaimListFluentImpl<WatchEventFluent.PersistentVolumeClaimListObjectNested<N>> implements WatchEventFluent.PersistentVolumeClaimListObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PersistentVolumeClaimListBuilder builder;

            PersistentVolumeClaimListObjectNestedImpl(PersistentVolumeClaimList item) {
                this.builder = new PersistentVolumeClaimListBuilder(this, item);
                        
            }

            PersistentVolumeClaimListObjectNestedImpl() {
                this.builder = new PersistentVolumeClaimListBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPersistentVolumeClaimListObject() {
                return and();
            }
    }


    public class ConfigObjectNestedImpl<N> extends ConfigFluentImpl<WatchEventFluent.ConfigObjectNested<N>> implements WatchEventFluent.ConfigObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConfigBuilder builder;

            ConfigObjectNestedImpl(Config item) {
                this.builder = new ConfigBuilder(this, item);
                        
            }

            ConfigObjectNestedImpl() {
                this.builder = new ConfigBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endConfigObject() {
                return and();
            }
    }


    public class AffinityObjectNestedImpl<N> extends AffinityFluentImpl<WatchEventFluent.AffinityObjectNested<N>> implements WatchEventFluent.AffinityObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AffinityBuilder builder;

            AffinityObjectNestedImpl(Affinity item) {
                this.builder = new AffinityBuilder(this, item);
                        
            }

            AffinityObjectNestedImpl() {
                this.builder = new AffinityBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endAffinityObject() {
                return and();
            }
    }


    public class ReplicationControllerStatusObjectNestedImpl<N> extends ReplicationControllerStatusFluentImpl<WatchEventFluent.ReplicationControllerStatusObjectNested<N>> implements WatchEventFluent.ReplicationControllerStatusObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ReplicationControllerStatusBuilder builder;

            ReplicationControllerStatusObjectNestedImpl(ReplicationControllerStatus item) {
                this.builder = new ReplicationControllerStatusBuilder(this, item);
                        
            }

            ReplicationControllerStatusObjectNestedImpl() {
                this.builder = new ReplicationControllerStatusBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endReplicationControllerStatusObject() {
                return and();
            }
    }


    public class MicroTimeObjectNestedImpl<N> extends MicroTimeFluentImpl<WatchEventFluent.MicroTimeObjectNested<N>> implements WatchEventFluent.MicroTimeObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final MicroTimeBuilder builder;

            MicroTimeObjectNestedImpl(MicroTime item) {
                this.builder = new MicroTimeBuilder(this, item);
                        
            }

            MicroTimeObjectNestedImpl() {
                this.builder = new MicroTimeBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endMicroTimeObject() {
                return and();
            }
    }


    public class APIServiceStatusObjectNestedImpl<N> extends APIServiceStatusFluentImpl<WatchEventFluent.APIServiceStatusObjectNested<N>> implements WatchEventFluent.APIServiceStatusObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final APIServiceStatusBuilder builder;

            APIServiceStatusObjectNestedImpl(APIServiceStatus item) {
                this.builder = new APIServiceStatusBuilder(this, item);
                        
            }

            APIServiceStatusObjectNestedImpl() {
                this.builder = new APIServiceStatusBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endAPIServiceStatusObject() {
                return and();
            }
    }


    public class LifecycleObjectNestedImpl<N> extends LifecycleFluentImpl<WatchEventFluent.LifecycleObjectNested<N>> implements WatchEventFluent.LifecycleObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LifecycleBuilder builder;

            LifecycleObjectNestedImpl(Lifecycle item) {
                this.builder = new LifecycleBuilder(this, item);
                        
            }

            LifecycleObjectNestedImpl() {
                this.builder = new LifecycleBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endLifecycleObject() {
                return and();
            }
    }


    public class PortworxVolumeSourceObjectNestedImpl<N> extends PortworxVolumeSourceFluentImpl<WatchEventFluent.PortworxVolumeSourceObjectNested<N>> implements WatchEventFluent.PortworxVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PortworxVolumeSourceBuilder builder;

            PortworxVolumeSourceObjectNestedImpl(PortworxVolumeSource item) {
                this.builder = new PortworxVolumeSourceBuilder(this, item);
                        
            }

            PortworxVolumeSourceObjectNestedImpl() {
                this.builder = new PortworxVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPortworxVolumeSourceObject() {
                return and();
            }
    }


    public class EventSourceObjectNestedImpl<N> extends EventSourceFluentImpl<WatchEventFluent.EventSourceObjectNested<N>> implements WatchEventFluent.EventSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EventSourceBuilder builder;

            EventSourceObjectNestedImpl(EventSource item) {
                this.builder = new EventSourceBuilder(this, item);
                        
            }

            EventSourceObjectNestedImpl() {
                this.builder = new EventSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endEventSourceObject() {
                return and();
            }
    }


    public class AzureFileVolumeSourceObjectNestedImpl<N> extends AzureFileVolumeSourceFluentImpl<WatchEventFluent.AzureFileVolumeSourceObjectNested<N>> implements WatchEventFluent.AzureFileVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AzureFileVolumeSourceBuilder builder;

            AzureFileVolumeSourceObjectNestedImpl(AzureFileVolumeSource item) {
                this.builder = new AzureFileVolumeSourceBuilder(this, item);
                        
            }

            AzureFileVolumeSourceObjectNestedImpl() {
                this.builder = new AzureFileVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endAzureFileVolumeSourceObject() {
                return and();
            }
    }


    public class ComponentConditionObjectNestedImpl<N> extends ComponentConditionFluentImpl<WatchEventFluent.ComponentConditionObjectNested<N>> implements WatchEventFluent.ComponentConditionObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ComponentConditionBuilder builder;

            ComponentConditionObjectNestedImpl(ComponentCondition item) {
                this.builder = new ComponentConditionBuilder(this, item);
                        
            }

            ComponentConditionObjectNestedImpl() {
                this.builder = new ComponentConditionBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endComponentConditionObject() {
                return and();
            }
    }


    public class EnvVarObjectNestedImpl<N> extends EnvVarFluentImpl<WatchEventFluent.EnvVarObjectNested<N>> implements WatchEventFluent.EnvVarObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EnvVarBuilder builder;

            EnvVarObjectNestedImpl(EnvVar item) {
                this.builder = new EnvVarBuilder(this, item);
                        
            }

            EnvVarObjectNestedImpl() {
                this.builder = new EnvVarBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endEnvVarObject() {
                return and();
            }
    }


    public class ReplicationControllerSpecObjectNestedImpl<N> extends ReplicationControllerSpecFluentImpl<WatchEventFluent.ReplicationControllerSpecObjectNested<N>> implements WatchEventFluent.ReplicationControllerSpecObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ReplicationControllerSpecBuilder builder;

            ReplicationControllerSpecObjectNestedImpl(ReplicationControllerSpec item) {
                this.builder = new ReplicationControllerSpecBuilder(this, item);
                        
            }

            ReplicationControllerSpecObjectNestedImpl() {
                this.builder = new ReplicationControllerSpecBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endReplicationControllerSpecObject() {
                return and();
            }
    }


    public class LoadBalancerIngressObjectNestedImpl<N> extends LoadBalancerIngressFluentImpl<WatchEventFluent.LoadBalancerIngressObjectNested<N>> implements WatchEventFluent.LoadBalancerIngressObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LoadBalancerIngressBuilder builder;

            LoadBalancerIngressObjectNestedImpl(LoadBalancerIngress item) {
                this.builder = new LoadBalancerIngressBuilder(this, item);
                        
            }

            LoadBalancerIngressObjectNestedImpl() {
                this.builder = new LoadBalancerIngressBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endLoadBalancerIngressObject() {
                return and();
            }
    }


    public class AttachedVolumeObjectNestedImpl<N> extends AttachedVolumeFluentImpl<WatchEventFluent.AttachedVolumeObjectNested<N>> implements WatchEventFluent.AttachedVolumeObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AttachedVolumeBuilder builder;

            AttachedVolumeObjectNestedImpl(AttachedVolume item) {
                this.builder = new AttachedVolumeBuilder(this, item);
                        
            }

            AttachedVolumeObjectNestedImpl() {
                this.builder = new AttachedVolumeBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endAttachedVolumeObject() {
                return and();
            }
    }


    public class LocalObjectReferenceNestedImpl<N> extends LocalObjectReferenceFluentImpl<WatchEventFluent.LocalObjectReferenceNested<N>> implements WatchEventFluent.LocalObjectReferenceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LocalObjectReferenceBuilder builder;

            LocalObjectReferenceNestedImpl(LocalObjectReference item) {
                this.builder = new LocalObjectReferenceBuilder(this, item);
                        
            }

            LocalObjectReferenceNestedImpl() {
                this.builder = new LocalObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endLocalObjectReference() {
                return and();
            }
    }


    public class NamedAuthInfoObjectNestedImpl<N> extends NamedAuthInfoFluentImpl<WatchEventFluent.NamedAuthInfoObjectNested<N>> implements WatchEventFluent.NamedAuthInfoObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NamedAuthInfoBuilder builder;

            NamedAuthInfoObjectNestedImpl(NamedAuthInfo item) {
                this.builder = new NamedAuthInfoBuilder(this, item);
                        
            }

            NamedAuthInfoObjectNestedImpl() {
                this.builder = new NamedAuthInfoBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endNamedAuthInfoObject() {
                return and();
            }
    }


    public class EmptyDirVolumeSourceObjectNestedImpl<N> extends EmptyDirVolumeSourceFluentImpl<WatchEventFluent.EmptyDirVolumeSourceObjectNested<N>> implements WatchEventFluent.EmptyDirVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EmptyDirVolumeSourceBuilder builder;

            EmptyDirVolumeSourceObjectNestedImpl(EmptyDirVolumeSource item) {
                this.builder = new EmptyDirVolumeSourceBuilder(this, item);
                        
            }

            EmptyDirVolumeSourceObjectNestedImpl() {
                this.builder = new EmptyDirVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endEmptyDirVolumeSourceObject() {
                return and();
            }
    }


    public class PodSpecObjectNestedImpl<N> extends PodSpecFluentImpl<WatchEventFluent.PodSpecObjectNested<N>> implements WatchEventFluent.PodSpecObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodSpecBuilder builder;

            PodSpecObjectNestedImpl(PodSpec item) {
                this.builder = new PodSpecBuilder(this, item);
                        
            }

            PodSpecObjectNestedImpl() {
                this.builder = new PodSpecBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPodSpecObject() {
                return and();
            }
    }


    public class AzureDiskVolumeSourceObjectNestedImpl<N> extends AzureDiskVolumeSourceFluentImpl<WatchEventFluent.AzureDiskVolumeSourceObjectNested<N>> implements WatchEventFluent.AzureDiskVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AzureDiskVolumeSourceBuilder builder;

            AzureDiskVolumeSourceObjectNestedImpl(AzureDiskVolumeSource item) {
                this.builder = new AzureDiskVolumeSourceBuilder(this, item);
                        
            }

            AzureDiskVolumeSourceObjectNestedImpl() {
                this.builder = new AzureDiskVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endAzureDiskVolumeSourceObject() {
                return and();
            }
    }


    public class ServerAddressByClientCIDRObjectNestedImpl<N> extends ServerAddressByClientCIDRFluentImpl<WatchEventFluent.ServerAddressByClientCIDRObjectNested<N>> implements WatchEventFluent.ServerAddressByClientCIDRObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ServerAddressByClientCIDRBuilder builder;

            ServerAddressByClientCIDRObjectNestedImpl(ServerAddressByClientCIDR item) {
                this.builder = new ServerAddressByClientCIDRBuilder(this, item);
                        
            }

            ServerAddressByClientCIDRObjectNestedImpl() {
                this.builder = new ServerAddressByClientCIDRBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endServerAddressByClientCIDRObject() {
                return and();
            }
    }


    public class PreconditionsObjectNestedImpl<N> extends PreconditionsFluentImpl<WatchEventFluent.PreconditionsObjectNested<N>> implements WatchEventFluent.PreconditionsObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PreconditionsBuilder builder;

            PreconditionsObjectNestedImpl(Preconditions item) {
                this.builder = new PreconditionsBuilder(this, item);
                        
            }

            PreconditionsObjectNestedImpl() {
                this.builder = new PreconditionsBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPreconditionsObject() {
                return and();
            }
    }


    public class InfoObjectNestedImpl<N> extends InfoFluentImpl<WatchEventFluent.InfoObjectNested<N>> implements WatchEventFluent.InfoObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final InfoBuilder builder;

            InfoObjectNestedImpl(Info item) {
                this.builder = new InfoBuilder(this, item);
                        
            }

            InfoObjectNestedImpl() {
                this.builder = new InfoBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endInfoObject() {
                return and();
            }
    }


    public class CephFSVolumeSourceObjectNestedImpl<N> extends CephFSVolumeSourceFluentImpl<WatchEventFluent.CephFSVolumeSourceObjectNested<N>> implements WatchEventFluent.CephFSVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CephFSVolumeSourceBuilder builder;

            CephFSVolumeSourceObjectNestedImpl(CephFSVolumeSource item) {
                this.builder = new CephFSVolumeSourceBuilder(this, item);
                        
            }

            CephFSVolumeSourceObjectNestedImpl() {
                this.builder = new CephFSVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endCephFSVolumeSourceObject() {
                return and();
            }
    }


    public class EphemeralContainerObjectNestedImpl<N> extends EphemeralContainerFluentImpl<WatchEventFluent.EphemeralContainerObjectNested<N>> implements WatchEventFluent.EphemeralContainerObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EphemeralContainerBuilder builder;

            EphemeralContainerObjectNestedImpl(EphemeralContainer item) {
                this.builder = new EphemeralContainerBuilder(this, item);
                        
            }

            EphemeralContainerObjectNestedImpl() {
                this.builder = new EphemeralContainerBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endEphemeralContainerObject() {
                return and();
            }
    }


    public class NodeConditionObjectNestedImpl<N> extends NodeConditionFluentImpl<WatchEventFluent.NodeConditionObjectNested<N>> implements WatchEventFluent.NodeConditionObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NodeConditionBuilder builder;

            NodeConditionObjectNestedImpl(NodeCondition item) {
                this.builder = new NodeConditionBuilder(this, item);
                        
            }

            NodeConditionObjectNestedImpl() {
                this.builder = new NodeConditionBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endNodeConditionObject() {
                return and();
            }
    }


    public class EndpointSubsetObjectNestedImpl<N> extends EndpointSubsetFluentImpl<WatchEventFluent.EndpointSubsetObjectNested<N>> implements WatchEventFluent.EndpointSubsetObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EndpointSubsetBuilder builder;

            EndpointSubsetObjectNestedImpl(EndpointSubset item) {
                this.builder = new EndpointSubsetBuilder(this, item);
                        
            }

            EndpointSubsetObjectNestedImpl() {
                this.builder = new EndpointSubsetBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endEndpointSubsetObject() {
                return and();
            }
    }


    public class LocalVolumeSourceObjectNestedImpl<N> extends LocalVolumeSourceFluentImpl<WatchEventFluent.LocalVolumeSourceObjectNested<N>> implements WatchEventFluent.LocalVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LocalVolumeSourceBuilder builder;

            LocalVolumeSourceObjectNestedImpl(LocalVolumeSource item) {
                this.builder = new LocalVolumeSourceBuilder(this, item);
                        
            }

            LocalVolumeSourceObjectNestedImpl() {
                this.builder = new LocalVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endLocalVolumeSourceObject() {
                return and();
            }
    }


    public class ServiceStatusObjectNestedImpl<N> extends ServiceStatusFluentImpl<WatchEventFluent.ServiceStatusObjectNested<N>> implements WatchEventFluent.ServiceStatusObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ServiceStatusBuilder builder;

            ServiceStatusObjectNestedImpl(ServiceStatus item) {
                this.builder = new ServiceStatusBuilder(this, item);
                        
            }

            ServiceStatusObjectNestedImpl() {
                this.builder = new ServiceStatusBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endServiceStatusObject() {
                return and();
            }
    }


    public class ServiceReferenceObjectNestedImpl<N> extends ServiceReferenceFluentImpl<WatchEventFluent.ServiceReferenceObjectNested<N>> implements WatchEventFluent.ServiceReferenceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ServiceReferenceBuilder builder;

            ServiceReferenceObjectNestedImpl(ServiceReference item) {
                this.builder = new ServiceReferenceBuilder(this, item);
                        
            }

            ServiceReferenceObjectNestedImpl() {
                this.builder = new ServiceReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endServiceReferenceObject() {
                return and();
            }
    }


    public class TaintObjectNestedImpl<N> extends TaintFluentImpl<WatchEventFluent.TaintObjectNested<N>> implements WatchEventFluent.TaintObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TaintBuilder builder;

            TaintObjectNestedImpl(Taint item) {
                this.builder = new TaintBuilder(this, item);
                        
            }

            TaintObjectNestedImpl() {
                this.builder = new TaintBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endTaintObject() {
                return and();
            }
    }


    public class PatchOptionsObjectNestedImpl<N> extends PatchOptionsFluentImpl<WatchEventFluent.PatchOptionsObjectNested<N>> implements WatchEventFluent.PatchOptionsObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PatchOptionsBuilder builder;

            PatchOptionsObjectNestedImpl(PatchOptions item) {
                this.builder = new PatchOptionsBuilder(this, item);
                        
            }

            PatchOptionsObjectNestedImpl() {
                this.builder = new PatchOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPatchOptionsObject() {
                return and();
            }
    }


    public class ConfigMapNodeConfigSourceObjectNestedImpl<N> extends ConfigMapNodeConfigSourceFluentImpl<WatchEventFluent.ConfigMapNodeConfigSourceObjectNested<N>> implements WatchEventFluent.ConfigMapNodeConfigSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConfigMapNodeConfigSourceBuilder builder;

            ConfigMapNodeConfigSourceObjectNestedImpl(ConfigMapNodeConfigSource item) {
                this.builder = new ConfigMapNodeConfigSourceBuilder(this, item);
                        
            }

            ConfigMapNodeConfigSourceObjectNestedImpl() {
                this.builder = new ConfigMapNodeConfigSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endConfigMapNodeConfigSourceObject() {
                return and();
            }
    }


    public class HTTPGetActionObjectNestedImpl<N> extends HTTPGetActionFluentImpl<WatchEventFluent.HTTPGetActionObjectNested<N>> implements WatchEventFluent.HTTPGetActionObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final HTTPGetActionBuilder builder;

            HTTPGetActionObjectNestedImpl(HTTPGetAction item) {
                this.builder = new HTTPGetActionBuilder(this, item);
                        
            }

            HTTPGetActionObjectNestedImpl() {
                this.builder = new HTTPGetActionBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endHTTPGetActionObject() {
                return and();
            }
    }


    public class GlusterfsPersistentVolumeSourceObjectNestedImpl<N> extends GlusterfsPersistentVolumeSourceFluentImpl<WatchEventFluent.GlusterfsPersistentVolumeSourceObjectNested<N>> implements WatchEventFluent.GlusterfsPersistentVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GlusterfsPersistentVolumeSourceBuilder builder;

            GlusterfsPersistentVolumeSourceObjectNestedImpl(GlusterfsPersistentVolumeSource item) {
                this.builder = new GlusterfsPersistentVolumeSourceBuilder(this, item);
                        
            }

            GlusterfsPersistentVolumeSourceObjectNestedImpl() {
                this.builder = new GlusterfsPersistentVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endGlusterfsPersistentVolumeSourceObject() {
                return and();
            }
    }


    public class WindowsSecurityContextOptionsObjectNestedImpl<N> extends WindowsSecurityContextOptionsFluentImpl<WatchEventFluent.WindowsSecurityContextOptionsObjectNested<N>> implements WatchEventFluent.WindowsSecurityContextOptionsObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final WindowsSecurityContextOptionsBuilder builder;

            WindowsSecurityContextOptionsObjectNestedImpl(WindowsSecurityContextOptions item) {
                this.builder = new WindowsSecurityContextOptionsBuilder(this, item);
                        
            }

            WindowsSecurityContextOptionsObjectNestedImpl() {
                this.builder = new WindowsSecurityContextOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endWindowsSecurityContextOptionsObject() {
                return and();
            }
    }


    public class ISCSIPersistentVolumeSourceObjectNestedImpl<N> extends ISCSIPersistentVolumeSourceFluentImpl<WatchEventFluent.ISCSIPersistentVolumeSourceObjectNested<N>> implements WatchEventFluent.ISCSIPersistentVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ISCSIPersistentVolumeSourceBuilder builder;

            ISCSIPersistentVolumeSourceObjectNestedImpl(ISCSIPersistentVolumeSource item) {
                this.builder = new ISCSIPersistentVolumeSourceBuilder(this, item);
                        
            }

            ISCSIPersistentVolumeSourceObjectNestedImpl() {
                this.builder = new ISCSIPersistentVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endISCSIPersistentVolumeSourceObject() {
                return and();
            }
    }


    public class DownwardAPIVolumeSourceObjectNestedImpl<N> extends DownwardAPIVolumeSourceFluentImpl<WatchEventFluent.DownwardAPIVolumeSourceObjectNested<N>> implements WatchEventFluent.DownwardAPIVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DownwardAPIVolumeSourceBuilder builder;

            DownwardAPIVolumeSourceObjectNestedImpl(DownwardAPIVolumeSource item) {
                this.builder = new DownwardAPIVolumeSourceBuilder(this, item);
                        
            }

            DownwardAPIVolumeSourceObjectNestedImpl() {
                this.builder = new DownwardAPIVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endDownwardAPIVolumeSourceObject() {
                return and();
            }
    }


    public class EnvFromSourceObjectNestedImpl<N> extends EnvFromSourceFluentImpl<WatchEventFluent.EnvFromSourceObjectNested<N>> implements WatchEventFluent.EnvFromSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EnvFromSourceBuilder builder;

            EnvFromSourceObjectNestedImpl(EnvFromSource item) {
                this.builder = new EnvFromSourceBuilder(this, item);
                        
            }

            EnvFromSourceObjectNestedImpl() {
                this.builder = new EnvFromSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endEnvFromSourceObject() {
                return and();
            }
    }


    public class CreateOptionsObjectNestedImpl<N> extends CreateOptionsFluentImpl<WatchEventFluent.CreateOptionsObjectNested<N>> implements WatchEventFluent.CreateOptionsObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CreateOptionsBuilder builder;

            CreateOptionsObjectNestedImpl(CreateOptions item) {
                this.builder = new CreateOptionsBuilder(this, item);
                        
            }

            CreateOptionsObjectNestedImpl() {
                this.builder = new CreateOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endCreateOptionsObject() {
                return and();
            }
    }


    public class NamespaceSpecObjectNestedImpl<N> extends NamespaceSpecFluentImpl<WatchEventFluent.NamespaceSpecObjectNested<N>> implements WatchEventFluent.NamespaceSpecObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NamespaceSpecBuilder builder;

            NamespaceSpecObjectNestedImpl(NamespaceSpec item) {
                this.builder = new NamespaceSpecBuilder(this, item);
                        
            }

            NamespaceSpecObjectNestedImpl() {
                this.builder = new NamespaceSpecBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endNamespaceSpecObject() {
                return and();
            }
    }


    public class ListMetaObjectNestedImpl<N> extends ListMetaFluentImpl<WatchEventFluent.ListMetaObjectNested<N>> implements WatchEventFluent.ListMetaObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ListMetaBuilder builder;

            ListMetaObjectNestedImpl(ListMeta item) {
                this.builder = new ListMetaBuilder(this, item);
                        
            }

            ListMetaObjectNestedImpl() {
                this.builder = new ListMetaBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endListMetaObject() {
                return and();
            }
    }


    public class TypeMetaObjectNestedImpl<N> extends TypeMetaFluentImpl<WatchEventFluent.TypeMetaObjectNested<N>> implements WatchEventFluent.TypeMetaObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TypeMetaBuilder builder;

            TypeMetaObjectNestedImpl(TypeMeta item) {
                this.builder = new TypeMetaBuilder(this, item);
                        
            }

            TypeMetaObjectNestedImpl() {
                this.builder = new TypeMetaBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endTypeMetaObject() {
                return and();
            }
    }


    public class RootPathsObjectNestedImpl<N> extends RootPathsFluentImpl<WatchEventFluent.RootPathsObjectNested<N>> implements WatchEventFluent.RootPathsObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RootPathsBuilder builder;

            RootPathsObjectNestedImpl(RootPaths item) {
                this.builder = new RootPathsBuilder(this, item);
                        
            }

            RootPathsObjectNestedImpl() {
                this.builder = new RootPathsBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endRootPathsObject() {
                return and();
            }
    }


    public class SecretReferenceObjectNestedImpl<N> extends SecretReferenceFluentImpl<WatchEventFluent.SecretReferenceObjectNested<N>> implements WatchEventFluent.SecretReferenceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SecretReferenceBuilder builder;

            SecretReferenceObjectNestedImpl(SecretReference item) {
                this.builder = new SecretReferenceBuilder(this, item);
                        
            }

            SecretReferenceObjectNestedImpl() {
                this.builder = new SecretReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endSecretReferenceObject() {
                return and();
            }
    }


    public class APIGroupObjectNestedImpl<N> extends APIGroupFluentImpl<WatchEventFluent.APIGroupObjectNested<N>> implements WatchEventFluent.APIGroupObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final APIGroupBuilder builder;

            APIGroupObjectNestedImpl(APIGroup item) {
                this.builder = new APIGroupBuilder(this, item);
                        
            }

            APIGroupObjectNestedImpl() {
                this.builder = new APIGroupBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endAPIGroupObject() {
                return and();
            }
    }


    public class FlexVolumeSourceObjectNestedImpl<N> extends FlexVolumeSourceFluentImpl<WatchEventFluent.FlexVolumeSourceObjectNested<N>> implements WatchEventFluent.FlexVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final FlexVolumeSourceBuilder builder;

            FlexVolumeSourceObjectNestedImpl(FlexVolumeSource item) {
                this.builder = new FlexVolumeSourceBuilder(this, item);
                        
            }

            FlexVolumeSourceObjectNestedImpl() {
                this.builder = new FlexVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endFlexVolumeSourceObject() {
                return and();
            }
    }


    public class PersistentVolumeClaimTemplateObjectNestedImpl<N> extends PersistentVolumeClaimTemplateFluentImpl<WatchEventFluent.PersistentVolumeClaimTemplateObjectNested<N>> implements WatchEventFluent.PersistentVolumeClaimTemplateObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PersistentVolumeClaimTemplateBuilder builder;

            PersistentVolumeClaimTemplateObjectNestedImpl(PersistentVolumeClaimTemplate item) {
                this.builder = new PersistentVolumeClaimTemplateBuilder(this, item);
                        
            }

            PersistentVolumeClaimTemplateObjectNestedImpl() {
                this.builder = new PersistentVolumeClaimTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPersistentVolumeClaimTemplateObject() {
                return and();
            }
    }


    public class ISCSIVolumeSourceObjectNestedImpl<N> extends ISCSIVolumeSourceFluentImpl<WatchEventFluent.ISCSIVolumeSourceObjectNested<N>> implements WatchEventFluent.ISCSIVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ISCSIVolumeSourceBuilder builder;

            ISCSIVolumeSourceObjectNestedImpl(ISCSIVolumeSource item) {
                this.builder = new ISCSIVolumeSourceBuilder(this, item);
                        
            }

            ISCSIVolumeSourceObjectNestedImpl() {
                this.builder = new ISCSIVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endISCSIVolumeSourceObject() {
                return and();
            }
    }


    public class SecretKeySelectorObjectNestedImpl<N> extends SecretKeySelectorFluentImpl<WatchEventFluent.SecretKeySelectorObjectNested<N>> implements WatchEventFluent.SecretKeySelectorObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SecretKeySelectorBuilder builder;

            SecretKeySelectorObjectNestedImpl(SecretKeySelector item) {
                this.builder = new SecretKeySelectorBuilder(this, item);
                        
            }

            SecretKeySelectorObjectNestedImpl() {
                this.builder = new SecretKeySelectorBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endSecretKeySelectorObject() {
                return and();
            }
    }


    public class RBDVolumeSourceObjectNestedImpl<N> extends RBDVolumeSourceFluentImpl<WatchEventFluent.RBDVolumeSourceObjectNested<N>> implements WatchEventFluent.RBDVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RBDVolumeSourceBuilder builder;

            RBDVolumeSourceObjectNestedImpl(RBDVolumeSource item) {
                this.builder = new RBDVolumeSourceBuilder(this, item);
                        
            }

            RBDVolumeSourceObjectNestedImpl() {
                this.builder = new RBDVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endRBDVolumeSourceObject() {
                return and();
            }
    }


    public class ResourceQuotaListObjectNestedImpl<N> extends ResourceQuotaListFluentImpl<WatchEventFluent.ResourceQuotaListObjectNested<N>> implements WatchEventFluent.ResourceQuotaListObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceQuotaListBuilder builder;

            ResourceQuotaListObjectNestedImpl(ResourceQuotaList item) {
                this.builder = new ResourceQuotaListBuilder(this, item);
                        
            }

            ResourceQuotaListObjectNestedImpl() {
                this.builder = new ResourceQuotaListBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endResourceQuotaListObject() {
                return and();
            }
    }


    public class NodeConfigStatusObjectNestedImpl<N> extends NodeConfigStatusFluentImpl<WatchEventFluent.NodeConfigStatusObjectNested<N>> implements WatchEventFluent.NodeConfigStatusObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NodeConfigStatusBuilder builder;

            NodeConfigStatusObjectNestedImpl(NodeConfigStatus item) {
                this.builder = new NodeConfigStatusBuilder(this, item);
                        
            }

            NodeConfigStatusObjectNestedImpl() {
                this.builder = new NodeConfigStatusBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endNodeConfigStatusObject() {
                return and();
            }
    }


    public class QuobyteVolumeSourceObjectNestedImpl<N> extends QuobyteVolumeSourceFluentImpl<WatchEventFluent.QuobyteVolumeSourceObjectNested<N>> implements WatchEventFluent.QuobyteVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final QuobyteVolumeSourceBuilder builder;

            QuobyteVolumeSourceObjectNestedImpl(QuobyteVolumeSource item) {
                this.builder = new QuobyteVolumeSourceBuilder(this, item);
                        
            }

            QuobyteVolumeSourceObjectNestedImpl() {
                this.builder = new QuobyteVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endQuobyteVolumeSourceObject() {
                return and();
            }
    }


    public class ResourceQuotaStatusObjectNestedImpl<N> extends ResourceQuotaStatusFluentImpl<WatchEventFluent.ResourceQuotaStatusObjectNested<N>> implements WatchEventFluent.ResourceQuotaStatusObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceQuotaStatusBuilder builder;

            ResourceQuotaStatusObjectNestedImpl(ResourceQuotaStatus item) {
                this.builder = new ResourceQuotaStatusBuilder(this, item);
                        
            }

            ResourceQuotaStatusObjectNestedImpl() {
                this.builder = new ResourceQuotaStatusBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endResourceQuotaStatusObject() {
                return and();
            }
    }


    public class ConfigMapProjectionObjectNestedImpl<N> extends ConfigMapProjectionFluentImpl<WatchEventFluent.ConfigMapProjectionObjectNested<N>> implements WatchEventFluent.ConfigMapProjectionObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConfigMapProjectionBuilder builder;

            ConfigMapProjectionObjectNestedImpl(ConfigMapProjection item) {
                this.builder = new ConfigMapProjectionBuilder(this, item);
                        
            }

            ConfigMapProjectionObjectNestedImpl() {
                this.builder = new ConfigMapProjectionBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endConfigMapProjectionObject() {
                return and();
            }
    }


    public class ScopedResourceSelectorRequirementObjectNestedImpl<N> extends ScopedResourceSelectorRequirementFluentImpl<WatchEventFluent.ScopedResourceSelectorRequirementObjectNested<N>> implements WatchEventFluent.ScopedResourceSelectorRequirementObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ScopedResourceSelectorRequirementBuilder builder;

            ScopedResourceSelectorRequirementObjectNestedImpl(ScopedResourceSelectorRequirement item) {
                this.builder = new ScopedResourceSelectorRequirementBuilder(this, item);
                        
            }

            ScopedResourceSelectorRequirementObjectNestedImpl() {
                this.builder = new ScopedResourceSelectorRequirementBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endScopedResourceSelectorRequirementObject() {
                return and();
            }
    }


    public class NamespaceObjectNestedImpl<N> extends NamespaceFluentImpl<WatchEventFluent.NamespaceObjectNested<N>> implements WatchEventFluent.NamespaceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NamespaceBuilder builder;

            NamespaceObjectNestedImpl(Namespace item) {
                this.builder = new NamespaceBuilder(this, item);
                        
            }

            NamespaceObjectNestedImpl() {
                this.builder = new NamespaceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endNamespaceObject() {
                return and();
            }
    }


    public class ContainerStateTerminatedObjectNestedImpl<N> extends ContainerStateTerminatedFluentImpl<WatchEventFluent.ContainerStateTerminatedObjectNested<N>> implements WatchEventFluent.ContainerStateTerminatedObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ContainerStateTerminatedBuilder builder;

            ContainerStateTerminatedObjectNestedImpl(ContainerStateTerminated item) {
                this.builder = new ContainerStateTerminatedBuilder(this, item);
                        
            }

            ContainerStateTerminatedObjectNestedImpl() {
                this.builder = new ContainerStateTerminatedBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endContainerStateTerminatedObject() {
                return and();
            }
    }


    public class GroupVersionKindObjectNestedImpl<N> extends GroupVersionKindFluentImpl<WatchEventFluent.GroupVersionKindObjectNested<N>> implements WatchEventFluent.GroupVersionKindObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GroupVersionKindBuilder builder;

            GroupVersionKindObjectNestedImpl(GroupVersionKind item) {
                this.builder = new GroupVersionKindBuilder(this, item);
                        
            }

            GroupVersionKindObjectNestedImpl() {
                this.builder = new GroupVersionKindBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endGroupVersionKindObject() {
                return and();
            }
    }


    public class LimitRangeSpecObjectNestedImpl<N> extends LimitRangeSpecFluentImpl<WatchEventFluent.LimitRangeSpecObjectNested<N>> implements WatchEventFluent.LimitRangeSpecObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LimitRangeSpecBuilder builder;

            LimitRangeSpecObjectNestedImpl(LimitRangeSpec item) {
                this.builder = new LimitRangeSpecBuilder(this, item);
                        
            }

            LimitRangeSpecObjectNestedImpl() {
                this.builder = new LimitRangeSpecBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endLimitRangeSpecObject() {
                return and();
            }
    }


    public class ProjectedVolumeSourceObjectNestedImpl<N> extends ProjectedVolumeSourceFluentImpl<WatchEventFluent.ProjectedVolumeSourceObjectNested<N>> implements WatchEventFluent.ProjectedVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ProjectedVolumeSourceBuilder builder;

            ProjectedVolumeSourceObjectNestedImpl(ProjectedVolumeSource item) {
                this.builder = new ProjectedVolumeSourceBuilder(this, item);
                        
            }

            ProjectedVolumeSourceObjectNestedImpl() {
                this.builder = new ProjectedVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endProjectedVolumeSourceObject() {
                return and();
            }
    }


    public class HandlerObjectNestedImpl<N> extends HandlerFluentImpl<WatchEventFluent.HandlerObjectNested<N>> implements WatchEventFluent.HandlerObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final HandlerBuilder builder;

            HandlerObjectNestedImpl(Handler item) {
                this.builder = new HandlerBuilder(this, item);
                        
            }

            HandlerObjectNestedImpl() {
                this.builder = new HandlerBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endHandlerObject() {
                return and();
            }
    }


    public class PersistentVolumeClaimStatusObjectNestedImpl<N> extends PersistentVolumeClaimStatusFluentImpl<WatchEventFluent.PersistentVolumeClaimStatusObjectNested<N>> implements WatchEventFluent.PersistentVolumeClaimStatusObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PersistentVolumeClaimStatusBuilder builder;

            PersistentVolumeClaimStatusObjectNestedImpl(PersistentVolumeClaimStatus item) {
                this.builder = new PersistentVolumeClaimStatusBuilder(this, item);
                        
            }

            PersistentVolumeClaimStatusObjectNestedImpl() {
                this.builder = new PersistentVolumeClaimStatusBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPersistentVolumeClaimStatusObject() {
                return and();
            }
    }


    public class ContainerStateObjectNestedImpl<N> extends ContainerStateFluentImpl<WatchEventFluent.ContainerStateObjectNested<N>> implements WatchEventFluent.ContainerStateObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ContainerStateBuilder builder;

            ContainerStateObjectNestedImpl(ContainerState item) {
                this.builder = new ContainerStateBuilder(this, item);
                        
            }

            ContainerStateObjectNestedImpl() {
                this.builder = new ContainerStateBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endContainerStateObject() {
                return and();
            }
    }


    public class ServiceSpecObjectNestedImpl<N> extends ServiceSpecFluentImpl<WatchEventFluent.ServiceSpecObjectNested<N>> implements WatchEventFluent.ServiceSpecObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ServiceSpecBuilder builder;

            ServiceSpecObjectNestedImpl(ServiceSpec item) {
                this.builder = new ServiceSpecBuilder(this, item);
                        
            }

            ServiceSpecObjectNestedImpl() {
                this.builder = new ServiceSpecBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endServiceSpecObject() {
                return and();
            }
    }


    public class PhotonPersistentDiskVolumeSourceObjectNestedImpl<N> extends PhotonPersistentDiskVolumeSourceFluentImpl<WatchEventFluent.PhotonPersistentDiskVolumeSourceObjectNested<N>> implements WatchEventFluent.PhotonPersistentDiskVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PhotonPersistentDiskVolumeSourceBuilder builder;

            PhotonPersistentDiskVolumeSourceObjectNestedImpl(PhotonPersistentDiskVolumeSource item) {
                this.builder = new PhotonPersistentDiskVolumeSourceBuilder(this, item);
                        
            }

            PhotonPersistentDiskVolumeSourceObjectNestedImpl() {
                this.builder = new PhotonPersistentDiskVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPhotonPersistentDiskVolumeSourceObject() {
                return and();
            }
    }


    public class ServiceAccountTokenProjectionObjectNestedImpl<N> extends ServiceAccountTokenProjectionFluentImpl<WatchEventFluent.ServiceAccountTokenProjectionObjectNested<N>> implements WatchEventFluent.ServiceAccountTokenProjectionObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ServiceAccountTokenProjectionBuilder builder;

            ServiceAccountTokenProjectionObjectNestedImpl(ServiceAccountTokenProjection item) {
                this.builder = new ServiceAccountTokenProjectionBuilder(this, item);
                        
            }

            ServiceAccountTokenProjectionObjectNestedImpl() {
                this.builder = new ServiceAccountTokenProjectionBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endServiceAccountTokenProjectionObject() {
                return and();
            }
    }


    public class ContainerObjectNestedImpl<N> extends ContainerFluentImpl<WatchEventFluent.ContainerObjectNested<N>> implements WatchEventFluent.ContainerObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ContainerBuilder builder;

            ContainerObjectNestedImpl(Container item) {
                this.builder = new ContainerBuilder(this, item);
                        
            }

            ContainerObjectNestedImpl() {
                this.builder = new ContainerBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endContainerObject() {
                return and();
            }
    }


    public class NodeSpecObjectNestedImpl<N> extends NodeSpecFluentImpl<WatchEventFluent.NodeSpecObjectNested<N>> implements WatchEventFluent.NodeSpecObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NodeSpecBuilder builder;

            NodeSpecObjectNestedImpl(NodeSpec item) {
                this.builder = new NodeSpecBuilder(this, item);
                        
            }

            NodeSpecObjectNestedImpl() {
                this.builder = new NodeSpecBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endNodeSpecObject() {
                return and();
            }
    }


    public class TypedLocalObjectReferenceNestedImpl<N> extends TypedLocalObjectReferenceFluentImpl<WatchEventFluent.TypedLocalObjectReferenceNested<N>> implements WatchEventFluent.TypedLocalObjectReferenceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TypedLocalObjectReferenceBuilder builder;

            TypedLocalObjectReferenceNestedImpl(TypedLocalObjectReference item) {
                this.builder = new TypedLocalObjectReferenceBuilder(this, item);
                        
            }

            TypedLocalObjectReferenceNestedImpl() {
                this.builder = new TypedLocalObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endTypedLocalObjectReference() {
                return and();
            }
    }


    public class FieldsV1ObjectNestedImpl<N> extends FieldsV1FluentImpl<WatchEventFluent.FieldsV1ObjectNested<N>> implements WatchEventFluent.FieldsV1ObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final FieldsV1Builder builder;

            FieldsV1ObjectNestedImpl(FieldsV1 item) {
                this.builder = new FieldsV1Builder(this, item);
                        
            }

            FieldsV1ObjectNestedImpl() {
                this.builder = new FieldsV1Builder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endFieldsV1Object() {
                return and();
            }
    }


    public class SecretListObjectNestedImpl<N> extends SecretListFluentImpl<WatchEventFluent.SecretListObjectNested<N>> implements WatchEventFluent.SecretListObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SecretListBuilder builder;

            SecretListObjectNestedImpl(SecretList item) {
                this.builder = new SecretListBuilder(this, item);
                        
            }

            SecretListObjectNestedImpl() {
                this.builder = new SecretListBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endSecretListObject() {
                return and();
            }
    }


    public class NodeAddressObjectNestedImpl<N> extends NodeAddressFluentImpl<WatchEventFluent.NodeAddressObjectNested<N>> implements WatchEventFluent.NodeAddressObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NodeAddressBuilder builder;

            NodeAddressObjectNestedImpl(NodeAddress item) {
                this.builder = new NodeAddressBuilder(this, item);
                        
            }

            NodeAddressObjectNestedImpl() {
                this.builder = new NodeAddressBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endNodeAddressObject() {
                return and();
            }
    }


    public class PodAffinityObjectNestedImpl<N> extends PodAffinityFluentImpl<WatchEventFluent.PodAffinityObjectNested<N>> implements WatchEventFluent.PodAffinityObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodAffinityBuilder builder;

            PodAffinityObjectNestedImpl(PodAffinity item) {
                this.builder = new PodAffinityBuilder(this, item);
                        
            }

            PodAffinityObjectNestedImpl() {
                this.builder = new PodAffinityBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPodAffinityObject() {
                return and();
            }
    }


    public class ServiceObjectNestedImpl<N> extends ServiceFluentImpl<WatchEventFluent.ServiceObjectNested<N>> implements WatchEventFluent.ServiceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ServiceBuilder builder;

            ServiceObjectNestedImpl(Service item) {
                this.builder = new ServiceBuilder(this, item);
                        
            }

            ServiceObjectNestedImpl() {
                this.builder = new ServiceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endServiceObject() {
                return and();
            }
    }


    public class ExecEnvVarObjectNestedImpl<N> extends ExecEnvVarFluentImpl<WatchEventFluent.ExecEnvVarObjectNested<N>> implements WatchEventFluent.ExecEnvVarObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ExecEnvVarBuilder builder;

            ExecEnvVarObjectNestedImpl(ExecEnvVar item) {
                this.builder = new ExecEnvVarBuilder(this, item);
                        
            }

            ExecEnvVarObjectNestedImpl() {
                this.builder = new ExecEnvVarBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endExecEnvVarObject() {
                return and();
            }
    }


    public class PodConditionObjectNestedImpl<N> extends PodConditionFluentImpl<WatchEventFluent.PodConditionObjectNested<N>> implements WatchEventFluent.PodConditionObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodConditionBuilder builder;

            PodConditionObjectNestedImpl(PodCondition item) {
                this.builder = new PodConditionBuilder(this, item);
                        
            }

            PodConditionObjectNestedImpl() {
                this.builder = new PodConditionBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPodConditionObject() {
                return and();
            }
    }


    public class EventSeriesObjectNestedImpl<N> extends EventSeriesFluentImpl<WatchEventFluent.EventSeriesObjectNested<N>> implements WatchEventFluent.EventSeriesObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EventSeriesBuilder builder;

            EventSeriesObjectNestedImpl(EventSeries item) {
                this.builder = new EventSeriesBuilder(this, item);
                        
            }

            EventSeriesObjectNestedImpl() {
                this.builder = new EventSeriesBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endEventSeriesObject() {
                return and();
            }
    }


    public class TopologySpreadConstraintObjectNestedImpl<N> extends TopologySpreadConstraintFluentImpl<WatchEventFluent.TopologySpreadConstraintObjectNested<N>> implements WatchEventFluent.TopologySpreadConstraintObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TopologySpreadConstraintBuilder builder;

            TopologySpreadConstraintObjectNestedImpl(TopologySpreadConstraint item) {
                this.builder = new TopologySpreadConstraintBuilder(this, item);
                        
            }

            TopologySpreadConstraintObjectNestedImpl() {
                this.builder = new TopologySpreadConstraintBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endTopologySpreadConstraintObject() {
                return and();
            }
    }


    public class ContainerImageObjectNestedImpl<N> extends ContainerImageFluentImpl<WatchEventFluent.ContainerImageObjectNested<N>> implements WatchEventFluent.ContainerImageObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ContainerImageBuilder builder;

            ContainerImageObjectNestedImpl(ContainerImage item) {
                this.builder = new ContainerImageBuilder(this, item);
                        
            }

            ContainerImageObjectNestedImpl() {
                this.builder = new ContainerImageBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endContainerImageObject() {
                return and();
            }
    }


    public class ExecActionObjectNestedImpl<N> extends ExecActionFluentImpl<WatchEventFluent.ExecActionObjectNested<N>> implements WatchEventFluent.ExecActionObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ExecActionBuilder builder;

            ExecActionObjectNestedImpl(ExecAction item) {
                this.builder = new ExecActionBuilder(this, item);
                        
            }

            ExecActionObjectNestedImpl() {
                this.builder = new ExecActionBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endExecActionObject() {
                return and();
            }
    }


    public class ReplicationControllerObjectNestedImpl<N> extends ReplicationControllerFluentImpl<WatchEventFluent.ReplicationControllerObjectNested<N>> implements WatchEventFluent.ReplicationControllerObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ReplicationControllerBuilder builder;

            ReplicationControllerObjectNestedImpl(ReplicationController item) {
                this.builder = new ReplicationControllerBuilder(this, item);
                        
            }

            ReplicationControllerObjectNestedImpl() {
                this.builder = new ReplicationControllerBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endReplicationControllerObject() {
                return and();
            }
    }


    public class NodeStatusObjectNestedImpl<N> extends NodeStatusFluentImpl<WatchEventFluent.NodeStatusObjectNested<N>> implements WatchEventFluent.NodeStatusObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NodeStatusBuilder builder;

            NodeStatusObjectNestedImpl(NodeStatus item) {
                this.builder = new NodeStatusBuilder(this, item);
                        
            }

            NodeStatusObjectNestedImpl() {
                this.builder = new NodeStatusBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endNodeStatusObject() {
                return and();
            }
    }


    public class ConfigMapListObjectNestedImpl<N> extends ConfigMapListFluentImpl<WatchEventFluent.ConfigMapListObjectNested<N>> implements WatchEventFluent.ConfigMapListObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConfigMapListBuilder builder;

            ConfigMapListObjectNestedImpl(ConfigMapList item) {
                this.builder = new ConfigMapListBuilder(this, item);
                        
            }

            ConfigMapListObjectNestedImpl() {
                this.builder = new ConfigMapListBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endConfigMapListObject() {
                return and();
            }
    }


    public class NodeSelectorObjectNestedImpl<N> extends NodeSelectorFluentImpl<WatchEventFluent.NodeSelectorObjectNested<N>> implements WatchEventFluent.NodeSelectorObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NodeSelectorBuilder builder;

            NodeSelectorObjectNestedImpl(NodeSelector item) {
                this.builder = new NodeSelectorBuilder(this, item);
                        
            }

            NodeSelectorObjectNestedImpl() {
                this.builder = new NodeSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endNodeSelectorObject() {
                return and();
            }
    }


    public class TolerationObjectNestedImpl<N> extends TolerationFluentImpl<WatchEventFluent.TolerationObjectNested<N>> implements WatchEventFluent.TolerationObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TolerationBuilder builder;

            TolerationObjectNestedImpl(Toleration item) {
                this.builder = new TolerationBuilder(this, item);
                        
            }

            TolerationObjectNestedImpl() {
                this.builder = new TolerationBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endTolerationObject() {
                return and();
            }
    }


    public class CephFSPersistentVolumeSourceObjectNestedImpl<N> extends CephFSPersistentVolumeSourceFluentImpl<WatchEventFluent.CephFSPersistentVolumeSourceObjectNested<N>> implements WatchEventFluent.CephFSPersistentVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CephFSPersistentVolumeSourceBuilder builder;

            CephFSPersistentVolumeSourceObjectNestedImpl(CephFSPersistentVolumeSource item) {
                this.builder = new CephFSPersistentVolumeSourceBuilder(this, item);
                        
            }

            CephFSPersistentVolumeSourceObjectNestedImpl() {
                this.builder = new CephFSPersistentVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endCephFSPersistentVolumeSourceObject() {
                return and();
            }
    }


    public class PersistentVolumeClaimConditionObjectNestedImpl<N> extends PersistentVolumeClaimConditionFluentImpl<WatchEventFluent.PersistentVolumeClaimConditionObjectNested<N>> implements WatchEventFluent.PersistentVolumeClaimConditionObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PersistentVolumeClaimConditionBuilder builder;

            PersistentVolumeClaimConditionObjectNestedImpl(PersistentVolumeClaimCondition item) {
                this.builder = new PersistentVolumeClaimConditionBuilder(this, item);
                        
            }

            PersistentVolumeClaimConditionObjectNestedImpl() {
                this.builder = new PersistentVolumeClaimConditionBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPersistentVolumeClaimConditionObject() {
                return and();
            }
    }


    public class PreferredSchedulingTermObjectNestedImpl<N> extends PreferredSchedulingTermFluentImpl<WatchEventFluent.PreferredSchedulingTermObjectNested<N>> implements WatchEventFluent.PreferredSchedulingTermObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PreferredSchedulingTermBuilder builder;

            PreferredSchedulingTermObjectNestedImpl(PreferredSchedulingTerm item) {
                this.builder = new PreferredSchedulingTermBuilder(this, item);
                        
            }

            PreferredSchedulingTermObjectNestedImpl() {
                this.builder = new PreferredSchedulingTermBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPreferredSchedulingTermObject() {
                return and();
            }
    }


    public class PersistentVolumeListObjectNestedImpl<N> extends PersistentVolumeListFluentImpl<WatchEventFluent.PersistentVolumeListObjectNested<N>> implements WatchEventFluent.PersistentVolumeListObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PersistentVolumeListBuilder builder;

            PersistentVolumeListObjectNestedImpl(PersistentVolumeList item) {
                this.builder = new PersistentVolumeListBuilder(this, item);
                        
            }

            PersistentVolumeListObjectNestedImpl() {
                this.builder = new PersistentVolumeListBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPersistentVolumeListObject() {
                return and();
            }
    }


    public class GCEPersistentDiskVolumeSourceObjectNestedImpl<N> extends GCEPersistentDiskVolumeSourceFluentImpl<WatchEventFluent.GCEPersistentDiskVolumeSourceObjectNested<N>> implements WatchEventFluent.GCEPersistentDiskVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GCEPersistentDiskVolumeSourceBuilder builder;

            GCEPersistentDiskVolumeSourceObjectNestedImpl(GCEPersistentDiskVolumeSource item) {
                this.builder = new GCEPersistentDiskVolumeSourceBuilder(this, item);
                        
            }

            GCEPersistentDiskVolumeSourceObjectNestedImpl() {
                this.builder = new GCEPersistentDiskVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endGCEPersistentDiskVolumeSourceObject() {
                return and();
            }
    }


    public class PodDNSConfigOptionObjectNestedImpl<N> extends PodDNSConfigOptionFluentImpl<WatchEventFluent.PodDNSConfigOptionObjectNested<N>> implements WatchEventFluent.PodDNSConfigOptionObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodDNSConfigOptionBuilder builder;

            PodDNSConfigOptionObjectNestedImpl(PodDNSConfigOption item) {
                this.builder = new PodDNSConfigOptionBuilder(this, item);
                        
            }

            PodDNSConfigOptionObjectNestedImpl() {
                this.builder = new PodDNSConfigOptionBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPodDNSConfigOptionObject() {
                return and();
            }
    }


    public class APIServiceConditionObjectNestedImpl<N> extends APIServiceConditionFluentImpl<WatchEventFluent.APIServiceConditionObjectNested<N>> implements WatchEventFluent.APIServiceConditionObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final APIServiceConditionBuilder builder;

            APIServiceConditionObjectNestedImpl(APIServiceCondition item) {
                this.builder = new APIServiceConditionBuilder(this, item);
                        
            }

            APIServiceConditionObjectNestedImpl() {
                this.builder = new APIServiceConditionBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endAPIServiceConditionObject() {
                return and();
            }
    }


    public class EventListObjectNestedImpl<N> extends EventListFluentImpl<WatchEventFluent.EventListObjectNested<N>> implements WatchEventFluent.EventListObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EventListBuilder builder;

            EventListObjectNestedImpl(EventList item) {
                this.builder = new EventListBuilder(this, item);
                        
            }

            EventListObjectNestedImpl() {
                this.builder = new EventListBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endEventListObject() {
                return and();
            }
    }


    public class PodReadinessGateObjectNestedImpl<N> extends PodReadinessGateFluentImpl<WatchEventFluent.PodReadinessGateObjectNested<N>> implements WatchEventFluent.PodReadinessGateObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodReadinessGateBuilder builder;

            PodReadinessGateObjectNestedImpl(PodReadinessGate item) {
                this.builder = new PodReadinessGateBuilder(this, item);
                        
            }

            PodReadinessGateObjectNestedImpl() {
                this.builder = new PodReadinessGateBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPodReadinessGateObject() {
                return and();
            }
    }


    public class ContainerStateWaitingObjectNestedImpl<N> extends ContainerStateWaitingFluentImpl<WatchEventFluent.ContainerStateWaitingObjectNested<N>> implements WatchEventFluent.ContainerStateWaitingObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ContainerStateWaitingBuilder builder;

            ContainerStateWaitingObjectNestedImpl(ContainerStateWaiting item) {
                this.builder = new ContainerStateWaitingBuilder(this, item);
                        
            }

            ContainerStateWaitingObjectNestedImpl() {
                this.builder = new ContainerStateWaitingBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endContainerStateWaitingObject() {
                return and();
            }
    }


    public class VolumeMountObjectNestedImpl<N> extends VolumeMountFluentImpl<WatchEventFluent.VolumeMountObjectNested<N>> implements WatchEventFluent.VolumeMountObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final VolumeMountBuilder builder;

            VolumeMountObjectNestedImpl(VolumeMount item) {
                this.builder = new VolumeMountBuilder(this, item);
                        
            }

            VolumeMountObjectNestedImpl() {
                this.builder = new VolumeMountBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endVolumeMountObject() {
                return and();
            }
    }


    public class NamespaceConditionObjectNestedImpl<N> extends NamespaceConditionFluentImpl<WatchEventFluent.NamespaceConditionObjectNested<N>> implements WatchEventFluent.NamespaceConditionObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NamespaceConditionBuilder builder;

            NamespaceConditionObjectNestedImpl(NamespaceCondition item) {
                this.builder = new NamespaceConditionBuilder(this, item);
                        
            }

            NamespaceConditionObjectNestedImpl() {
                this.builder = new NamespaceConditionBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endNamespaceConditionObject() {
                return and();
            }
    }


    public class LabelSelectorObjectNestedImpl<N> extends LabelSelectorFluentImpl<WatchEventFluent.LabelSelectorObjectNested<N>> implements WatchEventFluent.LabelSelectorObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LabelSelectorBuilder builder;

            LabelSelectorObjectNestedImpl(LabelSelector item) {
                this.builder = new LabelSelectorBuilder(this, item);
                        
            }

            LabelSelectorObjectNestedImpl() {
                this.builder = new LabelSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endLabelSelectorObject() {
                return and();
            }
    }


    public class StatusCauseObjectNestedImpl<N> extends StatusCauseFluentImpl<WatchEventFluent.StatusCauseObjectNested<N>> implements WatchEventFluent.StatusCauseObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final StatusCauseBuilder builder;

            StatusCauseObjectNestedImpl(StatusCause item) {
                this.builder = new StatusCauseBuilder(this, item);
                        
            }

            StatusCauseObjectNestedImpl() {
                this.builder = new StatusCauseBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endStatusCauseObject() {
                return and();
            }
    }


    public class NamedClusterObjectNestedImpl<N> extends NamedClusterFluentImpl<WatchEventFluent.NamedClusterObjectNested<N>> implements WatchEventFluent.NamedClusterObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NamedClusterBuilder builder;

            NamedClusterObjectNestedImpl(NamedCluster item) {
                this.builder = new NamedClusterBuilder(this, item);
                        
            }

            NamedClusterObjectNestedImpl() {
                this.builder = new NamedClusterBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endNamedClusterObject() {
                return and();
            }
    }


    public class StatusDetailsObjectNestedImpl<N> extends StatusDetailsFluentImpl<WatchEventFluent.StatusDetailsObjectNested<N>> implements WatchEventFluent.StatusDetailsObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final StatusDetailsBuilder builder;

            StatusDetailsObjectNestedImpl(StatusDetails item) {
                this.builder = new StatusDetailsBuilder(this, item);
                        
            }

            StatusDetailsObjectNestedImpl() {
                this.builder = new StatusDetailsBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endStatusDetailsObject() {
                return and();
            }
    }


    public class DownwardAPIVolumeFileObjectNestedImpl<N> extends DownwardAPIVolumeFileFluentImpl<WatchEventFluent.DownwardAPIVolumeFileObjectNested<N>> implements WatchEventFluent.DownwardAPIVolumeFileObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DownwardAPIVolumeFileBuilder builder;

            DownwardAPIVolumeFileObjectNestedImpl(DownwardAPIVolumeFile item) {
                this.builder = new DownwardAPIVolumeFileBuilder(this, item);
                        
            }

            DownwardAPIVolumeFileObjectNestedImpl() {
                this.builder = new DownwardAPIVolumeFileBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endDownwardAPIVolumeFileObject() {
                return and();
            }
    }


    public class SeccompProfileObjectNestedImpl<N> extends SeccompProfileFluentImpl<WatchEventFluent.SeccompProfileObjectNested<N>> implements WatchEventFluent.SeccompProfileObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SeccompProfileBuilder builder;

            SeccompProfileObjectNestedImpl(SeccompProfile item) {
                this.builder = new SeccompProfileBuilder(this, item);
                        
            }

            SeccompProfileObjectNestedImpl() {
                this.builder = new SeccompProfileBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endSeccompProfileObject() {
                return and();
            }
    }


    public class SysctlObjectNestedImpl<N> extends SysctlFluentImpl<WatchEventFluent.SysctlObjectNested<N>> implements WatchEventFluent.SysctlObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SysctlBuilder builder;

            SysctlObjectNestedImpl(Sysctl item) {
                this.builder = new SysctlBuilder(this, item);
                        
            }

            SysctlObjectNestedImpl() {
                this.builder = new SysctlBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endSysctlObject() {
                return and();
            }
    }


    public class StatusObjectNestedImpl<N> extends StatusFluentImpl<WatchEventFluent.StatusObjectNested<N>> implements WatchEventFluent.StatusObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final StatusBuilder builder;

            StatusObjectNestedImpl(Status item) {
                this.builder = new StatusBuilder(this, item);
                        
            }

            StatusObjectNestedImpl() {
                this.builder = new StatusBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endStatusObject() {
                return and();
            }
    }


    public class DeleteOptionsObjectNestedImpl<N> extends DeleteOptionsFluentImpl<WatchEventFluent.DeleteOptionsObjectNested<N>> implements WatchEventFluent.DeleteOptionsObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DeleteOptionsBuilder builder;

            DeleteOptionsObjectNestedImpl(DeleteOptions item) {
                this.builder = new DeleteOptionsBuilder(this, item);
                        
            }

            DeleteOptionsObjectNestedImpl() {
                this.builder = new DeleteOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endDeleteOptionsObject() {
                return and();
            }
    }


    public class ContainerStatusObjectNestedImpl<N> extends ContainerStatusFluentImpl<WatchEventFluent.ContainerStatusObjectNested<N>> implements WatchEventFluent.ContainerStatusObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ContainerStatusBuilder builder;

            ContainerStatusObjectNestedImpl(ContainerStatus item) {
                this.builder = new ContainerStatusBuilder(this, item);
                        
            }

            ContainerStatusObjectNestedImpl() {
                this.builder = new ContainerStatusBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endContainerStatusObject() {
                return and();
            }
    }


    public class PodTemplateObjectNestedImpl<N> extends PodTemplateFluentImpl<WatchEventFluent.PodTemplateObjectNested<N>> implements WatchEventFluent.PodTemplateObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodTemplateBuilder builder;

            PodTemplateObjectNestedImpl(PodTemplate item) {
                this.builder = new PodTemplateBuilder(this, item);
                        
            }

            PodTemplateObjectNestedImpl() {
                this.builder = new PodTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPodTemplateObject() {
                return and();
            }
    }


    public class ConfigMapEnvSourceObjectNestedImpl<N> extends ConfigMapEnvSourceFluentImpl<WatchEventFluent.ConfigMapEnvSourceObjectNested<N>> implements WatchEventFluent.ConfigMapEnvSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConfigMapEnvSourceBuilder builder;

            ConfigMapEnvSourceObjectNestedImpl(ConfigMapEnvSource item) {
                this.builder = new ConfigMapEnvSourceBuilder(this, item);
                        
            }

            ConfigMapEnvSourceObjectNestedImpl() {
                this.builder = new ConfigMapEnvSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endConfigMapEnvSourceObject() {
                return and();
            }
    }


    public class NodeSelectorRequirementObjectNestedImpl<N> extends NodeSelectorRequirementFluentImpl<WatchEventFluent.NodeSelectorRequirementObjectNested<N>> implements WatchEventFluent.NodeSelectorRequirementObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NodeSelectorRequirementBuilder builder;

            NodeSelectorRequirementObjectNestedImpl(NodeSelectorRequirement item) {
                this.builder = new NodeSelectorRequirementBuilder(this, item);
                        
            }

            NodeSelectorRequirementObjectNestedImpl() {
                this.builder = new NodeSelectorRequirementBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endNodeSelectorRequirementObject() {
                return and();
            }
    }


    public class TCPSocketActionObjectNestedImpl<N> extends TCPSocketActionFluentImpl<WatchEventFluent.TCPSocketActionObjectNested<N>> implements WatchEventFluent.TCPSocketActionObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TCPSocketActionBuilder builder;

            TCPSocketActionObjectNestedImpl(TCPSocketAction item) {
                this.builder = new TCPSocketActionBuilder(this, item);
                        
            }

            TCPSocketActionObjectNestedImpl() {
                this.builder = new TCPSocketActionBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endTCPSocketActionObject() {
                return and();
            }
    }


    public class EventObjectNestedImpl<N> extends EventFluentImpl<WatchEventFluent.EventObjectNested<N>> implements WatchEventFluent.EventObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EventBuilder builder;

            EventObjectNestedImpl(Event item) {
                this.builder = new EventBuilder(this, item);
                        
            }

            EventObjectNestedImpl() {
                this.builder = new EventBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endEventObject() {
                return and();
            }
    }


    public class PreferencesObjectNestedImpl<N> extends PreferencesFluentImpl<WatchEventFluent.PreferencesObjectNested<N>> implements WatchEventFluent.PreferencesObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PreferencesBuilder builder;

            PreferencesObjectNestedImpl(Preferences item) {
                this.builder = new PreferencesBuilder(this, item);
                        
            }

            PreferencesObjectNestedImpl() {
                this.builder = new PreferencesBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPreferencesObject() {
                return and();
            }
    }


    public class ObjectFieldSelectorObjectNestedImpl<N> extends ObjectFieldSelectorFluentImpl<WatchEventFluent.ObjectFieldSelectorObjectNested<N>> implements WatchEventFluent.ObjectFieldSelectorObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectFieldSelectorBuilder builder;

            ObjectFieldSelectorObjectNestedImpl(ObjectFieldSelector item) {
                this.builder = new ObjectFieldSelectorBuilder(this, item);
                        
            }

            ObjectFieldSelectorObjectNestedImpl() {
                this.builder = new ObjectFieldSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endObjectFieldSelectorObject() {
                return and();
            }
    }


    public class PodTemplateListObjectNestedImpl<N> extends PodTemplateListFluentImpl<WatchEventFluent.PodTemplateListObjectNested<N>> implements WatchEventFluent.PodTemplateListObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodTemplateListBuilder builder;

            PodTemplateListObjectNestedImpl(PodTemplateList item) {
                this.builder = new PodTemplateListBuilder(this, item);
                        
            }

            PodTemplateListObjectNestedImpl() {
                this.builder = new PodTemplateListBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPodTemplateListObject() {
                return and();
            }
    }


    public class PersistentVolumeObjectNestedImpl<N> extends PersistentVolumeFluentImpl<WatchEventFluent.PersistentVolumeObjectNested<N>> implements WatchEventFluent.PersistentVolumeObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PersistentVolumeBuilder builder;

            PersistentVolumeObjectNestedImpl(PersistentVolume item) {
                this.builder = new PersistentVolumeBuilder(this, item);
                        
            }

            PersistentVolumeObjectNestedImpl() {
                this.builder = new PersistentVolumeBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPersistentVolumeObject() {
                return and();
            }
    }


    public class CinderVolumeSourceObjectNestedImpl<N> extends CinderVolumeSourceFluentImpl<WatchEventFluent.CinderVolumeSourceObjectNested<N>> implements WatchEventFluent.CinderVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CinderVolumeSourceBuilder builder;

            CinderVolumeSourceObjectNestedImpl(CinderVolumeSource item) {
                this.builder = new CinderVolumeSourceBuilder(this, item);
                        
            }

            CinderVolumeSourceObjectNestedImpl() {
                this.builder = new CinderVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endCinderVolumeSourceObject() {
                return and();
            }
    }


    public class EndpointAddressObjectNestedImpl<N> extends EndpointAddressFluentImpl<WatchEventFluent.EndpointAddressObjectNested<N>> implements WatchEventFluent.EndpointAddressObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EndpointAddressBuilder builder;

            EndpointAddressObjectNestedImpl(EndpointAddress item) {
                this.builder = new EndpointAddressBuilder(this, item);
                        
            }

            EndpointAddressObjectNestedImpl() {
                this.builder = new EndpointAddressBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endEndpointAddressObject() {
                return and();
            }
    }


    public class NodeConfigSourceObjectNestedImpl<N> extends NodeConfigSourceFluentImpl<WatchEventFluent.NodeConfigSourceObjectNested<N>> implements WatchEventFluent.NodeConfigSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NodeConfigSourceBuilder builder;

            NodeConfigSourceObjectNestedImpl(NodeConfigSource item) {
                this.builder = new NodeConfigSourceBuilder(this, item);
                        
            }

            NodeConfigSourceObjectNestedImpl() {
                this.builder = new NodeConfigSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endNodeConfigSourceObject() {
                return and();
            }
    }


    public class VsphereVirtualDiskVolumeSourceObjectNestedImpl<N> extends VsphereVirtualDiskVolumeSourceFluentImpl<WatchEventFluent.VsphereVirtualDiskVolumeSourceObjectNested<N>> implements WatchEventFluent.VsphereVirtualDiskVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final VsphereVirtualDiskVolumeSourceBuilder builder;

            VsphereVirtualDiskVolumeSourceObjectNestedImpl(VsphereVirtualDiskVolumeSource item) {
                this.builder = new VsphereVirtualDiskVolumeSourceBuilder(this, item);
                        
            }

            VsphereVirtualDiskVolumeSourceObjectNestedImpl() {
                this.builder = new VsphereVirtualDiskVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endVsphereVirtualDiskVolumeSourceObject() {
                return and();
            }
    }


    public class ObjectMetaObjectNestedImpl<N> extends ObjectMetaFluentImpl<WatchEventFluent.ObjectMetaObjectNested<N>> implements WatchEventFluent.ObjectMetaObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectMetaBuilder builder;

            ObjectMetaObjectNestedImpl(ObjectMeta item) {
                this.builder = new ObjectMetaBuilder(this, item);
                        
            }

            ObjectMetaObjectNestedImpl() {
                this.builder = new ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endObjectMetaObject() {
                return and();
            }
    }


    public class PersistentVolumeClaimObjectNestedImpl<N> extends PersistentVolumeClaimFluentImpl<WatchEventFluent.PersistentVolumeClaimObjectNested<N>> implements WatchEventFluent.PersistentVolumeClaimObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PersistentVolumeClaimBuilder builder;

            PersistentVolumeClaimObjectNestedImpl(PersistentVolumeClaim item) {
                this.builder = new PersistentVolumeClaimBuilder(this, item);
                        
            }

            PersistentVolumeClaimObjectNestedImpl() {
                this.builder = new PersistentVolumeClaimBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPersistentVolumeClaimObject() {
                return and();
            }
    }


    public class LabelSelectorRequirementObjectNestedImpl<N> extends LabelSelectorRequirementFluentImpl<WatchEventFluent.LabelSelectorRequirementObjectNested<N>> implements WatchEventFluent.LabelSelectorRequirementObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LabelSelectorRequirementBuilder builder;

            LabelSelectorRequirementObjectNestedImpl(LabelSelectorRequirement item) {
                this.builder = new LabelSelectorRequirementBuilder(this, item);
                        
            }

            LabelSelectorRequirementObjectNestedImpl() {
                this.builder = new LabelSelectorRequirementBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endLabelSelectorRequirementObject() {
                return and();
            }
    }


    public class GitRepoVolumeSourceObjectNestedImpl<N> extends GitRepoVolumeSourceFluentImpl<WatchEventFluent.GitRepoVolumeSourceObjectNested<N>> implements WatchEventFluent.GitRepoVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GitRepoVolumeSourceBuilder builder;

            GitRepoVolumeSourceObjectNestedImpl(GitRepoVolumeSource item) {
                this.builder = new GitRepoVolumeSourceBuilder(this, item);
                        
            }

            GitRepoVolumeSourceObjectNestedImpl() {
                this.builder = new GitRepoVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endGitRepoVolumeSourceObject() {
                return and();
            }
    }


    public class EndpointsListObjectNestedImpl<N> extends EndpointsListFluentImpl<WatchEventFluent.EndpointsListObjectNested<N>> implements WatchEventFluent.EndpointsListObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EndpointsListBuilder builder;

            EndpointsListObjectNestedImpl(EndpointsList item) {
                this.builder = new EndpointsListBuilder(this, item);
                        
            }

            EndpointsListObjectNestedImpl() {
                this.builder = new EndpointsListBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endEndpointsListObject() {
                return and();
            }
    }


    public class GroupVersionResourceObjectNestedImpl<N> extends GroupVersionResourceFluentImpl<WatchEventFluent.GroupVersionResourceObjectNested<N>> implements WatchEventFluent.GroupVersionResourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GroupVersionResourceBuilder builder;

            GroupVersionResourceObjectNestedImpl(GroupVersionResource item) {
                this.builder = new GroupVersionResourceBuilder(this, item);
                        
            }

            GroupVersionResourceObjectNestedImpl() {
                this.builder = new GroupVersionResourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endGroupVersionResourceObject() {
                return and();
            }
    }


    public class CinderPersistentVolumeSourceObjectNestedImpl<N> extends CinderPersistentVolumeSourceFluentImpl<WatchEventFluent.CinderPersistentVolumeSourceObjectNested<N>> implements WatchEventFluent.CinderPersistentVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CinderPersistentVolumeSourceBuilder builder;

            CinderPersistentVolumeSourceObjectNestedImpl(CinderPersistentVolumeSource item) {
                this.builder = new CinderPersistentVolumeSourceBuilder(this, item);
                        
            }

            CinderPersistentVolumeSourceObjectNestedImpl() {
                this.builder = new CinderPersistentVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endCinderPersistentVolumeSourceObject() {
                return and();
            }
    }


    public class TopologySelectorTermObjectNestedImpl<N> extends TopologySelectorTermFluentImpl<WatchEventFluent.TopologySelectorTermObjectNested<N>> implements WatchEventFluent.TopologySelectorTermObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TopologySelectorTermBuilder builder;

            TopologySelectorTermObjectNestedImpl(TopologySelectorTerm item) {
                this.builder = new TopologySelectorTermBuilder(this, item);
                        
            }

            TopologySelectorTermObjectNestedImpl() {
                this.builder = new TopologySelectorTermBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endTopologySelectorTermObject() {
                return and();
            }
    }


    public class OwnerReferenceObjectNestedImpl<N> extends OwnerReferenceFluentImpl<WatchEventFluent.OwnerReferenceObjectNested<N>> implements WatchEventFluent.OwnerReferenceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final OwnerReferenceBuilder builder;

            OwnerReferenceObjectNestedImpl(OwnerReference item) {
                this.builder = new OwnerReferenceBuilder(this, item);
                        
            }

            OwnerReferenceObjectNestedImpl() {
                this.builder = new OwnerReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endOwnerReferenceObject() {
                return and();
            }
    }


    public class StorageOSPersistentVolumeSourceObjectNestedImpl<N> extends StorageOSPersistentVolumeSourceFluentImpl<WatchEventFluent.StorageOSPersistentVolumeSourceObjectNested<N>> implements WatchEventFluent.StorageOSPersistentVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final StorageOSPersistentVolumeSourceBuilder builder;

            StorageOSPersistentVolumeSourceObjectNestedImpl(StorageOSPersistentVolumeSource item) {
                this.builder = new StorageOSPersistentVolumeSourceBuilder(this, item);
                        
            }

            StorageOSPersistentVolumeSourceObjectNestedImpl() {
                this.builder = new StorageOSPersistentVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endStorageOSPersistentVolumeSourceObject() {
                return and();
            }
    }


    public class EphemeralVolumeSourceObjectNestedImpl<N> extends EphemeralVolumeSourceFluentImpl<WatchEventFluent.EphemeralVolumeSourceObjectNested<N>> implements WatchEventFluent.EphemeralVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EphemeralVolumeSourceBuilder builder;

            EphemeralVolumeSourceObjectNestedImpl(EphemeralVolumeSource item) {
                this.builder = new EphemeralVolumeSourceBuilder(this, item);
                        
            }

            EphemeralVolumeSourceObjectNestedImpl() {
                this.builder = new EphemeralVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endEphemeralVolumeSourceObject() {
                return and();
            }
    }


    public class ReplicationControllerConditionObjectNestedImpl<N> extends ReplicationControllerConditionFluentImpl<WatchEventFluent.ReplicationControllerConditionObjectNested<N>> implements WatchEventFluent.ReplicationControllerConditionObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ReplicationControllerConditionBuilder builder;

            ReplicationControllerConditionObjectNestedImpl(ReplicationControllerCondition item) {
                this.builder = new ReplicationControllerConditionBuilder(this, item);
                        
            }

            ReplicationControllerConditionObjectNestedImpl() {
                this.builder = new ReplicationControllerConditionBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endReplicationControllerConditionObject() {
                return and();
            }
    }


    public class PodAntiAffinityObjectNestedImpl<N> extends PodAntiAffinityFluentImpl<WatchEventFluent.PodAntiAffinityObjectNested<N>> implements WatchEventFluent.PodAntiAffinityObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodAntiAffinityBuilder builder;

            PodAntiAffinityObjectNestedImpl(PodAntiAffinity item) {
                this.builder = new PodAntiAffinityBuilder(this, item);
                        
            }

            PodAntiAffinityObjectNestedImpl() {
                this.builder = new PodAntiAffinityBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPodAntiAffinityObject() {
                return and();
            }
    }


    public class SecurityContextObjectNestedImpl<N> extends SecurityContextFluentImpl<WatchEventFluent.SecurityContextObjectNested<N>> implements WatchEventFluent.SecurityContextObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SecurityContextBuilder builder;

            SecurityContextObjectNestedImpl(SecurityContext item) {
                this.builder = new SecurityContextBuilder(this, item);
                        
            }

            SecurityContextObjectNestedImpl() {
                this.builder = new SecurityContextBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endSecurityContextObject() {
                return and();
            }
    }


    public class ReplicationControllerListObjectNestedImpl<N> extends ReplicationControllerListFluentImpl<WatchEventFluent.ReplicationControllerListObjectNested<N>> implements WatchEventFluent.ReplicationControllerListObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ReplicationControllerListBuilder builder;

            ReplicationControllerListObjectNestedImpl(ReplicationControllerList item) {
                this.builder = new ReplicationControllerListBuilder(this, item);
                        
            }

            ReplicationControllerListObjectNestedImpl() {
                this.builder = new ReplicationControllerListBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endReplicationControllerListObject() {
                return and();
            }
    }


    public class ConfigMapVolumeSourceObjectNestedImpl<N> extends ConfigMapVolumeSourceFluentImpl<WatchEventFluent.ConfigMapVolumeSourceObjectNested<N>> implements WatchEventFluent.ConfigMapVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConfigMapVolumeSourceBuilder builder;

            ConfigMapVolumeSourceObjectNestedImpl(ConfigMapVolumeSource item) {
                this.builder = new ConfigMapVolumeSourceBuilder(this, item);
                        
            }

            ConfigMapVolumeSourceObjectNestedImpl() {
                this.builder = new ConfigMapVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endConfigMapVolumeSourceObject() {
                return and();
            }
    }


    public class ContainerStateRunningObjectNestedImpl<N> extends ContainerStateRunningFluentImpl<WatchEventFluent.ContainerStateRunningObjectNested<N>> implements WatchEventFluent.ContainerStateRunningObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ContainerStateRunningBuilder builder;

            ContainerStateRunningObjectNestedImpl(ContainerStateRunning item) {
                this.builder = new ContainerStateRunningBuilder(this, item);
                        
            }

            ContainerStateRunningObjectNestedImpl() {
                this.builder = new ContainerStateRunningBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endContainerStateRunningObject() {
                return and();
            }
    }


    public class FlockerVolumeSourceObjectNestedImpl<N> extends FlockerVolumeSourceFluentImpl<WatchEventFluent.FlockerVolumeSourceObjectNested<N>> implements WatchEventFluent.FlockerVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final FlockerVolumeSourceBuilder builder;

            FlockerVolumeSourceObjectNestedImpl(FlockerVolumeSource item) {
                this.builder = new FlockerVolumeSourceBuilder(this, item);
                        
            }

            FlockerVolumeSourceObjectNestedImpl() {
                this.builder = new FlockerVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endFlockerVolumeSourceObject() {
                return and();
            }
    }


    public class ComponentStatusListObjectNestedImpl<N> extends ComponentStatusListFluentImpl<WatchEventFluent.ComponentStatusListObjectNested<N>> implements WatchEventFluent.ComponentStatusListObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ComponentStatusListBuilder builder;

            ComponentStatusListObjectNestedImpl(ComponentStatusList item) {
                this.builder = new ComponentStatusListBuilder(this, item);
                        
            }

            ComponentStatusListObjectNestedImpl() {
                this.builder = new ComponentStatusListBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endComponentStatusListObject() {
                return and();
            }
    }


    public class ScaleIOVolumeSourceObjectNestedImpl<N> extends ScaleIOVolumeSourceFluentImpl<WatchEventFluent.ScaleIOVolumeSourceObjectNested<N>> implements WatchEventFluent.ScaleIOVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ScaleIOVolumeSourceBuilder builder;

            ScaleIOVolumeSourceObjectNestedImpl(ScaleIOVolumeSource item) {
                this.builder = new ScaleIOVolumeSourceBuilder(this, item);
                        
            }

            ScaleIOVolumeSourceObjectNestedImpl() {
                this.builder = new ScaleIOVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endScaleIOVolumeSourceObject() {
                return and();
            }
    }


    public class LimitRangeListObjectNestedImpl<N> extends LimitRangeListFluentImpl<WatchEventFluent.LimitRangeListObjectNested<N>> implements WatchEventFluent.LimitRangeListObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LimitRangeListBuilder builder;

            LimitRangeListObjectNestedImpl(LimitRangeList item) {
                this.builder = new LimitRangeListBuilder(this, item);
                        
            }

            LimitRangeListObjectNestedImpl() {
                this.builder = new LimitRangeListBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endLimitRangeListObject() {
                return and();
            }
    }


    public class PodExecOptionsObjectNestedImpl<N> extends PodExecOptionsFluentImpl<WatchEventFluent.PodExecOptionsObjectNested<N>> implements WatchEventFluent.PodExecOptionsObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodExecOptionsBuilder builder;

            PodExecOptionsObjectNestedImpl(PodExecOptions item) {
                this.builder = new PodExecOptionsBuilder(this, item);
                        
            }

            PodExecOptionsObjectNestedImpl() {
                this.builder = new PodExecOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPodExecOptionsObject() {
                return and();
            }
    }


    public class ProbeObjectNestedImpl<N> extends ProbeFluentImpl<WatchEventFluent.ProbeObjectNested<N>> implements WatchEventFluent.ProbeObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ProbeBuilder builder;

            ProbeObjectNestedImpl(Probe item) {
                this.builder = new ProbeBuilder(this, item);
                        
            }

            ProbeObjectNestedImpl() {
                this.builder = new ProbeBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endProbeObject() {
                return and();
            }
    }


    public class UpdateOptionsObjectNestedImpl<N> extends UpdateOptionsFluentImpl<WatchEventFluent.UpdateOptionsObjectNested<N>> implements WatchEventFluent.UpdateOptionsObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final UpdateOptionsBuilder builder;

            UpdateOptionsObjectNestedImpl(UpdateOptions item) {
                this.builder = new UpdateOptionsBuilder(this, item);
                        
            }

            UpdateOptionsObjectNestedImpl() {
                this.builder = new UpdateOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endUpdateOptionsObject() {
                return and();
            }
    }


    public class EndpointsObjectNestedImpl<N> extends EndpointsFluentImpl<WatchEventFluent.EndpointsObjectNested<N>> implements WatchEventFluent.EndpointsObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EndpointsBuilder builder;

            EndpointsObjectNestedImpl(Endpoints item) {
                this.builder = new EndpointsBuilder(this, item);
                        
            }

            EndpointsObjectNestedImpl() {
                this.builder = new EndpointsBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endEndpointsObject() {
                return and();
            }
    }


    public class NamedExtensionObjectNestedImpl<N> extends NamedExtensionFluentImpl<WatchEventFluent.NamedExtensionObjectNested<N>> implements WatchEventFluent.NamedExtensionObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NamedExtensionBuilder builder;

            NamedExtensionObjectNestedImpl(NamedExtension item) {
                this.builder = new NamedExtensionBuilder(this, item);
                        
            }

            NamedExtensionObjectNestedImpl() {
                this.builder = new NamedExtensionBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endNamedExtensionObject() {
                return and();
            }
    }


    public class AzureFilePersistentVolumeSourceObjectNestedImpl<N> extends AzureFilePersistentVolumeSourceFluentImpl<WatchEventFluent.AzureFilePersistentVolumeSourceObjectNested<N>> implements WatchEventFluent.AzureFilePersistentVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AzureFilePersistentVolumeSourceBuilder builder;

            AzureFilePersistentVolumeSourceObjectNestedImpl(AzureFilePersistentVolumeSource item) {
                this.builder = new AzureFilePersistentVolumeSourceBuilder(this, item);
                        
            }

            AzureFilePersistentVolumeSourceObjectNestedImpl() {
                this.builder = new AzureFilePersistentVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endAzureFilePersistentVolumeSourceObject() {
                return and();
            }
    }


    public class APIServiceListObjectNestedImpl<N> extends APIServiceListFluentImpl<WatchEventFluent.APIServiceListObjectNested<N>> implements WatchEventFluent.APIServiceListObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final APIServiceListBuilder builder;

            APIServiceListObjectNestedImpl(APIServiceList item) {
                this.builder = new APIServiceListBuilder(this, item);
                        
            }

            APIServiceListObjectNestedImpl() {
                this.builder = new APIServiceListBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endAPIServiceListObject() {
                return and();
            }
    }


    public class SecretVolumeSourceObjectNestedImpl<N> extends SecretVolumeSourceFluentImpl<WatchEventFluent.SecretVolumeSourceObjectNested<N>> implements WatchEventFluent.SecretVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SecretVolumeSourceBuilder builder;

            SecretVolumeSourceObjectNestedImpl(SecretVolumeSource item) {
                this.builder = new SecretVolumeSourceBuilder(this, item);
                        
            }

            SecretVolumeSourceObjectNestedImpl() {
                this.builder = new SecretVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endSecretVolumeSourceObject() {
                return and();
            }
    }


    public class PodObjectNestedImpl<N> extends PodFluentImpl<WatchEventFluent.PodObjectNested<N>> implements WatchEventFluent.PodObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodBuilder builder;

            PodObjectNestedImpl(Pod item) {
                this.builder = new PodBuilder(this, item);
                        
            }

            PodObjectNestedImpl() {
                this.builder = new PodBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPodObject() {
                return and();
            }
    }


    public class ClientIPConfigObjectNestedImpl<N> extends ClientIPConfigFluentImpl<WatchEventFluent.ClientIPConfigObjectNested<N>> implements WatchEventFluent.ClientIPConfigObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ClientIPConfigBuilder builder;

            ClientIPConfigObjectNestedImpl(ClientIPConfig item) {
                this.builder = new ClientIPConfigBuilder(this, item);
                        
            }

            ClientIPConfigObjectNestedImpl() {
                this.builder = new ClientIPConfigBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endClientIPConfigObject() {
                return and();
            }
    }


    public class ContextObjectNestedImpl<N> extends ContextFluentImpl<WatchEventFluent.ContextObjectNested<N>> implements WatchEventFluent.ContextObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ContextBuilder builder;

            ContextObjectNestedImpl(Context item) {
                this.builder = new ContextBuilder(this, item);
                        
            }

            ContextObjectNestedImpl() {
                this.builder = new ContextBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endContextObject() {
                return and();
            }
    }


    public class NodeAffinityObjectNestedImpl<N> extends NodeAffinityFluentImpl<WatchEventFluent.NodeAffinityObjectNested<N>> implements WatchEventFluent.NodeAffinityObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NodeAffinityBuilder builder;

            NodeAffinityObjectNestedImpl(NodeAffinity item) {
                this.builder = new NodeAffinityBuilder(this, item);
                        
            }

            NodeAffinityObjectNestedImpl() {
                this.builder = new NodeAffinityBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endNodeAffinityObject() {
                return and();
            }
    }


    public class ConfigMapObjectNestedImpl<N> extends ConfigMapFluentImpl<WatchEventFluent.ConfigMapObjectNested<N>> implements WatchEventFluent.ConfigMapObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConfigMapBuilder builder;

            ConfigMapObjectNestedImpl(ConfigMap item) {
                this.builder = new ConfigMapBuilder(this, item);
                        
            }

            ConfigMapObjectNestedImpl() {
                this.builder = new ConfigMapBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endConfigMapObject() {
                return and();
            }
    }


    public class ContainerPortObjectNestedImpl<N> extends ContainerPortFluentImpl<WatchEventFluent.ContainerPortObjectNested<N>> implements WatchEventFluent.ContainerPortObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ContainerPortBuilder builder;

            ContainerPortObjectNestedImpl(ContainerPort item) {
                this.builder = new ContainerPortBuilder(this, item);
                        
            }

            ContainerPortObjectNestedImpl() {
                this.builder = new ContainerPortBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endContainerPortObject() {
                return and();
            }
    }


    public class ConditionObjectNestedImpl<N> extends ConditionFluentImpl<WatchEventFluent.ConditionObjectNested<N>> implements WatchEventFluent.ConditionObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConditionBuilder builder;

            ConditionObjectNestedImpl(Condition item) {
                this.builder = new ConditionBuilder(this, item);
                        
            }

            ConditionObjectNestedImpl() {
                this.builder = new ConditionBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endConditionObject() {
                return and();
            }
    }


    public class PodListObjectNestedImpl<N> extends PodListFluentImpl<WatchEventFluent.PodListObjectNested<N>> implements WatchEventFluent.PodListObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodListBuilder builder;

            PodListObjectNestedImpl(PodList item) {
                this.builder = new PodListBuilder(this, item);
                        
            }

            PodListObjectNestedImpl() {
                this.builder = new PodListBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPodListObject() {
                return and();
            }
    }


    public class FCVolumeSourceObjectNestedImpl<N> extends FCVolumeSourceFluentImpl<WatchEventFluent.FCVolumeSourceObjectNested<N>> implements WatchEventFluent.FCVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final FCVolumeSourceBuilder builder;

            FCVolumeSourceObjectNestedImpl(FCVolumeSource item) {
                this.builder = new FCVolumeSourceBuilder(this, item);
                        
            }

            FCVolumeSourceObjectNestedImpl() {
                this.builder = new FCVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endFCVolumeSourceObject() {
                return and();
            }
    }


    public class ResourceFieldSelectorObjectNestedImpl<N> extends ResourceFieldSelectorFluentImpl<WatchEventFluent.ResourceFieldSelectorObjectNested<N>> implements WatchEventFluent.ResourceFieldSelectorObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceFieldSelectorBuilder builder;

            ResourceFieldSelectorObjectNestedImpl(ResourceFieldSelector item) {
                this.builder = new ResourceFieldSelectorBuilder(this, item);
                        
            }

            ResourceFieldSelectorObjectNestedImpl() {
                this.builder = new ResourceFieldSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endResourceFieldSelectorObject() {
                return and();
            }
    }


    public class PersistentVolumeClaimSpecObjectNestedImpl<N> extends PersistentVolumeClaimSpecFluentImpl<WatchEventFluent.PersistentVolumeClaimSpecObjectNested<N>> implements WatchEventFluent.PersistentVolumeClaimSpecObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PersistentVolumeClaimSpecBuilder builder;

            PersistentVolumeClaimSpecObjectNestedImpl(PersistentVolumeClaimSpec item) {
                this.builder = new PersistentVolumeClaimSpecBuilder(this, item);
                        
            }

            PersistentVolumeClaimSpecObjectNestedImpl() {
                this.builder = new PersistentVolumeClaimSpecBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPersistentVolumeClaimSpecObject() {
                return and();
            }
    }


    public class LoadBalancerStatusObjectNestedImpl<N> extends LoadBalancerStatusFluentImpl<WatchEventFluent.LoadBalancerStatusObjectNested<N>> implements WatchEventFluent.LoadBalancerStatusObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LoadBalancerStatusBuilder builder;

            LoadBalancerStatusObjectNestedImpl(LoadBalancerStatus item) {
                this.builder = new LoadBalancerStatusBuilder(this, item);
                        
            }

            LoadBalancerStatusObjectNestedImpl() {
                this.builder = new LoadBalancerStatusBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endLoadBalancerStatusObject() {
                return and();
            }
    }


    public class ScopeSelectorObjectNestedImpl<N> extends ScopeSelectorFluentImpl<WatchEventFluent.ScopeSelectorObjectNested<N>> implements WatchEventFluent.ScopeSelectorObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ScopeSelectorBuilder builder;

            ScopeSelectorObjectNestedImpl(ScopeSelector item) {
                this.builder = new ScopeSelectorBuilder(this, item);
                        
            }

            ScopeSelectorObjectNestedImpl() {
                this.builder = new ScopeSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endScopeSelectorObject() {
                return and();
            }
    }


    public class PodSecurityContextObjectNestedImpl<N> extends PodSecurityContextFluentImpl<WatchEventFluent.PodSecurityContextObjectNested<N>> implements WatchEventFluent.PodSecurityContextObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodSecurityContextBuilder builder;

            PodSecurityContextObjectNestedImpl(PodSecurityContext item) {
                this.builder = new PodSecurityContextBuilder(this, item);
                        
            }

            PodSecurityContextObjectNestedImpl() {
                this.builder = new PodSecurityContextBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPodSecurityContextObject() {
                return and();
            }
    }


    public class DownwardAPIProjectionObjectNestedImpl<N> extends DownwardAPIProjectionFluentImpl<WatchEventFluent.DownwardAPIProjectionObjectNested<N>> implements WatchEventFluent.DownwardAPIProjectionObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DownwardAPIProjectionBuilder builder;

            DownwardAPIProjectionObjectNestedImpl(DownwardAPIProjection item) {
                this.builder = new DownwardAPIProjectionBuilder(this, item);
                        
            }

            DownwardAPIProjectionObjectNestedImpl() {
                this.builder = new DownwardAPIProjectionBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endDownwardAPIProjectionObject() {
                return and();
            }
    }


    public class PodAffinityTermObjectNestedImpl<N> extends PodAffinityTermFluentImpl<WatchEventFluent.PodAffinityTermObjectNested<N>> implements WatchEventFluent.PodAffinityTermObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodAffinityTermBuilder builder;

            PodAffinityTermObjectNestedImpl(PodAffinityTerm item) {
                this.builder = new PodAffinityTermBuilder(this, item);
                        
            }

            PodAffinityTermObjectNestedImpl() {
                this.builder = new PodAffinityTermBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPodAffinityTermObject() {
                return and();
            }
    }


    public class APIServiceSpecObjectNestedImpl<N> extends APIServiceSpecFluentImpl<WatchEventFluent.APIServiceSpecObjectNested<N>> implements WatchEventFluent.APIServiceSpecObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final APIServiceSpecBuilder builder;

            APIServiceSpecObjectNestedImpl(APIServiceSpec item) {
                this.builder = new APIServiceSpecBuilder(this, item);
                        
            }

            APIServiceSpecObjectNestedImpl() {
                this.builder = new APIServiceSpecBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endAPIServiceSpecObject() {
                return and();
            }
    }


    public class ServicePortObjectNestedImpl<N> extends ServicePortFluentImpl<WatchEventFluent.ServicePortObjectNested<N>> implements WatchEventFluent.ServicePortObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ServicePortBuilder builder;

            ServicePortObjectNestedImpl(ServicePort item) {
                this.builder = new ServicePortBuilder(this, item);
                        
            }

            ServicePortObjectNestedImpl() {
                this.builder = new ServicePortBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endServicePortObject() {
                return and();
            }
    }


    public class GroupVersionForDiscoveryObjectNestedImpl<N> extends GroupVersionForDiscoveryFluentImpl<WatchEventFluent.GroupVersionForDiscoveryObjectNested<N>> implements WatchEventFluent.GroupVersionForDiscoveryObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GroupVersionForDiscoveryBuilder builder;

            GroupVersionForDiscoveryObjectNestedImpl(GroupVersionForDiscovery item) {
                this.builder = new GroupVersionForDiscoveryBuilder(this, item);
                        
            }

            GroupVersionForDiscoveryObjectNestedImpl() {
                this.builder = new GroupVersionForDiscoveryBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endGroupVersionForDiscoveryObject() {
                return and();
            }
    }


    public class PersistentVolumeClaimSourceObjectNestedImpl<N> extends PersistentVolumeClaimVolumeSourceFluentImpl<WatchEventFluent.PersistentVolumeClaimSourceObjectNested<N>> implements WatchEventFluent.PersistentVolumeClaimSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PersistentVolumeClaimVolumeSourceBuilder builder;

            PersistentVolumeClaimSourceObjectNestedImpl(PersistentVolumeClaimVolumeSource item) {
                this.builder = new PersistentVolumeClaimVolumeSourceBuilder(this, item);
                        
            }

            PersistentVolumeClaimSourceObjectNestedImpl() {
                this.builder = new PersistentVolumeClaimVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPersistentVolumeClaimSourceObject() {
                return and();
            }
    }


    public class SessionAffinityConfigObjectNestedImpl<N> extends SessionAffinityConfigFluentImpl<WatchEventFluent.SessionAffinityConfigObjectNested<N>> implements WatchEventFluent.SessionAffinityConfigObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SessionAffinityConfigBuilder builder;

            SessionAffinityConfigObjectNestedImpl(SessionAffinityConfig item) {
                this.builder = new SessionAffinityConfigBuilder(this, item);
                        
            }

            SessionAffinityConfigObjectNestedImpl() {
                this.builder = new SessionAffinityConfigBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endSessionAffinityConfigObject() {
                return and();
            }
    }


    public class ServiceAccountListObjectNestedImpl<N> extends ServiceAccountListFluentImpl<WatchEventFluent.ServiceAccountListObjectNested<N>> implements WatchEventFluent.ServiceAccountListObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ServiceAccountListBuilder builder;

            ServiceAccountListObjectNestedImpl(ServiceAccountList item) {
                this.builder = new ServiceAccountListBuilder(this, item);
                        
            }

            ServiceAccountListObjectNestedImpl() {
                this.builder = new ServiceAccountListBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endServiceAccountListObject() {
                return and();
            }
    }


    public class ComponentStatusObjectNestedImpl<N> extends ComponentStatusFluentImpl<WatchEventFluent.ComponentStatusObjectNested<N>> implements WatchEventFluent.ComponentStatusObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ComponentStatusBuilder builder;

            ComponentStatusObjectNestedImpl(ComponentStatus item) {
                this.builder = new ComponentStatusBuilder(this, item);
                        
            }

            ComponentStatusObjectNestedImpl() {
                this.builder = new ComponentStatusBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endComponentStatusObject() {
                return and();
            }
    }


    public class DaemonEndpointObjectNestedImpl<N> extends DaemonEndpointFluentImpl<WatchEventFluent.DaemonEndpointObjectNested<N>> implements WatchEventFluent.DaemonEndpointObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DaemonEndpointBuilder builder;

            DaemonEndpointObjectNestedImpl(DaemonEndpoint item) {
                this.builder = new DaemonEndpointBuilder(this, item);
                        
            }

            DaemonEndpointObjectNestedImpl() {
                this.builder = new DaemonEndpointBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endDaemonEndpointObject() {
                return and();
            }
    }


    public class KeyToPathObjectNestedImpl<N> extends KeyToPathFluentImpl<WatchEventFluent.KeyToPathObjectNested<N>> implements WatchEventFluent.KeyToPathObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KeyToPathBuilder builder;

            KeyToPathObjectNestedImpl(KeyToPath item) {
                this.builder = new KeyToPathBuilder(this, item);
                        
            }

            KeyToPathObjectNestedImpl() {
                this.builder = new KeyToPathBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endKeyToPathObject() {
                return and();
            }
    }


    public class FlexPersistentVolumeSourceObjectNestedImpl<N> extends FlexPersistentVolumeSourceFluentImpl<WatchEventFluent.FlexPersistentVolumeSourceObjectNested<N>> implements WatchEventFluent.FlexPersistentVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final FlexPersistentVolumeSourceBuilder builder;

            FlexPersistentVolumeSourceObjectNestedImpl(FlexPersistentVolumeSource item) {
                this.builder = new FlexPersistentVolumeSourceBuilder(this, item);
                        
            }

            FlexPersistentVolumeSourceObjectNestedImpl() {
                this.builder = new FlexPersistentVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endFlexPersistentVolumeSourceObject() {
                return and();
            }
    }


    public class NamespaceListObjectNestedImpl<N> extends NamespaceListFluentImpl<WatchEventFluent.NamespaceListObjectNested<N>> implements WatchEventFluent.NamespaceListObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NamespaceListBuilder builder;

            NamespaceListObjectNestedImpl(NamespaceList item) {
                this.builder = new NamespaceListBuilder(this, item);
                        
            }

            NamespaceListObjectNestedImpl() {
                this.builder = new NamespaceListBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endNamespaceListObject() {
                return and();
            }
    }


    public class PodDNSConfigObjectNestedImpl<N> extends PodDNSConfigFluentImpl<WatchEventFluent.PodDNSConfigObjectNested<N>> implements WatchEventFluent.PodDNSConfigObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodDNSConfigBuilder builder;

            PodDNSConfigObjectNestedImpl(PodDNSConfig item) {
                this.builder = new PodDNSConfigBuilder(this, item);
                        
            }

            PodDNSConfigObjectNestedImpl() {
                this.builder = new PodDNSConfigBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPodDNSConfigObject() {
                return and();
            }
    }


    public class NodeListObjectNestedImpl<N> extends NodeListFluentImpl<WatchEventFluent.NodeListObjectNested<N>> implements WatchEventFluent.NodeListObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NodeListBuilder builder;

            NodeListObjectNestedImpl(NodeList item) {
                this.builder = new NodeListBuilder(this, item);
                        
            }

            NodeListObjectNestedImpl() {
                this.builder = new NodeListBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endNodeListObject() {
                return and();
            }
    }


    public class BindingObjectNestedImpl<N> extends BindingFluentImpl<WatchEventFluent.BindingObjectNested<N>> implements WatchEventFluent.BindingObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final BindingBuilder builder;

            BindingObjectNestedImpl(Binding item) {
                this.builder = new BindingBuilder(this, item);
                        
            }

            BindingObjectNestedImpl() {
                this.builder = new BindingBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endBindingObject() {
                return and();
            }
    }


    public class EnvVarSourceObjectNestedImpl<N> extends EnvVarSourceFluentImpl<WatchEventFluent.EnvVarSourceObjectNested<N>> implements WatchEventFluent.EnvVarSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EnvVarSourceBuilder builder;

            EnvVarSourceObjectNestedImpl(EnvVarSource item) {
                this.builder = new EnvVarSourceBuilder(this, item);
                        
            }

            EnvVarSourceObjectNestedImpl() {
                this.builder = new EnvVarSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endEnvVarSourceObject() {
                return and();
            }
    }


    public class VolumeProjectionObjectNestedImpl<N> extends VolumeProjectionFluentImpl<WatchEventFluent.VolumeProjectionObjectNested<N>> implements WatchEventFluent.VolumeProjectionObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final VolumeProjectionBuilder builder;

            VolumeProjectionObjectNestedImpl(VolumeProjection item) {
                this.builder = new VolumeProjectionBuilder(this, item);
                        
            }

            VolumeProjectionObjectNestedImpl() {
                this.builder = new VolumeProjectionBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endVolumeProjectionObject() {
                return and();
            }
    }


    public class ResourceQuotaObjectNestedImpl<N> extends ResourceQuotaFluentImpl<WatchEventFluent.ResourceQuotaObjectNested<N>> implements WatchEventFluent.ResourceQuotaObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceQuotaBuilder builder;

            ResourceQuotaObjectNestedImpl(ResourceQuota item) {
                this.builder = new ResourceQuotaBuilder(this, item);
                        
            }

            ResourceQuotaObjectNestedImpl() {
                this.builder = new ResourceQuotaBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endResourceQuotaObject() {
                return and();
            }
    }


    public class SecretObjectNestedImpl<N> extends SecretFluentImpl<WatchEventFluent.SecretObjectNested<N>> implements WatchEventFluent.SecretObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SecretBuilder builder;

            SecretObjectNestedImpl(Secret item) {
                this.builder = new SecretBuilder(this, item);
                        
            }

            SecretObjectNestedImpl() {
                this.builder = new SecretBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endSecretObject() {
                return and();
            }
    }


    public class ServiceListObjectNestedImpl<N> extends ServiceListFluentImpl<WatchEventFluent.ServiceListObjectNested<N>> implements WatchEventFluent.ServiceListObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ServiceListBuilder builder;

            ServiceListObjectNestedImpl(ServiceList item) {
                this.builder = new ServiceListBuilder(this, item);
                        
            }

            ServiceListObjectNestedImpl() {
                this.builder = new ServiceListBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endServiceListObject() {
                return and();
            }
    }


    public class VolumeNodeAffinityObjectNestedImpl<N> extends VolumeNodeAffinityFluentImpl<WatchEventFluent.VolumeNodeAffinityObjectNested<N>> implements WatchEventFluent.VolumeNodeAffinityObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final VolumeNodeAffinityBuilder builder;

            VolumeNodeAffinityObjectNestedImpl(VolumeNodeAffinity item) {
                this.builder = new VolumeNodeAffinityBuilder(this, item);
                        
            }

            VolumeNodeAffinityObjectNestedImpl() {
                this.builder = new VolumeNodeAffinityBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endVolumeNodeAffinityObject() {
                return and();
            }
    }


    public class ResourceQuotaSpecObjectNestedImpl<N> extends ResourceQuotaSpecFluentImpl<WatchEventFluent.ResourceQuotaSpecObjectNested<N>> implements WatchEventFluent.ResourceQuotaSpecObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceQuotaSpecBuilder builder;

            ResourceQuotaSpecObjectNestedImpl(ResourceQuotaSpec item) {
                this.builder = new ResourceQuotaSpecBuilder(this, item);
                        
            }

            ResourceQuotaSpecObjectNestedImpl() {
                this.builder = new ResourceQuotaSpecBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endResourceQuotaSpecObject() {
                return and();
            }
    }


    public class NodeSelectorTermObjectNestedImpl<N> extends NodeSelectorTermFluentImpl<WatchEventFluent.NodeSelectorTermObjectNested<N>> implements WatchEventFluent.NodeSelectorTermObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NodeSelectorTermBuilder builder;

            NodeSelectorTermObjectNestedImpl(NodeSelectorTerm item) {
                this.builder = new NodeSelectorTermBuilder(this, item);
                        
            }

            NodeSelectorTermObjectNestedImpl() {
                this.builder = new NodeSelectorTermBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endNodeSelectorTermObject() {
                return and();
            }
    }


    public class ScaleIOPersistentVolumeSourceObjectNestedImpl<N> extends ScaleIOPersistentVolumeSourceFluentImpl<WatchEventFluent.ScaleIOPersistentVolumeSourceObjectNested<N>> implements WatchEventFluent.ScaleIOPersistentVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ScaleIOPersistentVolumeSourceBuilder builder;

            ScaleIOPersistentVolumeSourceObjectNestedImpl(ScaleIOPersistentVolumeSource item) {
                this.builder = new ScaleIOPersistentVolumeSourceBuilder(this, item);
                        
            }

            ScaleIOPersistentVolumeSourceObjectNestedImpl() {
                this.builder = new ScaleIOPersistentVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endScaleIOPersistentVolumeSourceObject() {
                return and();
            }
    }


    public class ListOptionsObjectNestedImpl<N> extends ListOptionsFluentImpl<WatchEventFluent.ListOptionsObjectNested<N>> implements WatchEventFluent.ListOptionsObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ListOptionsBuilder builder;

            ListOptionsObjectNestedImpl(ListOptions item) {
                this.builder = new ListOptionsBuilder(this, item);
                        
            }

            ListOptionsObjectNestedImpl() {
                this.builder = new ListOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endListOptionsObject() {
                return and();
            }
    }


    public class WeightedPodAffinityTermObjectNestedImpl<N> extends WeightedPodAffinityTermFluentImpl<WatchEventFluent.WeightedPodAffinityTermObjectNested<N>> implements WatchEventFluent.WeightedPodAffinityTermObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final WeightedPodAffinityTermBuilder builder;

            WeightedPodAffinityTermObjectNestedImpl(WeightedPodAffinityTerm item) {
                this.builder = new WeightedPodAffinityTermBuilder(this, item);
                        
            }

            WeightedPodAffinityTermObjectNestedImpl() {
                this.builder = new WeightedPodAffinityTermBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endWeightedPodAffinityTermObject() {
                return and();
            }
    }


    public class BaseKubernetesListObjectNestedImpl<N> extends BaseKubernetesListFluentImpl<WatchEventFluent.BaseKubernetesListObjectNested<N>> implements WatchEventFluent.BaseKubernetesListObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final BaseKubernetesListBuilder builder;

            BaseKubernetesListObjectNestedImpl(BaseKubernetesList item) {
                this.builder = new BaseKubernetesListBuilder(this, item);
                        
            }

            BaseKubernetesListObjectNestedImpl() {
                this.builder = new BaseKubernetesListBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endBaseKubernetesListObject() {
                return and();
            }
    }


    public class NodeSystemInfoObjectNestedImpl<N> extends NodeSystemInfoFluentImpl<WatchEventFluent.NodeSystemInfoObjectNested<N>> implements WatchEventFluent.NodeSystemInfoObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NodeSystemInfoBuilder builder;

            NodeSystemInfoObjectNestedImpl(NodeSystemInfo item) {
                this.builder = new NodeSystemInfoBuilder(this, item);
                        
            }

            NodeSystemInfoObjectNestedImpl() {
                this.builder = new NodeSystemInfoBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endNodeSystemInfoObject() {
                return and();
            }
    }


    public class TopologySelectorLabelRequirementObjectNestedImpl<N> extends TopologySelectorLabelRequirementFluentImpl<WatchEventFluent.TopologySelectorLabelRequirementObjectNested<N>> implements WatchEventFluent.TopologySelectorLabelRequirementObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TopologySelectorLabelRequirementBuilder builder;

            TopologySelectorLabelRequirementObjectNestedImpl(TopologySelectorLabelRequirement item) {
                this.builder = new TopologySelectorLabelRequirementBuilder(this, item);
                        
            }

            TopologySelectorLabelRequirementObjectNestedImpl() {
                this.builder = new TopologySelectorLabelRequirementBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endTopologySelectorLabelRequirementObject() {
                return and();
            }
    }


    public class RBDPersistentVolumeSourceObjectNestedImpl<N> extends RBDPersistentVolumeSourceFluentImpl<WatchEventFluent.RBDPersistentVolumeSourceObjectNested<N>> implements WatchEventFluent.RBDPersistentVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RBDPersistentVolumeSourceBuilder builder;

            RBDPersistentVolumeSourceObjectNestedImpl(RBDPersistentVolumeSource item) {
                this.builder = new RBDPersistentVolumeSourceBuilder(this, item);
                        
            }

            RBDPersistentVolumeSourceObjectNestedImpl() {
                this.builder = new RBDPersistentVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endRBDPersistentVolumeSourceObject() {
                return and();
            }
    }


    public class AuthProviderConfigObjectNestedImpl<N> extends AuthProviderConfigFluentImpl<WatchEventFluent.AuthProviderConfigObjectNested<N>> implements WatchEventFluent.AuthProviderConfigObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AuthProviderConfigBuilder builder;

            AuthProviderConfigObjectNestedImpl(AuthProviderConfig item) {
                this.builder = new AuthProviderConfigBuilder(this, item);
                        
            }

            AuthProviderConfigObjectNestedImpl() {
                this.builder = new AuthProviderConfigBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endAuthProviderConfigObject() {
                return and();
            }
    }


    public class SELinuxOptionsObjectNestedImpl<N> extends SELinuxOptionsFluentImpl<WatchEventFluent.SELinuxOptionsObjectNested<N>> implements WatchEventFluent.SELinuxOptionsObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SELinuxOptionsBuilder builder;

            SELinuxOptionsObjectNestedImpl(SELinuxOptions item) {
                this.builder = new SELinuxOptionsBuilder(this, item);
                        
            }

            SELinuxOptionsObjectNestedImpl() {
                this.builder = new SELinuxOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endSELinuxOptionsObject() {
                return and();
            }
    }


    public class HostAliasObjectNestedImpl<N> extends HostAliasFluentImpl<WatchEventFluent.HostAliasObjectNested<N>> implements WatchEventFluent.HostAliasObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final HostAliasBuilder builder;

            HostAliasObjectNestedImpl(HostAlias item) {
                this.builder = new HostAliasBuilder(this, item);
                        
            }

            HostAliasObjectNestedImpl() {
                this.builder = new HostAliasBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endHostAliasObject() {
                return and();
            }
    }


    public class NodeDaemonEndpointsObjectNestedImpl<N> extends NodeDaemonEndpointsFluentImpl<WatchEventFluent.NodeDaemonEndpointsObjectNested<N>> implements WatchEventFluent.NodeDaemonEndpointsObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NodeDaemonEndpointsBuilder builder;

            NodeDaemonEndpointsObjectNestedImpl(NodeDaemonEndpoints item) {
                this.builder = new NodeDaemonEndpointsBuilder(this, item);
                        
            }

            NodeDaemonEndpointsObjectNestedImpl() {
                this.builder = new NodeDaemonEndpointsBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endNodeDaemonEndpointsObject() {
                return and();
            }
    }


    public class CSIVolumeSourceObjectNestedImpl<N> extends CSIVolumeSourceFluentImpl<WatchEventFluent.CSIVolumeSourceObjectNested<N>> implements WatchEventFluent.CSIVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CSIVolumeSourceBuilder builder;

            CSIVolumeSourceObjectNestedImpl(CSIVolumeSource item) {
                this.builder = new CSIVolumeSourceBuilder(this, item);
                        
            }

            CSIVolumeSourceObjectNestedImpl() {
                this.builder = new CSIVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endCSIVolumeSourceObject() {
                return and();
            }
    }


    public class VolumeDeviceObjectNestedImpl<N> extends VolumeDeviceFluentImpl<WatchEventFluent.VolumeDeviceObjectNested<N>> implements WatchEventFluent.VolumeDeviceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final VolumeDeviceBuilder builder;

            VolumeDeviceObjectNestedImpl(VolumeDevice item) {
                this.builder = new VolumeDeviceBuilder(this, item);
                        
            }

            VolumeDeviceObjectNestedImpl() {
                this.builder = new VolumeDeviceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endVolumeDeviceObject() {
                return and();
            }
    }


    public class PersistentVolumeSpecObjectNestedImpl<N> extends PersistentVolumeSpecFluentImpl<WatchEventFluent.PersistentVolumeSpecObjectNested<N>> implements WatchEventFluent.PersistentVolumeSpecObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PersistentVolumeSpecBuilder builder;

            PersistentVolumeSpecObjectNestedImpl(PersistentVolumeSpec item) {
                this.builder = new PersistentVolumeSpecBuilder(this, item);
                        
            }

            PersistentVolumeSpecObjectNestedImpl() {
                this.builder = new PersistentVolumeSpecBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPersistentVolumeSpecObject() {
                return and();
            }
    }


    public class NodeObjectNestedImpl<N> extends NodeFluentImpl<WatchEventFluent.NodeObjectNested<N>> implements WatchEventFluent.NodeObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NodeBuilder builder;

            NodeObjectNestedImpl(Node item) {
                this.builder = new NodeBuilder(this, item);
                        
            }

            NodeObjectNestedImpl() {
                this.builder = new NodeBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endNodeObject() {
                return and();
            }
    }


    public class VolumeObjectNestedImpl<N> extends VolumeFluentImpl<WatchEventFluent.VolumeObjectNested<N>> implements WatchEventFluent.VolumeObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final VolumeBuilder builder;

            VolumeObjectNestedImpl(Volume item) {
                this.builder = new VolumeBuilder(this, item);
                        
            }

            VolumeObjectNestedImpl() {
                this.builder = new VolumeBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endVolumeObject() {
                return and();
            }
    }


    public class NFSVolumeSourceObjectNestedImpl<N> extends NFSVolumeSourceFluentImpl<WatchEventFluent.NFSVolumeSourceObjectNested<N>> implements WatchEventFluent.NFSVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NFSVolumeSourceBuilder builder;

            NFSVolumeSourceObjectNestedImpl(NFSVolumeSource item) {
                this.builder = new NFSVolumeSourceBuilder(this, item);
                        
            }

            NFSVolumeSourceObjectNestedImpl() {
                this.builder = new NFSVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endNFSVolumeSourceObject() {
                return and();
            }
    }


    public class ClusterObjectNestedImpl<N> extends ClusterFluentImpl<WatchEventFluent.ClusterObjectNested<N>> implements WatchEventFluent.ClusterObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ClusterBuilder builder;

            ClusterObjectNestedImpl(Cluster item) {
                this.builder = new ClusterBuilder(this, item);
                        
            }

            ClusterObjectNestedImpl() {
                this.builder = new ClusterBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endClusterObject() {
                return and();
            }
    }


    public class StorageOSVolumeSourceObjectNestedImpl<N> extends StorageOSVolumeSourceFluentImpl<WatchEventFluent.StorageOSVolumeSourceObjectNested<N>> implements WatchEventFluent.StorageOSVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final StorageOSVolumeSourceBuilder builder;

            StorageOSVolumeSourceObjectNestedImpl(StorageOSVolumeSource item) {
                this.builder = new StorageOSVolumeSourceBuilder(this, item);
                        
            }

            StorageOSVolumeSourceObjectNestedImpl() {
                this.builder = new StorageOSVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endStorageOSVolumeSourceObject() {
                return and();
            }
    }


    public class PodStatusObjectNestedImpl<N> extends PodStatusFluentImpl<WatchEventFluent.PodStatusObjectNested<N>> implements WatchEventFluent.PodStatusObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodStatusBuilder builder;

            PodStatusObjectNestedImpl(PodStatus item) {
                this.builder = new PodStatusBuilder(this, item);
                        
            }

            PodStatusObjectNestedImpl() {
                this.builder = new PodStatusBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPodStatusObject() {
                return and();
            }
    }


    public class ExecConfigObjectNestedImpl<N> extends ExecConfigFluentImpl<WatchEventFluent.ExecConfigObjectNested<N>> implements WatchEventFluent.ExecConfigObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ExecConfigBuilder builder;

            ExecConfigObjectNestedImpl(ExecConfig item) {
                this.builder = new ExecConfigBuilder(this, item);
                        
            }

            ExecConfigObjectNestedImpl() {
                this.builder = new ExecConfigBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endExecConfigObject() {
                return and();
            }
    }


    public class KubernetesListObjectNestedImpl<N> extends KubernetesListFluentImpl<WatchEventFluent.KubernetesListObjectNested<N>> implements WatchEventFluent.KubernetesListObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KubernetesListBuilder builder;

            KubernetesListObjectNestedImpl(KubernetesList item) {
                this.builder = new KubernetesListBuilder(this, item);
                        
            }

            KubernetesListObjectNestedImpl() {
                this.builder = new KubernetesListBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endKubernetesListObject() {
                return and();
            }
    }


    public class PersistentVolumeStatusObjectNestedImpl<N> extends PersistentVolumeStatusFluentImpl<WatchEventFluent.PersistentVolumeStatusObjectNested<N>> implements WatchEventFluent.PersistentVolumeStatusObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PersistentVolumeStatusBuilder builder;

            PersistentVolumeStatusObjectNestedImpl(PersistentVolumeStatus item) {
                this.builder = new PersistentVolumeStatusBuilder(this, item);
                        
            }

            PersistentVolumeStatusObjectNestedImpl() {
                this.builder = new PersistentVolumeStatusBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPersistentVolumeStatusObject() {
                return and();
            }
    }


    public class EndpointPortObjectNestedImpl<N> extends EndpointPortFluentImpl<WatchEventFluent.EndpointPortObjectNested<N>> implements WatchEventFluent.EndpointPortObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EndpointPortBuilder builder;

            EndpointPortObjectNestedImpl(EndpointPort item) {
                this.builder = new EndpointPortBuilder(this, item);
                        
            }

            EndpointPortObjectNestedImpl() {
                this.builder = new EndpointPortBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endEndpointPortObject() {
                return and();
            }
    }


    public class HTTPHeaderObjectNestedImpl<N> extends HTTPHeaderFluentImpl<WatchEventFluent.HTTPHeaderObjectNested<N>> implements WatchEventFluent.HTTPHeaderObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final HTTPHeaderBuilder builder;

            HTTPHeaderObjectNestedImpl(HTTPHeader item) {
                this.builder = new HTTPHeaderBuilder(this, item);
                        
            }

            HTTPHeaderObjectNestedImpl() {
                this.builder = new HTTPHeaderBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endHTTPHeaderObject() {
                return and();
            }
    }


    public class CapabilitiesObjectNestedImpl<N> extends CapabilitiesFluentImpl<WatchEventFluent.CapabilitiesObjectNested<N>> implements WatchEventFluent.CapabilitiesObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CapabilitiesBuilder builder;

            CapabilitiesObjectNestedImpl(Capabilities item) {
                this.builder = new CapabilitiesBuilder(this, item);
                        
            }

            CapabilitiesObjectNestedImpl() {
                this.builder = new CapabilitiesBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endCapabilitiesObject() {
                return and();
            }
    }


    public class WatchEventObjectNestedImpl<N> extends WatchEventFluentImpl<WatchEventFluent.WatchEventObjectNested<N>> implements WatchEventFluent.WatchEventObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final WatchEventBuilder builder;

            WatchEventObjectNestedImpl(WatchEvent item) {
                this.builder = new WatchEventBuilder(this, item);
                        
            }

            WatchEventObjectNestedImpl() {
                this.builder = new WatchEventBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endWatchEventObject() {
                return and();
            }
    }


    public class ObjectReferenceObjectNestedImpl<N> extends ObjectReferenceFluentImpl<WatchEventFluent.ObjectReferenceObjectNested<N>> implements WatchEventFluent.ObjectReferenceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectReferenceBuilder builder;

            ObjectReferenceObjectNestedImpl(ObjectReference item) {
                this.builder = new ObjectReferenceBuilder(this, item);
                        
            }

            ObjectReferenceObjectNestedImpl() {
                this.builder = new ObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endObjectReferenceObject() {
                return and();
            }
    }


    public class LimitRangeItemObjectNestedImpl<N> extends LimitRangeItemFluentImpl<WatchEventFluent.LimitRangeItemObjectNested<N>> implements WatchEventFluent.LimitRangeItemObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LimitRangeItemBuilder builder;

            LimitRangeItemObjectNestedImpl(LimitRangeItem item) {
                this.builder = new LimitRangeItemBuilder(this, item);
                        
            }

            LimitRangeItemObjectNestedImpl() {
                this.builder = new LimitRangeItemBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endLimitRangeItemObject() {
                return and();
            }
    }


    public class SecretProjectionObjectNestedImpl<N> extends SecretProjectionFluentImpl<WatchEventFluent.SecretProjectionObjectNested<N>> implements WatchEventFluent.SecretProjectionObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SecretProjectionBuilder builder;

            SecretProjectionObjectNestedImpl(SecretProjection item) {
                this.builder = new SecretProjectionBuilder(this, item);
                        
            }

            SecretProjectionObjectNestedImpl() {
                this.builder = new SecretProjectionBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endSecretProjectionObject() {
                return and();
            }
    }


    public class GetOptionsObjectNestedImpl<N> extends GetOptionsFluentImpl<WatchEventFluent.GetOptionsObjectNested<N>> implements WatchEventFluent.GetOptionsObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GetOptionsBuilder builder;

            GetOptionsObjectNestedImpl(GetOptions item) {
                this.builder = new GetOptionsBuilder(this, item);
                        
            }

            GetOptionsObjectNestedImpl() {
                this.builder = new GetOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endGetOptionsObject() {
                return and();
            }
    }


    public class GlusterfsVolumeSourceObjectNestedImpl<N> extends GlusterfsVolumeSourceFluentImpl<WatchEventFluent.GlusterfsVolumeSourceObjectNested<N>> implements WatchEventFluent.GlusterfsVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GlusterfsVolumeSourceBuilder builder;

            GlusterfsVolumeSourceObjectNestedImpl(GlusterfsVolumeSource item) {
                this.builder = new GlusterfsVolumeSourceBuilder(this, item);
                        
            }

            GlusterfsVolumeSourceObjectNestedImpl() {
                this.builder = new GlusterfsVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endGlusterfsVolumeSourceObject() {
                return and();
            }
    }


    public class NamespaceStatusObjectNestedImpl<N> extends NamespaceStatusFluentImpl<WatchEventFluent.NamespaceStatusObjectNested<N>> implements WatchEventFluent.NamespaceStatusObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NamespaceStatusBuilder builder;

            NamespaceStatusObjectNestedImpl(NamespaceStatus item) {
                this.builder = new NamespaceStatusBuilder(this, item);
                        
            }

            NamespaceStatusObjectNestedImpl() {
                this.builder = new NamespaceStatusBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endNamespaceStatusObject() {
                return and();
            }
    }


    public class ManagedFieldsEntryObjectNestedImpl<N> extends ManagedFieldsEntryFluentImpl<WatchEventFluent.ManagedFieldsEntryObjectNested<N>> implements WatchEventFluent.ManagedFieldsEntryObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ManagedFieldsEntryBuilder builder;

            ManagedFieldsEntryObjectNestedImpl(ManagedFieldsEntry item) {
                this.builder = new ManagedFieldsEntryBuilder(this, item);
                        
            }

            ManagedFieldsEntryObjectNestedImpl() {
                this.builder = new ManagedFieldsEntryBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endManagedFieldsEntryObject() {
                return and();
            }
    }


    public class SecretEnvSourceObjectNestedImpl<N> extends SecretEnvSourceFluentImpl<WatchEventFluent.SecretEnvSourceObjectNested<N>> implements WatchEventFluent.SecretEnvSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SecretEnvSourceBuilder builder;

            SecretEnvSourceObjectNestedImpl(SecretEnvSource item) {
                this.builder = new SecretEnvSourceBuilder(this, item);
                        
            }

            SecretEnvSourceObjectNestedImpl() {
                this.builder = new SecretEnvSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endSecretEnvSourceObject() {
                return and();
            }
    }


    public class AWSElasticBlockStoreVolumeSourceObjectNestedImpl<N> extends AWSElasticBlockStoreVolumeSourceFluentImpl<WatchEventFluent.AWSElasticBlockStoreVolumeSourceObjectNested<N>> implements WatchEventFluent.AWSElasticBlockStoreVolumeSourceObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AWSElasticBlockStoreVolumeSourceBuilder builder;

            AWSElasticBlockStoreVolumeSourceObjectNestedImpl(AWSElasticBlockStoreVolumeSource item) {
                this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this, item);
                        
            }

            AWSElasticBlockStoreVolumeSourceObjectNestedImpl() {
                this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endAWSElasticBlockStoreVolumeSourceObject() {
                return and();
            }
    }


    public class ServiceAccountObjectNestedImpl<N> extends ServiceAccountFluentImpl<WatchEventFluent.ServiceAccountObjectNested<N>> implements WatchEventFluent.ServiceAccountObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ServiceAccountBuilder builder;

            ServiceAccountObjectNestedImpl(ServiceAccount item) {
                this.builder = new ServiceAccountBuilder(this, item);
                        
            }

            ServiceAccountObjectNestedImpl() {
                this.builder = new ServiceAccountBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endServiceAccountObject() {
                return and();
            }
    }


    public class PodIPObjectNestedImpl<N> extends PodIPFluentImpl<WatchEventFluent.PodIPObjectNested<N>> implements WatchEventFluent.PodIPObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodIPBuilder builder;

            PodIPObjectNestedImpl(PodIP item) {
                this.builder = new PodIPBuilder(this, item);
                        
            }

            PodIPObjectNestedImpl() {
                this.builder = new PodIPBuilder(this);
                        
            }

            public N and() {
                return (N) WatchEventFluentImpl.this.withObject(builder.build());
            }

            public N endPodIPObject() {
                return and();
            }
    }


}
