package io.fabric8.kubernetes.api.builder;

import java.lang.Class;

public interface Visitable<T> {


    T accept(io.fabric8.kubernetes.api.builder.Visitor... visitor);
    default <V>T accept(Class<V> type,io.fabric8.kubernetes.api.builder.Visitor<V> visitor) {
        return accept(new TypedVisitor<V>() {
        
            @Override
            public Class<V> getType() {
                return type;
            }
        
            @Override
            public void visit(V element) {
                visitor.visit(element);
            }
        });
    }

}
