package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodSecurityContextBuilder extends PodSecurityContextFluentImpl<PodSecurityContextBuilder> implements VisitableBuilder<PodSecurityContext,PodSecurityContextBuilder> {

    PodSecurityContextFluent<?> fluent;
    Boolean validationEnabled;

    public PodSecurityContextBuilder() {
        this(true);
    }

    public PodSecurityContextBuilder(Boolean validationEnabled) {
        this(new PodSecurityContext(), validationEnabled);
    }

    public PodSecurityContextBuilder(PodSecurityContextFluent<?> fluent) {
        this(fluent, true);
    }

    public PodSecurityContextBuilder(PodSecurityContextFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new PodSecurityContext(), validationEnabled);
    }

    public PodSecurityContextBuilder(PodSecurityContextFluent<?> fluent,PodSecurityContext instance) {
        this(fluent, instance, true);
    }

    public PodSecurityContextBuilder(PodSecurityContextFluent<?> fluent,PodSecurityContext instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withFsGroup(instance.getFsGroup()); 
        fluent.withFsGroupChangePolicy(instance.getFsGroupChangePolicy()); 
        fluent.withRunAsGroup(instance.getRunAsGroup()); 
        fluent.withRunAsNonRoot(instance.getRunAsNonRoot()); 
        fluent.withRunAsUser(instance.getRunAsUser()); 
        fluent.withSeLinuxOptions(instance.getSeLinuxOptions()); 
        fluent.withSeccompProfile(instance.getSeccompProfile()); 
        fluent.withSupplementalGroups(instance.getSupplementalGroups()); 
        fluent.withSysctls(instance.getSysctls()); 
        fluent.withWindowsOptions(instance.getWindowsOptions()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodSecurityContextBuilder(PodSecurityContext instance) {
        this(instance,true);
    }

    public PodSecurityContextBuilder(PodSecurityContext instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withFsGroup(instance.getFsGroup()); 
        this.withFsGroupChangePolicy(instance.getFsGroupChangePolicy()); 
        this.withRunAsGroup(instance.getRunAsGroup()); 
        this.withRunAsNonRoot(instance.getRunAsNonRoot()); 
        this.withRunAsUser(instance.getRunAsUser()); 
        this.withSeLinuxOptions(instance.getSeLinuxOptions()); 
        this.withSeccompProfile(instance.getSeccompProfile()); 
        this.withSupplementalGroups(instance.getSupplementalGroups()); 
        this.withSysctls(instance.getSysctls()); 
        this.withWindowsOptions(instance.getWindowsOptions()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodSecurityContext build() {
        PodSecurityContext buildable = new PodSecurityContext(fluent.getFsGroup(),fluent.getFsGroupChangePolicy(),fluent.getRunAsGroup(),fluent.isRunAsNonRoot(),fluent.getRunAsUser(),fluent.getSeLinuxOptions(),fluent.getSeccompProfile(),fluent.getSupplementalGroups(),fluent.getSysctls(),fluent.getWindowsOptions());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodSecurityContextBuilder that = (PodSecurityContextBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
