package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface ScaleIOPersistentVolumeSourceFluent<A extends ScaleIOPersistentVolumeSourceFluent<A>> extends Fluent<A> {


    public String getFsType();
    public A withFsType(String fsType);
    public Boolean hasFsType();
    public A withNewFsType(String arg1);
    public A withNewFsType(StringBuilder arg1);
    public A withNewFsType(StringBuffer arg1);
    public String getGateway();
    public A withGateway(String gateway);
    public Boolean hasGateway();
    public A withNewGateway(String arg1);
    public A withNewGateway(StringBuilder arg1);
    public A withNewGateway(StringBuffer arg1);
    public String getProtectionDomain();
    public A withProtectionDomain(String protectionDomain);
    public Boolean hasProtectionDomain();
    public A withNewProtectionDomain(String arg1);
    public A withNewProtectionDomain(StringBuilder arg1);
    public A withNewProtectionDomain(StringBuffer arg1);
    public Boolean isReadOnly();
    public A withReadOnly(Boolean readOnly);
    public Boolean hasReadOnly();
    public A withNewReadOnly(String arg1);
    public A withNewReadOnly(boolean arg1);
    
/**
 * This method has been deprecated, please use method buildSecretRef instead.
 * @return The buildable object.
 */
@Deprecated public SecretReference getSecretRef();
    public SecretReference buildSecretRef();
    public A withSecretRef(SecretReference secretRef);
    public Boolean hasSecretRef();
    public A withNewSecretRef(String name,String namespace);
    public ScaleIOPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRef();
    public ScaleIOPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(SecretReference item);
    public ScaleIOPersistentVolumeSourceFluent.SecretRefNested<A> editSecretRef();
    public ScaleIOPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef();
    public ScaleIOPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(SecretReference item);
    public Boolean isSslEnabled();
    public A withSslEnabled(Boolean sslEnabled);
    public Boolean hasSslEnabled();
    public A withNewSslEnabled(String arg1);
    public A withNewSslEnabled(boolean arg1);
    public String getStorageMode();
    public A withStorageMode(String storageMode);
    public Boolean hasStorageMode();
    public A withNewStorageMode(String arg1);
    public A withNewStorageMode(StringBuilder arg1);
    public A withNewStorageMode(StringBuffer arg1);
    public String getStoragePool();
    public A withStoragePool(String storagePool);
    public Boolean hasStoragePool();
    public A withNewStoragePool(String arg1);
    public A withNewStoragePool(StringBuilder arg1);
    public A withNewStoragePool(StringBuffer arg1);
    public String getSystem();
    public A withSystem(String system);
    public Boolean hasSystem();
    public A withNewSystem(String arg1);
    public A withNewSystem(StringBuilder arg1);
    public A withNewSystem(StringBuffer arg1);
    public String getVolumeName();
    public A withVolumeName(String volumeName);
    public Boolean hasVolumeName();
    public A withNewVolumeName(String arg1);
    public A withNewVolumeName(StringBuilder arg1);
    public A withNewVolumeName(StringBuffer arg1);
    public interface SecretRefNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SecretReferenceFluent<ScaleIOPersistentVolumeSourceFluent.SecretRefNested<N>> {

            public N and();
            public N endSecretRef();    }


}
