package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceReferenceBuilder extends ServiceReferenceFluentImpl<ServiceReferenceBuilder> implements VisitableBuilder<ServiceReference,ServiceReferenceBuilder> {

    ServiceReferenceFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceReferenceBuilder() {
        this(true);
    }

    public ServiceReferenceBuilder(Boolean validationEnabled) {
        this(new ServiceReference(), validationEnabled);
    }

    public ServiceReferenceBuilder(ServiceReferenceFluent<?> fluent) {
        this(fluent, true);
    }

    public ServiceReferenceBuilder(ServiceReferenceFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ServiceReference(), validationEnabled);
    }

    public ServiceReferenceBuilder(ServiceReferenceFluent<?> fluent,ServiceReference instance) {
        this(fluent, instance, true);
    }

    public ServiceReferenceBuilder(ServiceReferenceFluent<?> fluent,ServiceReference instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withName(instance.getName()); 
        fluent.withNamespace(instance.getNamespace()); 
        fluent.withPort(instance.getPort()); 
        this.validationEnabled = validationEnabled; 
    }

    public ServiceReferenceBuilder(ServiceReference instance) {
        this(instance,true);
    }

    public ServiceReferenceBuilder(ServiceReference instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withName(instance.getName()); 
        this.withNamespace(instance.getNamespace()); 
        this.withPort(instance.getPort()); 
        this.validationEnabled = validationEnabled; 
    }

    public ServiceReference build() {
        ServiceReference buildable = new ServiceReference(fluent.getName(),fluent.getNamespace(),fluent.getPort());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServiceReferenceBuilder that = (ServiceReferenceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
