package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class PodExecOptionsFluentImpl<A extends PodExecOptionsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PodExecOptionsFluent<A> {

    private String apiVersion;
    private List<String> command = new ArrayList<String>();
    private String container;
    private String kind;
    private Boolean stderr;
    private Boolean stdin;
    private Boolean stdout;
    private Boolean tty;

    public PodExecOptionsFluentImpl() {
    }

    public PodExecOptionsFluentImpl(PodExecOptions instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withCommand(instance.getCommand()); 
        this.withContainer(instance.getContainer()); 
        this.withKind(instance.getKind()); 
        this.withStderr(instance.getStderr()); 
        this.withStdin(instance.getStdin()); 
        this.withStdout(instance.getStdout()); 
        this.withTty(instance.getTty()); 
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A addToCommand(int index,String item) {
        if (this.command == null) {this.command = new ArrayList<String>();}
        this.command.add(index, item);
        return (A)this;
    }

    public A setToCommand(int index,String item) {
        if (this.command == null) {this.command = new ArrayList<String>();}
        this.command.set(index, item); return (A)this;
    }

    public A addToCommand(String... items) {
        if (this.command == null) {this.command = new ArrayList<String>();}
        for (String item : items) {this.command.add(item);} return (A)this;
    }

    public A addAllToCommand(Collection<String> items) {
        if (this.command == null) {this.command = new ArrayList<String>();}
        for (String item : items) {this.command.add(item);} return (A)this;
    }

    public A removeFromCommand(String... items) {
        for (String item : items) {if (this.command!= null){ this.command.remove(item);}} return (A)this;
    }

    public A removeAllFromCommand(Collection<String> items) {
        for (String item : items) {if (this.command!= null){ this.command.remove(item);}} return (A)this;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public String getCommand(int index) {
        return this.command.get(index);
    }

    public String getFirstCommand() {
        return this.command.get(0);
    }

    public String getLastCommand() {
        return this.command.get(command.size() - 1);
    }

    public String getMatchingCommand(Predicate<String> predicate) {
        for (String item: command) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingCommand(Predicate<String> predicate) {
        for (String item: command) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withCommand(List<String> command) {
        if (this.command != null) { _visitables.get("command").removeAll(this.command);}
        if (command != null) {this.command = new ArrayList<String>(); for (String item : command){this.addToCommand(item);}} else { this.command = null;} return (A) this;
    }

    public A withCommand(String... command) {
        if (this.command != null) {this.command.clear();}
        if (command != null) {for (String item :command){ this.addToCommand(item);}} return (A) this;
    }

    public Boolean hasCommand() {
        return command != null && !command.isEmpty();
    }

    public A addNewCommand(String arg1) {
        return (A)addToCommand(new String(arg1));
    }

    public A addNewCommand(StringBuilder arg1) {
        return (A)addToCommand(new String(arg1));
    }

    public A addNewCommand(StringBuffer arg1) {
        return (A)addToCommand(new String(arg1));
    }

    public String getContainer() {
        return this.container;
    }

    public A withContainer(String container) {
        this.container=container; return (A) this;
    }

    public Boolean hasContainer() {
        return this.container != null;
    }

    public A withNewContainer(String arg1) {
        return (A)withContainer(new String(arg1));
    }

    public A withNewContainer(StringBuilder arg1) {
        return (A)withContainer(new String(arg1));
    }

    public A withNewContainer(StringBuffer arg1) {
        return (A)withContainer(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    public Boolean isStderr() {
        return this.stderr;
    }

    public A withStderr(Boolean stderr) {
        this.stderr=stderr; return (A) this;
    }

    public Boolean hasStderr() {
        return this.stderr != null;
    }

    public A withNewStderr(String arg1) {
        return (A)withStderr(new Boolean(arg1));
    }

    public A withNewStderr(boolean arg1) {
        return (A)withStderr(new Boolean(arg1));
    }

    public Boolean isStdin() {
        return this.stdin;
    }

    public A withStdin(Boolean stdin) {
        this.stdin=stdin; return (A) this;
    }

    public Boolean hasStdin() {
        return this.stdin != null;
    }

    public A withNewStdin(String arg1) {
        return (A)withStdin(new Boolean(arg1));
    }

    public A withNewStdin(boolean arg1) {
        return (A)withStdin(new Boolean(arg1));
    }

    public Boolean isStdout() {
        return this.stdout;
    }

    public A withStdout(Boolean stdout) {
        this.stdout=stdout; return (A) this;
    }

    public Boolean hasStdout() {
        return this.stdout != null;
    }

    public A withNewStdout(String arg1) {
        return (A)withStdout(new Boolean(arg1));
    }

    public A withNewStdout(boolean arg1) {
        return (A)withStdout(new Boolean(arg1));
    }

    public Boolean isTty() {
        return this.tty;
    }

    public A withTty(Boolean tty) {
        this.tty=tty; return (A) this;
    }

    public Boolean hasTty() {
        return this.tty != null;
    }

    public A withNewTty(String arg1) {
        return (A)withTty(new Boolean(arg1));
    }

    public A withNewTty(boolean arg1) {
        return (A)withTty(new Boolean(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PodExecOptionsFluentImpl that = (PodExecOptionsFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (command != null ? !command.equals(that.command) :that.command != null) return false;
        if (container != null ? !container.equals(that.container) :that.container != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (stderr != null ? !stderr.equals(that.stderr) :that.stderr != null) return false;
        if (stdin != null ? !stdin.equals(that.stdin) :that.stdin != null) return false;
        if (stdout != null ? !stdout.equals(that.stdout) :that.stdout != null) return false;
        if (tty != null ? !tty.equals(that.tty) :that.tty != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  command,  container,  kind,  stderr,  stdin,  stdout,  tty,  super.hashCode());
    }

}
