/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Context;
import io.fabric8.kubernetes.api.model.ContextFluent;
import io.fabric8.kubernetes.api.model.NamedExtension;
import io.fabric8.kubernetes.api.model.NamedExtensionBuilder;
import io.fabric8.kubernetes.api.model.NamedExtensionFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ContextFluentImpl<A extends ContextFluent<A>>
extends BaseFluent<A>
implements ContextFluent<A> {
    private String cluster;
    private List<NamedExtensionBuilder> extensions = new ArrayList<NamedExtensionBuilder>();
    private String namespace;
    private String user;

    public ContextFluentImpl() {
    }

    public ContextFluentImpl(Context instance) {
        this.withCluster(instance.getCluster());
        this.withExtensions(instance.getExtensions());
        this.withNamespace(instance.getNamespace());
        this.withUser(instance.getUser());
    }

    @Override
    public String getCluster() {
        return this.cluster;
    }

    @Override
    public A withCluster(String cluster) {
        this.cluster = cluster;
        return (A)this;
    }

    @Override
    public Boolean hasCluster() {
        return this.cluster != null;
    }

    @Override
    public A withNewCluster(String arg1) {
        return this.withCluster(new String(arg1));
    }

    @Override
    public A withNewCluster(StringBuilder arg1) {
        return this.withCluster(new String(arg1));
    }

    @Override
    public A withNewCluster(StringBuffer arg1) {
        return this.withCluster(new String(arg1));
    }

    @Override
    public A addToExtensions(int index, NamedExtension item) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<NamedExtensionBuilder>();
        }
        NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
        this._visitables.get("extensions").add(index >= 0 ? index : this._visitables.get("extensions").size(), builder);
        this.extensions.add(index >= 0 ? index : this.extensions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToExtensions(int index, NamedExtension item) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<NamedExtensionBuilder>();
        }
        NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
        if (index < 0 || index >= this._visitables.get("extensions").size()) {
            this._visitables.get("extensions").add(builder);
        } else {
            this._visitables.get("extensions").set(index, builder);
        }
        if (index < 0 || index >= this.extensions.size()) {
            this.extensions.add(builder);
        } else {
            this.extensions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToExtensions(NamedExtension ... items) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<NamedExtensionBuilder>();
        }
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get("extensions").add(builder);
            this.extensions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToExtensions(Collection<NamedExtension> items) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<NamedExtensionBuilder>();
        }
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get("extensions").add(builder);
            this.extensions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtensions(NamedExtension ... items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get("extensions").remove(builder);
            if (this.extensions == null) continue;
            this.extensions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromExtensions(Collection<NamedExtension> items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get("extensions").remove(builder);
            if (this.extensions == null) continue;
            this.extensions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromExtensions(Predicate<NamedExtensionBuilder> predicate) {
        if (this.extensions == null) {
            return (A)this;
        }
        Iterator<NamedExtensionBuilder> each = this.extensions.iterator();
        Object visitables = this._visitables.get("extensions");
        while (each.hasNext()) {
            NamedExtensionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NamedExtension> getExtensions() {
        return ContextFluentImpl.build(this.extensions);
    }

    @Override
    public List<NamedExtension> buildExtensions() {
        return ContextFluentImpl.build(this.extensions);
    }

    @Override
    public NamedExtension buildExtension(int index) {
        return this.extensions.get(index).build();
    }

    @Override
    public NamedExtension buildFirstExtension() {
        return this.extensions.get(0).build();
    }

    @Override
    public NamedExtension buildLastExtension() {
        return this.extensions.get(this.extensions.size() - 1).build();
    }

    @Override
    public NamedExtension buildMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        for (NamedExtensionBuilder item : this.extensions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        for (NamedExtensionBuilder item : this.extensions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withExtensions(List<NamedExtension> extensions) {
        if (this.extensions != null) {
            this._visitables.get("extensions").removeAll(this.extensions);
        }
        if (extensions != null) {
            this.extensions = new ArrayList<NamedExtensionBuilder>();
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        } else {
            this.extensions = null;
        }
        return (A)this;
    }

    @Override
    public A withExtensions(NamedExtension ... extensions) {
        if (this.extensions != null) {
            this.extensions.clear();
        }
        if (extensions != null) {
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public ContextFluent.ExtensionsNested<A> addNewExtension() {
        return new ExtensionsNestedImpl();
    }

    @Override
    public ContextFluent.ExtensionsNested<A> addNewExtensionLike(NamedExtension item) {
        return new ExtensionsNestedImpl(-1, item);
    }

    @Override
    public ContextFluent.ExtensionsNested<A> setNewExtensionLike(int index, NamedExtension item) {
        return new ExtensionsNestedImpl(index, item);
    }

    @Override
    public ContextFluent.ExtensionsNested<A> editExtension(int index) {
        if (this.extensions.size() <= index) {
            throw new RuntimeException("Can't edit extensions. Index exceeds size.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    @Override
    public ContextFluent.ExtensionsNested<A> editFirstExtension() {
        if (this.extensions.size() == 0) {
            throw new RuntimeException("Can't edit first extensions. The list is empty.");
        }
        return this.setNewExtensionLike(0, this.buildExtension(0));
    }

    @Override
    public ContextFluent.ExtensionsNested<A> editLastExtension() {
        int index = this.extensions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last extensions. The list is empty.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    @Override
    public ContextFluent.ExtensionsNested<A> editMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.extensions.size(); ++i) {
            if (!predicate.test(this.extensions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching extensions. No match found.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    @Override
    public Boolean hasNamespace() {
        return this.namespace != null;
    }

    @Override
    public A withNewNamespace(String arg1) {
        return this.withNamespace(new String(arg1));
    }

    @Override
    public A withNewNamespace(StringBuilder arg1) {
        return this.withNamespace(new String(arg1));
    }

    @Override
    public A withNewNamespace(StringBuffer arg1) {
        return this.withNamespace(new String(arg1));
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public A withUser(String user) {
        this.user = user;
        return (A)this;
    }

    @Override
    public Boolean hasUser() {
        return this.user != null;
    }

    @Override
    public A withNewUser(String arg1) {
        return this.withUser(new String(arg1));
    }

    @Override
    public A withNewUser(StringBuilder arg1) {
        return this.withUser(new String(arg1));
    }

    @Override
    public A withNewUser(StringBuffer arg1) {
        return this.withUser(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextFluentImpl that = (ContextFluentImpl)o;
        if (this.cluster != null ? !this.cluster.equals(that.cluster) : that.cluster != null) {
            return false;
        }
        if (this.extensions != null ? !this.extensions.equals(that.extensions) : that.extensions != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public int hashCode() {
        return Objects.hash(this.cluster, this.extensions, this.namespace, this.user, super.hashCode());
    }

    public class ExtensionsNestedImpl<N>
    extends NamedExtensionFluentImpl<ContextFluent.ExtensionsNested<N>>
    implements ContextFluent.ExtensionsNested<N>,
    Nested<N> {
        private final NamedExtensionBuilder builder;
        private final int index;

        ExtensionsNestedImpl(int index, NamedExtension item) {
            this.index = index;
            this.builder = new NamedExtensionBuilder(this, item);
        }

        ExtensionsNestedImpl() {
            this.index = -1;
            this.builder = new NamedExtensionBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContextFluentImpl.this.setToExtensions(this.index, this.builder.build());
        }

        @Override
        public N endExtension() {
            return this.and();
        }
    }
}

